/*
 * Decompiled with CFR 0.152.
 */
package com.nijikokun.register.payment.methods;

import com.nijikokun.register.payment.Method;
import me.ashtheking.currency.Currency;
import me.ashtheking.currency.CurrencyList;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class MCUR
implements Method {
    private Currency currencyList;

    @Override
    public Object getPlugin() {
        return this.currencyList;
    }

    @Override
    public String getName() {
        return "MultiCurrency";
    }

    @Override
    public String getVersion() {
        return "0.09";
    }

    @Override
    public int fractionalDigits() {
        return -1;
    }

    @Override
    public String format(double amount) {
        return String.valueOf(amount) + " Currency";
    }

    @Override
    public boolean hasBanks() {
        return true;
    }

    @Override
    public boolean hasBank(String bank) {
        return CurrencyList.getAllCurrencys().contains(bank);
    }

    @Override
    public boolean hasAccount(String name) {
        return true;
    }

    @Override
    public boolean hasBankAccount(String bank, String name) {
        return CurrencyList.getAllCurrencys().contains(bank);
    }

    @Override
    public boolean createAccount(String name) {
        CurrencyList.setValue((String)((String)CurrencyList.maxCurrency((String)name)[0]), (String)name, (double)0.0);
        return true;
    }

    @Override
    public boolean createAccount(String name, double balance) {
        CurrencyList.setValue((String)((String)CurrencyList.maxCurrency((String)name)[0]), (String)name, (double)balance);
        return true;
    }

    @Override
    public Method.MethodAccount getAccount(String name) {
        return new MCurrencyAccount(name);
    }

    @Override
    public Method.MethodBankAccount getBankAccount(String bank, String name) {
        return new MCurrencyAccount(name, bank);
    }

    @Override
    public boolean isCompatible(Plugin plugin) {
        return (plugin.getDescription().getName().equalsIgnoreCase("Currency") || plugin.getDescription().getName().equalsIgnoreCase("MultiCurrency")) && plugin instanceof Currency;
    }

    @Override
    public void setPlugin(Plugin plugin) {
        this.currencyList = (Currency)plugin;
    }

    public class MCurrencyAccount
    implements Method.MethodAccount,
    Method.MethodBankAccount {
        private String name;
        private String currency;

        public MCurrencyAccount(String name) {
            this.name = name;
            this.currency = (String)CurrencyList.maxCurrency((String)name)[0];
        }

        public MCurrencyAccount(String name, String currency) {
            this.name = name;
            this.currency = currency;
        }

        @Override
        public double balance() {
            return CurrencyList.getValue((String)this.currency, (String)this.name);
        }

        @Override
        public String getBankName() {
            return this.currency;
        }

        @Override
        public int getBankId() {
            return -1;
        }

        @Override
        public boolean set(double amount) {
            CurrencyList.setValue((String)this.currency, (String)this.name, (double)amount);
            return true;
        }

        @Override
        public boolean add(double amount) {
            return CurrencyList.add((String)this.name, (double)amount, (String)this.currency);
        }

        @Override
        public boolean subtract(double amount) {
            return CurrencyList.subtract((String)this.name, (double)amount, (String)this.currency);
        }

        @Override
        public boolean multiply(double amount) {
            return CurrencyList.multiply((String)this.name, (double)amount, (String)this.currency);
        }

        @Override
        public boolean divide(double amount) {
            return CurrencyList.divide((String)this.name, (double)amount, (String)this.currency);
        }

        @Override
        public boolean hasEnough(double amount) {
            return CurrencyList.hasEnough((String)this.name, (double)amount, (String)this.currency);
        }

        @Override
        public boolean hasOver(double amount) {
            return CurrencyList.hasOver((String)this.name, (double)amount, (String)this.currency);
        }

        @Override
        public boolean hasUnder(double amount) {
            return CurrencyList.hasUnder((String)this.name, (double)amount, (String)this.currency);
        }

        @Override
        public boolean isNegative() {
            return CurrencyList.isNegative((String)this.name, (String)this.currency);
        }

        @Override
        public boolean remove() {
            return CurrencyList.remove((String)this.name, (String)this.currency);
        }

        @Override
        public double balance(World world) {
            return this.balance();
        }

        @Override
        public boolean set(double amount, World world) {
            return this.set(amount);
        }

        @Override
        public boolean add(double amount, World world) {
            return this.add(amount);
        }

        @Override
        public boolean subtract(double amount, World world) {
            return this.subtract(amount);
        }

        @Override
        public boolean multiply(double amount, World world) {
            return this.multiply(amount);
        }

        @Override
        public boolean divide(double amount, World world) {
            return this.divide(amount);
        }

        @Override
        public boolean hasEnough(double amount, World world) {
            return this.hasEnough(amount);
        }

        @Override
        public boolean hasOver(double amount, World world) {
            return this.hasOver(amount);
        }

        @Override
        public boolean hasUnder(double amount, World world) {
            return this.hasUnder(amount);
        }

        @Override
        public boolean isNegative(World world) {
            return this.isNegative();
        }
    }
}

