/*
 * Decompiled with CFR 0.152.
 */
package ca.xshade.bukkit.questioner;

import ca.xshade.bukkit.questioner.BukkitQuestionTask;
import ca.xshade.bukkit.questioner.QuestionerPlayerListener;
import ca.xshade.questionmanager.AbstractQuestion;
import ca.xshade.questionmanager.InvalidOptionException;
import ca.xshade.questionmanager.LinkedQuestion;
import ca.xshade.questionmanager.Option;
import ca.xshade.questionmanager.Poll;
import ca.xshade.questionmanager.PollQuestion;
import ca.xshade.questionmanager.PollTask;
import ca.xshade.questionmanager.Question;
import ca.xshade.questionmanager.QuestionFormatter;
import ca.xshade.questionmanager.QuestionManager;
import ca.xshade.questionmanager.QuestionTask;
import ca.xshade.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Questioner
extends JavaPlugin {
    protected QuestionManager questionManager;
    protected QuestionerPlayerListener playerListener;
    private List<Option> currentOptions = new ArrayList<Option>();
    private List<String> currentTargets = new ArrayList<String>();
    private int questionsPerPage = 5;
    private String questionFormat = ChatColor.DARK_GRAY + "[" + ChatColor.GRAY + "%s" + ChatColor.DARK_GRAY + "] " + ChatColor.DARK_GREEN + "%s";
    private String optionFormat = ChatColor.GREEN + "          /%s";
    private String optionEntendedFormat = ChatColor.YELLOW + " : %s";
    private String listFooterFormat = ChatColor.DARK_GRAY + " ---- " + ChatColor.GRAY + "Page: %d/%d " + ChatColor.DARK_GRAY + "~" + ChatColor.GRAY + " Total Questions: %d";

    public static void main(String[] args) {
        Questioner questioner = new Questioner();
        questioner.onEnable();
        ArrayList<Option> options = new ArrayList<Option>();
        options.add(new Option("yes", new QuestionTask(){

            @Override
            public void run() {
                System.out.println(String.valueOf(((Question)this.getQuestion()).getTarget()) + " recieved fries!");
            }
        }));
        options.add(new Option("no", new QuestionTask(){

            @Override
            public void run() {
                System.out.println(String.valueOf(((Question)this.getQuestion()).getTarget()) + " slapped the worker!");
            }
        }));
        AbstractQuestion question = new Question("You", "Would you like fries with that?", options);
        try {
            questioner.getQuestionManager().appendQuestion((Question)question);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        options = new ArrayList();
        options.add(new Option("rock", new PollTask()));
        options.add(new Option("metal", new PollTask()));
        question = new Question("", "What's better?", options);
        List<String> voters = Arrays.asList("You");
        for (String voter : voters) {
            Poll poll = new Poll((List)voters, (Question)question){

                @Override
                public void end() {
                    System.out.println("End of poll. Displaying results:");
                    System.out.println("Voters choice:");
                    HashMap<String, Option> results = this.getVoters();
                    for (String voter : results.keySet()) {
                        System.out.println("    " + voter + ": " + results.get(voter).getOptionString());
                    }
                    System.out.println("Votes:");
                    Map<Option, Integer> votes = this.getVotes();
                    for (Option option : votes.keySet()) {
                        System.out.println("    " + option.getOptionString() + ": " + votes.get(option));
                    }
                }
            };
            try {
                questioner.getQuestionManager().appendQuestion(new PollQuestion(poll, voter, (Question)question, poll.isPersistant()));
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        options = new ArrayList();
        options.add(new Option("yes", new QuestionTask(){

            @Override
            public void run() {
                System.out.println("Chris gave you a high five!");
            }
        }));
        options.add(new Option("no", new QuestionTask(){

            @Override
            public void run() {
                System.out.println("Chris slapped you!");
            }
        }));
        ArrayList<String> targets = new ArrayList<String>();
        targets.add("You");
        targets.add("Him");
        LinkedQuestion question2 = new LinkedQuestion(QuestionManager.getNextQuestionId(), targets, "Am I awesome?", options);
        try {
            questioner.getQuestionManager().appendLinkedQuestion(question2);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        System.out.println("Peeking at his top question.");
        try {
            AbstractQuestion question3 = questioner.getQuestionManager().peekAtFirstQuestion("Him");
            for (String line : QuestionFormatter.format(question3)) {
                System.out.println(line);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        System.out.println("Answer your questions.");
        boolean hasQuestion = true;
        do {
            if (!questioner.getQuestionManager().hasQuestion("You")) {
                hasQuestion = false;
                continue;
            }
            try {
                question = questioner.getQuestionManager().peekAtFirstQuestion("You");
                for (String line : QuestionFormatter.format(question)) {
                    System.out.println(line);
                }
                do {
                    Scanner input = new Scanner(System.in);
                    try {
                        question.getOption(input.nextLine()).getReaction().run();
                        questioner.getQuestionManager().removeFirstQuestion("You");
                        question = null;
                    }
                    catch (InvalidOptionException e) {
                        System.out.println(e.getMessage());
                    }
                } while (question != null);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                hasQuestion = false;
            }
        } while (hasQuestion);
        System.out.println("Peeking at his top question.");
        try {
            question = questioner.getQuestionManager().peekAtFirstQuestion("Him");
            for (String line : QuestionFormatter.format(question)) {
                System.out.println(line);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void onDisable() {
        this.playerListener = null;
        this.questionManager = null;
        System.out.println("[Questioner] v" + this.getDescription().getVersion() + " - Disabled");
    }

    public void onEnable() {
        this.questionManager = new QuestionManager();
        this.playerListener = new QuestionerPlayerListener(this, this.questionManager);
        if (this.getServer() != null) {
            this.getServer().getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)this);
            System.out.println("[Questioner] v" + this.getDescription().getVersion() + " - Enabled");
        }
    }

    public QuestionManager getQuestionManager() {
        return this.questionManager;
    }

    public void appendQuestion(Question question) throws Exception {
        for (Option option : question.getOptions()) {
            if (!(option.getReaction() instanceof BukkitQuestionTask)) continue;
            ((BukkitQuestionTask)option.getReaction()).setServer(this.getServer());
        }
        this.getQuestionManager().appendQuestion(question);
        Player player = this.getServer().getPlayer(question.getTarget());
        if (player != null) {
            for (String line : this.formatQuestion(question, "New Question")) {
                player.sendMessage(line);
            }
        }
    }

    public void sendErrorMsg(String msg) {
        System.out.println("[Questioner] Error: " + msg);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        String command = cmd.getName().toLowerCase();
        if (command.equals("question")) {
            if (args.length > 0) {
                if (sender.isOp()) {
                    if (args[0].equalsIgnoreCase("target")) {
                        int i = 1;
                        while (i < args.length) {
                            this.currentTargets.add(args[i]);
                            ++i;
                        }
                        sender.sendMessage("NumTargets: " + this.currentTargets.size());
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("opt")) {
                        if (args.length > 1) {
                            this.currentOptions.add(new Option(args[1], new QuestionTask(){

                                @Override
                                public void run() {
                                    System.out.println("You chose " + this.getOption().getOptionString() + "!");
                                }
                            }));
                            sender.sendMessage("NumOptions: " + this.currentOptions.size());
                        } else {
                            sender.sendMessage("help > question opt [option]");
                        }
                        return true;
                    }
                    if (args[0].equalsIgnoreCase("ask")) {
                        try {
                            String q = StringMgmt.join(StringMgmt.remFirstArg(args), " ");
                            for (String target : this.currentTargets) {
                                Question question = new Question(target.toLowerCase(), q, this.currentOptions);
                                this.appendQuestion(question);
                            }
                            this.currentOptions.clear();
                            this.currentTargets.clear();
                        }
                        catch (Exception e) {
                            System.out.println(e.getMessage());
                        }
                        return true;
                    }
                }
                if (args[0].equalsIgnoreCase("list") && sender instanceof Player) {
                    Player player = (Player)sender;
                    int page = 1;
                    if (args.length > 1) {
                        try {
                            page = Integer.parseInt(args[1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    for (String line : this.formatQuestionList(player.getName(), page)) {
                        player.sendMessage(line);
                    }
                    return true;
                }
            }
            sender.sendMessage("Invalid sub command.");
            return true;
        }
        return false;
    }

    public List<String> formatQuestionList(String user, int page) {
        ArrayList<String> out = new ArrayList<String>();
        try {
            int start;
            if (page < 0) {
                throw new Exception("Invalid page number.");
            }
            LinkedList<AbstractQuestion> activePlayerQuestions = this.getQuestionManager().getQuestions(user);
            int numQuestions = activePlayerQuestions.size();
            int maxPage = (int)Math.ceil((double)numQuestions / (double)this.questionsPerPage);
            if (page > maxPage) {
                throw new Exception("There are no questions on page " + page);
            }
            int i = start = (page - 1) * this.questionsPerPage;
            while (i < start + this.questionsPerPage) {
                try {
                    AbstractQuestion question = activePlayerQuestions.get(i);
                    out.addAll(this.formatQuestion(question, Integer.toString(i)));
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                ++i;
            }
            if (maxPage > 1) {
                out.add(String.format(this.listFooterFormat, page, maxPage, numQuestions));
            }
        }
        catch (Exception e) {
            out.add(ChatColor.RED + e.getMessage());
        }
        return out;
    }

    public List<String> formatQuestion(AbstractQuestion question, String tag) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(String.format(this.questionFormat, tag, StringMgmt.maxLength(question.getQuestion(), 54)));
        for (Option option : question.getOptions()) {
            out.add(String.valueOf(String.format(this.optionFormat, option.toString())) + (option.hasDescription() ? String.format(this.optionEntendedFormat, option.getOptionDescription()) : ""));
        }
        return out;
    }

    public void loadClasses() {
        String[] classes;
        String[] stringArray = classes = new String[]{"ca.xshade.bukkit.questioner.BukkitQuestionTask", "ca.xshade.questionmanager.AbstractQuestion", "ca.xshade.questionmanager.InvalidOptionException", "ca.xshade.questionmanager.LinkedQuestion", "ca.xshade.questionmanager.LinkedQuestionTask", "ca.xshade.questionmanager.Option", "ca.xshade.questionmanager.OptionTask", "ca.xshade.questionmanager.Poll", "ca.xshade.questionmanager.PollQuestion", "ca.xshade.questionmanager.PollTask", "ca.xshade.questionmanager.Question", "ca.xshade.questionmanager.QuestionFormatter", "ca.xshade.questionmanager.QuestionManager", "ca.xshade.questionmanager.QuestionTask"};
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            try {
                Questioner.class.getClassLoader().loadClass(c);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }
}

