/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.blockqueue;

import com.palmergames.bukkit.blockqueue.BlockWorker;
import java.util.LinkedList;
import org.bukkit.Server;

public class BlockQueue {
    private LinkedList<Object> queue = new LinkedList();
    private static volatile BlockQueue instance;
    private BlockWorker worker;

    public synchronized void addWork(Object obj) {
        this.queue.addLast(obj);
        this.notify();
    }

    public synchronized Object getWork() throws InterruptedException {
        while (this.queue.isEmpty()) {
            this.wait();
        }
        return this.queue.removeFirst();
    }

    public static BlockQueue getInstance() throws Exception {
        if (instance == null) {
            throw new Exception("BlockQueue has not been initialized yet");
        }
        return instance;
    }

    public static BlockQueue newInstance(Server server) {
        instance = new BlockQueue();
        BlockQueue.instance.worker = new BlockWorker(server, instance);
        server.getScheduler().scheduleAsyncDelayedTask(null, (Runnable)instance.getWorker());
        return instance;
    }

    public BlockWorker getWorker() {
        return this.worker;
    }
}

