/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.blockqueue;

import com.palmergames.bukkit.blockqueue.BlockJob;
import com.palmergames.bukkit.blockqueue.BlockQueue;
import com.palmergames.bukkit.blockqueue.BlockWork;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class BlockWorker
implements Runnable {
    private BlockQueue blockQueue;
    private Server server;
    public static final Object NO_MORE_WORK = new Object();
    public static final Object END_JOB = new Object();
    private boolean running;
    private BlockJob currentJob;
    private int blocks;
    private int skipped;

    public BlockWorker(Server server, BlockQueue blockQueue) {
        this.blockQueue = blockQueue;
        this.setServer(server);
        this.setRunning(true);
    }

    public synchronized void setRunning(boolean running) {
        this.running = running;
    }

    @Override
    public void run() {
        this.blocks = 0;
        this.skipped = 0;
        try {
            while (this.running) {
                Object obj = this.blockQueue.getWork();
                if (obj == NO_MORE_WORK) break;
                if (obj == END_JOB) {
                    this.onJobFinish(this.currentJob);
                }
                if (obj instanceof BlockWork) {
                    try {
                        this.buildBlock((BlockWork)obj);
                    }
                    catch (Exception e) {
                        ++this.skipped;
                    }
                    ++this.blocks;
                }
                if (!(obj instanceof BlockJob)) continue;
                this.currentJob = (BlockJob)obj;
                this.blocks = 0;
                this.skipped = 0;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("[Blocker] BlockQueue Thread stopped.");
        this.blockQueue = null;
    }

    public void buildBlock(BlockWork blockWork) {
        Block block = blockWork.getWorld().getBlockAt(blockWork.getX(), blockWork.getY(), blockWork.getZ());
        if (blockWork.getId() == block.getTypeId()) {
            return;
        }
        block.setTypeId(blockWork.getId());
        block.setData(blockWork.getData());
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Server getServer() {
        return this.server;
    }

    public void onJobFinish(BlockJob job) {
        if (job.isNotify()) {
            Player player = this.getServer().getPlayer(job.getBoss());
            player.sendMessage("Generated: " + this.blocks + " Blocks");
            if (this.skipped > 0) {
                player.sendMessage("Skipped: " + this.skipped + " Blocks");
            }
        }
    }
}

