/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.config;

import com.palmergames.util.FileMgmt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class CommentedConfiguration
extends YamlConfiguration {
    private HashMap<String, String> comments = new HashMap();
    private File file;

    public CommentedConfiguration(File file) {
        this.file = file;
    }

    public boolean load() {
        boolean loaded = true;
        try {
            this.load(this.file);
        }
        catch (FileNotFoundException e) {
            loaded = false;
        }
        catch (IOException e) {
            loaded = false;
        }
        catch (InvalidConfigurationException e) {
            loaded = false;
        }
        return loaded;
    }

    public boolean save() {
        boolean saved = true;
        try {
            super.save(this.file);
        }
        catch (Exception e) {
            saved = false;
        }
        if (!this.comments.isEmpty() && saved) {
            String[] yamlContents = FileMgmt.convertFileToString(this.file).split("[" + System.getProperty("line.separator") + "]");
            String newContents = "";
            String currentPath = "";
            boolean commentedPath = false;
            boolean node = false;
            int depth = 0;
            String[] stringArray = yamlContents;
            int n = yamlContents.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.contains(": ") || line.length() > 1 && line.charAt(line.length() - 1) == ':') {
                    commentedPath = false;
                    node = true;
                    int index = 0;
                    index = line.indexOf(": ");
                    if (index < 0) {
                        index = line.length() - 1;
                    }
                    if (currentPath.isEmpty()) {
                        currentPath = line.substring(0, index);
                    } else {
                        int whiteSpace = 0;
                        int n3 = 0;
                        while (n3 < line.length()) {
                            if (line.charAt(n3) != ' ') break;
                            ++whiteSpace;
                            ++n3;
                        }
                        if (whiteSpace / 2 > depth) {
                            currentPath = String.valueOf(currentPath) + "." + line.substring(whiteSpace, index);
                            ++depth;
                        } else if (whiteSpace / 2 < depth) {
                            int newDepth = whiteSpace / 2;
                            int i = 0;
                            while (i < depth - newDepth) {
                                currentPath = currentPath.replace(currentPath.substring(currentPath.lastIndexOf(".")), "");
                                ++i;
                            }
                            int lastIndex = currentPath.lastIndexOf(".");
                            if (lastIndex < 0) {
                                currentPath = "";
                            } else {
                                currentPath = currentPath.replace(currentPath.substring(currentPath.lastIndexOf(".")), "");
                                currentPath = String.valueOf(currentPath) + ".";
                            }
                            currentPath = String.valueOf(currentPath) + line.substring(whiteSpace, index);
                            depth = newDepth;
                        } else {
                            int lastIndex = currentPath.lastIndexOf(".");
                            if (lastIndex < 0) {
                                currentPath = "";
                            } else {
                                currentPath = currentPath.replace(currentPath.substring(currentPath.lastIndexOf(".")), "");
                                currentPath = String.valueOf(currentPath) + ".";
                            }
                            currentPath = String.valueOf(currentPath) + line.substring(whiteSpace, index);
                        }
                    }
                } else {
                    node = false;
                }
                if (node) {
                    String comment = null;
                    if (!commentedPath) {
                        comment = this.comments.get(currentPath);
                    }
                    if (comment != null) {
                        line = String.valueOf(comment) + System.getProperty("line.separator") + line + System.getProperty("line.separator");
                        comment = null;
                        commentedPath = true;
                    } else {
                        line = String.valueOf(line) + System.getProperty("line.separator");
                    }
                }
                newContents = String.valueOf(newContents) + line + (!node ? System.getProperty("line.separator") : "");
                ++n2;
            }
            while (newContents.startsWith(System.getProperty("line.separator"))) {
                newContents = newContents.replaceFirst(System.getProperty("line.separator"), "");
            }
            try {
                FileMgmt.stringToFile(newContents, this.file);
            }
            catch (IOException e) {
                saved = false;
            }
        }
        return saved;
    }

    public void addComment(String path, String ... commentLines) {
        StringBuilder commentstring = new StringBuilder();
        String leadingSpaces = "";
        int n = 0;
        while (n < path.length()) {
            if (path.charAt(n) == '.') {
                leadingSpaces = String.valueOf(leadingSpaces) + "  ";
            }
            ++n;
        }
        String[] stringArray = commentLines;
        int n2 = commentLines.length;
        int n3 = 0;
        while (n3 < n2) {
            String line = stringArray[n3];
            line = !line.isEmpty() ? String.valueOf(leadingSpaces) + line : " ";
            if (commentstring.length() > 0) {
                commentstring.append("\r\n");
            }
            commentstring.append(line);
            ++n3;
        }
        this.comments.put(path, commentstring.toString());
    }
}

