/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;

public class ChunkNotification {
    public static String notificationFormat = "\u00a76 ~ %s";
    public static String notificationSpliter = "\u00a77 - ";
    public static String areaWildernessNotificationFormat = "\u00a72%s";
    public static String areaTownNotificationFormat = "\u00a72%s";
    public static String ownerNotificationFormat = "\u00a7a%s";
    public static String noOwnerNotificationFormat = "\u00a7a%s";
    public static String plotNotficationSplitter = " ";
    public static String plotNotificationFormat = "%s";
    public static String homeBlockNotification = "\u00a7b[Home]";
    public static String outpostBlockNotification = "\u00a7b[Outpost]";
    public static String forSaleNotificationFormat = "\u00a7e[For Sale: %s]";
    public static String plotTypeNotificationFormat = "\u00a76[%s]";
    WorldCoord from;
    WorldCoord to;
    boolean fromWild = false;
    boolean toWild = false;
    boolean toForSale = false;
    boolean toHomeBlock = false;
    boolean toOutpostBlock = false;
    TownBlock fromTownBlock;
    TownBlock toTownBlock = null;
    Town fromTown = null;
    Town toTown = null;
    Resident fromResident = null;
    Resident toResident = null;
    TownBlockType fromPlotType = null;
    TownBlockType toPlotType = null;

    public static void loadFormatStrings() {
        notificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_FORMAT);
        notificationSpliter = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_SPLITTER);
        areaWildernessNotificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_AREA_WILDERNESS);
        areaTownNotificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_AREA_TOWN);
        ownerNotificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_OWNER);
        noOwnerNotificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_NO_OWNER);
        plotNotficationSplitter = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_PLOT_SPLITTER);
        plotNotificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_PLOT_FORMAT);
        homeBlockNotification = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_PLOT_HOMEBLOCK);
        outpostBlockNotification = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_PLOT_OUTPOSTBLOCK);
        forSaleNotificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_PLOT_FORSALE);
        plotTypeNotificationFormat = TownySettings.getConfigLang(ConfigNodes.NOTIFICATION_PLOT_TYPE);
    }

    public ChunkNotification(WorldCoord from, WorldCoord to) {
        this.from = from;
        this.to = to;
        try {
            this.fromTownBlock = from.getTownBlock();
            this.fromPlotType = this.fromTownBlock.getType();
            try {
                this.fromTown = this.fromTownBlock.getTown();
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            try {
                this.fromResident = this.fromTownBlock.getResident();
            }
            catch (NotRegisteredException notRegisteredException) {}
        }
        catch (NotRegisteredException e) {
            this.fromWild = true;
        }
        try {
            this.toTownBlock = to.getTownBlock();
            this.toPlotType = this.toTownBlock.getType();
            try {
                this.toTown = this.toTownBlock.getTown();
            }
            catch (NotRegisteredException e) {
                // empty catch block
            }
            try {
                this.toResident = this.toTownBlock.getResident();
            }
            catch (NotRegisteredException e) {
                // empty catch block
            }
            this.toForSale = this.toTownBlock.getPlotPrice() != -1.0;
            this.toHomeBlock = this.toTownBlock.isHomeBlock();
            this.toOutpostBlock = this.toTownBlock.isOutpost();
        }
        catch (NotRegisteredException e) {
            this.toWild = true;
        }
    }

    public String getNotificationString() {
        if (notificationFormat.length() == 0) {
            return null;
        }
        List<String> outputContent = this.getNotificationContent();
        if (outputContent.size() == 0) {
            return null;
        }
        return String.format(notificationFormat, StringMgmt.join(outputContent, notificationSpliter));
    }

    public List<String> getNotificationContent() {
        ArrayList<String> out = new ArrayList<String>();
        String output = this.getAreaNotification();
        if (output != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getOwnerNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getPVPNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getPlotNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        return out;
    }

    public String getAreaNotification() {
        if (this.fromWild ^ this.toWild || !this.fromWild && !this.toWild && this.fromTown != null && this.toTown != null && this.fromTown != this.toTown) {
            if (this.toWild) {
                try {
                    return String.valueOf(String.format(areaWildernessNotificationFormat, this.to.getTownyWorld().getUnclaimedZoneName())) + (this.to.getTownyWorld().isPVP() && this.testWorldPVP() ? "\u00a74 (PvP)" : "");
                }
                catch (NotRegisteredException notRegisteredException) {
                }
            } else {
                return String.format(areaTownNotificationFormat, TownyFormatter.getFormattedName(this.toTown));
            }
        }
        return null;
    }

    public String getOwnerNotification() {
        if (this.fromResident != this.toResident && !this.toWild) {
            if (this.toResident != null) {
                return String.format(ownerNotificationFormat, TownyFormatter.getFormattedName(this.toResident));
            }
            return String.format(noOwnerNotificationFormat, TownySettings.getUnclaimedPlotName());
        }
        return null;
    }

    public String getPVPNotification() {
        if (!this.toWild && (this.fromWild || this.toTownBlock.getPermissions().pvp != this.fromTownBlock.getPermissions().pvp && !this.toTown.isPVP())) {
            try {
                return this.testWorldPVP() && (this.to.getTownyWorld().isForcePVP() || this.toTown.isPVP() || this.toTownBlock.getPermissions().pvp) ? "\u00a74 (PvP)" : "\u00a72(No PVP)";
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean testWorldPVP() {
        try {
            return Bukkit.getServer().getWorld(this.to.getTownyWorld().getName()).getPVP();
        }
        catch (NotRegisteredException e) {
            return true;
        }
    }

    public String getPlotNotification() {
        if (plotNotificationFormat.length() == 0) {
            return null;
        }
        List<String> outputContent = this.getPlotNotificationContent();
        if (outputContent.size() == 0) {
            return null;
        }
        return String.format(plotNotificationFormat, StringMgmt.join(outputContent, plotNotficationSplitter));
    }

    public List<String> getPlotNotificationContent() {
        ArrayList<String> out = new ArrayList<String>();
        String output = this.getHomeblockNotification();
        if (output != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getOutpostblockNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getForSaleNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        if ((output = this.getPlotTypeNotification()) != null && output.length() > 0) {
            out.add(output);
        }
        return out;
    }

    public String getHomeblockNotification() {
        if (this.toHomeBlock) {
            return homeBlockNotification;
        }
        return null;
    }

    public String getOutpostblockNotification() {
        if (this.toOutpostBlock) {
            return outpostBlockNotification;
        }
        return null;
    }

    public String getForSaleNotification() {
        if (this.toForSale) {
            return String.format(forSaleNotificationFormat, TownyEconomyHandler.getFormattedBalance(this.toTownBlock.getPlotPrice()));
        }
        return null;
    }

    public String getPlotTypeNotification() {
        if (this.fromPlotType != this.toPlotType && this.toPlotType != null && this.toPlotType != TownBlockType.RESIDENTIAL) {
            return String.format(plotTypeNotificationFormat, this.toPlotType.toString());
        }
        return null;
    }
}

