/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import ca.xshade.bukkit.questioner.Questioner;
import ca.xshade.questionmanager.Option;
import ca.xshade.questionmanager.Question;
import com.earth2me.essentials.Essentials;
import com.nijiko.permissions.PermissionHandler;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.command.NationCommand;
import com.palmergames.bukkit.towny.command.PlotCommand;
import com.palmergames.bukkit.towny.command.ResidentCommand;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.command.TownyAdminCommand;
import com.palmergames.bukkit.towny.command.TownyCommand;
import com.palmergames.bukkit.towny.command.TownyWorldCommand;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.listeners.TownyBlockListener;
import com.palmergames.bukkit.towny.listeners.TownyCustomListener;
import com.palmergames.bukkit.towny.listeners.TownyEntityListener;
import com.palmergames.bukkit.towny.listeners.TownyEntityMonitorListener;
import com.palmergames.bukkit.towny.listeners.TownyPlayerListener;
import com.palmergames.bukkit.towny.listeners.TownyWeatherListener;
import com.palmergames.bukkit.towny.listeners.TownyWorldListener;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.BukkitPermSource;
import com.palmergames.bukkit.towny.permissions.GroupManagerSource;
import com.palmergames.bukkit.towny.permissions.NullPermSource;
import com.palmergames.bukkit.towny.permissions.PEXSource;
import com.palmergames.bukkit.towny.permissions.Perms3Source;
import com.palmergames.bukkit.towny.permissions.bPermsSource;
import com.palmergames.bukkit.towny.questioner.TownyQuestionTask;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.towny.war.flagwar.TownyWar;
import com.palmergames.bukkit.towny.war.flagwar.listeners.TownyWarBlockListener;
import com.palmergames.bukkit.towny.war.flagwar.listeners.TownyWarCustomListener;
import com.palmergames.bukkit.towny.war.flagwar.listeners.TownyWarEntityListener;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.JavaUtil;
import com.palmergames.util.StringMgmt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Towny
extends JavaPlugin {
    private String version = "2.0.0";
    public static PermissionHandler permissionHandler;
    private final TownyPlayerListener playerListener = new TownyPlayerListener(this);
    private final TownyBlockListener blockListener = new TownyBlockListener(this);
    private final TownyCustomListener customListener = new TownyCustomListener(this);
    private final TownyEntityListener entityListener = new TownyEntityListener(this);
    private final TownyWeatherListener weatherListener = new TownyWeatherListener(this);
    private final TownyEntityMonitorListener entityMonitorListener = new TownyEntityMonitorListener(this);
    private final TownyWorldListener worldListener = new TownyWorldListener(this);
    private final TownyWarBlockListener townyWarBlockListener = new TownyWarBlockListener(this);
    private final TownyWarCustomListener townyWarCustomListener = new TownyWarCustomListener(this);
    private final TownyWarEntityListener townyWarEntityListener = new TownyWarEntityListener(this);
    private TownyUniverse townyUniverse;
    private Map<String, PlayerCache> playerCache = Collections.synchronizedMap(new HashMap());
    private Essentials essentials = null;
    private boolean citizens2 = false;
    private boolean error = false;

    public void onEnable() {
        System.out.println("====================      Towny      ========================");
        this.version = this.getDescription().getVersion();
        this.townyUniverse = new TownyUniverse(this);
        BukkitTools.initialize(this);
        TownyTimerHandler.initialize(this);
        TownyEconomyHandler.initialize(this);
        TownyFormatter.initialize(this);
        TownyRegenAPI.initialize(this);
        PlayerCacheUtil.initialize(this);
        if (this.load()) {
            this.getCommand("townyadmin").setExecutor((CommandExecutor)new TownyAdminCommand(this));
            this.getCommand("townyworld").setExecutor((CommandExecutor)new TownyWorldCommand(this));
            this.getCommand("resident").setExecutor((CommandExecutor)new ResidentCommand(this));
            this.getCommand("towny").setExecutor((CommandExecutor)new TownyCommand(this));
            this.getCommand("town").setExecutor((CommandExecutor)new TownCommand(this));
            this.getCommand("nation").setExecutor((CommandExecutor)new NationCommand(this));
            this.getCommand("plot").setExecutor((CommandExecutor)new PlotCommand(this));
            TownyWar.onEnable();
            if (TownySettings.isTownyUpdating(this.getVersion())) {
                this.update();
            }
        }
        this.registerEvents();
        TownyLogger.log.info("=============================================================");
        if (this.isError()) {
            TownyLogger.log.info("[WARNING] - ***** SAFE MODE ***** " + this.version);
        } else {
            TownyLogger.log.info("[Towny] Version: " + this.version + " - Mod Enabled");
        }
        TownyLogger.log.info("=============================================================");
        if (!this.isError()) {
            Player[] playerArray = BukkitTools.getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player player = playerArray[n2];
                if (player != null) {
                    try {
                        this.getTownyUniverse().onLogin(player);
                    }
                    catch (TownyException x) {
                        TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                    }
                }
                ++n2;
            }
        }
    }

    public void SetWorldFlags() {
        for (Town town : TownyUniverse.getDataSource().getTowns()) {
            TownyMessaging.sendDebugMsg("[Towny] Setting flags for: " + town.getName());
            if (town.getWorld() != null) continue;
            TownyLogger.log.warning("[Towny Error] Detected an error with the world files. Attempting to repair");
            if (town.hasHomeBlock()) {
                try {
                    TownyWorld world = town.getHomeBlock().getWorld();
                    if (world.hasTown(town)) continue;
                    world.addTown(town);
                    TownyUniverse.getDataSource().saveTown(town);
                    TownyUniverse.getDataSource().saveWorld(world);
                }
                catch (TownyException e) {
                    TownyLogger.log.warning("[Towny Error] Failed get world data for: " + town.getName());
                }
                continue;
            }
            TownyLogger.log.warning("[Towny Error] No Homeblock - Failed to detect world for: " + town.getName());
        }
    }

    public void onDisable() {
        System.out.println("==============================================================");
        if (TownyUniverse.getDataSource() != null && !this.error) {
            TownyUniverse.getDataSource().saveQueues();
        }
        if (!this.error) {
            TownyWar.onDisable();
        }
        if (TownyUniverse.isWarTime()) {
            this.getTownyUniverse().getWarEvent().toggleEnd();
        }
        TownyTimerHandler.toggleTownyRepeatingTimer(false);
        TownyTimerHandler.toggleDailyTimer(false);
        TownyTimerHandler.toggleMobRemoval(false);
        TownyTimerHandler.toggleHealthRegen(false);
        TownyTimerHandler.toggleTeleportWarmup(false);
        TownyRegenAPI.cancelProtectionRegenTasks();
        this.playerCache.clear();
        this.townyUniverse = null;
        System.out.println("[Towny] Version: " + this.version + " - Mod Disabled");
        System.out.println("=============================================================");
        TownyLogger.shutDown();
    }

    public boolean load() {
        Pattern pattern = Pattern.compile("-b(\\d*?)jnks", 2);
        Matcher matcher = pattern.matcher(this.getServer().getVersion());
        if (!this.townyUniverse.loadSettings()) {
            this.setError(true);
            return false;
        }
        this.setupLogger();
        if (TownySettings.isBypassVersionCheck()) {
            TownyLogger.log.info("[Towny] Bypassing CraftBukkit Version check.");
        } else {
            int bukkitVer = TownySettings.getMinBukkitVersion();
            if (!matcher.find() || matcher.group(1) == null) {
                this.error = true;
                TownyLogger.log.severe("[Towny Error] Unable to read CraftBukkit Version.");
                TownyLogger.log.severe("[Towny Error] Towny requires version " + bukkitVer + " or higher.");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return false;
            }
            int curBuild = Integer.parseInt(matcher.group(1));
            if (curBuild < bukkitVer) {
                this.error = true;
                TownyLogger.log.severe("[Towny Error] CraftBukkit Version (" + curBuild + ") is outdated! ");
                TownyLogger.log.severe("[Towny Error] Towny requires version " + bukkitVer + " or higher.");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return false;
            }
        }
        this.checkPlugins();
        this.SetWorldFlags();
        TownyTimerHandler.toggleTownyRepeatingTimer(false);
        TownyTimerHandler.toggleDailyTimer(false);
        TownyTimerHandler.toggleMobRemoval(false);
        TownyTimerHandler.toggleHealthRegen(false);
        TownyTimerHandler.toggleTeleportWarmup(false);
        TownyTimerHandler.toggleTownyRepeatingTimer(true);
        TownyTimerHandler.toggleDailyTimer(true);
        TownyTimerHandler.toggleMobRemoval(true);
        TownyTimerHandler.toggleHealthRegen(TownySettings.hasHealthRegen());
        TownyTimerHandler.toggleTeleportWarmup(TownySettings.getTeleportWarmupTime() > 0);
        this.resetCache();
        return true;
    }

    private void checkPlugins() {
        Plugin test;
        ArrayList<String> using = new ArrayList<String>();
        if (TownySettings.isUsingPermissions()) {
            test = this.getServer().getPluginManager().getPlugin("GroupManager");
            if (test != null) {
                this.getTownyUniverse().setPermissionSource(new GroupManagerSource(this, test));
                using.add(String.format("%s v%s", "GroupManager", test.getDescription().getVersion()));
            } else {
                test = this.getServer().getPluginManager().getPlugin("PermissionsEx");
                if (test != null) {
                    this.getTownyUniverse().setPermissionSource(new PEXSource(this, test));
                    using.add(String.format("%s v%s", "PermissionsEX", test.getDescription().getVersion()));
                } else {
                    test = this.getServer().getPluginManager().getPlugin("bPermissions");
                    if (test != null) {
                        this.getTownyUniverse().setPermissionSource(new bPermsSource(this, test));
                        using.add(String.format("%s v%s", "bPermissions", test.getDescription().getVersion()));
                    } else {
                        test = this.getServer().getPluginManager().getPlugin("Permissions");
                        if (test != null) {
                            this.getTownyUniverse().setPermissionSource(new Perms3Source(this, test));
                            using.add(String.format("%s v%s", "Permissions", test.getDescription().getVersion()));
                        } else {
                            this.getTownyUniverse().setPermissionSource(new BukkitPermSource(this));
                            using.add("BukkitPermissions");
                        }
                    }
                }
            }
        } else {
            this.getTownyUniverse().setPermissionSource(new NullPermSource(this));
        }
        if (TownySettings.isUsingEconomy()) {
            if (TownyEconomyHandler.setupEconomy().booleanValue()) {
                using.add(TownyEconomyHandler.getVersion());
            } else {
                TownyMessaging.sendErrorMsg("No compatible Economy plugins found. You need iConomy 5.01, or the vault/Register.jar with any of the supported eco systems.");
            }
        }
        if ((test = this.getServer().getPluginManager().getPlugin("Essentials")) == null) {
            TownySettings.setUsingEssentials(false);
        } else if (TownySettings.isUsingEssentials()) {
            this.essentials = (Essentials)test;
            using.add(String.format("%s v%s", "Essentials", test.getDescription().getVersion()));
        }
        test = this.getServer().getPluginManager().getPlugin("Questioner");
        if (test == null) {
            TownySettings.setUsingQuestioner(false);
        } else if (TownySettings.isUsingQuestioner()) {
            using.add(String.format("%s v%s", "Questioner", test.getDescription().getVersion()));
        }
        test = this.getServer().getPluginManager().getPlugin("Citizens");
        if (test != null) {
            this.citizens2 = test.getDescription().getVersion().startsWith("2");
        }
        if (using.size() > 0) {
            TownyLogger.log.info("[Towny] Using: " + StringMgmt.join(using, ", "));
        }
    }

    private void registerEvents() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        if (!this.isError()) {
            pluginManager.registerEvents((Listener)this.townyWarBlockListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.townyWarEntityListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.entityMonitorListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.weatherListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.townyWarCustomListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.customListener, (Plugin)this);
            pluginManager.registerEvents((Listener)this.worldListener, (Plugin)this);
        }
        pluginManager.registerEvents((Listener)this.playerListener, (Plugin)this);
        pluginManager.registerEvents((Listener)this.blockListener, (Plugin)this);
        pluginManager.registerEvents((Listener)this.entityListener, (Plugin)this);
    }

    private void update() {
        try {
            List<String> changeLog = JavaUtil.readTextFromJar("/ChangeLog.txt");
            boolean display = false;
            TownyLogger.log.info("------------------------------------");
            TownyLogger.log.info("[Towny] ChangeLog up until v" + this.getVersion());
            String lastVersion = TownySettings.getLastRunVersion(this.getVersion());
            for (String line : changeLog) {
                if (line.startsWith("v" + lastVersion)) {
                    display = true;
                }
                if (!display || line.replaceAll(" ", "").replaceAll("\t", "").length() <= 0) continue;
                TownyLogger.log.info(line);
            }
            TownyLogger.log.info("------------------------------------");
        }
        catch (IOException e) {
            TownyMessaging.sendDebugMsg("Could not read ChangeLog.txt");
        }
        TownySettings.setLastRunVersion(this.getVersion());
    }

    public TownyUniverse getTownyUniverse() {
        return this.townyUniverse;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isError() {
        return this.error;
    }

    protected void setError(boolean error) {
        this.error = error;
    }

    public boolean isPermissions() {
        return TownySettings.isUsingPermissions();
    }

    public boolean isEssentials() {
        return TownySettings.isUsingEssentials() && this.essentials != null;
    }

    public boolean isCitizens2() {
        return this.citizens2;
    }

    public Essentials getEssentials() throws TownyException {
        if (this.essentials == null) {
            throw new TownyException("Essentials is not installed, or not enabled!");
        }
        return this.essentials;
    }

    public World getServerWorld(String name) throws NotRegisteredException {
        for (World world : BukkitTools.getWorlds()) {
            if (!world.getName().equals(name)) continue;
            return world;
        }
        throw new NotRegisteredException(String.format("A world called '$%s' has not been registered.", name));
    }

    public boolean hasCache(Player player) {
        return this.playerCache.containsKey(player.getName().toLowerCase());
    }

    public void newCache(Player player) {
        try {
            this.getTownyUniverse();
            this.playerCache.put(player.getName().toLowerCase(), new PlayerCache(TownyUniverse.getDataSource().getWorld(player.getWorld().getName()), player));
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendErrorMsg((Object)player, "Could not create permission cache for this world (" + player.getWorld().getName() + ".");
        }
    }

    public void deleteCache(Player player) {
        this.deleteCache(player.getName());
    }

    public void deleteCache(String name) {
        this.playerCache.remove(name.toLowerCase());
    }

    public PlayerCache getCache(Player player) {
        if (!this.hasCache(player)) {
            this.newCache(player);
            this.getCache(player).setLastTownBlock(new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player)));
        }
        return this.playerCache.get(player.getName().toLowerCase());
    }

    public void resetCache() {
        Player[] playerArray = BukkitTools.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            if (player != null) {
                this.getCache(player).resetAndUpdate(new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player)));
            }
            ++n2;
        }
    }

    public void updateCache(WorldCoord worldCoord) {
        Player[] playerArray = BukkitTools.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            if (player != null && Coord.parseCoord((Entity)player).equals(worldCoord)) {
                this.getCache(player).resetAndUpdate(worldCoord);
            }
            ++n2;
        }
    }

    public void updateCache() {
        WorldCoord worldCoord = null;
        Player[] playerArray = BukkitTools.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            if (player != null) {
                worldCoord = new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player));
                PlayerCache cache = this.getCache(player);
                if (cache.getLastTownBlock() != worldCoord) {
                    cache.resetAndUpdate(worldCoord);
                }
            }
            ++n2;
        }
    }

    public void updateCache(Player player) {
        WorldCoord worldCoord = new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player));
        PlayerCache cache = this.getCache(player);
        if (cache.getLastTownBlock() != worldCoord) {
            cache.resetAndUpdate(worldCoord);
        }
    }

    public void resetCache(Player player) {
        this.getCache(player).resetAndUpdate(new WorldCoord(player.getWorld().getName(), Coord.parseCoord((Entity)player)));
    }

    public void setPlayerMode(Player player, String[] modes, boolean notify) {
        if (player == null) {
            return;
        }
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            resident.setModes(modes, notify);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
    }

    public void removePlayerMode(Player player) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            resident.clearModes();
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
    }

    public List<String> getPlayerMode(Player player) {
        return this.getPlayerMode(player.getName());
    }

    public List<String> getPlayerMode(String name) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(name);
            return resident.getModes();
        }
        catch (NotRegisteredException e) {
            return null;
        }
    }

    public boolean hasPlayerMode(Player player, String mode) {
        return this.hasPlayerMode(player.getName(), mode);
    }

    public boolean hasPlayerMode(String name, String mode) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(name);
            return resident.hasMode(mode);
        }
        catch (NotRegisteredException e) {
            return false;
        }
    }

    public String getConfigPath() {
        return String.valueOf(this.getDataFolder().getPath()) + FileMgmt.fileSeparator() + "settings" + FileMgmt.fileSeparator() + "config.yml";
    }

    public Object getSetting(String root) {
        return TownySettings.getProperty(root);
    }

    public void log(String msg) {
        if (TownySettings.isLogging()) {
            TownyLogger.log.info(ChatColor.stripColor((String)msg));
        }
    }

    public void setupLogger() {
        TownyLogger.setup(this.getTownyUniverse().getRootFolder(), TownySettings.isAppendingToLog());
    }

    public void appendQuestion(Questioner questioner, Question question) throws Exception {
        for (Option option : question.getOptions()) {
            if (!(option.getReaction() instanceof TownyQuestionTask)) continue;
            ((TownyQuestionTask)((Object)option.getReaction())).setTowny(this);
        }
        questioner.appendQuestion(question);
    }

    public boolean parseOnOff(String s) throws Exception {
        if (s.equalsIgnoreCase("on")) {
            return true;
        }
        if (s.equalsIgnoreCase("off")) {
            return false;
        }
        throw new Exception(String.format(TownySettings.getLangString("msg_err_invalid_input"), " on/off."));
    }
}

