/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Compass;
import org.bukkit.entity.Player;

public class TownyAsciiMap {
    public static final int lineWidth = 27;
    public static final int halfLineWidth = 13;
    public static final String[] help = new String[]{"  \u00a78-\u00a77 = Unclaimed", "  \u00a7f+\u00a77 = Claimed", "  \u00a7f$\u00a77 = For sale", "  \u00a7a+\u00a77 = Your town", "  \u00a7e+\u00a77 = Your plot", "  \u00a72+\u00a77 = Ally", "  \u00a74+\u00a77 = Enemy"};

    public static String[] generateCompass(Player player) {
        Compass.Point dir = Compass.getCompassPointForDirection(player.getLocation().getYaw());
        return new String[]{"\u00a70  -----  ", "\u00a70  -" + (dir == Compass.Point.NW ? "\u00a76\\" : "-") + (dir == Compass.Point.N ? "\u00a76" : "\u00a7f") + "N" + (dir == Compass.Point.NE ? "\u00a76/\u00a70" : "\u00a70-") + "-  ", "\u00a70  -" + (dir == Compass.Point.W ? "\u00a76W" : "\u00a7fW") + "\u00a77" + "+" + (dir == Compass.Point.E ? "\u00a76" : "\u00a7f") + "E" + "\u00a70" + "-  ", "\u00a70  -" + (dir == Compass.Point.SW ? "\u00a76/" : "-") + (dir == Compass.Point.S ? "\u00a76" : "\u00a7f") + "S" + (dir == Compass.Point.SE ? "\u00a76\\\u00a70" : "\u00a70-") + "-  "};
    }

    public static void generateAndSend(Towny plugin, Player player, int lineHeight) {
        TownyWorld world;
        Resident resident;
        boolean hasTown = false;
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
            if (resident.hasTown()) {
                hasTown = true;
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        try {
            world = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
        }
        catch (NotRegisteredException e1) {
            TownyMessaging.sendErrorMsg((Object)player, "You are not in a registered world.");
            return;
        }
        if (!world.isUsingTowny()) {
            TownyMessaging.sendErrorMsg((Object)player, "This world is not using towny.");
            return;
        }
        Coord pos = Coord.parseCoord(plugin.getCache(player).getLastLocation());
        int halfLineHeight = lineHeight / 2;
        String[][] townyMap = new String[27][lineHeight];
        int y = 0;
        int tby = pos.getX() + 13;
        while (tby >= pos.getX() - 13) {
            int x = 0;
            int tbx = pos.getZ() - halfLineHeight;
            while (tbx <= pos.getZ() + (lineHeight - halfLineHeight - 1)) {
                try {
                    TownBlock townblock = world.getTownBlock(tby, tbx);
                    if (!townblock.hasTown()) {
                        throw new TownyException();
                    }
                    if (x == halfLineHeight && y == 13) {
                        townyMap[y][x] = "\u00a76";
                    } else if (hasTown) {
                        if (resident.getTown() == townblock.getTown()) {
                            townyMap[y][x] = "\u00a7a";
                            try {
                                if (resident == townblock.getResident()) {
                                    townyMap[y][x] = "\u00a7e";
                                }
                            }
                            catch (NotRegisteredException notRegisteredException) {}
                        } else {
                            Nation nation;
                            townyMap[y][x] = resident.hasNation() ? (resident.getTown().getNation().hasTown(townblock.getTown()) ? "\u00a72" : (townblock.getTown().hasNation() ? ((nation = resident.getTown().getNation()).hasAlly(townblock.getTown().getNation()) ? "\u00a72" : (nation.hasEnemy(townblock.getTown().getNation()) ? "\u00a74" : "\u00a7f")) : "\u00a7f")) : "\u00a7f";
                        }
                    } else {
                        townyMap[y][x] = "\u00a7f";
                    }
                    if (townblock.getPlotPrice() != -1.0) {
                        if (townblock.getType().equals((Object)TownBlockType.COMMERCIAL)) {
                            townyMap[y][x] = "\u00a73";
                        }
                        String[] stringArray = townyMap[y];
                        int n = x;
                        stringArray[n] = String.valueOf(stringArray[n]) + "$";
                    } else if (townblock.isHomeBlock()) {
                        String[] stringArray = townyMap[y];
                        int n = x;
                        stringArray[n] = String.valueOf(stringArray[n]) + "H";
                    } else {
                        String[] stringArray = townyMap[y];
                        int n = x;
                        stringArray[n] = String.valueOf(stringArray[n]) + townblock.getType().getAsciiMapKey();
                    }
                }
                catch (TownyException e) {
                    townyMap[y][x] = x == halfLineHeight && y == 13 ? "\u00a76" : "\u00a78";
                    String[] stringArray = townyMap[y];
                    int n = x;
                    stringArray[n] = String.valueOf(stringArray[n]) + "-";
                }
                ++x;
                ++tbx;
            }
            ++y;
            --tby;
        }
        String[] compass = TownyAsciiMap.generateCompass(player);
        player.sendMessage(ChatTools.formatTitle("Towny Map \u00a7f(" + pos.toString() + ")"));
        int lineCount = 0;
        int my = 0;
        while (my < lineHeight) {
            String line = compass[0];
            if (lineCount < compass.length) {
                line = compass[lineCount];
            }
            int mx = 26;
            while (mx >= 0) {
                line = String.valueOf(line) + townyMap[mx][my];
                --mx;
            }
            if (lineCount < help.length) {
                line = String.valueOf(line) + help[lineCount];
            }
            player.sendMessage(line);
            ++lineCount;
            ++my;
        }
        try {
            TownBlock townblock = world.getTownBlock(pos);
            TownyMessaging.sendMsg((Object)player, "Town: " + (townblock.hasTown() ? townblock.getTown().getName() : "None") + " : " + "Owner: " + (townblock.hasResident() ? townblock.getResident().getName() : "None"));
        }
        catch (TownyException e) {
            player.sendMessage("");
        }
    }
}

