/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.iConomy.iConomy;
import com.iConomy.system.Account;
import com.nijikokun.register.payment.Method;
import com.nijikokun.register.payment.Methods;
import com.palmergames.bukkit.towny.Towny;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class TownyEconomyHandler {
    private static Towny plugin = null;
    private static Economy vaultEconomy = null;
    private static EcoType Type = EcoType.NONE;
    private static String version = "";

    public static void initialize(Towny plugin) {
        TownyEconomyHandler.plugin = plugin;
    }

    public static EcoType getType() {
        return Type;
    }

    public static boolean isActive() {
        return Type != EcoType.NONE;
    }

    public static String getVersion() {
        return version;
    }

    private static void setVersion(String version) {
        TownyEconomyHandler.version = version;
    }

    public static Boolean setupEconomy() {
        Plugin economyProvider = null;
        economyProvider = plugin.getServer().getPluginManager().getPlugin("iConomy");
        if (economyProvider != null && economyProvider.getDescription().getVersion().matches("5.01")) {
            TownyEconomyHandler.setVersion(String.format("%s v%s", "iConomy", economyProvider.getDescription().getVersion()));
            Type = EcoType.ICO5;
            return true;
        }
        economyProvider = plugin.getServer().getPluginManager().getPlugin("Register");
        if (economyProvider != null) {
            TownyEconomyHandler.setVersion(String.format("%s v%s", "Register", economyProvider.getDescription().getVersion()));
            Type = EcoType.REGISTER;
            return true;
        }
        try {
            RegisteredServiceProvider vaultEcoProvider = plugin.getServer().getServicesManager().getRegistration(Economy.class);
            if (vaultEcoProvider != null) {
                vaultEconomy = (Economy)vaultEcoProvider.getProvider();
                TownyEconomyHandler.setVersion(String.format("%s v%s", "Vault", vaultEcoProvider.getPlugin().getDescription().getVersion()));
                Type = EcoType.VAULT;
                return true;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return false;
    }

    private static Object getEconomyAccount(String accountName) {
        switch (Type) {
            case ICO5: {
                return iConomy.getAccount((String)accountName);
            }
            case REGISTER: {
                if (!Methods.getMethod().hasAccount(accountName)) {
                    Methods.getMethod().createAccount(accountName);
                }
                return Methods.getMethod().getAccount(accountName);
            }
        }
        return null;
    }

    public static void removeAccount(String accountName) {
        try {
            switch (Type) {
                case ICO5: {
                    iConomy.getAccount((String)accountName).remove();
                    break;
                }
                case REGISTER: {
                    Method.MethodAccount account = (Method.MethodAccount)TownyEconomyHandler.getEconomyAccount(accountName);
                    account.remove();
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public static double getBalance(String accountName, World world) {
        switch (Type) {
            case ICO5: {
                Account icoAccount = (Account)TownyEconomyHandler.getEconomyAccount(accountName);
                if (icoAccount == null) break;
                return icoAccount.getHoldings().balance();
            }
            case REGISTER: {
                Method.MethodAccount registerAccount = (Method.MethodAccount)TownyEconomyHandler.getEconomyAccount(accountName);
                if (registerAccount == null) break;
                return registerAccount.balance(world);
            }
            case VAULT: {
                if (!vaultEconomy.hasAccount(accountName)) {
                    vaultEconomy.createPlayerAccount(accountName);
                }
                return vaultEconomy.getBalance(accountName);
            }
        }
        return 0.0;
    }

    public static boolean hasEnough(String accountName, Double amount, World world) {
        return TownyEconomyHandler.getBalance(accountName, world) >= amount;
    }

    public static boolean subtract(String accountName, Double amount, World world) {
        switch (Type) {
            case ICO5: {
                Account icoAccount = (Account)TownyEconomyHandler.getEconomyAccount(accountName);
                if (icoAccount == null) break;
                icoAccount.getHoldings().subtract(amount.doubleValue());
                return true;
            }
            case REGISTER: {
                Method.MethodAccount registerAccount = (Method.MethodAccount)TownyEconomyHandler.getEconomyAccount(accountName);
                if (registerAccount == null) break;
                return registerAccount.subtract(amount.doubleValue(), world);
            }
            case VAULT: {
                if (!vaultEconomy.hasAccount(accountName)) {
                    vaultEconomy.createPlayerAccount(accountName);
                }
                return TownyEconomyHandler.vaultEconomy.withdrawPlayer((String)accountName, (double)amount.doubleValue()).type == EconomyResponse.ResponseType.SUCCESS;
            }
        }
        return false;
    }

    public static boolean add(String accountName, Double amount, World world) {
        switch (Type) {
            case ICO5: {
                Account icoAccount = (Account)TownyEconomyHandler.getEconomyAccount(accountName);
                if (icoAccount == null) break;
                icoAccount.getHoldings().add(amount.doubleValue());
                return true;
            }
            case REGISTER: {
                Method.MethodAccount registerAccount = (Method.MethodAccount)TownyEconomyHandler.getEconomyAccount(accountName);
                if (registerAccount == null) break;
                return registerAccount.add(amount.doubleValue(), world);
            }
            case VAULT: {
                if (!vaultEconomy.hasAccount(accountName)) {
                    vaultEconomy.createPlayerAccount(accountName);
                }
                return TownyEconomyHandler.vaultEconomy.depositPlayer((String)accountName, (double)amount.doubleValue()).type == EconomyResponse.ResponseType.SUCCESS;
            }
        }
        return false;
    }

    public static boolean setBalance(String accountName, Double amount, World world) {
        switch (Type) {
            case ICO5: {
                Account icoAccount = (Account)TownyEconomyHandler.getEconomyAccount(accountName);
                if (icoAccount == null) break;
                icoAccount.getHoldings().set(amount.doubleValue());
                return true;
            }
            case REGISTER: {
                Method.MethodAccount registerAccount = (Method.MethodAccount)TownyEconomyHandler.getEconomyAccount(accountName);
                if (registerAccount == null) break;
                return registerAccount.set(amount.doubleValue(), world);
            }
            case VAULT: {
                if (!vaultEconomy.hasAccount(accountName)) {
                    vaultEconomy.createPlayerAccount(accountName);
                }
                return TownyEconomyHandler.vaultEconomy.depositPlayer((String)accountName, (double)(amount.doubleValue() - TownyEconomyHandler.vaultEconomy.getBalance((String)accountName))).type == EconomyResponse.ResponseType.SUCCESS;
            }
        }
        return false;
    }

    public static String getFormattedBalance(double balance) {
        try {
            switch (Type) {
                case ICO5: {
                    return iConomy.format((double)balance);
                }
                case REGISTER: {
                    return Methods.getMethod().format(balance);
                }
                case VAULT: {
                    return vaultEconomy.format(balance);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.format("%.2f", balance);
    }

    public static enum EcoType {
        NONE,
        ICO5,
        REGISTER,
        VAULT;

    }
}

