/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.util.StringMgmt;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class TownyFormatter {
    public static final SimpleDateFormat lastOnlineFormat = new SimpleDateFormat("MMMMM dd '@' HH:mm");
    public static final SimpleDateFormat registeredFormat = new SimpleDateFormat("MMM d yyyy");
    public static final String residentListPrefixFormat = "%3$s%1$s %4$s[%2$d]%3$s:%5$s ";

    public static void initialize(Towny plugin) {
    }

    public static List<String> getFormattedOnlineResidents(String prefix, ResidentList residentList) {
        List<Resident> onlineResidents = TownyUniverse.getOnlineResidents(residentList);
        return TownyFormatter.getFormattedResidents(prefix, onlineResidents);
    }

    public static List<String> getFormattedResidents(String prefix, List<Resident> residentList) {
        return ChatTools.listArr(TownyFormatter.getFormattedNames(residentList), String.format(residentListPrefixFormat, prefix, residentList.size(), "\u00a72", "\u00a7a", "\u00a7f"));
    }

    public static String[] getFormattedNames(List<Resident> residentList) {
        return TownyFormatter.getFormattedNames(residentList.toArray(new Resident[0]));
    }

    public static String getTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("hh:mm aa");
        return sdf.format(System.currentTimeMillis());
    }

    public static List<String> getStatus(TownBlock townBlock) {
        ArrayList<String> out = new ArrayList<String>();
        try {
            Town town = townBlock.getTown();
            TownyWorld world = townBlock.getWorld();
            TownBlockOwner owner = townBlock.hasResident() ? townBlock.getResident() : townBlock.getTown();
            out.add(ChatTools.formatTitle(String.valueOf(TownyFormatter.getFormattedName(owner)) + (BukkitTools.isOnline(owner.getName()) ? "\u00a7a (Online)" : "")));
            out.add("\u00a72 Perm: " + (owner instanceof Resident ? townBlock.getPermissions().getColourString() : townBlock.getPermissions().getColourString().replace("f", "r")));
            out.add("\u00a72PvP: " + (town.isPVP() || world.isForcePVP() || townBlock.getPermissions().pvp ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Explosions: " + (world.isForceExpl() || townBlock.getPermissions().explosion ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Firespread: " + (town.isFire() || world.isForceFire() || townBlock.getPermissions().fire ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Mob Spawns: " + (town.hasMobs() || world.isForceTownMobs() || townBlock.getPermissions().mobs ? "\u00a74ON" : "\u00a7aOFF"));
        }
        catch (NotRegisteredException e) {
            out.add("Error: " + e.getMessage());
        }
        return out;
    }

    public static List<String> getStatus(Resident resident) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(ChatTools.formatTitle(String.valueOf(TownyFormatter.getFormattedName(resident)) + (BukkitTools.isOnline(resident.getName()) ? "\u00a7a (Online)" : "")));
        out.add("\u00a72Registered: \u00a7a" + registeredFormat.format(resident.getRegistered()) + "\u00a78" + " | " + "\u00a72" + "Last Online: " + "\u00a7a" + lastOnlineFormat.format(resident.getLastOnline()));
        out.add("\u00a72Owner of: \u00a7a" + resident.getTownBlocks().size() + " plots");
        out.add("\u00a72    Perm: " + resident.getPermissions().getColourString());
        out.add("\u00a72PVP: " + (resident.getPermissions().pvp ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Explosions: " + (resident.getPermissions().explosion ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Firespread: " + (resident.getPermissions().fire ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Mob Spawns: " + (resident.getPermissions().mobs ? "\u00a74ON" : "\u00a7aOFF"));
        if (TownySettings.isUsingEconomy() && TownyEconomyHandler.isActive()) {
            out.add("\u00a72Bank: \u00a7a" + resident.getHoldingFormattedBalance());
        }
        String line = "\u00a72Town: \u00a7a";
        if (!resident.hasTown()) {
            line = String.valueOf(line) + "None";
        } else {
            try {
                line = String.valueOf(line) + TownyFormatter.getFormattedName(resident.getTown());
            }
            catch (TownyException e) {
                line = String.valueOf(line) + "Error: " + e.getMessage();
            }
        }
        out.add(line);
        List<Resident> friends = resident.getFriends();
        out.addAll(TownyFormatter.getFormattedResidents("Friends", friends));
        return out;
    }

    public static List<String> getStatus(Town town) {
        ArrayList<String> out = new ArrayList<String>();
        TownyWorld world = town.getWorld();
        String title = TownyFormatter.getFormattedName(town);
        title = String.valueOf(title) + (town.isPVP() || town.getWorld().isForcePVP() ? "\u00a74 (PvP)" : "");
        title = String.valueOf(title) + (town.isOpen() ? "\u00a7b (Open)" : "");
        out.add(ChatTools.formatTitle(title));
        try {
            out.add("\u00a72Board: \u00a7a" + town.getTownBoard());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            out.add("\u00a72Town Size: \u00a7a" + town.getTownBlocks().size() + " / " + TownySettings.getMaxTownBlocks(town) + (TownySettings.isSellingBonusBlocks() ? "\u00a7b [Bought: " + town.getPurchasedBlocks() + "/" + TownySettings.getMaxPurchedBlocks() + "]" : "") + (town.getBonusBlocks() > 0 ? "\u00a7b [Bonus: " + town.getBonusBlocks() + "]" : "") + (TownySettings.getNationBonusBlocks(town) > 0 ? "\u00a7b [NationBonus: " + TownySettings.getNationBonusBlocks(town) + "]" : "") + (town.isPublic() ? "\u00a77 [Home: " + (town.hasHomeBlock() ? town.getHomeBlock().getCoord().toString() : "None") + "]" : ""));
        }
        catch (TownyException townyException) {
            // empty catch block
        }
        if (town.hasOutpostSpawn()) {
            out.add("\u00a72Outposts: \u00a7a" + town.getMaxOutpostSpawn());
        }
        out.add("\u00a72Permissions: " + town.getPermissions().getColourString().replace("f", "r"));
        out.add("\u00a72Explosions: " + (town.isBANG() || world.isForceExpl() ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Firespread: " + (town.isFire() || world.isForceFire() ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Mob Spawns: " + (town.hasMobs() || world.isForceTownMobs() ? "\u00a74ON" : "\u00a7aOFF"));
        String bankString = "";
        if (TownySettings.isUsingEconomy()) {
            if (TownyEconomyHandler.isActive()) {
                bankString = "\u00a72Bank: \u00a7a" + town.getHoldingFormattedBalance();
                if (town.hasUpkeep()) {
                    bankString = String.valueOf(bankString) + "\u00a78 | \u00a72Daily upkeep: \u00a74" + TownySettings.getTownUpkeepCost(town);
                }
                bankString = String.valueOf(bankString) + "\u00a78 | \u00a72Tax: \u00a74" + town.getTaxes() + (town.isTaxPercentage() ? "%" : "");
            }
            out.add(bankString);
        }
        out.add("\u00a72Mayor: \u00a7a" + TownyFormatter.getFormattedName(town.getMayor()));
        if (town.getAssistants().size() > 0) {
            out.addAll(TownyFormatter.getFormattedResidents("Assistants", town.getAssistants()));
        }
        try {
            out.add("\u00a72Nation: \u00a7a" + TownyFormatter.getFormattedName(town.getNation()));
        }
        catch (TownyException townyException) {
            // empty catch block
        }
        String[] residents = TownyFormatter.getFormattedNames(town.getResidents().toArray(new Resident[0]));
        if (residents.length > 34) {
            String[] entire = residents;
            residents = new String[36];
            System.arraycopy(entire, 0, residents, 0, 35);
            residents[35] = "and more...";
        }
        out.addAll(ChatTools.listArr(residents, "\u00a72Residents \u00a7a[" + town.getNumResidents() + "]" + "\u00a72" + ":" + "\u00a7f" + " "));
        return out;
    }

    public static List<String> getStatus(Nation nation) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(ChatTools.formatTitle(TownyFormatter.getFormattedName(nation)));
        String line = "";
        if (TownySettings.isUsingEconomy() && TownyEconomyHandler.isActive()) {
            line = "\u00a72Bank: \u00a7a" + nation.getHoldingFormattedBalance();
            if (TownySettings.getNationUpkeepCost(nation) > 0.0) {
                line = String.valueOf(line) + "\u00a78 | \u00a72Daily upkeep: \u00a74" + TownySettings.getNationUpkeepCost(nation);
            }
        }
        if (nation.isNeutral()) {
            if (line.length() > 0) {
                line = String.valueOf(line) + "\u00a78 | ";
            }
            line = String.valueOf(line) + "\u00a77Neutral";
        }
        if (line.length() > 0) {
            out.add(line);
        }
        if (nation.getNumTowns() > 0 && nation.hasCapital() && nation.getCapital().hasMayor()) {
            out.add("\u00a72King: \u00a7a" + TownyFormatter.getFormattedName(nation.getCapital().getMayor()) + "\u00a72" + "  NationTax: " + "\u00a74" + nation.getTaxes());
        }
        if (nation.getAssistants().size() > 0) {
            out.addAll(ChatTools.listArr(TownyFormatter.getFormattedNames(nation.getAssistants().toArray(new Resident[0])), "\u00a72Assistants:\u00a7f "));
        }
        out.addAll(ChatTools.listArr(TownyFormatter.getFormattedNames(nation.getTowns().toArray(new Town[0])), "\u00a72Towns \u00a7a[" + nation.getNumTowns() + "]" + "\u00a72" + ":" + "\u00a7f" + " "));
        out.addAll(ChatTools.listArr(TownyFormatter.getFormattedNames(nation.getAllies().toArray(new Nation[0])), "\u00a72Allies \u00a7a[" + nation.getAllies().size() + "]" + "\u00a72" + ":" + "\u00a7f" + " "));
        out.addAll(ChatTools.listArr(TownyFormatter.getFormattedNames(nation.getEnemies().toArray(new Nation[0])), "\u00a72Enemies \u00a7a[" + nation.getEnemies().size() + "]" + "\u00a72" + ":" + "\u00a7f" + " "));
        return out;
    }

    public static List<String> getStatus(TownyWorld world) {
        ArrayList<String> out = new ArrayList<String>();
        String title = TownyFormatter.getFormattedName(world);
        title = String.valueOf(title) + (world.isPVP() || world.isForcePVP() ? "\u00a74 (PvP)" : "");
        title = String.valueOf(title) + (world.isClaimable() ? "\u00a7a Claimable" : "\u00a7c NoClaims");
        out.add(ChatTools.formatTitle(title));
        if (!world.isUsingTowny()) {
            out.add(TownySettings.getLangString("msg_set_use_towny_off"));
        } else {
            out.add("\u00a72ForcePvP: " + (world.isForcePVP() ? "\u00a7cOn" : "\u00a7aOff") + "\u00a78" + " | " + "\u00a72" + "Fire: " + (world.isFire() ? "\u00a7cOn" : "\u00a7aOff") + "\u00a78" + " | " + "\u00a72" + "Force Fire: " + (world.isForceFire() ? "\u00a7cForced" : "\u00a7aAdjustable"));
            out.add("\u00a72Explosions: " + (world.isExpl() ? "\u00a7cOn:" : "\u00a7aOff") + "\u00a78" + " | " + "\u00a72" + " Force explosion: " + (world.isForceExpl() ? "\u00a7cForced" : "\u00a7aAdjustable"));
            out.add("\u00a72World Mobs: " + (world.hasWorldMobs() ? "\u00a7cOn" : "\u00a7aOff") + "\u00a78" + " | " + "\u00a72" + "Force TownMobs: " + (world.isForceTownMobs() ? "\u00a7cForced" : "\u00a7aAdjustable"));
            out.add("\u00a72Unclaim Revert: " + (world.isUsingPlotManagementRevert() ? "\u00a7aOn" : "\u00a7coff") + "\u00a78" + " | " + "\u00a72" + "Explosion Revert: " + (world.isUsingPlotManagementWildRevert() ? "\u00a7aOn" : "\u00a7coff"));
            out.add("\u00a72" + world.getUnclaimedZoneName() + ":");
            out.add("    " + (world.getUnclaimedZoneBuild() != false ? "\u00a7a" : "\u00a7c") + "Build" + "\u00a78" + ", " + (world.getUnclaimedZoneDestroy() != false ? "\u00a7a" : "\u00a7c") + "Destroy" + "\u00a78" + ", " + (world.getUnclaimedZoneSwitch() != false ? "\u00a7a" : "\u00a7c") + "Switch" + "\u00a78" + ", " + (world.getUnclaimedZoneItemUse() != false ? "\u00a7a" : "\u00a7c") + "ItemUse");
            out.add("    \u00a72Ignored Blocks:\u00a7a " + StringMgmt.join(world.getUnclaimedZoneIgnoreIds(), ", "));
        }
        return out;
    }

    public static List<String> getTaxStatus(Resident resident) {
        ArrayList<String> out = new ArrayList<String>();
        Town town = null;
        double plotTax = 0.0;
        out.add(ChatTools.formatTitle(String.valueOf(TownyFormatter.getFormattedName(resident)) + (BukkitTools.isOnline(resident.getName()) ? "\u00a7a (Online)" : "")));
        if (resident.hasTown()) {
            try {
                town = resident.getTown();
                out.add("\u00a72Owner of: \u00a7a" + resident.getTownBlocks().size() + " plots");
                if (resident.isMayor() || town.hasAssistant(resident)) {
                    out.add("\u00a72Staff are exempt from paying town taxes.");
                } else if (town.isTaxPercentage()) {
                    out.add("\u00a72Town Tax: \u00a7a" + resident.getHoldingBalance() * town.getTaxes() / 100.0);
                } else {
                    out.add("\u00a72Town Tax: \u00a7a" + town.getTaxes());
                    if (resident.getTownBlocks().size() > 0) {
                        for (TownBlock townBlock : new ArrayList<TownBlock>(resident.getTownBlocks())) {
                            plotTax += townBlock.getType().getTax(townBlock.getTown());
                        }
                        out.add("\u00a72Total Plot Taxes: \u00a7a" + plotTax);
                    }
                    out.add("\u00a72Total Tax to pay: \u00a7a" + (town.getTaxes() + plotTax));
                }
            }
            catch (NotRegisteredException notRegisteredException) {
            }
            catch (EconomyException economyException) {
                // empty catch block
            }
        }
        return out;
    }

    public static String getNamePrefix(Resident resident) {
        if (resident == null) {
            return "";
        }
        if (resident.isKing()) {
            return TownySettings.getKingPrefix(resident);
        }
        if (resident.isMayor()) {
            return TownySettings.getMayorPrefix(resident);
        }
        return "";
    }

    public static String getNamePostfix(Resident resident) {
        if (resident == null) {
            return "";
        }
        if (resident.isKing()) {
            return TownySettings.getKingPostfix(resident);
        }
        if (resident.isMayor()) {
            return TownySettings.getMayorPostfix(resident);
        }
        return "";
    }

    public static String getFormattedName(TownyObject obj) {
        if (obj == null) {
            return "Null";
        }
        if (obj instanceof Resident) {
            return TownyFormatter.getFormattedResidentName((Resident)obj);
        }
        if (obj instanceof Town) {
            return TownyFormatter.getFormattedTownName((Town)obj);
        }
        if (obj instanceof Nation) {
            return TownyFormatter.getFormattedNationName((Nation)obj);
        }
        return obj.getName().replaceAll("_", " ");
    }

    public static String getFormattedResidentName(Resident resident) {
        if (resident == null) {
            return "null";
        }
        if (resident.isKing()) {
            return String.valueOf(TownySettings.getKingPrefix(resident)) + resident.getName().replaceAll("_", " ") + TownySettings.getKingPostfix(resident);
        }
        if (resident.isMayor()) {
            return String.valueOf(TownySettings.getMayorPrefix(resident)) + resident.getName().replaceAll("_", " ") + TownySettings.getMayorPostfix(resident);
        }
        return resident.getName().replaceAll("_", " ");
    }

    public static String getFormattedTownName(Town town) {
        if (town.isCapital()) {
            return String.valueOf(TownySettings.getCapitalPrefix(town)) + town.getName().replaceAll("_", " ") + TownySettings.getCapitalPostfix(town);
        }
        return String.valueOf(TownySettings.getTownPrefix(town)) + town.getName().replaceAll("_", " ") + TownySettings.getTownPostfix(town);
    }

    public static String getFormattedNationName(Nation nation) {
        return String.valueOf(TownySettings.getNationPrefix(nation)) + nation.getName().replaceAll("_", " ") + TownySettings.getNationPostfix(nation);
    }

    public static String[] getFormattedNames(Resident[] residents) {
        ArrayList<String> names = new ArrayList<String>();
        Resident[] residentArray = residents;
        int n = residents.length;
        int n2 = 0;
        while (n2 < n) {
            Resident resident = residentArray[n2];
            names.add(TownyFormatter.getFormattedName(resident));
            ++n2;
        }
        return names.toArray(new String[0]);
    }

    public static String[] getFormattedNames(Town[] towns) {
        ArrayList<String> names = new ArrayList<String>();
        Town[] townArray = towns;
        int n = towns.length;
        int n2 = 0;
        while (n2 < n) {
            Town town = townArray[n2];
            names.add(TownyFormatter.getFormattedName(town));
            ++n2;
        }
        return names.toArray(new String[0]);
    }

    public static String[] getFormattedNames(Nation[] nations) {
        ArrayList<String> names = new ArrayList<String>();
        Nation[] nationArray = nations;
        int n = nations.length;
        int n2 = 0;
        while (n2 < n) {
            Nation nation = nationArray[n2];
            names.add(TownyFormatter.getFormattedName(nation));
            ++n2;
        }
        return names.toArray(new String[0]);
    }
}

