/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TownyMessaging {
    public static void sendErrorMsg(String msg) {
        TownyLogger.log.warning(ChatTools.stripColour("[Towny] Error: " + msg));
    }

    public static void sendErrorMsg(Object sender, String msg) {
        boolean isPlayer = false;
        if (sender instanceof Player) {
            isPlayer = true;
        }
        if (sender == null) {
            System.out.print("Message called with null sender");
        }
        for (String line : ChatTools.color(String.valueOf(TownySettings.getLangString("default_towny_prefix")) + "\u00a7c" + msg)) {
            if (isPlayer) {
                ((Player)sender).sendMessage(line);
                continue;
            }
            ((CommandSender)sender).sendMessage(Colors.strip(line));
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendErrorMsg(Object sender, String[] msg) {
        boolean isPlayer = false;
        if (sender instanceof Player) {
            isPlayer = true;
        }
        for (String line : ChatTools.color(String.valueOf(TownySettings.getLangString("default_towny_prefix")) + "\u00a7c" + msg)) {
            if (isPlayer) {
                ((Player)sender).sendMessage(line);
                continue;
            }
            ((CommandSender)sender).sendMessage(Colors.strip(line));
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendMsg(String msg) {
        TownyLogger.log.info("[Towny] " + ChatTools.stripColour(msg));
    }

    public static void sendMsg(Object sender, String msg) {
        for (String line : ChatTools.color(String.valueOf(TownySettings.getLangString("default_towny_prefix")) + "\u00a72" + msg)) {
            if (sender instanceof Player) {
                ((Player)sender).sendMessage(line);
                continue;
            }
            if (sender instanceof CommandSender) {
                ((CommandSender)sender).sendMessage(Colors.strip(line));
                continue;
            }
            if (!(sender instanceof Resident)) continue;
            try {
                TownyUniverse.getPlayer((Resident)sender).sendMessage(Colors.strip(line));
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendMsg(Player player, String[] msg) {
        for (String line : ChatTools.color(String.valueOf(TownySettings.getLangString("default_towny_prefix")) + "\u00a72" + msg)) {
            player.sendMessage(line);
        }
    }

    public static void sendDevMsg(String msg) {
        if (TownySettings.isDevMode()) {
            Player townyDev = Bukkit.getServer().getPlayer(TownySettings.getDevName());
            if (townyDev == null) {
                return;
            }
            for (String line : ChatTools.color(String.valueOf(TownySettings.getLangString("default_towny_prefix")) + " DevMode: " + "\u00a7c" + msg)) {
                townyDev.sendMessage(line);
            }
        }
    }

    public static void sendDevMsg(String[] msg) {
        if (TownySettings.isDevMode()) {
            Player townyDev = Bukkit.getServer().getPlayer(TownySettings.getDevName());
            if (townyDev == null) {
                return;
            }
            for (String line : ChatTools.color(String.valueOf(TownySettings.getLangString("default_towny_prefix")) + " DevMode: " + "\u00a7c" + msg)) {
                townyDev.sendMessage(line);
            }
        }
    }

    public static void sendDebugMsg(String msg) {
        if (TownySettings.getDebug()) {
            TownyLogger.debug.info(ChatTools.stripColour("[Towny] Debug: " + msg));
        }
        TownyMessaging.sendDevMsg(msg);
    }

    public static void sendMessage(Object sender, List<String> lines) {
        TownyMessaging.sendMessage(sender, lines.toArray(new String[0]));
    }

    public static void sendMessage(Object sender, String line) {
        if (sender instanceof Player) {
            ((Player)sender).sendMessage(line);
        } else if (sender instanceof CommandSender) {
            ((CommandSender)sender).sendMessage(line);
        } else if (sender instanceof Resident) {
            try {
                TownyUniverse.getPlayer((Resident)sender).sendMessage(Colors.strip(line));
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
    }

    public static void sendMessage(Object sender, String[] lines) {
        boolean isPlayer = false;
        if (sender instanceof Player) {
            isPlayer = true;
        }
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (isPlayer) {
                ((Player)sender).sendMessage(line);
            } else {
                ((CommandSender)sender).sendMessage(line);
            }
            ++n2;
        }
    }

    public static void sendTownMessage(Town town, List<String> lines) {
        TownyMessaging.sendTownMessage(town, lines.toArray(new String[0]));
    }

    public static void sendNationMessage(Nation nation, List<String> lines) {
        TownyMessaging.sendNationMessage(nation, lines.toArray(new String[0]));
    }

    public static void sendGlobalMessage(List<String> lines) {
        TownyMessaging.sendGlobalMessage(lines.toArray(new String[0]));
    }

    public static void sendGlobalMessage(String[] lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            TownyLogger.log.info(ChatTools.stripColour("[Global Msg] " + line));
            ++n2;
        }
        stringArray = BukkitTools.getOnlinePlayers();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String player = stringArray[n2];
            if (player != null) {
                String[] stringArray2 = lines;
                int n3 = lines.length;
                int n4 = 0;
                while (n4 < n3) {
                    String line = stringArray2[n4];
                    player.sendMessage(line);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public static void sendGlobalMessage(String line) {
        TownyLogger.log.info(ChatTools.stripColour("[Global Message] " + line));
        Player[] playerArray = BukkitTools.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            if (player != null) {
                player.sendMessage(line);
            }
            ++n2;
        }
    }

    public static void sendResidentMessage(Resident resident, String[] lines) throws TownyException {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            TownyLogger.log.info(ChatTools.stripColour("[Resident Msg] " + resident.getName() + ": " + line));
            ++n2;
        }
        Player player = TownyUniverse.getPlayer(resident);
        String[] stringArray2 = lines;
        int n3 = lines.length;
        n = 0;
        while (n < n3) {
            String line = stringArray2[n];
            player.sendMessage(line);
            ++n;
        }
    }

    public static void sendResidentMessage(Resident resident, String line) throws TownyException {
        TownyLogger.log.info(ChatTools.stripColour("[Resident Msg] " + resident.getName() + ": " + line));
        Player player = TownyUniverse.getPlayer(resident);
        player.sendMessage(String.valueOf(TownySettings.getLangString("default_towny_prefix")) + line);
    }

    public static void sendTownMessage(Town town, String[] lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            TownyLogger.log.info(ChatTools.stripColour("[Town Msg] " + town.getName() + ": " + line));
            ++n2;
        }
        for (Player player : TownyUniverse.getOnlinePlayers(town)) {
            String[] stringArray2 = lines;
            int n3 = lines.length;
            int n4 = 0;
            while (n4 < n3) {
                String line = stringArray2[n4];
                player.sendMessage(line);
                ++n4;
            }
        }
    }

    public static void sendTownMessagePrefixed(Town town, String line) {
        TownyLogger.log.info(ChatTools.stripColour(line));
        for (Player player : TownyUniverse.getOnlinePlayers(town)) {
            player.sendMessage(String.valueOf(TownySettings.getLangString("default_towny_prefix")) + line);
        }
    }

    public static void sendTownMessage(Town town, String line) {
        TownyLogger.log.info(ChatTools.stripColour("[Town Msg] " + town.getName() + ": " + line));
        for (Player player : TownyUniverse.getOnlinePlayers(town)) {
            player.sendMessage(line);
        }
    }

    public static void sendNationMessage(Nation nation, String[] lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            TownyLogger.log.info(ChatTools.stripColour("[Nation Msg] " + nation.getName() + ": " + line));
            ++n2;
        }
        for (Player player : TownyUniverse.getOnlinePlayers(nation)) {
            String[] stringArray2 = lines;
            int n3 = lines.length;
            int n4 = 0;
            while (n4 < n3) {
                String line = stringArray2[n4];
                player.sendMessage(line);
                ++n4;
            }
        }
    }

    public static void sendNationMessage(Nation nation, String line) {
        TownyLogger.log.info(ChatTools.stripColour("[Nation Msg] " + nation.getName() + ": " + line));
        for (Player player : TownyUniverse.getOnlinePlayers(nation)) {
            player.sendMessage(line);
        }
    }

    public static void sendNationMessagePrefixed(Nation nation, String line) {
        TownyLogger.log.info(ChatTools.stripColour("[Nation Msg] " + nation.getName() + ": " + line));
        for (Player player : TownyUniverse.getOnlinePlayers(nation)) {
            player.sendMessage(String.valueOf(TownySettings.getLangString("default_towny_prefix")) + line);
        }
    }

    public static void sendTownBoard(Player player, Town town) {
        for (String line : ChatTools.color("\u00a76[" + town.getName() + "] " + "\u00a7e" + town.getTownBoard())) {
            player.sendMessage(line);
        }
    }

    public static void sendMessageToMode(ResidentList residents, String msg, String modeRequired) {
        for (Resident resident : TownyUniverse.getOnlineResidents(residents)) {
            if (!resident.hasMode(modeRequired)) continue;
            TownyMessaging.sendMessage((Object)resident, msg);
        }
    }

    public static void sendMessageToMode(Town town, String msg, String modeRequired) {
        for (Resident resident : town.getResidents()) {
            if (!BukkitTools.isOnline(resident.getName())) continue;
            TownyMessaging.sendMessage((Object)resident, msg);
        }
    }
}

