/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny;

import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.ChunkNotification;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.TimeTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;

public class TownySettings {
    private static CommentedConfiguration config;
    private static CommentedConfiguration newConfig;
    private static CommentedConfiguration language;
    private static final SortedMap<Integer, Map<TownLevel, Object>> configTownLevel;
    private static final SortedMap<Integer, Map<NationLevel, Object>> configNationLevel;

    static {
        configTownLevel = Collections.synchronizedSortedMap(new TreeMap(Collections.reverseOrder()));
        configNationLevel = Collections.synchronizedSortedMap(new TreeMap(Collections.reverseOrder()));
    }

    public static void newTownLevel(int numResidents, String namePrefix, String namePostfix, String mayorPrefix, String mayorPostfix, int townBlockLimit, double townUpkeepMultiplier) {
        ConcurrentHashMap<TownLevel, Object> m = new ConcurrentHashMap<TownLevel, Object>();
        m.put(TownLevel.NAME_PREFIX, namePrefix);
        m.put(TownLevel.NAME_POSTFIX, namePostfix);
        m.put(TownLevel.MAYOR_PREFIX, mayorPrefix);
        m.put(TownLevel.MAYOR_POSTFIX, mayorPostfix);
        m.put(TownLevel.TOWN_BLOCK_LIMIT, townBlockLimit);
        m.put(TownLevel.UPKEEP_MULTIPLIER, townUpkeepMultiplier);
        configTownLevel.put(numResidents, m);
    }

    public static void newNationLevel(int numResidents, String namePrefix, String namePostfix, String capitalPrefix, String capitalPostfix, String kingPrefix, String kingPostfix, int townBlockLimitBonus, double nationUpkeepMultiplier) {
        ConcurrentHashMap<NationLevel, Object> m = new ConcurrentHashMap<NationLevel, Object>();
        m.put(NationLevel.NAME_PREFIX, namePrefix);
        m.put(NationLevel.NAME_POSTFIX, namePostfix);
        m.put(NationLevel.CAPITAL_PREFIX, capitalPrefix);
        m.put(NationLevel.CAPITAL_POSTFIX, capitalPostfix);
        m.put(NationLevel.KING_PREFIX, kingPrefix);
        m.put(NationLevel.KING_POSTFIX, kingPostfix);
        m.put(NationLevel.TOWN_BLOCK_LIMIT_BONUS, townBlockLimitBonus);
        m.put(NationLevel.UPKEEP_MULTIPLIER, nationUpkeepMultiplier);
        configNationLevel.put(numResidents, m);
    }

    public static void loadTownLevelConfig() throws IOException {
        List levels = config.getMapList("levels.town_level");
        for (Map level : levels) {
            TownySettings.newTownLevel((Integer)level.get("numResidents"), (String)level.get("namePrefix"), (String)level.get("namePostfix"), (String)level.get("mayorPrefix"), (String)level.get("mayorPostfix"), (Integer)level.get("townBlockLimit"), (Double)level.get("upkeepModifier"));
        }
    }

    public static void loadNationLevelConfig() throws IOException {
        List levels = config.getMapList("levels.nation_level");
        for (Map level : levels) {
            TownySettings.newNationLevel((Integer)level.get("numResidents"), (String)level.get("namePrefix"), (String)level.get("namePostfix"), (String)level.get("capitalPrefix"), (String)level.get("capitalPostfix"), (String)level.get("kingPrefix"), (String)level.get("kingPostfix"), level.containsKey("townBlockLimitBonus") ? (Integer)level.get("townBlockLimitBonus") : 0, (Double)level.get("upkeepModifier"));
        }
    }

    public static Map<TownLevel, Object> getTownLevel(int numResidents) {
        return (Map)configTownLevel.get(numResidents);
    }

    public static Map<NationLevel, Object> getNationLevel(int numResidents) {
        return (Map)configNationLevel.get(numResidents);
    }

    public static Map<TownLevel, Object> getTownLevel(Town town) {
        return TownySettings.getTownLevel(TownySettings.calcTownLevel(town));
    }

    public static Map<NationLevel, Object> getNationLevel(Nation nation) {
        return TownySettings.getNationLevel(TownySettings.calcNationLevel(nation));
    }

    public static int calcTownLevel(Town town) {
        int n = town.getNumResidents();
        for (Integer level : configTownLevel.keySet()) {
            if (n < level) continue;
            return level;
        }
        return 0;
    }

    public static int calcNationLevel(Nation nation) {
        int n = nation.getNumResidents();
        for (Integer level : configNationLevel.keySet()) {
            if (n < level) continue;
            return level;
        }
        return 0;
    }

    public static void loadConfig(String filepath, String version) throws IOException {
        File file = FileMgmt.CheckYMLExists(new File(filepath));
        if (file != null) {
            config = new CommentedConfiguration(file);
            if (!config.load()) {
                System.out.print("Failed to load Config!");
            }
            TownySettings.setDefaults(version, file);
            config.save();
            TownySettings.loadCachedObjects();
        }
    }

    public static void loadCachedObjects() throws IOException {
        TownyWarConfig.setFlagBaseMaterial(Material.matchMaterial((String)TownySettings.getString(ConfigNodes.WAR_ENEMY_FLAG_BASE_BLOCK)));
        TownyWarConfig.setFlagLightMaterial(Material.matchMaterial((String)TownySettings.getString(ConfigNodes.WAR_ENEMY_FLAG_LIGHT_BLOCK)));
        TownyWarConfig.setBeaconWireFrameMaterial(Material.matchMaterial((String)TownySettings.getString(ConfigNodes.WAR_ENEMY_BEACON_WIREFRAME_BLOCK)));
        TownySettings.loadTownLevelConfig();
        TownySettings.loadNationLevelConfig();
        TownyWarConfig.setEditableMaterialsInWarZone(TownySettings.getAllowedMaterials(ConfigNodes.WAR_WARZONE_EDITABLE_MATERIALS));
        ChunkNotification.loadFormatStrings();
    }

    public static void loadLanguage(String filepath, String defaultRes) throws IOException {
        String res = TownySettings.getString(ConfigNodes.LANGUAGE.getRoot(), defaultRes);
        String fullPath = String.valueOf(filepath) + FileMgmt.fileSeparator() + res;
        File file = FileMgmt.unpackLanguageFile(fullPath, res, defaultRes);
        if (file != null) {
            language = new CommentedConfiguration(file);
            language.load();
        }
    }

    private static void sendError(String msg) {
        System.out.println("[Towny] Error could not read " + msg);
    }

    private static String[] parseString(String str) {
        return TownySettings.parseSingleLineString(str).split("@");
    }

    public static String parseSingleLineString(String str) {
        return str.replaceAll("&", "\u00a7");
    }

    public static boolean getBoolean(ConfigNodes node) {
        return Boolean.parseBoolean(config.getString(node.getRoot().toLowerCase(), node.getDefault()));
    }

    public static double getDouble(ConfigNodes node) {
        try {
            return Double.parseDouble(config.getString(node.getRoot().toLowerCase(), node.getDefault()).trim());
        }
        catch (NumberFormatException e) {
            TownySettings.sendError(String.valueOf(node.getRoot().toLowerCase()) + " from config.yml");
            return 0.0;
        }
    }

    public static int getInt(ConfigNodes node) {
        try {
            return Integer.parseInt(config.getString(node.getRoot().toLowerCase(), node.getDefault()).trim());
        }
        catch (NumberFormatException e) {
            TownySettings.sendError(String.valueOf(node.getRoot().toLowerCase()) + " from config.yml");
            return 0;
        }
    }

    public static String getString(ConfigNodes node) {
        return config.getString(node.getRoot().toLowerCase(), node.getDefault());
    }

    public static String getString(String root, String def) {
        String data = config.getString(root.toLowerCase(), def);
        if (data == null) {
            TownySettings.sendError(String.valueOf(root.toLowerCase()) + " from config.yml");
            return "";
        }
        return data;
    }

    public static String getLangString(String root) {
        String data = language.getString(root.toLowerCase());
        if (data == null) {
            TownySettings.sendError(String.valueOf(root.toLowerCase()) + " from " + config.getString("language"));
            return "";
        }
        return TownySettings.parseSingleLineString(data);
    }

    public static String getConfigLang(ConfigNodes node) {
        return TownySettings.parseSingleLineString(TownySettings.getString(node));
    }

    public static List<Integer> getIntArr(ConfigNodes node) {
        String[] strArray = TownySettings.getString(node.getRoot(), node.getDefault()).split(",");
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (strArray != null) {
            int ctr = 0;
            while (ctr < strArray.length) {
                if (strArray[ctr] != null) {
                    try {
                        list.add(Integer.parseInt(strArray[ctr].trim()));
                    }
                    catch (NumberFormatException e) {
                        TownySettings.sendError(String.valueOf(node.getRoot().toLowerCase()) + " from config.yml");
                    }
                }
                ++ctr;
            }
        }
        return list;
    }

    private static List<String> getStrArr(ConfigNodes node) {
        String[] strArray = TownySettings.getString(node.getRoot().toLowerCase(), node.getDefault()).split(",");
        ArrayList<String> list = new ArrayList<String>();
        if (strArray != null) {
            int ctr = 0;
            while (ctr < strArray.length) {
                if (strArray[ctr] != null) {
                    list.add(strArray[ctr].trim());
                }
                ++ctr;
            }
        }
        return list;
    }

    public static long getSeconds(ConfigNodes node) {
        try {
            return TimeTools.getSeconds(TownySettings.getString(node));
        }
        catch (NumberFormatException e) {
            TownySettings.sendError(String.valueOf(node.getRoot().toLowerCase()) + " from config.yml");
            return 1L;
        }
    }

    public static Set<Material> getAllowedMaterials(ConfigNodes node) {
        HashSet<Material> allowedMaterials = new HashSet<Material>();
        for (String material : TownySettings.getStrArr(node)) {
            if (material.equals("*")) {
                allowedMaterials.addAll(Arrays.asList(Material.values()));
                continue;
            }
            if (material.startsWith("-")) {
                allowedMaterials.remove(Material.matchMaterial((String)material));
                continue;
            }
            allowedMaterials.add(Material.matchMaterial((String)material));
        }
        return allowedMaterials;
    }

    public static void addComment(String root, String ... comments) {
        newConfig.addComment(root.toLowerCase(), comments);
    }

    private static void setDefaults(String version, File file) {
        newConfig = new CommentedConfiguration(file);
        newConfig.load();
        ConfigNodes[] configNodesArray = ConfigNodes.values();
        int n = configNodesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigNodes root = configNodesArray[n2];
            if (root.getComments().length > 0) {
                TownySettings.addComment(root.getRoot(), root.getComments());
            }
            if (root.getRoot() == ConfigNodes.LEVELS.getRoot()) {
                TownySettings.setDefaultLevels();
            } else if (root.getRoot() != ConfigNodes.LEVELS_TOWN_LEVEL.getRoot() && root.getRoot() != ConfigNodes.LEVELS_NATION_LEVEL.getRoot()) {
                if (root.getRoot() == ConfigNodes.VERSION.getRoot()) {
                    TownySettings.setNewProperty(root.getRoot(), version);
                } else if (root.getRoot() == ConfigNodes.LAST_RUN_VERSION.getRoot()) {
                    TownySettings.setNewProperty(root.getRoot(), TownySettings.getLastRunVersion(version));
                } else if (root.getRoot() == ConfigNodes.VERSION_BUKKIT.getRoot()) {
                    TownySettings.setNewProperty(root.getRoot(), ConfigNodes.VERSION_BUKKIT.getDefault());
                } else {
                    TownySettings.setNewProperty(root.getRoot(), config.get(root.getRoot().toLowerCase()) != null ? config.get(root.getRoot().toLowerCase()) : root.getDefault());
                }
            }
            ++n2;
        }
        config = newConfig;
        newConfig = null;
    }

    private static void setDefaultLevels() {
        HashMap<String, Object> level;
        ArrayList levels;
        TownySettings.addComment(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot(), "", "# default Town levels.");
        if (!config.contains(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot())) {
            levels = new ArrayList();
            level = new HashMap<String, Object>();
            level.put("numResidents", 0);
            level.put("namePrefix", "");
            level.put("namePostfix", " Ruins");
            level.put("mayorPrefix", "Spirit ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 1);
            level.put("upkeepModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 1);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Settlement)");
            level.put("mayorPrefix", "Hermit ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 16);
            level.put("upkeepModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 2);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Hamlet)");
            level.put("mayorPrefix", "Chief ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 32);
            level.put("upkeepModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 6);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Village)");
            level.put("mayorPrefix", "Baron Von ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 96);
            level.put("upkeepModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 10);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Town)");
            level.put("mayorPrefix", "Viscount ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 160);
            level.put("upkeepModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 14);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Large Town)");
            level.put("mayorPrefix", "Count Von ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 224);
            level.put("upkeepModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 20);
            level.put("namePrefix", "");
            level.put("namePostfix", " (City)");
            level.put("mayorPrefix", "Earl ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 320);
            level.put("upkeepModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 24);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Large City)");
            level.put("mayorPrefix", "Duke ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 384);
            level.put("upkeepModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 28);
            level.put("namePrefix", "");
            level.put("namePostfix", " (Metropolis)");
            level.put("mayorPrefix", "Lord ");
            level.put("mayorPostfix", "");
            level.put("townBlockLimit", 448);
            level.put("upkeepModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            newConfig.set(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot(), levels);
        } else {
            newConfig.set(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot(), config.get(ConfigNodes.LEVELS_TOWN_LEVEL.getRoot()));
        }
        TownySettings.addComment(ConfigNodes.LEVELS_NATION_LEVEL.getRoot(), "", "# default Nation levels.");
        if (!config.contains(ConfigNodes.LEVELS_NATION_LEVEL.getRoot())) {
            levels = new ArrayList();
            level = new HashMap();
            level.put("numResidents", 0);
            level.put("namePrefix", "Land of ");
            level.put("namePostfix", " (Nation)");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "Leader ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 10);
            level.put("upkeepModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 10);
            level.put("namePrefix", "Federation of ");
            level.put("namePostfix", " (Nation)");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "Count ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 20);
            level.put("upkeepModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 20);
            level.put("namePrefix", "Dominion of ");
            level.put("namePostfix", " (Nation)");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "Duke ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 40);
            level.put("upkeepModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 30);
            level.put("namePrefix", "Kingdom of ");
            level.put("namePostfix", " (Nation)");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "King ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 60);
            level.put("upkeepModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 40);
            level.put("namePrefix", "The ");
            level.put("namePostfix", " Empire");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "Emperor ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 100);
            level.put("upkeepModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            level.put("numResidents", 60);
            level.put("namePrefix", "The ");
            level.put("namePostfix", " Realm");
            level.put("capitalPrefix", "");
            level.put("capitalPostfix", "");
            level.put("kingPrefix", "God Emperor ");
            level.put("kingPostfix", "");
            level.put("townBlockLimitBonus", 140);
            level.put("upkeepModifier", 1.0);
            levels.add(new HashMap(level));
            level.clear();
            newConfig.set(ConfigNodes.LEVELS_NATION_LEVEL.getRoot(), levels);
        } else {
            newConfig.set(ConfigNodes.LEVELS_NATION_LEVEL.getRoot(), config.get(ConfigNodes.LEVELS_NATION_LEVEL.getRoot()));
        }
    }

    public static String[] getRegistrationMsg(String name) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_REGISTRATION"), name));
    }

    public static String[] getNewTownMsg(String who, String town) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_NEW_TOWN"), who, town));
    }

    public static String[] getNewNationMsg(String who, String nation) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_NEW_NATION"), who, nation));
    }

    public static String[] getJoinTownMsg(String who) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_JOIN_TOWN"), who));
    }

    public static String[] getJoinNationMsg(String who) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_JOIN_NATION"), who));
    }

    public static String[] getNewMayorMsg(String who) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_NEW_MAYOR"), who));
    }

    public static String[] getNewKingMsg(String who, String nation) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_NEW_KING"), who, nation));
    }

    public static String[] getJoinWarMsg(TownyObject obj) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_JOIN"), obj.getName()));
    }

    public static String[] getWarTimeEliminatedMsg(String who) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_ELIMINATED"), who));
    }

    public static String[] getWarTimeForfeitMsg(String who) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_FORFEITED"), who));
    }

    public static String[] getWarTimeLoseTownBlockMsg(WorldCoord worldCoord, String town) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_LOSE_BLOCK"), worldCoord.toString(), town));
    }

    public static String[] getWarTimeScoreMsg(Town town, int n) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_WAR_SCORE"), town.getName(), n));
    }

    public static String[] getCouldntPayTaxesMsg(TownyObject obj, String type) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_COULDNT_PAY_TAXES"), obj.getName(), type));
    }

    public static String getPayedTownTaxMsg() {
        return TownySettings.getLangString("MSG_PAYED_TOWN_TAX");
    }

    public static String getPayedResidentTaxMsg() {
        return TownySettings.getLangString("MSG_PAYED_RESIDENT_TAX");
    }

    public static String getTaxExemptMsg() {
        return TownySettings.getLangString("MSG_TAX_EXEMPT");
    }

    public static String[] getDelResidentMsg(Resident resident) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_DEL_RESIDENT"), resident.getName()));
    }

    public static String[] getDelTownMsg(Town town) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_DEL_TOWN"), town.getName()));
    }

    public static String[] getDelNationMsg(Nation nation) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_DEL_NATION"), nation.getName()));
    }

    public static String[] getBuyResidentPlotMsg(String who, String owner, Double price) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_BUY_RESIDENT_PLOT"), who, owner, price));
    }

    public static String[] getPlotForSaleMsg(String who, WorldCoord worldCoord) {
        return TownySettings.parseString(String.format(TownySettings.getLangString("MSG_PLOT_FOR_SALE"), who, worldCoord.toString()));
    }

    public static String getMayorAbondonMsg() {
        return TownySettings.parseSingleLineString(TownySettings.getLangString("MSG_MAYOR_ABANDON"));
    }

    public static String getNotPermToNewTownLine() {
        return TownySettings.parseSingleLineString(TownySettings.getLangString("MSG_ADMIN_ONLY_CREATE_TOWN"));
    }

    public static String getNotPermToNewNationLine() {
        return TownySettings.parseSingleLineString(TownySettings.getLangString("MSG_ADMIN_ONLY_CREATE_NATION"));
    }

    public static String getKingPrefix(Resident resident) {
        try {
            return (String)TownySettings.getNationLevel(resident.getTown().getNation()).get((Object)NationLevel.KING_PREFIX);
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getKingPrefix.");
            return "";
        }
    }

    public static String getMayorPrefix(Resident resident) {
        try {
            return (String)TownySettings.getTownLevel(resident.getTown()).get((Object)TownLevel.MAYOR_PREFIX);
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getMayorPrefix.");
            return "";
        }
    }

    public static String getCapitalPostfix(Town town) {
        try {
            return (String)TownySettings.getNationLevel(town.getNation()).get((Object)NationLevel.CAPITAL_POSTFIX);
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getCapitalPostfix.");
            return "";
        }
    }

    public static String getTownPostfix(Town town) {
        try {
            return (String)TownySettings.getTownLevel(town).get((Object)TownLevel.NAME_POSTFIX);
        }
        catch (Exception e) {
            TownySettings.sendError("getTownPostfix.");
            return "";
        }
    }

    public static String getNationPostfix(Nation nation) {
        try {
            return (String)TownySettings.getNationLevel(nation).get((Object)NationLevel.NAME_POSTFIX);
        }
        catch (Exception e) {
            TownySettings.sendError("getNationPostfix.");
            return "";
        }
    }

    public static String getNationPrefix(Nation nation) {
        try {
            return (String)TownySettings.getNationLevel(nation).get((Object)NationLevel.NAME_PREFIX);
        }
        catch (Exception e) {
            TownySettings.sendError("getNationPrefix.");
            return "";
        }
    }

    public static String getTownPrefix(Town town) {
        try {
            return (String)TownySettings.getTownLevel(town).get((Object)TownLevel.NAME_PREFIX);
        }
        catch (Exception e) {
            TownySettings.sendError("getTownPrefix.");
            return "";
        }
    }

    public static String getCapitalPrefix(Town town) {
        try {
            return (String)TownySettings.getNationLevel(town.getNation()).get((Object)NationLevel.CAPITAL_PREFIX);
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getCapitalPrefix.");
            return "";
        }
    }

    public static String getKingPostfix(Resident resident) {
        try {
            return (String)TownySettings.getNationLevel(resident.getTown().getNation()).get((Object)NationLevel.KING_POSTFIX);
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getKingPostfix.");
            return "";
        }
    }

    public static String getMayorPostfix(Resident resident) {
        try {
            return (String)TownySettings.getTownLevel(resident.getTown()).get((Object)TownLevel.MAYOR_POSTFIX);
        }
        catch (NotRegisteredException e) {
            TownySettings.sendError("getMayorPostfix.");
            return "";
        }
    }

    public static String getNPCPrefix() {
        return TownySettings.getString(ConfigNodes.FILTERS_NPC_PREFIX.getRoot(), ConfigNodes.FILTERS_NPC_PREFIX.getDefault());
    }

    public static long getInactiveAfter() {
        return TownySettings.getSeconds(ConfigNodes.RES_SETTING_INACTIVE_AFTER_TIME);
    }

    public static String getLoadDatabase() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_LOAD);
    }

    public static String getSaveDatabase() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_SAVE);
    }

    public static String getSQLHostName() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_HOSTNAME);
    }

    public static String getSQLPort() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_PORT);
    }

    public static String getSQLDBName() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_DBNAME);
    }

    public static String getSQLTablePrefix() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_TABLEPREFIX);
    }

    public static String getSQLUsername() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_USERNAME);
    }

    public static String getSQLPassword() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DATABASE_PASSWORD);
    }

    public static int getMaxTownBlocks(Town town) {
        int ratio = TownySettings.getTownBlockRatio();
        int n = town.getBonusBlocks() + town.getPurchasedBlocks();
        n = ratio == 0 ? (n += ((Integer)TownySettings.getTownLevel(town).get((Object)TownLevel.TOWN_BLOCK_LIMIT)).intValue()) : (n += town.getNumResidents() * ratio);
        if (town.hasNation()) {
            try {
                n += ((Integer)TownySettings.getNationLevel(town.getNation()).get((Object)NationLevel.TOWN_BLOCK_LIMIT_BONUS)).intValue();
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return n;
    }

    public static int getNationBonusBlocks(Nation nation) {
        return (Integer)TownySettings.getNationLevel(nation).get((Object)NationLevel.TOWN_BLOCK_LIMIT_BONUS);
    }

    public static int getNationBonusBlocks(Town town) {
        if (town.hasNation()) {
            try {
                return TownySettings.getNationBonusBlocks(town.getNation());
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static int getTownBlockRatio() {
        return TownySettings.getInt(ConfigNodes.TOWN_TOWN_BLOCK_RATIO);
    }

    public static int getTownBlockSize() {
        return TownySettings.getInt(ConfigNodes.TOWN_TOWN_BLOCK_SIZE);
    }

    public static boolean getFriendlyFire() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_FRIENDLY_FIRE);
    }

    public static boolean isTownCreationAdminOnly() {
        return TownySettings.getBoolean(ConfigNodes.PERMS_TOWN_CREATION_ADMIN_ONLY);
    }

    public static boolean isNationCreationAdminOnly() {
        return TownySettings.getBoolean(ConfigNodes.PERMS_NATION_CREATION_ADMIN_ONLY);
    }

    public static boolean isUsingEconomy() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_USING_ECONOMY);
    }

    public static boolean isUsingEssentials() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_USING_ESSENTIALS);
    }

    public static void setUsingEssentials(boolean newSetting) {
        TownySettings.setProperty(ConfigNodes.PLUGIN_USING_ESSENTIALS.getRoot(), newSetting);
    }

    public static double getNewTownPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_NEW_TOWN);
    }

    public static double getNewNationPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_NEW_NATION);
    }

    public static boolean getUnclaimedZoneBuildRights() {
        return TownySettings.getBoolean(ConfigNodes.UNCLAIMED_ZONE_BUILD);
    }

    public static boolean getUnclaimedZoneDestroyRights() {
        return TownySettings.getBoolean(ConfigNodes.UNCLAIMED_ZONE_DESTROY);
    }

    public static boolean getUnclaimedZoneItemUseRights() {
        return TownySettings.getBoolean(ConfigNodes.UNCLAIMED_ZONE_ITEM_USE);
    }

    public static boolean getDebug() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_DEBUG_MODE);
    }

    public static void setDebug(boolean b) {
        TownySettings.setProperty(ConfigNodes.PLUGIN_DEBUG_MODE.getRoot(), b);
    }

    public static boolean getShowTownNotifications() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_SHOW_TOWN_NOTIFICATIONS);
    }

    public static String getUnclaimedZoneName() {
        return TownySettings.getLangString("UNCLAIMED_ZONE_NAME");
    }

    public static int getMaxTitleLength() {
        return TownySettings.getInt(ConfigNodes.FILTERS_MODIFY_CHAT_MAX_LGTH);
    }

    public static int getMaxNameLength() {
        return TownySettings.getInt(ConfigNodes.FILTERS_MAX_NAME_LGTH);
    }

    public static long getDeleteTime() {
        return TownySettings.getSeconds(ConfigNodes.RES_SETTING_DELETE_OLD_RESIDENTS_TIME);
    }

    public static boolean isDeleteEcoAccount() {
        return TownySettings.getBoolean(ConfigNodes.RES_SETTING_DELETE_OLD_RESIDENTS_ECO);
    }

    public static boolean isDeletingOldResidents() {
        return TownySettings.getBoolean(ConfigNodes.RES_SETTING_DELETE_OLD_RESIDENTS_ENABLE);
    }

    public static int getWarTimeWarningDelay() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_WARNING_DELAY);
    }

    public static boolean isWarTimeTownsNeutral() {
        return TownySettings.getBoolean(ConfigNodes.WAR_EVENT_TOWNS_NEUTRAL);
    }

    public static boolean isAllowWarBlockGriefing() {
        return TownySettings.getBoolean(ConfigNodes.WAR_EVENT_BLOCK_GRIEFING);
    }

    public static int getWarzoneTownBlockHealth() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_TOWN_BLOCK_HP);
    }

    public static int getWarzoneHomeBlockHealth() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_HOME_BLOCK_HP);
    }

    public static String[] getWarTimeLoseTownBlockMsg(WorldCoord worldCoord) {
        return TownySettings.getWarTimeLoseTownBlockMsg(worldCoord, "");
    }

    public static String getDefaultTownName() {
        return TownySettings.getString(ConfigNodes.RES_SETTING_DEFAULT_TOWN_NAME);
    }

    public static int getWarPointsForTownBlock() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_POINTS_TOWNBLOCK);
    }

    public static int getWarPointsForTown() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_POINTS_TOWN);
    }

    public static int getWarPointsForNation() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_POINTS_NATION);
    }

    public static int getWarPointsForKill() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_POINTS_KILL);
    }

    public static int getMinWarHeight() {
        return TownySettings.getInt(ConfigNodes.WAR_EVENT_MIN_HEIGHT);
    }

    public static List<String> getWorldMobRemovalEntities() {
        if (TownySettings.getDebug()) {
            System.out.println("[Towny] Debug: Reading World Mob removal entities. ");
        }
        return TownySettings.getStrArr(ConfigNodes.PROT_MOB_REMOVE_WORLD);
    }

    public static List<String> getTownMobRemovalEntities() {
        if (TownySettings.getDebug()) {
            System.out.println("[Towny] Debug: Reading Town Mob removal entities. ");
        }
        return TownySettings.getStrArr(ConfigNodes.PROT_MOB_REMOVE_TOWN);
    }

    public static List<String> getWildExplosionProtectionEntities() {
        if (TownySettings.getDebug()) {
            System.out.println("[Towny] Debug: Wilderness explosion protection entities. ");
        }
        return TownySettings.getStrArr(ConfigNodes.NWS_PLOT_MANAGEMENT_WILD_ENTITY_REVERT_LIST);
    }

    public static long getMobRemovalSpeed() {
        return TownySettings.getSeconds(ConfigNodes.PROT_MOB_REMOVE_SPEED);
    }

    public static long getHealthRegenSpeed() {
        return TownySettings.getSeconds(ConfigNodes.GTOWN_SETTINGS_REGEN_SPEED);
    }

    public static boolean hasHealthRegen() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_REGEN_ENABLE);
    }

    public static boolean getTownDefaultPublic() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_DEF_PUBLIC);
    }

    public static boolean getTownDefaultOpen() {
        return TownySettings.getBoolean(ConfigNodes.TOWN_DEF_OPEN);
    }

    public static boolean hasTownLimit() {
        return TownySettings.getTownLimit() == 0;
    }

    public static int getTownLimit() {
        return TownySettings.getInt(ConfigNodes.TOWN_LIMIT);
    }

    public static int getMaxPurchedBlocks() {
        return TownySettings.getInt(ConfigNodes.TOWN_MAX_PURCHASED_BLOCKS);
    }

    public static boolean isSellingBonusBlocks() {
        return TownySettings.getMaxPurchedBlocks() != 0;
    }

    public static double getPurchasedBonusBlocksCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_PURCHASED_BONUS_TOWNBLOCK);
    }

    public static double getNationNeutralityCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_NATION_NEUTRALITY);
    }

    public static boolean isAllowingOutposts() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_ALLOW_OUTPOSTS);
    }

    public static double getOutpostCost() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_OUTPOST);
    }

    public static List<Integer> getSwitchIds() {
        return TownySettings.getIntArr(ConfigNodes.PROT_SWITCH_ID);
    }

    public static List<Integer> getUnclaimedZoneIgnoreIds() {
        return TownySettings.getIntArr(ConfigNodes.UNCLAIMED_ZONE_IGNORE);
    }

    public static List<Integer> getItemUseIds() {
        return TownySettings.getIntArr(ConfigNodes.PROT_ITEM_USE_ID);
    }

    public static boolean isUnclaimedZoneIgnoreId(int id) {
        return TownySettings.getUnclaimedZoneIgnoreIds().contains(id);
    }

    public static boolean isSwitchId(int id) {
        return TownySettings.getSwitchIds().contains(id);
    }

    public static boolean isItemUseId(int id) {
        return TownySettings.getItemUseIds().contains(id);
    }

    private static void setProperty(String root, Object value) {
        config.set(root.toLowerCase(), value.toString());
    }

    private static void setNewProperty(String root, Object value) {
        if (value == null) {
            value = "";
        }
        newConfig.set(root.toLowerCase(), value.toString());
    }

    public static Object getProperty(String root) {
        return config.get(root.toLowerCase());
    }

    public static double getClaimPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_CLAIM_TOWNBLOCK);
    }

    public static boolean getUnclaimedZoneSwitchRights() {
        return TownySettings.getBoolean(ConfigNodes.UNCLAIMED_ZONE_SWITCH);
    }

    public static boolean getEndermanProtect() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_ENDERMAN);
    }

    public static String getUnclaimedPlotName() {
        return TownySettings.getLangString("UNCLAIMED_PLOT_NAME");
    }

    public static long getDayInterval() {
        return TownySettings.getSeconds(ConfigNodes.PLUGIN_DAY_INTERVAL);
    }

    public static long getNewDayTime() {
        long day;
        long time = TownySettings.getSeconds(ConfigNodes.PLUGIN_NEWDAY_TIME);
        if (time > (day = TownySettings.getDayInterval())) {
            TownySettings.setProperty(ConfigNodes.PLUGIN_NEWDAY_TIME.getRoot(), day);
            return day;
        }
        return time;
    }

    public static boolean isAllowingTownSpawn() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_ALLOW_TOWN_SPAWN);
    }

    public static boolean isAllowingPublicTownSpawnTravel() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_ALLOW_TOWN_SPAWN_TRAVEL);
    }

    public static List<String> getDisallowedTownSpawnZones() {
        if (TownySettings.getDebug()) {
            System.out.println("[Towny] Debug: Reading disallowed town spawn zones. ");
        }
        return TownySettings.getStrArr(ConfigNodes.GTOWN_SETTINGS_PREVENT_TOWN_SPAWN_IN);
    }

    public static boolean isTaxingDaily() {
        return TownySettings.getBoolean(ConfigNodes.ECO_DAILY_TAXES_ENABLED);
    }

    public static double getMaxTax() {
        return TownySettings.getDouble(ConfigNodes.ECO_DAILY_TAXES_MAX_TAX);
    }

    public static double getMaxTaxPercent() {
        return TownySettings.getDouble(ConfigNodes.ECO_DAILY_TAXES_MAX_TAX_PERCENT);
    }

    public static boolean isBackingUpDaily() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_DAILY_BACKUPS);
    }

    public static double getBaseSpoilsOfWar() {
        return TownySettings.getDouble(ConfigNodes.WAR_EVENT_BASE_SPOILS);
    }

    public static double getWartimeDeathPrice() {
        return TownySettings.getDouble(ConfigNodes.WAR_EVENT_PRICE_DEATH);
    }

    public static double getDeathPrice() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_DEATH);
    }

    public static double getWartimeTownBlockLossPrice() {
        return TownySettings.getDouble(ConfigNodes.WAR_EVENT_TOWN_BLOCK_LOSS_PRICE);
    }

    public static boolean isDevMode() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_DEV_MODE_ENABLE);
    }

    public static void setDevMode(boolean choice) {
        TownySettings.setProperty(ConfigNodes.PLUGIN_DEV_MODE_ENABLE.getRoot(), choice);
    }

    public static String getDevName() {
        return TownySettings.getString(ConfigNodes.PLUGIN_DEV_MODE_DEV_NAME);
    }

    public static boolean isDeclaringNeutral() {
        return TownySettings.getBoolean(ConfigNodes.WARTIME_NATION_CAN_BE_NEUTRAL);
    }

    public static void setDeclaringNeutral(boolean choice) {
        TownySettings.setProperty(ConfigNodes.WARTIME_NATION_CAN_BE_NEUTRAL.getRoot(), choice);
    }

    public static boolean isRemovingOnMonarchDeath() {
        return TownySettings.getBoolean(ConfigNodes.WAR_EVENT_REMOVE_ON_MONARCH_DEATH);
    }

    public static double getTownUpkeepCost(Town town) {
        double multiplier = town != null ? (TownySettings.isUpkeepByPlot() ? (double)town.getTownBlocks().size() : Double.valueOf(TownySettings.getTownLevel(town).get((Object)TownLevel.UPKEEP_MULTIPLIER).toString())) : 1.0;
        return TownySettings.getTownUpkeep() * multiplier;
    }

    public static double getTownUpkeep() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_TOWN_UPKEEP);
    }

    public static boolean isUpkeepByPlot() {
        return TownySettings.getBoolean(ConfigNodes.ECO_PRICE_TOWN_UPKEEP_PLOTBASED);
    }

    public static boolean isUpkeepPayingPlots() {
        return TownySettings.getBoolean(ConfigNodes.ECO_UPKEEP_PLOTPAYMENTS);
    }

    public static double getNationUpkeep() {
        return TownySettings.getDouble(ConfigNodes.ECO_PRICE_NATION_UPKEEP);
    }

    public static double getNationUpkeepCost(Nation nation) {
        double multiplier = nation != null ? Double.valueOf(TownySettings.getNationLevel(nation).get((Object)NationLevel.UPKEEP_MULTIPLIER).toString()) : 1.0;
        return TownySettings.getNationUpkeep() * multiplier;
    }

    public static String getFlatFileBackupType() {
        return TownySettings.getString(ConfigNodes.PLUGIN_FLATFILE_BACKUP);
    }

    public static long getBackupLifeLength() {
        long t = TimeTools.getMillis(TownySettings.getString(ConfigNodes.PLUGIN_BACKUPS_ARE_DELETED_AFTER));
        long minT = TimeTools.getMillis("1d");
        if (t >= 0L && t < minT) {
            t = minT;
        }
        return t;
    }

    public static boolean isPvP() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_PVP);
    }

    public static boolean isForcingPvP() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FORCE_PVP_ON);
    }

    public static boolean isPlayerTramplingCropsDisabled() {
        return TownySettings.getBoolean(ConfigNodes.NWS_DISABLE_PLAYER_CROP_TRAMPLING);
    }

    public static boolean isCreatureTramplingCropsDisabled() {
        return TownySettings.getBoolean(ConfigNodes.NWS_DISABLE_CREATURE_CROP_TRAMPLING);
    }

    public static boolean isWorldMonstersOn() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_MONSTERS_ON);
    }

    public static boolean isExplosions() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_EXPLOSION);
    }

    public static boolean isForcingExplosions() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FORCE_EXPLOSIONS_ON);
    }

    public static boolean isForcingMonsters() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FORCE_TOWN_MONSTERS_ON);
    }

    public static boolean isFire() {
        return TownySettings.getBoolean(ConfigNodes.NWS_WORLD_FIRE);
    }

    public static boolean isForcingFire() {
        return TownySettings.getBoolean(ConfigNodes.NWS_FORCE_FIRE_ON);
    }

    public static boolean isUsingPlotManagementDelete() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_DELETE_ENABLE);
    }

    public static List<Integer> getPlotManagementDeleteIds() {
        return TownySettings.getIntArr(ConfigNodes.NWS_PLOT_MANAGEMENT_DELETE);
    }

    public static boolean isUsingPlotManagementMayorDelete() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_MAYOR_DELETE_ENABLE);
    }

    public static List<String> getPlotManagementMayorDelete() {
        return TownySettings.getStrArr(ConfigNodes.NWS_PLOT_MANAGEMENT_MAYOR_DELETE);
    }

    public static boolean isUsingPlotManagementRevert() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_REVERT_ENABLE);
    }

    public static long getPlotManagementSpeed() {
        return TownySettings.getSeconds(ConfigNodes.NWS_PLOT_MANAGEMENT_REVERT_TIME);
    }

    public static boolean isUsingPlotManagementWildRegen() {
        return TownySettings.getBoolean(ConfigNodes.NWS_PLOT_MANAGEMENT_WILD_MOB_REVERT_ENABLE);
    }

    public static long getPlotManagementWildRegenDelay() {
        return TownySettings.getSeconds(ConfigNodes.NWS_PLOT_MANAGEMENT_WILD_MOB_REVERT_TIME);
    }

    public static List<Integer> getPlotManagementIgnoreIds() {
        return TownySettings.getIntArr(ConfigNodes.NWS_PLOT_MANAGEMENT_REVERT_IGNORE);
    }

    public static boolean isTownRespawning() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_TOWN_RESPAWN);
    }

    public static boolean isTownRespawningInOtherWorlds() {
        return TownySettings.getBoolean(ConfigNodes.GTOWN_SETTINGS_TOWN_RESPAWN_SAME_WORLD_ONLY);
    }

    public static boolean isTownyUpdating(String currentVersion) {
        return !TownySettings.isTownyUpToDate(currentVersion);
    }

    public static int getMinBukkitVersion() {
        return TownySettings.getInt(ConfigNodes.VERSION_BUKKIT);
    }

    public static boolean isBypassVersionCheck() {
        return TownySettings.getBoolean(ConfigNodes.VERSION_BUKKIT_BYPASS);
    }

    public static boolean isTownyUpToDate(String currentVersion) {
        return currentVersion.equals(TownySettings.getLastRunVersion(currentVersion));
    }

    public static String getLastRunVersion(String currentVersion) {
        return TownySettings.getString(ConfigNodes.LAST_RUN_VERSION.getRoot(), currentVersion);
    }

    public static void setLastRunVersion(String currentVersion) {
        TownySettings.setProperty(ConfigNodes.LAST_RUN_VERSION.getRoot(), currentVersion);
        config.save();
    }

    public static int getMinDistanceFromTownHomeblocks() {
        return TownySettings.getInt(ConfigNodes.TOWN_MIN_DISTANCE_FROM_TOWN_HOMEBLOCK);
    }

    public static int getMaxDistanceBetweenHomeblocks() {
        return TownySettings.getInt(ConfigNodes.TOWN_MAX_DISTANCE_BETWEEN_HOMEBLOCKS);
    }

    public static int getMaxResidentPlots(Resident resident) {
        int maxPlots = TownyUniverse.getPermissionSource().getGroupPermissionIntNode(resident.getName(), PermissionNodes.TOWNY_MAX_PLOTS.getNode());
        if (maxPlots == -1) {
            maxPlots = TownySettings.getInt(ConfigNodes.TOWN_MAX_PLOTS_PER_RESIDENT);
        }
        return maxPlots;
    }

    public static boolean getPermFlag_Resident_Friend_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_FR_BUILD);
    }

    public static boolean getPermFlag_Resident_Friend_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_FR_DESTROY);
    }

    public static boolean getPermFlag_Resident_Friend_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_FR_ITEM_USE);
    }

    public static boolean getPermFlag_Resident_Friend_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_FR_SWITCH);
    }

    public static boolean getPermFlag_Resident_Ally_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_ALLY_BUILD);
    }

    public static boolean getPermFlag_Resident_Ally_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_ALLY_DESTROY);
    }

    public static boolean getPermFlag_Resident_Ally_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_ALLY_ITEM_USE);
    }

    public static boolean getPermFlag_Resident_Ally_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_ALLY_SWITCH);
    }

    public static boolean getPermFlag_Resident_Outsider_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_OUTSIDER_BUILD);
    }

    public static boolean getPermFlag_Resident_Outsider_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_OUTSIDER_DESTROY);
    }

    public static boolean getPermFlag_Resident_Outsider_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_OUTSIDER_ITEM_USE);
    }

    public static boolean getPermFlag_Resident_Outsider_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_RES_OUTSIDER_SWITCH);
    }

    public static boolean getPermFlag_Town_Default_PVP() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_DEF_PVP);
    }

    public static boolean getPermFlag_Town_Default_FIRE() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_DEF_FIRE);
    }

    public static boolean getPermFlag_Town_Default_Explosion() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_DEF_EXPLOSION);
    }

    public static boolean getPermFlag_Town_Default_Mobs() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_DEF_MOBS);
    }

    public static boolean getPermFlag_Town_Resident_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_RES_BUILD);
    }

    public static boolean getPermFlag_Town_Resident_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_RES_DESTROY);
    }

    public static boolean getPermFlag_Town_Resident_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_RES_ITEM_USE);
    }

    public static boolean getPermFlag_Town_Resident_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_RES_SWITCH);
    }

    public static boolean getPermFlag_Town_Ally_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_ALLY_BUILD);
    }

    public static boolean getPermFlag_Town_Ally_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_ALLY_DESTROY);
    }

    public static boolean getPermFlag_Town_Ally_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_ALLY_ITEM_USE);
    }

    public static boolean getPermFlag_Town_Ally_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_ALLY_SWITCH);
    }

    public static boolean getPermFlag_Town_Outsider_Build() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_OUTSIDER_BUILD);
    }

    public static boolean getPermFlag_Town_Outsider_Destroy() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_OUTSIDER_DESTROY);
    }

    public static boolean getPermFlag_Town_Outsider_ItemUse() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_OUTSIDER_ITEM_USE);
    }

    public static boolean getPermFlag_Town_Outsider_Switch() {
        return TownySettings.getBoolean(ConfigNodes.FLAGS_TOWN_OUTSIDER_SWITCH);
    }

    public static boolean getDefaultResidentPermission(TownBlockOwner owner, TownyPermission.ActionType type) {
        if (owner instanceof Resident) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Resident_Friend_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Resident_Friend_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Resident_Friend_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Resident_Friend_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        if (owner instanceof Town) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Town_Resident_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Town_Resident_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Town_Resident_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Town_Resident_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean getDefaultAllyPermission(TownBlockOwner owner, TownyPermission.ActionType type) {
        if (owner instanceof Resident) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Resident_Ally_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Resident_Ally_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Resident_Ally_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Resident_Ally_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        if (owner instanceof Town) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Town_Ally_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Town_Ally_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Town_Ally_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Town_Ally_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean getDefaultOutsiderPermission(TownBlockOwner owner, TownyPermission.ActionType type) {
        if (owner instanceof Resident) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Resident_Outsider_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Resident_Outsider_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Resident_Outsider_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Resident_Outsider_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        if (owner instanceof Town) {
            switch (type) {
                case BUILD: {
                    return TownySettings.getPermFlag_Town_Outsider_Build();
                }
                case DESTROY: {
                    return TownySettings.getPermFlag_Town_Outsider_Destroy();
                }
                case SWITCH: {
                    return TownySettings.getPermFlag_Town_Outsider_Switch();
                }
                case ITEM_USE: {
                    return TownySettings.getPermFlag_Town_Outsider_ItemUse();
                }
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean getDefaultPermission(TownBlockOwner owner, TownyPermission.PermLevel level, TownyPermission.ActionType type) {
        switch (level) {
            case RESIDENT: {
                return TownySettings.getDefaultResidentPermission(owner, type);
            }
            case ALLY: {
                return TownySettings.getDefaultAllyPermission(owner, type);
            }
            case OUTSIDER: {
                return TownySettings.getDefaultOutsiderPermission(owner, type);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean isLogging() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_LOGGING);
    }

    public static boolean isUsingQuestioner() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_USING_QUESTIONER_ENABLE);
    }

    public static void setUsingQuestioner(boolean newSetting) {
        TownySettings.setProperty(ConfigNodes.PLUGIN_USING_QUESTIONER_ENABLE.getRoot(), newSetting);
    }

    public static String questionerAccept() {
        return TownySettings.getString(ConfigNodes.PLUGIN_QUESTIONER_ACCEPT);
    }

    public static String questionerDeny() {
        return TownySettings.getString(ConfigNodes.PLUGIN_QUESTIONER_DENY);
    }

    public static boolean isAppendingToLog() {
        return !TownySettings.getBoolean(ConfigNodes.PLUGIN_RESET_LOG_ON_BOOT);
    }

    public static boolean isUsingPermissions() {
        return TownySettings.getBoolean(ConfigNodes.PLUGIN_USING_PERMISSIONS);
    }

    public static void setUsingPermissions(boolean newSetting) {
        TownySettings.setProperty(ConfigNodes.PLUGIN_USING_PERMISSIONS.getRoot(), newSetting);
    }

    public static String getNameFilterRegex() {
        return TownySettings.getString(ConfigNodes.FILTERS_REGEX_NAME_FILTER_REGEX);
    }

    public static String getNameCheckRegex() {
        return TownySettings.getString(ConfigNodes.FILTERS_REGEX_NAME_CHECK_REGEX);
    }

    public static String getNameRemoveRegex() {
        return TownySettings.getString(ConfigNodes.FILTERS_REGEX_NAME_REMOVE_REGEX);
    }

    public static boolean isUsingCheatProtection() {
        return TownySettings.getBoolean(ConfigNodes.PROT_CHEAT);
    }

    public static long getRegenDelay() {
        return TownySettings.getSeconds(ConfigNodes.PROT_REGEN_DELAY);
    }

    public static int getTeleportWarmupTime() {
        return TownySettings.getInt(ConfigNodes.GTOWN_SETTINGS_SPAWN_TIMER);
    }

    public static double getTownBankCap() {
        return TownySettings.getDouble(ConfigNodes.ECO_BANK_CAP_TOWN);
    }

    public static double getNationBankCap() {
        return TownySettings.getDouble(ConfigNodes.ECO_BANK_CAP_NATION);
    }

    public static boolean getTownBankAllowWithdrawls() {
        return TownySettings.getBoolean(ConfigNodes.ECO_BANK_TOWN_ALLOW_WITHDRAWLS);
    }

    public static void SetTownBankAllowWithdrawls(boolean newSetting) {
        TownySettings.setProperty(ConfigNodes.ECO_BANK_TOWN_ALLOW_WITHDRAWLS.getRoot(), newSetting);
    }

    public static boolean geNationBankAllowWithdrawls() {
        return TownySettings.getBoolean(ConfigNodes.ECO_BANK_NATION_ALLOW_WITHDRAWLS);
    }

    public static void SetNationBankAllowWithdrawls(boolean newSetting) {
        TownySettings.setProperty(ConfigNodes.ECO_BANK_NATION_ALLOW_WITHDRAWLS.getRoot(), newSetting);
    }

    @Deprecated
    public static boolean isValidRegionName(String name) {
        return !NameValidation.isBlacklistName(name);
    }

    @Deprecated
    public static boolean isValidName(String name) {
        return NameValidation.isValidName(name);
    }

    @Deprecated
    public static String filterName(String input) {
        return NameValidation.filterName(input);
    }

    public static enum NationLevel {
        NAME_PREFIX,
        NAME_POSTFIX,
        CAPITAL_PREFIX,
        CAPITAL_POSTFIX,
        KING_PREFIX,
        KING_POSTFIX,
        TOWN_BLOCK_LIMIT_BONUS,
        UPKEEP_MULTIPLIER;

    }

    public static enum TownLevel {
        NAME_PREFIX,
        NAME_POSTFIX,
        MAYOR_PREFIX,
        MAYOR_POSTFIX,
        TOWN_BLOCK_LIMIT,
        UPKEEP_MULTIPLIER;

    }
}

