/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import ca.xshade.bukkit.questioner.Questioner;
import ca.xshade.questionmanager.Option;
import ca.xshade.questionmanager.Question;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.questioner.JoinNationTask;
import com.palmergames.bukkit.towny.questioner.ResidentNationQuestionTask;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.InvalidNameException;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NationCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> nation_help;
    private static final List<String> king_help;

    static {
        nation_help = new ArrayList<String>();
        king_help = new ArrayList<String>();
        nation_help.add(ChatTools.formatTitle("/nation"));
        nation_help.add(ChatTools.formatCommand("", "/nation", "", TownySettings.getLangString("nation_help_1")));
        nation_help.add(ChatTools.formatCommand("", "/nation", TownySettings.getLangString("nation_help_2"), TownySettings.getLangString("nation_help_3")));
        nation_help.add(ChatTools.formatCommand("", "/nation", "list", TownySettings.getLangString("nation_help_4")));
        nation_help.add(ChatTools.formatCommand("", "/nation", "online", TownySettings.getLangString("nation_help_9")));
        nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/nation", "deposit [$]", ""));
        nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/nation", "leave", TownySettings.getLangString("nation_help_5")));
        if (!TownySettings.isNationCreationAdminOnly()) {
            nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/nation", "new " + TownySettings.getLangString("nation_help_2"), TownySettings.getLangString("nation_help_6")));
        }
        nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "king ?", TownySettings.getLangString("nation_help_7")));
        nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/nation", "new " + TownySettings.getLangString("nation_help_2") + " [capital]", TownySettings.getLangString("nation_help_8")));
        nation_help.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/nation", "delete " + TownySettings.getLangString("nation_help_2"), ""));
        king_help.add(ChatTools.formatTitle(TownySettings.getLangString("king_help_1")));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "withdraw [$]", ""));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "[add/kick] [town] .. [town]", ""));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "assistant [add/remove] " + TownySettings.getLangString("res_2"), TownySettings.getLangString("res_6")));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "assistant [add+/remove+] " + TownySettings.getLangString("res_2"), TownySettings.getLangString("res_7")));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "set [] .. []", ""));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "toggle [] .. []", ""));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "ally [add/remove] " + TownySettings.getLangString("nation_help_2"), TownySettings.getLangString("king_help_2")));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "enemy [add/remove] " + TownySettings.getLangString("nation_help_2"), TownySettings.getLangString("king_help_3")));
        king_help.add(ChatTools.formatCommand(TownySettings.getLangString("king_sing"), "/nation", "delete", ""));
    }

    public NationCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            System.out.println("[PLAYER_COMMAND] " + player.getName() + ": /" + commandLabel + " " + StringMgmt.join(args));
            if (args == null) {
                for (String line : nation_help) {
                    player.sendMessage(line);
                }
                this.parseNationCommand(player, args);
            } else {
                this.parseNationCommand(player, args);
            }
        } else {
            for (String line : nation_help) {
                sender.sendMessage(Colors.strip(line));
            }
        }
        return true;
    }

    public void parseNationCommand(Player player, String[] split) {
        String nationCom = "/nation";
        if (split.length == 0) {
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                Town town = resident.getTown();
                Nation nation = town.getNation();
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(nation));
            }
            catch (NotRegisteredException x) {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_dont_belong_nation"));
            }
        } else if (split[0].equalsIgnoreCase("?")) {
            for (String line : nation_help) {
                player.sendMessage(line);
            }
        } else if (split[0].equalsIgnoreCase("list")) {
            this.listNations(player);
        } else if (split[0].equalsIgnoreCase("new")) {
            if (split.length == 1) {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_specify_nation_name"));
            } else if (split.length == 2) {
                try {
                    Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                    if (!resident.isMayor() && !resident.getTown().hasAssistant(resident)) {
                        throw new TownyException(TownySettings.getLangString("msg_peasant_right"));
                    }
                    this.newNation(player, split[1], resident.getTown().getName());
                }
                catch (TownyException x) {
                    TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                }
            } else {
                this.newNation(player, split[1], split[2]);
            }
        } else if (split[0].equalsIgnoreCase("leave")) {
            this.nationLeave(player);
        } else if (split[0].equalsIgnoreCase("withdraw")) {
            if (split.length == 2) {
                try {
                    this.nationWithdraw(player, Integer.parseInt(split[1].trim()));
                }
                catch (NumberFormatException e) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
                }
            } else {
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_must_specify_amnt"), nationCom));
            }
        } else if (split[0].equalsIgnoreCase("deposit")) {
            if (split.length == 2) {
                try {
                    this.nationDeposit(player, Integer.parseInt(split[1].trim()));
                }
                catch (NumberFormatException e) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
                }
            } else {
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_must_specify_amnt"), String.valueOf(nationCom) + " deposit"));
            }
        } else {
            String[] newSplit = StringMgmt.remFirstArg(split);
            if (split[0].equalsIgnoreCase("king")) {
                this.nationKing(player, newSplit);
            } else if (split[0].equalsIgnoreCase("add")) {
                this.nationAdd(player, newSplit);
            } else if (split[0].equalsIgnoreCase("kick")) {
                this.nationKick(player, newSplit);
            } else if (split[0].equalsIgnoreCase("assistant")) {
                this.nationAssistant(player, newSplit);
            } else if (split[0].equalsIgnoreCase("set")) {
                this.nationSet(player, newSplit);
            } else if (split[0].equalsIgnoreCase("toggle")) {
                this.nationToggle(player, newSplit);
            } else if (split[0].equalsIgnoreCase("ally")) {
                this.nationAlly(player, newSplit);
            } else if (split[0].equalsIgnoreCase("enemy")) {
                this.nationEnemy(player, newSplit);
            } else if (split[0].equalsIgnoreCase("delete")) {
                this.nationDelete(player, newSplit);
            } else if (split[0].equalsIgnoreCase("online")) {
                try {
                    Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                    Town town = resident.getTown();
                    Nation nation = town.getNation();
                    TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOnlineResidents(TownySettings.getLangString("msg_nation_online"), nation));
                }
                catch (NotRegisteredException x) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_dont_belong_nation"));
                }
            } else {
                try {
                    Nation nation = TownyUniverse.getDataSource().getNation(split[0]);
                    TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(nation));
                }
                catch (NotRegisteredException x) {
                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_registered_1"), split[0]));
                }
            }
        }
    }

    private void nationWithdraw(Player player, int amount) {
        try {
            if (!TownySettings.geNationBankAllowWithdrawls()) {
                throw new TownyException(TownySettings.getLangString("msg_err_withdraw_disabled"));
            }
            if (amount < 0) {
                throw new TownyException(TownySettings.getLangString("msg_err_negative_money"));
            }
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Nation nation = resident.getTown().getNation();
            nation.withdrawFromBank(resident, amount);
            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_xx_withdrew_xx"), resident.getName(), amount, "nation"));
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
        catch (EconomyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
    }

    private void nationDeposit(Player player, int amount) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Nation nation = resident.getTown().getNation();
            double bankcap = TownySettings.getNationBankCap();
            if (bankcap > 0.0 && (double)amount + nation.getHoldingBalance() > bankcap) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_deposit_capped"), bankcap));
            }
            if (amount < 0) {
                throw new TownyException(TownySettings.getLangString("msg_err_negative_money"));
            }
            if (!resident.payTo(amount, nation, "Nation Deposit")) {
                throw new TownyException(TownySettings.getLangString("msg_insuf_funds"));
            }
            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_xx_deposited_xx"), resident.getName(), amount, "nation"));
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
        catch (EconomyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
    }

    public void listNations(Player player) {
        player.sendMessage(ChatTools.formatTitle(TownySettings.getLangString("nation_plu")));
        ArrayList<String> formatedList = new ArrayList<String>();
        for (Nation nation : TownyUniverse.getDataSource().getNations()) {
            formatedList.add("\u00a7b" + nation.getName() + "\u00a73" + " [" + nation.getNumTowns() + "]" + "\u00a7f");
        }
        for (String line : ChatTools.list(formatedList)) {
            player.sendMessage(line);
        }
    }

    public void newNation(Player player, String name, String capitalName) {
        TownyUniverse universe = plugin.getTownyUniverse();
        try {
            String filteredName;
            if (!TownyUniverse.getPermissionSource().isTownyAdmin(player) && (TownySettings.isNationCreationAdminOnly() && !plugin.isPermissions() || plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_NATION_NEW.getNode()))) {
                throw new TownyException(TownySettings.getNotPermToNewNationLine());
            }
            Town town = TownyUniverse.getDataSource().getTown(capitalName);
            if (town.hasNation()) {
                throw new TownyException(TownySettings.getLangString("msg_err_already_nation"));
            }
            try {
                filteredName = NameValidation.checkAndFilterName(name);
            }
            catch (InvalidNameException e) {
                filteredName = null;
            }
            if (filteredName == null || TownyUniverse.getDataSource().hasNation(filteredName)) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_name"), name));
            }
            if (TownySettings.isUsingEconomy() && !town.pay(TownySettings.getNewNationPrice(), "New Nation Cost")) {
                throw new TownyException(TownySettings.getLangString("msg_no_funds_new_nation"));
            }
            this.newNation(universe, name, town);
            TownyMessaging.sendGlobalMessage(TownySettings.getNewNationMsg(player.getName(), name));
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
        catch (EconomyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
    }

    public Nation newNation(TownyUniverse universe, String name, Town town) throws AlreadyRegisteredException, NotRegisteredException {
        TownyUniverse.getDataSource().newNation(name);
        Nation nation = TownyUniverse.getDataSource().getNation(name);
        nation.addTown(town);
        nation.setCapital(town);
        if (TownySettings.isUsingEconomy()) {
            nation.setBalance(0.0);
        }
        TownyUniverse.getDataSource().saveTown(town);
        TownyUniverse.getDataSource().saveNation(nation);
        TownyUniverse.getDataSource().saveNationList();
        return nation;
    }

    public void nationLeave(Player player) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Town town = resident.getTown();
            Nation nation = town.getNation();
            if (!resident.isMayor() && !town.hasAssistant(resident)) {
                throw new TownyException(TownySettings.getLangString("msg_not_mayor_ass"));
            }
            nation.removeTown(town);
            TownyUniverse.getDataSource().saveTown(town);
            TownyUniverse.getDataSource().saveNation(nation);
            TownyUniverse.getDataSource().saveNationList();
            TownyMessaging.sendNationMessage(nation, ChatTools.color(String.format(TownySettings.getLangString("msg_nation_town_left"), town.getName())));
            TownyMessaging.sendTownMessage(town, ChatTools.color(String.format(TownySettings.getLangString("msg_town_left_nation"), nation.getName())));
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        catch (EmptyNationException en) {
            TownyUniverse.getDataSource().removeNation(en.getNation());
            TownyUniverse.getDataSource().saveNationList();
            TownyMessaging.sendGlobalMessage(ChatTools.color(String.format(TownySettings.getLangString("msg_del_nation"), en.getNation().getName())));
        }
    }

    public void nationDelete(Player player, String[] split) {
        if (split.length == 0) {
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                Town town = resident.getTown();
                Nation nation = town.getNation();
                if (!resident.isKing()) {
                    throw new TownyException(TownySettings.getLangString("msg_not_king"));
                }
                if (plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_NATION_DELETE.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                TownyUniverse.getDataSource().removeNation(nation);
                TownyMessaging.sendGlobalMessage(TownySettings.getDelNationMsg(nation));
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
        }
        try {
            if (!TownyUniverse.getPermissionSource().isTownyAdmin(player)) {
                throw new TownyException(TownySettings.getLangString("msg_err_admin_only_delete_nation"));
            }
            Nation nation = TownyUniverse.getDataSource().getNation(split[0]);
            TownyUniverse.getDataSource().removeNation(nation);
            TownyMessaging.sendGlobalMessage(TownySettings.getDelNationMsg(nation));
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
    }

    public void nationKing(Player player, String[] split) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            for (String line : king_help) {
                player.sendMessage(line);
            }
        }
    }

    public void nationAdd(Player player, String[] names) {
        Nation nation;
        if (names.length < 1) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation add [names]");
            return;
        }
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            nation = resident.getTown().getNation();
            if (!resident.isKing() && !nation.hasAssistant(resident)) {
                throw new TownyException(TownySettings.getLangString("msg_not_king_ass"));
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        NationCommand.nationAdd(player, nation, TownyUniverse.getDataSource().getTowns(names));
    }

    public static void nationAdd(Player player, Nation nation, List<Town> invited) {
        ArrayList<Town> remove = new ArrayList<Town>();
        for (Town town : invited) {
            try {
                NationCommand.nationInviteTown(player, nation, town);
            }
            catch (AlreadyRegisteredException e) {
                remove.add(town);
            }
        }
        for (Town town : remove) {
            invited.remove(town);
        }
        if (invited.size() > 0) {
            String msg = "";
            for (Town town : invited) {
                msg = String.valueOf(msg) + town.getName() + ", ";
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = String.format(TownySettings.getLangString("msg_invited_join_nation"), player.getName(), msg);
            TownyMessaging.sendNationMessage(nation, ChatTools.color(msg));
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    private static void nationInviteTown(Player player, Nation nation, Town town) throws AlreadyRegisteredException {
        Plugin test = plugin.getServer().getPluginManager().getPlugin("Questioner");
        Resident townMayor = town.getMayor();
        if (TownySettings.isUsingQuestioner() && test != null && test instanceof Questioner && test.isEnabled()) {
            Questioner questioner = (Questioner)test;
            questioner.loadClasses();
            ArrayList<Option> options = new ArrayList<Option>();
            options.add(new Option(TownySettings.questionerAccept(), (Runnable)((Object)new JoinNationTask(townMayor, nation))));
            options.add(new Option(TownySettings.questionerDeny(), (Runnable)((Object)new ResidentNationQuestionTask(townMayor, nation){

                @Override
                public void run() {
                    TownyMessaging.sendNationMessage(this.nation, String.format(TownySettings.getLangString("msg_deny_invite"), this.getResident().getName()));
                }
            })));
            Question question = new Question(townMayor.getName(), String.format(TownySettings.getLangString("msg_invited"), nation.getName()), options);
            try {
                plugin.appendQuestion(questioner, question);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } else {
            nation.addTown(town);
            plugin.resetCache();
            TownyUniverse.getDataSource().saveTown(town);
        }
    }

    public static void nationAdd(Nation nation, List<Town> towns) throws AlreadyRegisteredException {
        for (Town town : towns) {
            if (town.hasNation()) continue;
            nation.addTown(town);
            TownyUniverse.getDataSource().saveTown(town);
            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_join_nation"), town.getName()));
        }
        plugin.resetCache();
        TownyUniverse.getDataSource().saveNation(nation);
    }

    public void nationKick(Player player, String[] names) {
        Nation nation;
        Resident resident;
        if (names.length < 1) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation kick [names]");
            return;
        }
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
            nation = resident.getTown().getNation();
            if (!resident.isKing() && !nation.hasAssistant(resident)) {
                throw new TownyException(TownySettings.getLangString("msg_not_king_ass"));
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        this.nationKick(player, resident, nation, TownyUniverse.getDataSource().getTowns(names));
    }

    public void nationKick(Player player, Resident resident, Nation nation, List<Town> kicking) {
        ArrayList<Town> remove = new ArrayList<Town>();
        for (Town town : kicking) {
            if (town.isCapital()) {
                remove.add(town);
                continue;
            }
            try {
                nation.removeTown(town);
                TownyUniverse.getDataSource().saveTown(town);
            }
            catch (NotRegisteredException e) {
                remove.add(town);
            }
            catch (EmptyNationException emptyNationException) {
                // empty catch block
            }
        }
        for (Town town : remove) {
            kicking.remove(town);
        }
        if (kicking.size() > 0) {
            String msg = "";
            for (Town town : kicking) {
                msg = String.valueOf(msg) + town.getName() + ", ";
                msg = msg.substring(0, msg.length() - 2);
                TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_nation_kicked_by"), player.getName()));
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = String.format(TownySettings.getLangString("msg_nation_kicked"), player.getName(), msg);
            TownyMessaging.sendNationMessage(nation, ChatTools.color(msg));
            TownyUniverse.getDataSource().saveNation(nation);
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public void nationAssistant(Player player, String[] split) {
        if (split.length != 0) {
            if (split[0].equalsIgnoreCase("add")) {
                String[] newSplit = StringMgmt.remFirstArg(split);
                this.nationAssistantsAdd(player, newSplit, true);
            } else if (split[0].equalsIgnoreCase("remove")) {
                String[] newSplit = StringMgmt.remFirstArg(split);
                this.nationAssistantsRemove(player, newSplit, true);
            } else if (split[0].equalsIgnoreCase("add+")) {
                String[] newSplit = StringMgmt.remFirstArg(split);
                this.nationAssistantsAdd(player, newSplit, false);
            } else if (split[0].equalsIgnoreCase("remove+")) {
                String[] newSplit = StringMgmt.remFirstArg(split);
                this.nationAssistantsRemove(player, newSplit, false);
            }
        }
    }

    public void nationAssistantsAdd(Player player, String[] names, boolean matchOnline) {
        Nation nation;
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            nation = resident.getTown().getNation();
            if (!resident.isKing()) {
                throw new TownyException(TownySettings.getLangString("msg_not_king"));
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        this.nationAssistantsAdd(player, nation, matchOnline ? plugin.getTownyUniverse().getOnlineResidents(player, names) : this.getResidents(player, names));
    }

    public void nationAssistantsAdd(Player player, Nation nation, List<Resident> invited) {
        ArrayList<Resident> remove = new ArrayList<Resident>();
        for (Resident newMember : invited) {
            try {
                nation.addAssistant(newMember);
                plugin.deleteCache(newMember.getName());
                TownyUniverse.getDataSource().saveResident(newMember);
            }
            catch (AlreadyRegisteredException e) {
                remove.add(newMember);
            }
        }
        for (Resident newMember : remove) {
            invited.remove(newMember);
        }
        if (invited.size() > 0) {
            String msg = "";
            for (Resident newMember : invited) {
                msg = String.valueOf(msg) + newMember.getName() + ", ";
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = String.format(TownySettings.getLangString("msg_raised_ass"), player.getName(), msg, "nation");
            TownyMessaging.sendNationMessage(nation, ChatTools.color(msg));
            TownyUniverse.getDataSource().saveNation(nation);
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public void nationAssistantsRemove(Player player, String[] names, boolean matchOnline) {
        Nation nation;
        Resident resident;
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
            nation = resident.getTown().getNation();
            if (!resident.isKing()) {
                throw new TownyException(TownySettings.getLangString("msg_not_king"));
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        this.nationAssistantsRemove(player, resident, nation, matchOnline ? plugin.getTownyUniverse().getOnlineResidents(player, names) : this.getResidents(player, names));
    }

    public void nationAssistantsRemove(Player player, Resident resident, Nation nation, List<Resident> kicking) {
        ArrayList<Resident> remove = new ArrayList<Resident>();
        for (Resident member : kicking) {
            try {
                nation.removeAssistant(member);
                plugin.deleteCache(member.getName());
                TownyUniverse.getDataSource().saveResident(member);
                TownyUniverse.getDataSource().saveNation(nation);
            }
            catch (NotRegisteredException e) {
                remove.add(member);
            }
        }
        for (Resident member : remove) {
            kicking.remove(member);
        }
        if (kicking.size() > 0) {
            String msg = "";
            for (Resident member : kicking) {
                msg = String.valueOf(msg) + member.getName() + ", ";
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = String.format(TownySettings.getLangString("msg_lowered_to_res"), player.getName(), msg);
            TownyMessaging.sendNationMessage(nation, ChatTools.color(msg));
            TownyUniverse.getDataSource().saveNation(nation);
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public void nationAlly(Player player, String[] split) {
        Nation nation;
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation ally [add/remove] [name]");
            return;
        }
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            nation = resident.getTown().getNation();
            if (!resident.isKing() && !nation.hasAssistant(resident)) {
                throw new TownyException(TownySettings.getLangString("msg_not_king_ass"));
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        ArrayList<Nation> list = new ArrayList<Nation>();
        String test = split[0];
        String[] newSplit = StringMgmt.remFirstArg(split);
        if ((test.equalsIgnoreCase("remove") || test.equalsIgnoreCase("add")) && newSplit.length > 0) {
            String[] stringArray = newSplit;
            int n = newSplit.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                try {
                    Nation ally = TownyUniverse.getDataSource().getNation(name);
                    if (nation.equals(ally)) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_own_nation_disallow"));
                    } else {
                        list.add(ally);
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                ++n2;
            }
            if (!list.isEmpty()) {
                this.nationAlly(player, nation, list, test.equalsIgnoreCase("add"));
            }
        } else {
            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "[add/remove]"));
        }
    }

    public void nationAlly(Player player, Nation nation, List<Nation> allies, boolean add) {
        ArrayList<Nation> remove = new ArrayList<Nation>();
        for (Nation targetNation : allies) {
            try {
                if (add && !nation.getAllies().contains(targetNation)) {
                    if (!targetNation.hasEnemy(nation)) {
                        nation.addAlly(targetNation);
                        TownyMessaging.sendNationMessage(targetNation, String.format(TownySettings.getLangString("msg_added_ally"), nation.getName()));
                        continue;
                    }
                    remove.add(targetNation);
                    TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_unable_ally_enemy"), targetNation.getName()));
                    continue;
                }
                if (!nation.getAllies().contains(targetNation)) continue;
                nation.removeAlly(targetNation);
                TownyMessaging.sendNationMessage(targetNation, String.format(TownySettings.getLangString("msg_removed_ally"), nation.getName()));
                if (!targetNation.hasAlly(nation)) continue;
                this.nationAlly(player, targetNation, Arrays.asList(nation), false);
            }
            catch (AlreadyRegisteredException e) {
                remove.add(targetNation);
            }
            catch (NotRegisteredException e) {
                remove.add(targetNation);
            }
        }
        for (Nation newAlly : remove) {
            allies.remove(newAlly);
        }
        if (allies.size() > 0) {
            String msg = "";
            for (Nation newAlly : allies) {
                msg = String.valueOf(msg) + newAlly.getName() + ", ";
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = add ? String.format(TownySettings.getLangString("msg_allied_nations"), player.getName(), msg) : String.format(TownySettings.getLangString("msg_broke_alliance"), player.getName(), msg);
            TownyMessaging.sendNationMessage(nation, ChatTools.color(msg));
            TownyUniverse.getDataSource().saveNations();
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public void nationEnemy(Player player, String[] split) {
        Nation nation;
        if (split.length < 2) {
            TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation enemy [add/remove] [name]");
            return;
        }
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            nation = resident.getTown().getNation();
            if (!resident.isKing() && !nation.hasAssistant(resident)) {
                throw new TownyException(TownySettings.getLangString("msg_not_king_ass"));
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        ArrayList<Nation> list = new ArrayList<Nation>();
        String test = split[0];
        String[] newSplit = StringMgmt.remFirstArg(split);
        if ((test.equalsIgnoreCase("remove") || test.equalsIgnoreCase("add")) && newSplit.length > 0) {
            String[] stringArray = newSplit;
            int n = newSplit.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                try {
                    Nation enemy = TownyUniverse.getDataSource().getNation(name);
                    if (nation.equals(enemy)) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_own_nation_disallow"));
                    } else {
                        list.add(enemy);
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                ++n2;
            }
            if (!list.isEmpty()) {
                this.nationEnemy(player, nation, list, test.equalsIgnoreCase("add"));
            }
        } else {
            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "[add/remove]"));
        }
    }

    public void nationEnemy(Player player, Nation nation, List<Nation> enemies, boolean add) {
        ArrayList<Nation> remove = new ArrayList<Nation>();
        for (Nation targetNation : enemies) {
            try {
                if (add && !nation.getEnemies().contains(targetNation)) {
                    nation.addEnemy(targetNation);
                    TownyMessaging.sendNationMessage(targetNation, String.format(TownySettings.getLangString("msg_added_enemy"), nation.getName()));
                    if (!targetNation.hasAlly(nation)) continue;
                    this.nationAlly(player, targetNation, Arrays.asList(nation), false);
                    continue;
                }
                if (!nation.getEnemies().contains(targetNation)) continue;
                nation.removeEnemy(targetNation);
                TownyMessaging.sendNationMessage(targetNation, String.format(TownySettings.getLangString("msg_removed_enemy"), nation.getName()));
            }
            catch (AlreadyRegisteredException e) {
                remove.add(targetNation);
            }
            catch (NotRegisteredException e) {
                remove.add(targetNation);
            }
        }
        for (Nation newEnemy : remove) {
            enemies.remove(newEnemy);
        }
        if (enemies.size() > 0) {
            String msg = "";
            for (Nation newEnemy : enemies) {
                msg = String.valueOf(msg) + newEnemy.getName() + ", ";
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = add ? String.format(TownySettings.getLangString("msg_enemy_nations"), player.getName(), msg) : String.format(TownySettings.getLangString("msg_enemy_to_neutral"), player.getName(), msg);
            TownyMessaging.sendNationMessage(nation, ChatTools.color(msg));
            TownyUniverse.getDataSource().saveNations();
            plugin.resetCache();
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public void nationSet(Player player, String[] split) {
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/nation set"));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "king " + TownySettings.getLangString("res_2"), ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "capital [town]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "taxes [$]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "name [name]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "title/surname [resident] [text]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/nation set", "tag [upto 4 letters] or clear", ""));
        } else {
            Nation nation;
            block66: {
                Resident resident;
                try {
                    resident = TownyUniverse.getDataSource().getResident(player.getName());
                    nation = resident.getTown().getNation();
                    if (!resident.isKing() && !nation.hasAssistant(resident)) {
                        throw new TownyException(TownySettings.getLangString("msg_not_king_ass"));
                    }
                }
                catch (TownyException x) {
                    TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                    return;
                }
                if (split[0].equalsIgnoreCase("king")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set king Dumbo");
                    } else {
                        try {
                            Resident newKing = TownyUniverse.getDataSource().getResident(split[1]);
                            String oldKingsName = nation.getCapital().getMayor().getName();
                            nation.setKing(newKing);
                            plugin.deleteCache(oldKingsName);
                            plugin.deleteCache(newKing.getName());
                            TownyMessaging.sendNationMessage(nation, TownySettings.getNewKingMsg(newKing.getName(), nation.getName()));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        }
                    }
                } else if (split[0].equalsIgnoreCase("capital")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set capital {town name}");
                    } else {
                        try {
                            Town newCapital = TownyUniverse.getDataSource().getTown(split[1]);
                            nation.setCapital(newCapital);
                            plugin.resetCache();
                            TownyMessaging.sendNationMessage(nation, TownySettings.getNewKingMsg(newCapital.getMayor().getName(), nation.getName()));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        }
                    }
                } else if (split[0].equalsIgnoreCase("taxes")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set taxes 70");
                    } else {
                        Integer amount = Integer.parseInt(split[1].trim());
                        if (amount < 0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        try {
                            nation.setTaxes(amount.intValue());
                            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_town_set_nation_tax"), player.getName(), split[1]));
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
                        }
                    }
                } else if (split[0].equalsIgnoreCase("name")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set name Plutoria");
                    } else {
                        if (plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_NATION_RENAME.getNode())) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_command_disable"));
                            return;
                        }
                        if (!NameValidation.isBlacklistName(split[1])) {
                            this.nationRename(player, nation, split[1]);
                        } else {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
                        }
                    }
                } else if (split[0].equalsIgnoreCase("tag")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set tag PLT");
                    } else if (split[1].equalsIgnoreCase("clear")) {
                        try {
                            nation.setTag(" ");
                            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_reset_nation_tag"), player.getName()));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        }
                    } else {
                        try {
                            nation.setTag(NameValidation.checkAndFilterName(split[1]));
                            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_set_nation_tag"), player.getName(), nation.getTag()));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        }
                        catch (InvalidNameException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        }
                    }
                } else if (split[0].equalsIgnoreCase("title")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set title bilbo Jester ");
                    } else {
                        try {
                            if (plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_NATION_GRANT_TITLES.getNode())) {
                                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_command_disable"));
                                return;
                            }
                            resident = TownyUniverse.getDataSource().getResident(split[1]);
                            if (resident.hasNation()) {
                                if (resident.getTown().getNation() != TownyUniverse.getDataSource().getResident(player.getName()).getTown().getNation()) {
                                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_same_nation"), resident.getName()));
                                    return;
                                }
                            } else {
                                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_same_nation"), resident.getName()));
                                return;
                            }
                            if (StringMgmt.join(split = StringMgmt.remArgs(split, 2)).length() > TownySettings.getMaxTitleLength()) {
                                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_input_too_long"));
                                return;
                            }
                            String title = StringMgmt.join(NameValidation.checkAndFilterArray(split));
                            resident.setTitle(String.valueOf(title) + " ");
                            TownyUniverse.getDataSource().saveResident(resident);
                            if (resident.hasTitle()) {
                                TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_set_title"), resident.getName(), resident.getTitle()));
                                break block66;
                            }
                            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_clear_title_surname"), "Title", resident.getName()));
                        }
                        catch (NotRegisteredException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        }
                    }
                } else if (split[0].equalsIgnoreCase("surname")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /nation set surname bilbo the dwarf ");
                    } else {
                        try {
                            if (plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_NATION_GRANT_TITLES.getNode())) {
                                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_command_disable"));
                                return;
                            }
                            resident = TownyUniverse.getDataSource().getResident(split[1]);
                            if (resident.hasNation()) {
                                if (resident.getTown().getNation() != TownyUniverse.getDataSource().getResident(player.getName()).getTown().getNation()) {
                                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_same_nation"), resident.getName()));
                                    return;
                                }
                            } else {
                                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_same_nation"), resident.getName()));
                                return;
                            }
                            if (StringMgmt.join(split = StringMgmt.remArgs(split, 2)).length() > TownySettings.getMaxTitleLength()) {
                                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_input_too_long"));
                                return;
                            }
                            String surname = StringMgmt.join(NameValidation.checkAndFilterArray(split));
                            resident.setSurname(" " + surname);
                            TownyUniverse.getDataSource().saveResident(resident);
                            if (resident.hasSurname()) {
                                TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_set_surname"), resident.getName(), resident.getSurname()));
                                break block66;
                            }
                            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_clear_title_surname"), "Surname", resident.getName()));
                        }
                        catch (NotRegisteredException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        }
                    }
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "nation"));
                    return;
                }
            }
            TownyUniverse.getDataSource().saveNation(nation);
            TownyUniverse.getDataSource().saveNationList();
        }
    }

    public void nationToggle(Player player, String[] split) {
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/nation toggle"));
            player.sendMessage(ChatTools.formatCommand("", "/nation toggle", "neutral", ""));
        } else {
            Nation nation;
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                nation = resident.getTown().getNation();
                if (!resident.isKing() && !nation.hasAssistant(resident)) {
                    throw new TownyException(TownySettings.getLangString("msg_not_king_ass"));
                }
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
            if (split[0].equalsIgnoreCase("neutral")) {
                try {
                    if (!TownySettings.isDeclaringNeutral()) {
                        throw new TownyException(TownySettings.getLangString("msg_neutral_disabled"));
                    }
                    boolean choice = !nation.isNeutral();
                    Double cost = TownySettings.getNationNeutralityCost();
                    if (choice && TownySettings.isUsingEconomy() && !nation.pay(cost, "Nation Neutrality Cost")) {
                        throw new TownyException(TownySettings.getLangString("msg_nation_cant_neutral"));
                    }
                    nation.setNeutral(choice);
                    if (TownySettings.isUsingEconomy() && cost > 0.0) {
                        TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_you_paid"), TownyEconomyHandler.getFormattedBalance(cost)));
                    } else {
                        TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_nation_set_neutral"));
                    }
                    TownyMessaging.sendNationMessage(nation, String.valueOf(TownySettings.getLangString("msg_nation_neutral")) + (nation.isNeutral() ? "\u00a72" : "\u00a74 not") + " neutral.");
                }
                catch (EconomyException e) {
                    TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                }
                catch (TownyException e) {
                    try {
                        nation.setNeutral(false);
                    }
                    catch (TownyException e1) {
                        e1.printStackTrace();
                    }
                    TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                }
            } else {
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "nation"));
                return;
            }
            plugin.getTownyUniverse();
            TownyUniverse.getDataSource().saveNation(nation);
        }
    }

    public void nationRename(Player player, Nation nation, String newName) {
        try {
            TownyUniverse.getDataSource().renameNation(nation, newName);
            TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_nation_set_name"), player.getName(), nation.getName()));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
    }

    private List<Resident> getResidents(Player player, String[] names) {
        ArrayList<Resident> invited = new ArrayList<Resident>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                Resident target = TownyUniverse.getDataSource().getResident(name);
                invited.add(target);
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
            ++n2;
        }
        return invited;
    }
}

