/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.PlotClaim;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlotCommand
implements CommandExecutor {
    private static Towny plugin;
    public static final List<String> output;

    static {
        output = new ArrayList<String>();
        output.add(ChatTools.formatTitle("/plot"));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/plot claim", "", TownySettings.getLangString("msg_block_claim")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/plot claim", "[rect/circle] [radius]", ""));
        output.add(ChatTools.formatCommand(String.valueOf(TownySettings.getLangString("res_sing")) + "/" + TownySettings.getLangString("mayor_sing"), "/plot notforsale", "", TownySettings.getLangString("msg_plot_nfs")));
        output.add(ChatTools.formatCommand(String.valueOf(TownySettings.getLangString("res_sing")) + "/" + TownySettings.getLangString("mayor_sing"), "/plot notforsale", "[rect/circle] [radius]", ""));
        output.add(ChatTools.formatCommand(String.valueOf(TownySettings.getLangString("res_sing")) + "/" + TownySettings.getLangString("mayor_sing"), "/plot forsale [$]", "", TownySettings.getLangString("msg_plot_fs")));
        output.add(ChatTools.formatCommand(String.valueOf(TownySettings.getLangString("res_sing")) + "/" + TownySettings.getLangString("mayor_sing"), "/plot forsale [$]", "within [rect/circle] [radius]", ""));
        output.add(ChatTools.formatCommand(String.valueOf(TownySettings.getLangString("res_sing")) + "/" + TownySettings.getLangString("mayor_sing"), "/plot clear", "", ""));
        output.add(ChatTools.formatCommand(String.valueOf(TownySettings.getLangString("res_sing")) + "/" + TownySettings.getLangString("mayor_sing"), "/plot set ...", "", TownySettings.getLangString("msg_plot_fs")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/plot toggle", "[pvp/fire/explosion/mobs]", ""));
        output.add(TownySettings.getLangString("msg_nfs_abr"));
    }

    public PlotCommand(Towny instance) {
        plugin = instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            System.out.println("[PLAYER_COMMAND] " + player.getName() + ": /" + commandLabel + " " + StringMgmt.join(args));
            if (args == null) {
                for (String line : output) {
                    player.sendMessage(line);
                }
                return true;
            }
            try {
                return this.parsePlotCommand(player, args);
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return true;
            }
        }
        for (String line : output) {
            sender.sendMessage(Colors.strip(line));
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean parsePlotCommand(Player player, String[] split) throws TownyException {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            for (String line : output) {
                player.sendMessage(line);
            }
        } else {
            Town town;
            String world;
            Resident resident;
            if (!TownyUniverse.getPermissionSource().isTownyAdmin(player) && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOWN_PLOT_COMMAND.getNode(split[0].toLowerCase()))) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
            try {
                resident = TownyUniverse.getDataSource().getResident(player.getName());
                world = player.getWorld().getName();
                town = resident.getTown();
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return true;
            }
            try {
                if (split[0].equalsIgnoreCase("claim")) {
                    if (TownyUniverse.isWarTime()) {
                        throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
                    }
                    List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(world, Coord.parseCoord((Entity)player)), StringMgmt.remFirstArg(split));
                    if (selection.size() > 0) {
                        double cost = 0.0;
                        for (WorldCoord worldCoord : new ArrayList<WorldCoord>(selection)) {
                            try {
                                double d = worldCoord.getTownBlock().getPlotPrice();
                                if (d > -1.0) {
                                    cost += worldCoord.getTownBlock().getPlotPrice();
                                    continue;
                                }
                                if (worldCoord.getTownBlock().getTown().isMayor(resident)) continue;
                                selection.remove(worldCoord);
                            }
                            catch (NotRegisteredException notRegisteredException) {
                                selection.remove(worldCoord);
                            }
                        }
                        int maxPlots = TownySettings.getMaxResidentPlots(resident);
                        if (maxPlots >= 0 && resident.getTownBlocks().size() + selection.size() > maxPlots) {
                            throw new TownyException(String.format(TownySettings.getLangString("msg_max_plot_own"), maxPlots));
                        }
                        if (TownySettings.isUsingEconomy() && !resident.canPayFromHoldings(cost)) {
                            throw new TownyException(String.format(TownySettings.getLangString("msg_no_funds_claim"), selection.size(), TownyEconomyHandler.getFormattedBalance(cost)));
                        }
                        new PlotClaim(plugin, player, resident, selection, true).start();
                    }
                    player.sendMessage(TownySettings.getLangString("msg_err_empty_area_selection"));
                }
                if (split[0].equalsIgnoreCase("unclaim")) {
                    if (TownyUniverse.isWarTime()) {
                        throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
                    }
                    if (split.length == 2 && split[1].equalsIgnoreCase("all")) {
                        new PlotClaim(plugin, player, resident, null, false).start();
                    }
                    List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(world, Coord.parseCoord((Entity)player)), StringMgmt.remFirstArg(split));
                    if ((selection = AreaSelectionUtil.filterOwnedBlocks(resident, selection)).size() > 0) {
                        new PlotClaim(plugin, player, resident, selection, false).start();
                    }
                    player.sendMessage(TownySettings.getLangString("msg_err_empty_area_selection"));
                }
                if (split[0].equalsIgnoreCase("notforsale") || split[0].equalsIgnoreCase("nfs")) {
                    List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(world, Coord.parseCoord((Entity)player)), StringMgmt.remFirstArg(split));
                    selection = AreaSelectionUtil.filterOwnedBlocks(resident.getTown(), selection);
                    for (WorldCoord worldCoord : selection) {
                        this.setPlotForSale(resident, worldCoord, -1.0);
                    }
                }
                if (split[0].equalsIgnoreCase("forsale") || split[0].equalsIgnoreCase("fs")) {
                    WorldCoord pos = new WorldCoord(world, Coord.parseCoord((Entity)player));
                    double plotPrice = pos.getTownBlock().getTown().getPlotTypePrice(pos.getTownBlock().getType());
                    if (split.length > 1) {
                        List<Object> selection;
                        int areaSelectPivot = AreaSelectionUtil.getAreaSelectPivot(split);
                        if (areaSelectPivot >= 0) {
                            selection = AreaSelectionUtil.selectWorldCoordArea(resident, new WorldCoord(world, Coord.parseCoord((Entity)player)), StringMgmt.subArray(split, areaSelectPivot + 1, split.length));
                            selection = AreaSelectionUtil.filterOwnedBlocks(resident.getTown(), selection);
                            if (selection.size() == 0) {
                                player.sendMessage(TownySettings.getLangString("msg_err_empty_area_selection"));
                                return true;
                            }
                        } else {
                            selection = new ArrayList<WorldCoord>();
                            selection.add(pos);
                        }
                        if (areaSelectPivot != 1) {
                            try {
                                plotPrice = Double.parseDouble(split[1]);
                                if (plotPrice < 0.0) {
                                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                                    return true;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                player.sendMessage(String.format(TownySettings.getLangString("msg_error_must_be_num"), new Object[0]));
                                return true;
                            }
                        }
                        for (WorldCoord worldCoord : selection) {
                            if (selection.size() > 1) {
                                plotPrice = worldCoord.getTownBlock().getTown().getPlotTypePrice(worldCoord.getTownBlock().getType());
                            }
                            this.setPlotForSale(resident, worldCoord, plotPrice);
                        }
                    }
                    this.setPlotForSale(resident, pos, plotPrice);
                }
                if (split[0].equalsIgnoreCase("perm")) {
                    TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
                    TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(townBlock));
                }
                if (split[0].equalsIgnoreCase("toggle")) {
                    TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
                    this.plotTestOwner(resident, townBlock);
                    town = townBlock.getTown();
                    this.plotToggle(player, new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock(), StringMgmt.remFirstArg(split));
                }
                if (split[0].equalsIgnoreCase("set")) {
                    if ((split = StringMgmt.remFirstArg(split)).length > 0) {
                        if (split[0].equalsIgnoreCase("perm")) {
                            TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
                            TownBlockOwner owner = this.plotTestOwner(resident, townBlock);
                            town = townBlock.getTown();
                            this.toggleTest(player, townBlock, StringMgmt.join(StringMgmt.remFirstArg(split), ""));
                            TownCommand.setTownBlockPermissions(player, owner, townBlock.getPermissions(), StringMgmt.remFirstArg(split), true);
                            townBlock.setChanged(true);
                            TownyUniverse.getDataSource().saveTownBlock(townBlock);
                            return true;
                        }
                        if (!(TownyUniverse.getPermissionSource().isTownyAdmin(player) || !plugin.isPermissions() || TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOWN_PLOTTYPE.getNode()) || town.isMayor(resident) || town.hasAssistant(resident))) {
                            throw new TownyException(String.format(TownySettings.getLangString("msg_cache_block_error_town_resident"), "change plot types"));
                        }
                        WorldCoord worldCoord = new WorldCoord(world, Coord.parseCoord((Entity)player));
                        TownBlock townBlock = worldCoord.getTownBlock();
                        this.setPlotType(resident, worldCoord, split[0]);
                        townBlock.setChanged(true);
                        TownyUniverse.getDataSource().saveTownBlock(townBlock);
                        player.sendMessage(String.format(TownySettings.getLangString("msg_plot_set_type"), split[0]));
                    }
                    player.sendMessage(ChatTools.formatCommand("", "/plot set", "reset", ""));
                    player.sendMessage(ChatTools.formatCommand("", "/plot set", "shop|embassy|arena|wilds|spleef", ""));
                    player.sendMessage(ChatTools.formatCommand("", "/plot set perm", "?", ""));
                }
                if (split[0].equalsIgnoreCase("clear")) {
                    TownBlock townBlock = new WorldCoord(world, Coord.parseCoord((Entity)player)).getTownBlock();
                    if (townBlock != null) {
                        if (townBlock.hasResident()) {
                            if (!townBlock.isOwner(resident)) {
                                player.sendMessage(TownySettings.getLangString("msg_area_not_own"));
                                return true;
                            }
                        } else if (!town.isMayor(resident)) {
                            player.sendMessage(TownySettings.getLangString("msg_not_mayor"));
                            return true;
                        }
                        for (String material : TownyUniverse.getDataSource().getWorld(world).getPlotManagementMayorDelete()) {
                            if (Material.matchMaterial((String)material) != null) {
                                TownyRegenAPI.deleteTownBlockMaterial(townBlock, Material.getMaterial((String)material).getId());
                                player.sendMessage(String.format(TownySettings.getLangString("msg_clear_plot_material"), material));
                                continue;
                            }
                            throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_property"), material));
                        }
                    }
                    player.sendMessage(TownySettings.getLangString("msg_err_empty_area_selection"));
                }
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_property"), split[0]));
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
            catch (EconomyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
        }
        return true;
    }

    public void setPlotType(Resident resident, WorldCoord worldCoord, String type) throws TownyException {
        if (resident.hasTown()) {
            try {
                TownBlock townBlock = worldCoord.getTownBlock();
                this.plotTestOwner(resident, townBlock);
                townBlock.setType(type);
            }
            catch (NotRegisteredException e) {
                throw new TownyException(TownySettings.getLangString("msg_err_not_part_town"));
            }
        } else {
            throw new TownyException(TownySettings.getLangString("msg_err_must_belong_town"));
        }
    }

    public void setPlotForSale(Resident resident, WorldCoord worldCoord, double forSale) throws TownyException {
        if (resident.hasTown()) {
            try {
                TownBlock townBlock = worldCoord.getTownBlock();
                this.plotTestOwner(resident, townBlock);
                townBlock.setPlotPrice(forSale);
                if (forSale != -1.0) {
                    TownyMessaging.sendTownMessage(townBlock.getTown(), TownySettings.getPlotForSaleMsg(resident.getName(), worldCoord));
                } else {
                    TownyUniverse.getPlayer(resident).sendMessage(TownySettings.getLangString("msg_err_plot_nfs"));
                }
                TownyUniverse.getDataSource().saveTown(townBlock.getTown());
            }
            catch (NotRegisteredException e) {
                throw new TownyException(TownySettings.getLangString("msg_err_not_part_town"));
            }
        } else {
            throw new TownyException(TownySettings.getLangString("msg_err_must_belong_town"));
        }
    }

    public void plotToggle(Player player, TownBlock townBlock, String[] split) {
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/res toggle"));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "pvp", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "explosion", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "fire", ""));
            player.sendMessage(ChatTools.formatCommand("", "/res toggle", "mobs", ""));
        } else {
            try {
                if (split[0].equalsIgnoreCase("pvp")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
                    townBlock.getPermissions().pvp = !townBlock.getPermissions().pvp;
                    TownyMessaging.sendMessage((Object)player, String.format(TownySettings.getLangString("msg_changed_pvp"), "Plot", townBlock.getPermissions().pvp ? "Enabled" : "Disabled"));
                } else if (split[0].equalsIgnoreCase("explosion")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
                    townBlock.getPermissions().explosion = !townBlock.getPermissions().explosion;
                    TownyMessaging.sendMessage((Object)player, String.format(TownySettings.getLangString("msg_changed_expl"), "the Plot", townBlock.getPermissions().explosion ? "Enabled" : "Disabled"));
                } else if (split[0].equalsIgnoreCase("fire")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
                    townBlock.getPermissions().fire = !townBlock.getPermissions().fire;
                    TownyMessaging.sendMessage((Object)player, String.format(TownySettings.getLangString("msg_changed_fire"), "the Plot", townBlock.getPermissions().fire ? "Enabled" : "Disabled"));
                } else if (split[0].equalsIgnoreCase("mobs")) {
                    this.toggleTest(player, townBlock, StringMgmt.join(split, " "));
                    townBlock.getPermissions().mobs = !townBlock.getPermissions().mobs;
                    TownyMessaging.sendMessage((Object)player, String.format(TownySettings.getLangString("msg_changed_mobs"), "the Plot", townBlock.getPermissions().mobs ? "Enabled" : "Disabled"));
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "plot"));
                    return;
                }
                townBlock.setChanged(true);
                TownyUniverse.getDataSource().saveTownBlock(townBlock);
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
            }
            TownyUniverse.getDataSource().saveTownBlock(townBlock);
        }
    }

    private void toggleTest(Player player, TownBlock townBlock, String split) throws TownyException {
        Town town = townBlock.getTown();
        if ((split = split.toLowerCase()).contains("mobs")) {
            if (town.getWorld().isForceTownMobs()) {
                throw new TownyException(TownySettings.getLangString("msg_world_mobs"));
            }
            if (plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOGGLE_MOBS.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
        }
        if (split.contains("fire")) {
            if (town.getWorld().isForceFire()) {
                throw new TownyException(TownySettings.getLangString("msg_world_fire"));
            }
            if (plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOGGLE_FIRE.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
        }
        if (split.contains("explosion")) {
            if (town.getWorld().isForceExpl()) {
                throw new TownyException(TownySettings.getLangString("msg_world_expl"));
            }
            if (plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOGGLE_EXPLOSION.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
        }
        if (split.contains("pvp")) {
            if (town.getWorld().isForcePVP()) {
                throw new TownyException(TownySettings.getLangString("msg_world_pvp"));
            }
            if (plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOGGLE_PVP.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
        }
        if ((split.contains("pvp") || split.trim().equalsIgnoreCase("off")) && townBlock.getType().equals((Object)TownBlockType.ARENA)) {
            throw new TownyException(TownySettings.getLangString("msg_plot_pvp"));
        }
    }

    public TownBlockOwner plotTestOwner(Resident resident, TownBlock townBlock) throws TownyException {
        if (townBlock.hasResident()) {
            Resident owner = townBlock.getResident();
            if (resident != owner && !townBlock.getTown().getMayor().equals(resident) && !townBlock.getTown().hasAssistant(resident)) {
                throw new TownyException(TownySettings.getLangString("msg_area_not_own"));
            }
            return owner;
        }
        Town owner = townBlock.getTown();
        if (!owner.isMayor(resident) && !owner.hasAssistant(resident)) {
            throw new TownyException(TownySettings.getLangString("msg_not_mayor_ass"));
        }
        if (resident.getTown() != owner) {
            throw new TownyException(TownySettings.getLangString("msg_err_not_part_town"));
        }
        return owner;
    }
}

