/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ResidentCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> output;

    static {
        output = new ArrayList<String>();
        output.add(ChatTools.formatTitle("/resident"));
        output.add(ChatTools.formatCommand("", "/resident", "", TownySettings.getLangString("res_1")));
        output.add(ChatTools.formatCommand("", "/resident", TownySettings.getLangString("res_2"), TownySettings.getLangString("res_3")));
        output.add(ChatTools.formatCommand("", "/resident", "list", TownySettings.getLangString("res_4")));
        output.add(ChatTools.formatCommand("", "/resident", "tax", ""));
        output.add(ChatTools.formatCommand("", "/resident", "toggle", "[mode]...[mode]"));
        output.add(ChatTools.formatCommand("", "/resident", "set [] .. []", "'/resident set' " + TownySettings.getLangString("res_5")));
        output.add(ChatTools.formatCommand("", "/resident", "friend [add/remove] " + TownySettings.getLangString("res_2"), TownySettings.getLangString("res_6")));
        output.add(ChatTools.formatCommand("", "/resident", "friend [add+/remove+] " + TownySettings.getLangString("res_2") + " ", TownySettings.getLangString("res_7")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/resident", "delete " + TownySettings.getLangString("res_2"), ""));
    }

    public ResidentCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            System.out.println("[PLAYER_COMMAND] " + player.getName() + ": /" + commandLabel + " " + StringMgmt.join(args));
            if (args == null) {
                for (String line : output) {
                    player.sendMessage(line);
                }
                this.parseResidentCommand(player, args);
            } else {
                this.parseResidentCommand(player, args);
            }
        } else {
            for (String line : output) {
                sender.sendMessage(Colors.strip(line));
            }
        }
        return true;
    }

    public void parseResidentCommand(Player player, String[] split) {
        if (split.length == 0) {
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(resident));
            }
            catch (NotRegisteredException x) {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_not_registered"));
            }
        } else if (split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            for (String line : output) {
                player.sendMessage(line);
            }
        } else if (split[0].equalsIgnoreCase("list")) {
            this.listResidents(player);
        } else if (split[0].equalsIgnoreCase("tax")) {
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getTaxStatus(resident));
            }
            catch (NotRegisteredException x) {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_not_registered"));
            }
        } else if (split[0].equalsIgnoreCase("set")) {
            String[] newSplit = StringMgmt.remFirstArg(split);
            this.residentSet(player, newSplit);
        } else if (split[0].equalsIgnoreCase("toggle")) {
            String[] newSplit = StringMgmt.remFirstArg(split);
            this.residentToggle(player, newSplit);
        } else if (split[0].equalsIgnoreCase("friend")) {
            String[] newSplit = StringMgmt.remFirstArg(split);
            this.residentFriend(player, newSplit);
        } else if (split[0].equalsIgnoreCase("delete")) {
            String[] newSplit = StringMgmt.remFirstArg(split);
            this.residentDelete(player, newSplit);
        } else {
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(split[0]);
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(resident));
            }
            catch (NotRegisteredException x) {
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_registered_1"), split[0]));
            }
        }
    }

    private void residentToggle(Player player, String[] newSplit) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            resident.toggleMode(newSplit, true);
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_registered"), player.getName()));
        }
    }

    public void listResidents(Player player) {
        player.sendMessage(ChatTools.formatTitle(TownySettings.getLangString("res_list")));
        ArrayList<String> formatedList = new ArrayList<String>();
        for (Resident resident : plugin.getTownyUniverse().getActiveResidents()) {
            String colour = resident.isKing() ? "\u00a76" : (resident.isMayor() ? "\u00a7b" : "\u00a7f");
            formatedList.add(String.valueOf(colour) + resident.getName() + "\u00a7f");
        }
        for (String line : ChatTools.list(formatedList)) {
            player.sendMessage(line);
        }
    }

    public void residentSet(Player player, String[] split) {
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatCommand("", "/resident set", "perm ...", "'/resident set perm' " + TownySettings.getLangString("res_5")));
            player.sendMessage(ChatTools.formatCommand("", "/resident set", "mode ...", "'/resident set mode' " + TownySettings.getLangString("res_5")));
        } else {
            Resident resident;
            try {
                resident = TownyUniverse.getDataSource().getResident(player.getName());
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
            if (split[0].equalsIgnoreCase("perm")) {
                String[] newSplit = StringMgmt.remFirstArg(split);
                TownCommand.setTownBlockPermissions(player, resident, resident.getPermissions(), newSplit, true);
            } else if (split[0].equalsIgnoreCase("mode")) {
                String[] newSplit = StringMgmt.remFirstArg(split);
                this.setMode(player, newSplit);
            } else {
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "town"));
                return;
            }
            TownyUniverse.getDataSource().saveResident(resident);
        }
    }

    private void setMode(Player player, String[] split) {
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatCommand("", "/resident set mode", "clear", ""));
            player.sendMessage(ChatTools.formatCommand("", "/resident set mode", "[mode] ...[mode]", ""));
            player.sendMessage(ChatTools.formatCommand("Mode", "map", "", TownySettings.getLangString("mode_1")));
            player.sendMessage(ChatTools.formatCommand("Mode", "townclaim", "", TownySettings.getLangString("mode_2")));
            player.sendMessage(ChatTools.formatCommand("Mode", "townunclaim", "", TownySettings.getLangString("mode_3")));
            player.sendMessage(ChatTools.formatCommand("Mode", "tc", "", TownySettings.getLangString("mode_4")));
            player.sendMessage(ChatTools.formatCommand("Mode", "nc", "", TownySettings.getLangString("mode_5")));
            player.sendMessage(ChatTools.formatCommand("Eg", "/resident set mode", "map townclaim town nation general", ""));
            return;
        }
        if (split[0].equalsIgnoreCase("reset") || split[0].equalsIgnoreCase("clear")) {
            plugin.removePlayerMode(player);
            return;
        }
        List<String> list = Arrays.asList(split);
        if (list.contains("spy") && plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_CHAT_SPY.getNode())) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_command_disable"));
            return;
        }
        plugin.setPlayerMode(player, split, true);
    }

    public void residentFriend(Player player, String[] split) {
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatCommand("", "/resident friend", "add " + TownySettings.getLangString("res_2"), ""));
            player.sendMessage(ChatTools.formatCommand("", "/resident friend", "remove " + TownySettings.getLangString("res_2"), ""));
            player.sendMessage(ChatTools.formatCommand("", "/resident friend", "clear", ""));
        } else {
            Resident resident;
            try {
                resident = TownyUniverse.getDataSource().getResident(player.getName());
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
            if (split[0].equalsIgnoreCase("add")) {
                String[] names = StringMgmt.remFirstArg(split);
                this.residentFriendAdd(player, resident, plugin.getTownyUniverse().getOnlineResidents(player, names));
            } else if (split[0].equalsIgnoreCase("remove")) {
                String[] names = StringMgmt.remFirstArg(split);
                this.residentFriendRemove(player, resident, plugin.getTownyUniverse().getOnlineResidents(player, names));
            } else if (split[0].equalsIgnoreCase("add+")) {
                String[] names = StringMgmt.remFirstArg(split);
                this.residentFriendAdd(player, resident, ResidentCommand.getResidents(player, names));
            } else if (split[0].equalsIgnoreCase("remove+")) {
                String[] names = StringMgmt.remFirstArg(split);
                this.residentFriendRemove(player, resident, ResidentCommand.getResidents(player, names));
            } else if (split[0].equalsIgnoreCase("clearlist") || split[0].equalsIgnoreCase("clear")) {
                this.residentFriendRemove(player, resident, resident.getFriends());
            }
        }
    }

    private static List<Resident> getResidents(Player player, String[] names) {
        ArrayList<Resident> invited = new ArrayList<Resident>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                Resident target = TownyUniverse.getDataSource().getResident(name);
                invited.add(target);
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
            ++n2;
        }
        return invited;
    }

    public void residentFriendAdd(Player player, Resident resident, List<Resident> invited) {
        ArrayList<Resident> remove = new ArrayList<Resident>();
        for (Resident newFriend : invited) {
            try {
                resident.addFriend(newFriend);
                plugin.deleteCache(newFriend.getName());
            }
            catch (AlreadyRegisteredException e) {
                remove.add(newFriend);
            }
        }
        for (Resident newFriend : remove) {
            invited.remove(newFriend);
        }
        if (invited.size() > 0) {
            String msg = "Added ";
            for (Resident newFriend : invited) {
                msg = String.valueOf(msg) + newFriend.getName() + ", ";
                Player p = plugin.getServer().getPlayer(newFriend.getName());
                if (p == null) continue;
                TownyMessaging.sendMsg((Object)p, String.format(TownySettings.getLangString("msg_friend_add"), player.getName()));
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = String.valueOf(msg) + TownySettings.getLangString("msg_to_list");
            TownyMessaging.sendMsg((Object)player, msg);
            TownyUniverse.getDataSource().saveResident(resident);
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public void residentFriendRemove(Player player, Resident resident, List<Resident> kicking) {
        ArrayList<Resident> remove = new ArrayList<Resident>();
        ArrayList<Resident> toKick = new ArrayList<Resident>(kicking);
        for (Resident friend : toKick) {
            try {
                resident.removeFriend(friend);
                plugin.deleteCache(friend.getName());
            }
            catch (NotRegisteredException e) {
                remove.add(friend);
            }
        }
        if (remove.size() > 0) {
            for (Resident friend : remove) {
                toKick.remove(friend);
            }
        }
        if (toKick.size() > 0) {
            String msg = TownySettings.getLangString("msg_removed");
            for (Resident member : toKick) {
                msg = String.valueOf(msg) + member.getName() + ", ";
                Player p = plugin.getServer().getPlayer(member.getName());
                if (p == null) continue;
                TownyMessaging.sendMsg((Object)p, String.format(TownySettings.getLangString("msg_friend_remove"), player.getName()));
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = String.valueOf(msg) + TownySettings.getLangString("msg_from_list");
            TownyMessaging.sendMsg((Object)player, msg);
            TownyUniverse.getDataSource().saveResident(resident);
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public void residentDelete(Player player, String[] split) {
        if (split.length == 0) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        } else {
            try {
                if (!TownyUniverse.getPermissionSource().isTownyAdmin(player)) {
                    throw new TownyException(TownySettings.getLangString("msg_err_admin_only_delete"));
                }
                String[] stringArray = split;
                int n = split.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    try {
                        Resident resident = TownyUniverse.getDataSource().getResident(name);
                        if (!resident.isNPC() && !BukkitTools.isOnline(resident.getName())) {
                            TownyUniverse.getDataSource().removeResident(resident);
                            TownyUniverse.getDataSource().removeResidentList(resident);
                            TownyMessaging.sendGlobalMessage(TownySettings.getDelResidentMsg(resident));
                        } else {
                            TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_online_or_npc"), name));
                        }
                    }
                    catch (NotRegisteredException x) {
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_name"), name));
                    }
                    ++n2;
                }
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
        }
    }
}

