/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import ca.xshade.bukkit.questioner.Questioner;
import ca.xshade.questionmanager.Option;
import ca.xshade.questionmanager.Question;
import com.earth2me.essentials.Teleport;
import com.earth2me.essentials.User;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownSpawnLevel;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.questioner.JoinTownTask;
import com.palmergames.bukkit.towny.questioner.ResidentTownQuestionTask;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.TownClaim;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.InvalidNameException;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TownCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> output;

    static {
        output = new ArrayList<String>();
        output.add(ChatTools.formatTitle("/town"));
        output.add(ChatTools.formatCommand("", "/town", "", TownySettings.getLangString("town_help_1")));
        output.add(ChatTools.formatCommand("", "/town", "[town]", TownySettings.getLangString("town_help_3")));
        output.add(ChatTools.formatCommand("", "/town", "here", TownySettings.getLangString("town_help_4")));
        output.add(ChatTools.formatCommand("", "/town", "list", ""));
        output.add(ChatTools.formatCommand("", "/town", "online", TownySettings.getLangString("town_help_10")));
        output.add(ChatTools.formatCommand("", "/town", "leave", ""));
        output.add(ChatTools.formatCommand("", "/town", "spawn", TownySettings.getLangString("town_help_5")));
        if (!TownySettings.isTownCreationAdminOnly()) {
            output.add(ChatTools.formatCommand("", "/town", "new [town]", TownySettings.getLangString("town_help_6")));
        }
        output.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/town", "new [town] " + TownySettings.getLangString("town_help_2"), TownySettings.getLangString("town_help_7")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("res_sing"), "/town", "deposit [$]", ""));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "mayor ?", TownySettings.getLangString("town_help_8")));
        output.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/town", "delete [town]", ""));
    }

    public TownCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            System.out.println("[PLAYER_COMMAND] " + player.getName() + ": /" + commandLabel + " " + StringMgmt.join(args));
            this.parseTownCommand(player, args);
        } else {
            for (String line : output) {
                sender.sendMessage(Colors.strip(line));
            }
        }
        return true;
    }

    private void parseTownCommand(Player player, String[] split) {
        if (split.length == 0) {
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                Town town = resident.getTown();
                TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(town));
            }
            catch (NotRegisteredException x) {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_dont_belong_town"));
            }
        } else if (split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            for (String line : output) {
                player.sendMessage(line);
            }
        } else if (split[0].equalsIgnoreCase("here")) {
            this.showTownStatusHere(player);
        } else if (split[0].equalsIgnoreCase("list")) {
            this.listTowns(player);
        } else if (split[0].equalsIgnoreCase("new")) {
            if (split.length == 1) {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_specify_name"));
            } else if (split.length == 2) {
                this.newTown(player, split[1], player.getName());
            } else {
                this.newTown(player, split[1], split[2]);
            }
        } else if (split[0].equalsIgnoreCase("leave")) {
            this.townLeave(player);
        } else if (split[0].equalsIgnoreCase("withdraw")) {
            if (split.length == 2) {
                try {
                    this.townWithdraw(player, Integer.parseInt(split[1].trim()));
                }
                catch (NumberFormatException e) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
                }
            } else {
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_must_specify_amnt"), "/town withdraw"));
            }
        } else if (split[0].equalsIgnoreCase("deposit")) {
            if (split.length == 2) {
                try {
                    this.townDeposit(player, Integer.parseInt(split[1].trim()));
                }
                catch (NumberFormatException e) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_int"));
                }
            } else {
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_must_specify_amnt"), "/town deposit"));
            }
        } else {
            String[] newSplit = StringMgmt.remFirstArg(split);
            if (split[0].equalsIgnoreCase("set")) {
                this.townSet(player, newSplit);
            } else if (split[0].equalsIgnoreCase("buy")) {
                this.townBuy(player, newSplit);
            } else if (split[0].equalsIgnoreCase("toggle")) {
                this.townToggle(player, newSplit);
            } else if (split[0].equalsIgnoreCase("mayor")) {
                this.townMayor(player, newSplit);
            } else if (split[0].equalsIgnoreCase("assistant")) {
                this.townAssistant(player, newSplit);
            } else if (split[0].equalsIgnoreCase("spawn")) {
                TownCommand.townSpawn(player, newSplit, false);
            } else if (split[0].equalsIgnoreCase("outpost")) {
                TownCommand.townSpawn(player, newSplit, true);
            } else if (split[0].equalsIgnoreCase("delete")) {
                this.townDelete(player, newSplit);
            } else if (split[0].equalsIgnoreCase("join")) {
                TownCommand.parseTownJoin((CommandSender)player, newSplit);
            } else if (split[0].equalsIgnoreCase("add")) {
                TownCommand.townAdd(player, null, newSplit);
            } else if (split[0].equalsIgnoreCase("kick")) {
                TownCommand.townKick(player, newSplit);
            } else if (split[0].equalsIgnoreCase("claim")) {
                TownCommand.parseTownClaimCommand(player, newSplit);
            } else if (split[0].equalsIgnoreCase("unclaim")) {
                TownCommand.parseTownUnclaimCommand(player, newSplit);
            } else if (split[0].equalsIgnoreCase("online")) {
                try {
                    Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                    Town town = resident.getTown();
                    TownyMessaging.sendMessage((Object)player, TownyFormatter.getFormattedOnlineResidents(TownySettings.getLangString("msg_town_online"), town));
                }
                catch (NotRegisteredException x) {
                    TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_dont_belong_town"));
                }
            } else {
                try {
                    Town town = TownyUniverse.getDataSource().getTown(split[0]);
                    TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(town));
                }
                catch (NotRegisteredException x) {
                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_not_registered_1"), split[0]));
                }
            }
        }
    }

    public void listTowns(Player player) {
        player.sendMessage(ChatTools.formatTitle(TownySettings.getLangString("town_plu")));
        ArrayList<String> formatedList = new ArrayList<String>();
        for (Town town : TownyUniverse.getDataSource().getTowns()) {
            String townToken = "\u00a7b" + town.getName();
            townToken = String.valueOf(townToken) + (town.isOpen() ? "\u00a7f (Open)" : "");
            townToken = String.valueOf(townToken) + "\u00a73 [" + town.getNumResidents() + "]";
            townToken = String.valueOf(townToken) + "\u00a7f";
            formatedList.add(townToken);
        }
        for (String line : ChatTools.list(formatedList)) {
            player.sendMessage(line);
        }
    }

    public void townMayor(Player player, String[] split) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            this.showTownMayorHelp(player);
        }
    }

    public void townAssistant(Player player, String[] split) {
        if (split.length != 0) {
            if (split[0].equalsIgnoreCase("add")) {
                String[] newSplit = StringMgmt.remFirstArg(split);
                this.townAssistantsAdd(player, newSplit);
            } else if (split[0].equalsIgnoreCase("remove")) {
                String[] newSplit = StringMgmt.remFirstArg(split);
                this.townAssistantsRemove(player, newSplit);
            }
        }
    }

    public void showTownStatusHere(Player player) {
        try {
            TownyWorld world = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
            Coord coord = Coord.parseCoord((Entity)player);
            this.showTownStatusAtCoord(player, world, coord);
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
    }

    public void showTownStatusAtCoord(Player player, TownyWorld world, Coord coord) throws TownyException {
        if (!world.hasTownBlock(coord)) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_not_claimed"), coord));
        }
        Town town = world.getTownBlock(coord).getTown();
        TownyMessaging.sendMessage((Object)player, TownyFormatter.getStatus(town));
    }

    public void showTownMayorHelp(Player player) {
        player.sendMessage(ChatTools.formatTitle("Town Mayor Help"));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "withdraw [$]", ""));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "claim", "'/town claim ?' " + TownySettings.getLangString("res_5")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "unclaim", "'/town " + TownySettings.getLangString("res_5")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "[add/kick] " + TownySettings.getLangString("res_2") + " .. []", TownySettings.getLangString("res_6")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "[add+/kick+] " + TownySettings.getLangString("res_2"), TownySettings.getLangString("res_7")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "set [] .. []", "'/town set' " + TownySettings.getLangString("res_5")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "buy [] .. []", "'/town buy' " + TownySettings.getLangString("res_5")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "toggle", ""));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "assistant [add/remove] [player]", TownySettings.getLangString("res_6")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "assistant [add+/remove+] [player]", TownySettings.getLangString("res_7")));
        player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town", "delete", ""));
    }

    public void townToggle(Player player, String[] split) {
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/town toggle"));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "pvp", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "public", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "explosion", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "fire", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "mobs", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "taxpercent", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town toggle", "open", ""));
        } else {
            Town town;
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                town = resident.getTown();
                if (!resident.isMayor() && !town.hasAssistant(resident)) {
                    throw new TownyException(TownySettings.getLangString("msg_not_mayor_ass"));
                }
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
            try {
                if (split[0].equalsIgnoreCase("public")) {
                    if (plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOGGLE_PUBLIC.getNode())) {
                        throw new Exception(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    town.setPublic(!town.isPublic());
                    TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_public"), town.isPublic() ? "Enabled" : "Disabled"));
                } else if (split[0].equalsIgnoreCase("pvp")) {
                    this.toggleTest(player, town, StringMgmt.join(split, " "));
                    town.setPVP(!town.isPVP());
                    TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_pvp"), "Town", town.isPVP() ? "Enabled" : "Disabled"));
                } else if (split[0].equalsIgnoreCase("explosion")) {
                    this.toggleTest(player, town, StringMgmt.join(split, " "));
                    town.setBANG(!town.isBANG());
                    TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_expl"), "Town", town.isBANG() ? "Enabled" : "Disabled"));
                } else if (split[0].equalsIgnoreCase("fire")) {
                    this.toggleTest(player, town, StringMgmt.join(split, " "));
                    town.setFire(!town.isFire());
                    TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_fire"), "Town", town.isFire() ? "Enabled" : "Disabled"));
                } else if (split[0].equalsIgnoreCase("mobs")) {
                    this.toggleTest(player, town, StringMgmt.join(split, " "));
                    town.setHasMobs(!town.hasMobs());
                    TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_mobs"), "Town", town.hasMobs() ? "Enabled" : "Disabled"));
                } else if (split[0].equalsIgnoreCase("taxpercent")) {
                    town.setTaxPercentage(!town.isTaxPercentage());
                    TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_taxpercent"), town.isTaxPercentage() ? "Enabled" : "Disabled"));
                } else if (split[0].equalsIgnoreCase("open")) {
                    if (plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOGGLE_OPEN.getNode())) {
                        throw new Exception(TownySettings.getLangString("msg_err_command_disable"));
                    }
                    town.setOpen(!town.isOpen());
                    TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_changed_open"), town.isOpen() ? "Enabled" : "Disabled"));
                    if (town.isOpen()) {
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_toggle_open_on_warning"), new Object[0]));
                    }
                } else {
                    TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "town"));
                    return;
                }
                for (TownBlock townBlock : town.getTownBlocks()) {
                    if (townBlock.hasResident() || townBlock.isChanged()) continue;
                    townBlock.setType(townBlock.getType());
                    TownyUniverse.getDataSource().saveTownBlock(townBlock);
                }
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
            }
            TownyUniverse.getDataSource().saveTown(town);
        }
    }

    private void toggleTest(Player player, Town town, String split) throws TownyException {
        if ((split = split.toLowerCase()).contains("mobs")) {
            if (town.getWorld().isForceTownMobs()) {
                throw new TownyException(TownySettings.getLangString("msg_world_mobs"));
            }
            if (plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOGGLE_MOBS.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
        }
        if (split.contains("fire")) {
            if (town.getWorld().isForceFire()) {
                throw new TownyException(TownySettings.getLangString("msg_world_fire"));
            }
            if (plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOGGLE_FIRE.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
        }
        if (split.contains("explosion")) {
            if (town.getWorld().isForceExpl()) {
                throw new TownyException(TownySettings.getLangString("msg_world_expl"));
            }
            if (plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOGGLE_EXPLOSION.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
        }
        if (split.contains("pvp")) {
            if (town.getWorld().isForcePVP()) {
                throw new TownyException(TownySettings.getLangString("msg_world_pvp"));
            }
            if (plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOGGLE_PVP.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
            }
        }
    }

    public void townSet(Player player, String[] split) {
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/town set"));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "board [message ... ]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "mayor " + TownySettings.getLangString("town_help_2"), ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "homeblock", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "spawn/outpost", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "perm ...", "'/town set perm' " + TownySettings.getLangString("res_5")));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "taxes [$]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "[plottax/shoptax/embassytax] [$]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "[plotprice/shopprice/embassyprice] [$]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "name [name]", ""));
            player.sendMessage(ChatTools.formatCommand("", "/town set", "tag [upto 4 letters] or clear", ""));
        } else {
            Resident resident;
            Town town = null;
            Nation nation = null;
            TownyWorld oldWorld = null;
            try {
                resident = TownyUniverse.getDataSource().getResident(player.getName());
                town = resident.getTown();
                if (!resident.isMayor() && !town.hasAssistant(resident)) {
                    throw new TownyException(TownySettings.getLangString("msg_not_mayor_ass"));
                }
                if (town.hasNation()) {
                    nation = town.getNation();
                }
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
            if (split[0].equalsIgnoreCase("board")) {
                if (split.length < 2) {
                    TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set board " + TownySettings.getLangString("town_help_9"));
                    return;
                }
                String line = split[1];
                int i = 2;
                while (i < split.length) {
                    line = String.valueOf(line) + " " + split[i];
                    ++i;
                }
                town.setTownBoard(line);
                TownyMessaging.sendTownBoard(player, town);
            } else {
                if (split[0].equalsIgnoreCase("mayor")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set mayor Dumbo");
                        return;
                    }
                    try {
                        if (!resident.isMayor()) {
                            throw new TownyException(TownySettings.getLangString("msg_not_mayor"));
                        }
                        String oldMayor = town.getMayor().getName();
                        Resident newMayor = TownyUniverse.getDataSource().getResident(split[1]);
                        town.setMayor(newMayor);
                        plugin.deleteCache(oldMayor);
                        plugin.deleteCache(newMayor.getName());
                        TownyMessaging.sendTownMessage(town, TownySettings.getNewMayorMsg(newMayor.getName()));
                    }
                    catch (TownyException e) {
                        TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("taxes")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set taxes 7");
                        return;
                    }
                    try {
                        Double amount = Double.parseDouble(split[1]);
                        if (amount < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        if (town.isTaxPercentage() && amount > 100.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_not_percentage"));
                            return;
                        }
                        town.setTaxes(amount);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_tax"), player.getName(), split[1]));
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("plottax")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set plottax 10");
                        return;
                    }
                    try {
                        Double amount = Double.parseDouble(split[1]);
                        if (amount < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setPlotTax(amount);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_plottax"), player.getName(), split[1]));
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("shoptax")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set shoptax 10");
                        return;
                    }
                    try {
                        Double amount = Double.parseDouble(split[1]);
                        if (amount < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setCommercialPlotTax(amount);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_alttax"), player.getName(), "shop", split[1]));
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("embassytax")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set embassytax 10");
                        return;
                    }
                    try {
                        Double amount = Double.parseDouble(split[1]);
                        if (amount < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setEmbassyPlotTax(amount);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_alttax"), player.getName(), "embassy", split[1]));
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("plotprice")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set plotprice 50");
                        return;
                    }
                    try {
                        Double amount = Double.parseDouble(split[1]);
                        if (amount < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setPlotPrice(amount);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_plotprice"), player.getName(), split[1]));
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("shopprice")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set shopprice 50");
                        return;
                    }
                    try {
                        Double amount = Double.parseDouble(split[1]);
                        if (amount < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setCommercialPlotPrice(amount);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_altprice"), player.getName(), "shop", split[1]));
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("embassyprice")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set embassyprice 50");
                        return;
                    }
                    try {
                        Double amount = Double.parseDouble(split[1]);
                        if (amount < 0.0) {
                            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_negative_money"));
                            return;
                        }
                        town.setEmbassyPlotPrice(amount);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_altprice"), player.getName(), "embassy", split[1]));
                    }
                    catch (NumberFormatException e) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_error_must_be_num"));
                        return;
                    }
                }
                if (split[0].equalsIgnoreCase("name")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set name BillyBobTown");
                        return;
                    }
                    if (plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOWN_RENAME.getNode())) {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_command_disable"));
                        return;
                    }
                    if (!NameValidation.isBlacklistName(split[1])) {
                        this.townRename(player, town, split[1]);
                    } else {
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
                    }
                } else if (split[0].equalsIgnoreCase("tag")) {
                    if (split.length < 2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Eg: /town set tag PLTC");
                    } else if (split[1].equalsIgnoreCase("clear")) {
                        try {
                            town.setTag(" ");
                            TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_reset_town_tag"), player.getName()));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        }
                    } else {
                        try {
                            town.setTag(NameValidation.checkAndFilterName(split[1]));
                            TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_set_town_tag"), player.getName(), town.getTag()));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        }
                        catch (InvalidNameException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                        }
                    }
                } else {
                    if (split[0].equalsIgnoreCase("homeblock")) {
                        Coord coord = Coord.parseCoord((Entity)player);
                        try {
                            if (TownyUniverse.isWarTime()) {
                                throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
                            }
                            TownyWorld world = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
                            if (world.getMinDistanceFromOtherTowns(coord, resident.getTown()) < TownySettings.getMinDistanceFromTownHomeblocks()) {
                                throw new TownyException(TownySettings.getLangString("msg_too_close"));
                            }
                            if (TownySettings.getMaxDistanceBetweenHomeblocks() > 0 && world.getMinDistanceFromOtherTowns(coord, resident.getTown()) > TownySettings.getMaxDistanceBetweenHomeblocks() && world.hasTowns()) {
                                throw new TownyException(TownySettings.getLangString("msg_too_far"));
                            }
                            TownBlock townBlock = TownyUniverse.getDataSource().getWorld(player.getWorld().getName()).getTownBlock(coord);
                            oldWorld = town.getWorld();
                            town.setHomeBlock(townBlock);
                            TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_set_town_home"), coord.toString()));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                            return;
                        }
                    }
                    if (split[0].equalsIgnoreCase("spawn")) {
                        try {
                            town.setSpawn(player.getLocation());
                            TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_set_town_spawn"));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                            return;
                        }
                    }
                    if (split[0].equalsIgnoreCase("outpost")) {
                        try {
                            town.addOutpostSpawn(player.getLocation());
                            TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_set_outpost_spawn"));
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                            return;
                        }
                    }
                    if (split[0].equalsIgnoreCase("perm")) {
                        try {
                            this.toggleTest(player, town, StringMgmt.join(split, " "));
                        }
                        catch (Exception e) {
                            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                            return;
                        }
                        String[] newSplit = StringMgmt.remFirstArg(split);
                        TownCommand.setTownBlockOwnerPermissions(player, town, newSplit);
                    } else {
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_invalid_property"), "town"));
                        return;
                    }
                }
            }
            TownyUniverse.getDataSource().saveTown(town);
            TownyUniverse.getDataSource().saveTownList();
            if (nation != null) {
                TownyUniverse.getDataSource().saveNation(nation);
            }
            if (oldWorld != null) {
                TownyUniverse.getDataSource().saveWorld(town.getWorld());
                TownyUniverse.getDataSource().saveWorld(oldWorld);
            }
        }
    }

    public void townBuy(Player player, String[] split) {
        if (split.length == 0) {
            player.sendMessage(ChatTools.formatTitle("/town buy"));
            if (TownySettings.isSellingBonusBlocks()) {
                String line = "\u00a7e[Purchased Bonus] \u00a72Cost: \u00a7a%s\u00a78 | \u00a72Max: \u00a7a%d";
                player.sendMessage(String.format(line, TownyEconomyHandler.getFormattedBalance(TownySettings.getPurchasedBonusBlocksCost()), TownySettings.getMaxPurchedBlocks()));
                player.sendMessage(ChatTools.formatCommand("", "/town buy", "bonus [n]", ""));
            } else {
                player.sendMessage("Nothing for sale right now.");
            }
        } else {
            Town town;
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                town = resident.getTown();
                if (!resident.isMayor() && !town.hasAssistant(resident)) {
                    throw new TownyException(TownySettings.getLangString("msg_not_mayor_ass"));
                }
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
            try {
                if (split[0].equalsIgnoreCase("bonus")) {
                    if (split.length == 2) {
                        try {
                            int bought = TownCommand.townBuyBonusTownBlocks(town, Integer.parseInt(split[1].trim()));
                            double cost = (double)bought * TownySettings.getPurchasedBonusBlocksCost();
                            TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_buy"), bought, "bonus town blocks", TownyEconomyHandler.getFormattedBalance(cost)));
                        }
                        catch (NumberFormatException e) {
                            throw new TownyException(TownySettings.getLangString("msg_error_must_be_int"));
                        }
                    } else {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_must_specify_amnt"), "/town buy bonus"));
                    }
                }
                TownyUniverse.getDataSource().saveTown(town);
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
        }
    }

    public static int townBuyBonusTownBlocks(Town town, int inputN) throws TownyException {
        if (inputN < 0) {
            throw new TownyException(TownySettings.getLangString("msg_err_negative"));
        }
        int current = town.getPurchasedBlocks();
        int n = current + inputN > TownySettings.getMaxPurchedBlocks() ? TownySettings.getMaxPurchedBlocks() - current : inputN;
        if (n == 0) {
            return n;
        }
        try {
            double cost = (double)n * TownySettings.getPurchasedBonusBlocksCost();
            if (TownySettings.isUsingEconomy() && !town.pay(cost, String.format("Town Buy Bonus (%d)", n))) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_no_funds_to_buy"), n, "bonus town blocks", TownyEconomyHandler.getFormattedBalance(cost)));
            }
        }
        catch (EconomyException e1) {
            throw new TownyException("Economy Error");
        }
        town.addPurchasedBlocks(n);
        return n;
    }

    public void newTown(Player player, String name, String mayorName) {
        try {
            String filteredName;
            if (TownyUniverse.isWarTime()) {
                throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
            }
            if (!TownyUniverse.getPermissionSource().isTownyAdmin(player) && (TownySettings.isTownCreationAdminOnly() && !plugin.isPermissions() || plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOWN_NEW.getNode()))) {
                throw new TownyException(TownySettings.getNotPermToNewTownLine());
            }
            if (TownySettings.hasTownLimit() && TownyUniverse.getDataSource().getTowns().size() >= TownySettings.getTownLimit()) {
                throw new TownyException(TownySettings.getLangString("msg_err_universe_limit"));
            }
            try {
                filteredName = NameValidation.checkAndFilterName(name);
            }
            catch (InvalidNameException e) {
                filteredName = null;
            }
            if (filteredName == null || TownyUniverse.getDataSource().hasTown(filteredName)) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_name"), name));
            }
            Resident resident = TownyUniverse.getDataSource().getResident(mayorName);
            if (resident.hasTown()) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_already_res"), resident.getName()));
            }
            TownyWorld world = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
            if (!world.isUsingTowny()) {
                throw new TownyException(TownySettings.getLangString("msg_set_use_towny_off"));
            }
            Coord key = Coord.parseCoord((Entity)player);
            if (world.hasTownBlock(key)) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_already_claimed_1"), key));
            }
            if (world.getMinDistanceFromOtherTowns(key) < TownySettings.getMinDistanceFromTownHomeblocks()) {
                throw new TownyException(TownySettings.getLangString("msg_too_close"));
            }
            if (TownySettings.getMaxDistanceBetweenHomeblocks() > 0 && world.getMinDistanceFromOtherTowns(key) > TownySettings.getMaxDistanceBetweenHomeblocks() && world.hasTowns()) {
                throw new TownyException(TownySettings.getLangString("msg_too_far"));
            }
            if (TownySettings.isUsingEconomy() && !resident.pay(TownySettings.getNewTownPrice(), "New Town Cost")) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_no_funds_new_town"), resident.getName().equals(player.getName()) ? "You" : resident.getName()));
            }
            this.newTown(world, name, resident, key, player.getLocation());
            TownyMessaging.sendGlobalMessage(TownySettings.getNewTownMsg(player.getName(), name));
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
        catch (EconomyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
    }

    public Town newTown(TownyWorld world, String name, Resident resident, Coord key, Location spawn) throws TownyException {
        world.newTownBlock(key);
        TownyUniverse.getDataSource().newTown(name);
        Town town = TownyUniverse.getDataSource().getTown(name);
        town.addResident(resident);
        town.setMayor(resident);
        TownBlock townBlock = world.getTownBlock(key);
        townBlock.setTown(town);
        town.setHomeBlock(townBlock);
        townBlock.setType(townBlock.getType());
        town.setSpawn(spawn);
        if (world.isUsingPlotManagementRevert()) {
            PlotBlockData plotChunk = TownyRegenAPI.getPlotChunk(townBlock);
            if (plotChunk != null) {
                TownyRegenAPI.deletePlotChunk(plotChunk);
            } else {
                plotChunk = new PlotBlockData(townBlock);
                plotChunk.initialize();
            }
            TownyRegenAPI.addPlotChunkSnapshot(plotChunk);
            plotChunk = null;
        }
        TownyMessaging.sendDebugMsg("Creating new Town account: town-" + name);
        if (TownySettings.isUsingEconomy()) {
            town.setBalance(0.0);
        }
        TownyUniverse.getDataSource().saveResident(resident);
        TownyUniverse.getDataSource().saveTownBlock(townBlock);
        TownyUniverse.getDataSource().saveTown(town);
        TownyUniverse.getDataSource().saveWorld(world);
        TownyUniverse.getDataSource().saveTownList();
        plugin.updateCache(townBlock.getWorldCoord());
        return town;
    }

    public void townRename(Player player, Town town, String newName) {
        try {
            TownyUniverse.getDataSource().renameTown(town, newName);
            TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_name"), player.getName(), town.getName()));
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
    }

    public void townLeave(Player player) {
        Town town;
        Resident resident;
        try {
            if (TownyUniverse.isWarTime()) {
                throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
            }
            resident = TownyUniverse.getDataSource().getResident(player.getName());
            town = resident.getTown();
            plugin.deleteCache(resident.getName());
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        if (resident.isMayor()) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getMayorAbondonMsg());
            return;
        }
        try {
            town.removeResident(resident);
        }
        catch (EmptyTownException et) {
            TownyUniverse.getDataSource().removeTown(et.getTown());
        }
        catch (NotRegisteredException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        TownyUniverse.getDataSource().saveResident(resident);
        TownyUniverse.getDataSource().saveTown(town);
        plugin.resetCache();
        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_left_town"), resident.getName()));
        TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_left_town"), resident.getName()));
    }

    public static void townSpawn(Player player, String[] split, Boolean outpost) {
        try {
            double travelCost;
            List<String> disallowedZones;
            TownSpawnLevel townSpawnPermission;
            Location spawnLoc;
            String notAffordMSG;
            Town town;
            boolean isTownyAdmin = TownyUniverse.getPermissionSource().isTownyAdmin(player);
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            if (split.length == 0 || split.length > 0 && outpost.booleanValue()) {
                town = resident.getTown();
                notAffordMSG = TownySettings.getLangString("msg_err_cant_afford_tp");
            } else {
                town = TownyUniverse.getDataSource().getTown(split[0]);
                notAffordMSG = String.format(TownySettings.getLangString("msg_err_cant_afford_tp_town"), town.getName());
            }
            if (outpost.booleanValue()) {
                Integer index;
                if (!town.hasOutpostSpawn()) {
                    throw new TownyException(TownySettings.getLangString("msg_err_outpost_spawn"));
                }
                try {
                    index = Integer.parseInt(split[split.length - 1]);
                }
                catch (NumberFormatException e) {
                    index = 1;
                }
                catch (ArrayIndexOutOfBoundsException i) {
                    index = 1;
                }
                spawnLoc = town.getOutpostSpawn(Math.max(1, index));
            } else {
                spawnLoc = town.getSpawn();
            }
            if (isTownyAdmin) {
                townSpawnPermission = TownSpawnLevel.ADMIN;
            } else if (split.length == 0) {
                townSpawnPermission = TownSpawnLevel.TOWN_RESIDENT;
            } else if (!resident.hasTown()) {
                townSpawnPermission = TownSpawnLevel.UNAFFILIATED;
            } else if (resident.getTown() == town) {
                townSpawnPermission = outpost != false ? TownSpawnLevel.TOWN_RESIDENT_OUTPOST : TownSpawnLevel.TOWN_RESIDENT;
            } else if (resident.hasNation() && town.hasNation()) {
                Nation targetNation;
                Nation playerNation = resident.getTown().getNation();
                if (playerNation == (targetNation = town.getNation())) {
                    townSpawnPermission = TownSpawnLevel.PART_OF_NATION;
                } else {
                    if (targetNation.hasEnemy(playerNation)) {
                        throw new TownyException(TownySettings.getLangString("msg_err_public_spawn_enemy"));
                    }
                    townSpawnPermission = targetNation.hasAlly(playerNation) ? TownSpawnLevel.NATION_ALLY : TownSpawnLevel.UNAFFILIATED;
                }
            } else {
                townSpawnPermission = TownSpawnLevel.UNAFFILIATED;
            }
            TownyMessaging.sendDebugMsg(String.valueOf(townSpawnPermission.toString()) + " " + townSpawnPermission.isAllowed());
            townSpawnPermission.checkIfAllowed(plugin, player);
            if (!isTownyAdmin && townSpawnPermission != TownSpawnLevel.TOWN_RESIDENT && townSpawnPermission != TownSpawnLevel.TOWN_RESIDENT_OUTPOST && !town.isPublic()) {
                throw new TownyException(TownySettings.getLangString("msg_err_not_public"));
            }
            if (!isTownyAdmin && !(disallowedZones = TownySettings.getDisallowedTownSpawnZones()).isEmpty()) {
                String inTown = null;
                try {
                    Location loc = plugin.getCache(player).getLastLocation();
                    inTown = TownyUniverse.getTownName(loc);
                }
                catch (NullPointerException e) {
                    inTown = TownyUniverse.getTownName(player.getLocation());
                }
                if (inTown == null && disallowedZones.contains("unclaimed")) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_err_town_spawn_disallowed_from"), "the Wilderness"));
                }
                if (inTown != null && resident.hasNation() && TownyUniverse.getDataSource().getTown(inTown).hasNation()) {
                    Nation playerNation;
                    Nation inNation = TownyUniverse.getDataSource().getTown(inTown).getNation();
                    if (inNation.hasEnemy(playerNation = resident.getTown().getNation()) && disallowedZones.contains("enemy")) {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_err_town_spawn_disallowed_from"), "Enemy areas"));
                    }
                    if (!inNation.hasAlly(playerNation) && !inNation.hasEnemy(playerNation) && disallowedZones.contains("neutral")) {
                        throw new TownyException(String.format(TownySettings.getLangString("msg_err_town_spawn_disallowed_from"), "Neutral towns"));
                    }
                }
            }
            if ((travelCost = townSpawnPermission.getCost()) > 0.0 && TownySettings.isUsingEconomy() && resident.getHoldingBalance() < travelCost) {
                throw new TownyException(notAffordMSG);
            }
            Chunk chunk = spawnLoc.getChunk();
            boolean UsingESS = plugin.isEssentials();
            if (UsingESS && !isTownyAdmin) {
                try {
                    User user = plugin.getEssentials().getUser((Object)player);
                    if (!user.isJailed()) {
                        Teleport teleport = user.getTeleport();
                        if (!chunk.isLoaded()) {
                            chunk.load();
                        }
                        teleport.cooldown(true);
                        teleport.teleport(spawnLoc, null);
                    }
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg((Object)player, "Error: " + e.getMessage());
                    return;
                }
            }
            if (travelCost > 0.0 && TownySettings.isUsingEconomy() && resident.payTo(travelCost, town, String.format("Town Spawn (%s)", new Object[]{townSpawnPermission}))) {
                TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_cost_spawn"), TownyEconomyHandler.getFormattedBalance(travelCost)));
            }
            if (isTownyAdmin) {
                if (player.getVehicle() != null) {
                    player.getVehicle().eject();
                }
                if (!chunk.isLoaded()) {
                    chunk.load();
                }
                player.teleport(spawnLoc);
                return;
            }
            if (!UsingESS) {
                if (TownyTimerHandler.isTeleportWarmupRunning()) {
                    player.sendMessage(String.format(TownySettings.getLangString("msg_town_spawn_warmup"), TownySettings.getTeleportWarmupTime()));
                    plugin.getTownyUniverse().requestTeleport(player, spawnLoc, travelCost);
                } else {
                    if (player.getVehicle() != null) {
                        player.getVehicle().eject();
                    }
                    if (!chunk.isLoaded()) {
                        chunk.load();
                    }
                    player.teleport(spawnLoc);
                }
            }
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
        catch (EconomyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
    }

    public void townDelete(Player player, String[] split) {
        if (split.length == 0) {
            try {
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                Town town = resident.getTown();
                if (!resident.isMayor()) {
                    throw new TownyException(TownySettings.getLangString("msg_not_mayor"));
                }
                if (plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOWN_DELETE.getNode())) {
                    throw new TownyException(TownySettings.getLangString("msg_err_command_disable"));
                }
                TownyUniverse.getDataSource().removeTown(town);
                TownyMessaging.sendGlobalMessage(TownySettings.getDelTownMsg(town));
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
        }
        try {
            if (!TownyUniverse.getPermissionSource().isTownyAdmin(player)) {
                throw new TownyException(TownySettings.getLangString("msg_err_admin_only_delete_town"));
            }
            Town town = TownyUniverse.getDataSource().getTown(split[0]);
            TownyUniverse.getDataSource().removeTown(town);
            TownyMessaging.sendGlobalMessage(TownySettings.getDelTownMsg(town));
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
    }

    public static void townKick(Player player, String[] names) {
        Town town;
        Resident resident;
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
            town = resident.getTown();
            if (!resident.isMayor() && !town.hasAssistant(resident)) {
                throw new TownyException(TownySettings.getLangString("msg_not_mayor_ass"));
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        TownCommand.townKickResidents(player, resident, town, plugin.getTownyUniverse().getValidatedResidents(player, names));
        plugin.resetCache();
    }

    public static void townAddResidents(Object sender, Town town, List<Resident> invited) {
        ArrayList<Resident> remove = new ArrayList<Resident>();
        for (Resident newMember : invited) {
            try {
                if (plugin.isPermissions()) {
                    if (Bukkit.getServer().matchPlayer(newMember.getName()).isEmpty()) {
                        TownyMessaging.sendErrorMsg(sender, String.format(TownySettings.getLangString("msg_offline_no_join"), newMember.getName()));
                        remove.add(newMember);
                        continue;
                    }
                    if (!TownyUniverse.getPermissionSource().has(Bukkit.getServer().getPlayer(newMember.getName()), PermissionNodes.TOWNY_TOWN_RESIDENT.getNode())) {
                        TownyMessaging.sendErrorMsg(sender, String.format(TownySettings.getLangString("msg_not_allowed_join"), newMember.getName()));
                        remove.add(newMember);
                        continue;
                    }
                    town.addResidentCheck(newMember);
                    TownCommand.townInviteResident(town, newMember);
                    continue;
                }
                town.addResidentCheck(newMember);
                TownCommand.townInviteResident(town, newMember);
            }
            catch (AlreadyRegisteredException e) {
                remove.add(newMember);
                TownyMessaging.sendErrorMsg(sender, e.getMessage());
            }
        }
        for (Resident newMember : remove) {
            invited.remove(newMember);
        }
        if (invited.size() > 0) {
            String msg = "";
            for (Resident newMember : invited) {
                msg = String.valueOf(msg) + newMember.getName() + ", ";
            }
            msg = msg.substring(0, msg.length() - 2);
            String name = sender instanceof Player ? ((Player)sender).getName() : "Console";
            msg = String.format(TownySettings.getLangString("msg_invited_join_town"), name, msg);
            TownyMessaging.sendTownMessage(town, ChatTools.color(msg));
            TownyUniverse.getDataSource().saveTown(town);
        } else {
            TownyMessaging.sendErrorMsg(sender, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public static void townAddResident(Town town, Resident resident) throws AlreadyRegisteredException {
        town.addResident(resident);
        plugin.deleteCache(resident.getName());
        TownyUniverse.getDataSource().saveResident(resident);
        TownyUniverse.getDataSource().saveTown(town);
    }

    private static void townInviteResident(Town town, Resident newMember) throws AlreadyRegisteredException {
        Plugin test = Bukkit.getServer().getPluginManager().getPlugin("Questioner");
        if (TownySettings.isUsingQuestioner() && test != null && test instanceof Questioner && test.isEnabled()) {
            Questioner questioner = (Questioner)test;
            questioner.loadClasses();
            ArrayList<Option> options = new ArrayList<Option>();
            options.add(new Option(TownySettings.questionerAccept(), (Runnable)((Object)new JoinTownTask(newMember, town))));
            options.add(new Option(TownySettings.questionerDeny(), (Runnable)((Object)new ResidentTownQuestionTask(newMember, town){

                @Override
                public void run() {
                    TownyMessaging.sendTownMessage(this.getTown(), String.format(TownySettings.getLangString("msg_deny_invite"), this.getResident().getName()));
                }
            })));
            Question question = new Question(newMember.getName(), String.format(TownySettings.getLangString("msg_invited"), town.getName()), options);
            try {
                plugin.appendQuestion(questioner, question);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } else {
            try {
                TownCommand.townAddResident(town, newMember);
            }
            catch (AlreadyRegisteredException alreadyRegisteredException) {
                // empty catch block
            }
        }
    }

    public static void townKickResidents(Object sender, Resident resident, Town town, List<Resident> kicking) {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        ArrayList<Resident> remove = new ArrayList<Resident>();
        for (Resident member : kicking) {
            if (resident == member || member.isMayor() || town.hasAssistant(member)) {
                remove.add(member);
                continue;
            }
            try {
                town.removeResident(member);
                plugin.deleteCache(member.getName());
                TownyUniverse.getDataSource().saveResident(member);
            }
            catch (NotRegisteredException e) {
                remove.add(member);
            }
            catch (EmptyTownException emptyTownException) {
                // empty catch block
            }
        }
        for (Resident member : remove) {
            kicking.remove(member);
        }
        if (kicking.size() > 0) {
            String msg = "";
            for (Resident member : kicking) {
                msg = String.valueOf(msg) + member.getName() + ", ";
                Player p = Bukkit.getServer().getPlayer(member.getName());
                if (p == null) continue;
                p.sendMessage(String.format(TownySettings.getLangString("msg_kicked_by"), player != null ? player.getName() : "CONSOLE"));
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = String.format(TownySettings.getLangString("msg_kicked"), player != null ? player.getName() : "CONSOLE", msg);
            TownyMessaging.sendTownMessage(town, ChatTools.color(msg));
            TownyUniverse.getDataSource().saveTown(town);
        } else {
            TownyMessaging.sendErrorMsg(sender, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public void townAssistantsAdd(Player player, String[] names) {
        Town town;
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            town = resident.getTown();
            if (!resident.isMayor()) {
                throw new TownyException(TownySettings.getLangString("msg_not_mayor"));
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        this.townAssistantsAdd(player, town, plugin.getTownyUniverse().getValidatedResidents(player, names));
    }

    public void townAssistantsAdd(Player player, Town town, List<Resident> invited) {
        ArrayList<Resident> remove = new ArrayList<Resident>();
        for (Resident newMember : invited) {
            try {
                town.addAssistant(newMember);
                plugin.deleteCache(newMember.getName());
                TownyUniverse.getDataSource().saveResident(newMember);
            }
            catch (AlreadyRegisteredException e) {
                remove.add(newMember);
            }
            catch (NotRegisteredException e) {
                remove.add(newMember);
                TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
            }
        }
        for (Resident newMember : remove) {
            invited.remove(newMember);
        }
        if (invited.size() > 0) {
            String msg = "";
            for (Resident newMember : invited) {
                msg = String.valueOf(msg) + newMember.getName() + ", ";
            }
            msg = String.format(TownySettings.getLangString("msg_raised_ass"), player.getName(), msg, "town");
            TownyMessaging.sendTownMessage(town, ChatTools.color(msg));
            TownyUniverse.getDataSource().saveTown(town);
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public void townAssistantsRemove(Player player, String[] names) {
        Town town;
        Resident resident;
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
            town = resident.getTown();
            if (!resident.isMayor()) {
                throw new TownyException(TownySettings.getLangString("msg_not_mayor"));
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
        this.townAssistantsRemove(player, resident, town, plugin.getTownyUniverse().getValidatedResidents(player, names));
    }

    public void townAssistantsRemove(Player player, Resident resident, Town town, List<Resident> kicking) {
        ArrayList<Resident> remove = new ArrayList<Resident>();
        ArrayList<Resident> toKick = new ArrayList<Resident>(kicking);
        for (Resident member : toKick) {
            try {
                town.removeAssistant(member);
                plugin.deleteCache(member.getName());
                TownyUniverse.getDataSource().saveResident(member);
                TownyUniverse.getDataSource().saveTown(town);
            }
            catch (NotRegisteredException e) {
                remove.add(member);
            }
        }
        if (remove.size() > 0) {
            for (Resident member : remove) {
                toKick.remove(member);
            }
        }
        if (toKick.size() > 0) {
            String msg = "";
            for (Resident member : toKick) {
                msg = String.valueOf(msg) + member.getName() + ", ";
                Player p = Bukkit.getServer().getPlayer(member.getName());
                if (p == null) continue;
                p.sendMessage(String.format(TownySettings.getLangString("msg_lowered_to_res_by"), player.getName()));
            }
            msg = msg.substring(0, msg.length() - 2);
            msg = String.format(TownySettings.getLangString("msg_lowered_to_res"), player.getName(), msg);
            TownyMessaging.sendTownMessage(town, ChatTools.color(msg));
            TownyUniverse.getDataSource().saveTown(town);
        } else {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_invalid_name"));
        }
    }

    public static void parseTownJoin(CommandSender sender, String[] args) {
        try {
            String contextualResidentName;
            String townName;
            String residentName;
            boolean console = false;
            if (sender instanceof Player) {
                if (args.length < 1) {
                    throw new Exception(String.format("Usage: /town join [town]", new Object[0]));
                }
                Player player = (Player)sender;
                residentName = player.getName();
                townName = args[0];
                contextualResidentName = "You";
            } else {
                if (args.length < 2) {
                    throw new Exception(String.format("Usage: town join [resident] [town]", new Object[0]));
                }
                residentName = args[0];
                townName = args[1];
                contextualResidentName = residentName;
            }
            Resident resident = TownyUniverse.getDataSource().getResident(residentName);
            Town town = TownyUniverse.getDataSource().getTown(townName);
            if (resident.hasTown()) {
                throw new Exception(String.format(TownySettings.getLangString("msg_err_already_res"), contextualResidentName));
            }
            if (!console && !town.isOpen()) {
                throw new Exception(String.format(TownySettings.getLangString("msg_err_not_open"), town.getFormattedName()));
            }
            TownCommand.townAddResident(town, resident);
            TownyMessaging.sendTownMessage(town, ChatTools.color(String.format(TownySettings.getLangString("msg_join_town"), resident.getName())));
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage());
        }
    }

    public static void townAdd(Object sender, Town specifiedTown, String[] names) {
        Town town;
        String name = sender instanceof Player ? ((Player)sender).getName() : "Console";
        try {
            if (name.equalsIgnoreCase("Console")) {
                town = specifiedTown;
            } else {
                Resident resident = TownyUniverse.getDataSource().getResident(name);
                town = specifiedTown == null ? resident.getTown() : specifiedTown;
                if (!(TownyUniverse.getPermissionSource().isTownyAdmin((Player)sender) || resident.isMayor() || town.hasAssistant(resident))) {
                    throw new TownyException(TownySettings.getLangString("msg_not_mayor_ass"));
                }
            }
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg(sender, x.getMessage());
            return;
        }
        TownCommand.townAddResidents(sender, town, plugin.getTownyUniverse().getValidatedResidents(sender, names));
        plugin.resetCache(BukkitTools.getPlayerExact(name));
    }

    public static void setTownBlockOwnerPermissions(Player player, TownBlockOwner townBlockOwner, String[] split) {
        TownCommand.setTownBlockPermissions(player, townBlockOwner, townBlockOwner.getPermissions(), split, false);
    }

    public static void setTownBlockPermissions(Player player, TownBlockOwner townBlockOwner, TownyPermission perm, String[] split, boolean friend) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            player.sendMessage(ChatTools.formatTitle("/... set perm"));
            player.sendMessage(ChatTools.formatCommand("Level", "[resident/ally/outsider]", "", ""));
            player.sendMessage(ChatTools.formatCommand("Type", "[build/destroy/switch/itemuse]", "", ""));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "[on/off]", "Toggle all permissions"));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "[level/type] [on/off]", ""));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "[level] [type] [on/off]", ""));
            player.sendMessage(ChatTools.formatCommand("", "set perm", "reset", ""));
            if (townBlockOwner instanceof Town) {
                player.sendMessage(ChatTools.formatCommand("Eg", "/town set perm", "ally off", ""));
            }
            if (townBlockOwner instanceof Resident) {
                player.sendMessage(ChatTools.formatCommand("Eg", "/resident|plot set perm", "friend build on", ""));
            }
            player.sendMessage(String.format(TownySettings.getLangString("plot_perms"), "'friend'", "'resident'"));
            player.sendMessage(TownySettings.getLangString("plot_perms_1"));
        } else {
            if (friend && split[0].equalsIgnoreCase("friend")) {
                split[0] = "resident";
            }
            if (split.length == 1) {
                if (split[0].equalsIgnoreCase("reset")) {
                    for (TownBlock townBlock : townBlockOwner.getTownBlocks()) {
                        if ((!(townBlockOwner instanceof Town) || townBlock.hasResident()) && (!(townBlockOwner instanceof Resident) || !townBlock.hasResident())) continue;
                        townBlock.setType(townBlock.getType());
                        TownyUniverse.getDataSource().deleteTownBlock(townBlock);
                    }
                    if (townBlockOwner instanceof Town) {
                        TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_set_perms_reset"), "Town owned"));
                    } else {
                        TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_set_perms_reset"), "your"));
                    }
                    plugin.resetCache();
                    return;
                }
                try {
                    boolean b = plugin.parseOnOff(split[0]);
                    String[] stringArray = new String[]{"residentBuild", "residentDestroy", "residentSwitch", "residentItemUse", "outsiderBuild", "outsiderDestroy", "outsiderSwitch", "outsiderItemUse", "allyBuild", "allyDestroy", "allySwitch", "allyItemUse"};
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String element = stringArray[n2];
                        perm.set(element, b);
                        ++n2;
                    }
                }
                catch (Exception b) {}
            } else if (split.length == 2) {
                try {
                    boolean b = plugin.parseOnOff(split[1]);
                    if (split[0].equalsIgnoreCase("resident") || split[0].equalsIgnoreCase("friend")) {
                        perm.residentBuild = b;
                        perm.residentDestroy = b;
                        perm.residentSwitch = b;
                        perm.residentItemUse = b;
                    } else if (split[0].equalsIgnoreCase("outsider")) {
                        perm.outsiderBuild = b;
                        perm.outsiderDestroy = b;
                        perm.outsiderSwitch = b;
                        perm.outsiderItemUse = b;
                    } else if (split[0].equalsIgnoreCase("ally")) {
                        perm.allyBuild = b;
                        perm.allyDestroy = b;
                        perm.allySwitch = b;
                        perm.allyItemUse = b;
                    } else if (split[0].equalsIgnoreCase("build")) {
                        perm.residentBuild = b;
                        perm.outsiderBuild = b;
                        perm.allyBuild = b;
                    } else if (split[0].equalsIgnoreCase("destroy")) {
                        perm.residentDestroy = b;
                        perm.outsiderDestroy = b;
                        perm.allyDestroy = b;
                    } else if (split[0].equalsIgnoreCase("switch")) {
                        perm.residentSwitch = b;
                        perm.outsiderSwitch = b;
                        perm.allySwitch = b;
                    } else if (split[0].equalsIgnoreCase("itemuse")) {
                        perm.residentItemUse = b;
                        perm.outsiderItemUse = b;
                        perm.allyItemUse = b;
                    }
                }
                catch (Exception b) {}
            } else if (split.length == 3) {
                try {
                    boolean b = plugin.parseOnOff(split[2]);
                    String s = "";
                    s = String.valueOf(split[0]) + split[1];
                    perm.set(s, b);
                }
                catch (Exception b) {
                    // empty catch block
                }
            }
            for (TownBlock townBlock : townBlockOwner.getTownBlocks()) {
                if (!(townBlockOwner instanceof Town) || townBlock.hasResident() || townBlock.isChanged()) continue;
                townBlock.setType(townBlock.getType());
                TownyUniverse.getDataSource().deleteTownBlock(townBlock);
            }
            TownyMessaging.sendMsg((Object)player, TownySettings.getLangString("msg_set_perms"));
            TownyMessaging.sendMessage((Object)player, "\u00a72 Perm: " + (townBlockOwner instanceof Resident ? perm.getColourString().replace("f", "r") : perm.getColourString()));
            TownyMessaging.sendMessage((Object)player, "\u00a72PvP: " + (perm.pvp ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Explosions: " + (perm.explosion ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Firespread: " + (perm.fire ? "\u00a74ON" : "\u00a7aOFF") + "\u00a72" + "  Mob Spawns: " + (perm.mobs ? "\u00a74ON" : "\u00a7aOFF"));
            plugin.resetCache();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parseTownClaimCommand(Player player, String[] split) {
        if (split.length == 1 && split[0].equalsIgnoreCase("?")) {
            player.sendMessage(ChatTools.formatTitle("/town claim"));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town claim", "", TownySettings.getLangString("msg_block_claim")));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town claim", "outpost", TownySettings.getLangString("mayor_help_3")));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town claim", "[circle/rect] [radius]", TownySettings.getLangString("mayor_help_4")));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town claim", "[circle/rect] auto", TownySettings.getLangString("mayor_help_5")));
            return;
        }
        try {
            List<WorldCoord> selection;
            if (TownyUniverse.isWarTime()) {
                throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
            }
            if (!TownyUniverse.getPermissionSource().isTownyAdmin(player) && plugin.isPermissions() && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOWN_CLAIM.getNode())) {
                throw new TownyException(TownySettings.getLangString("msg_no_perms_claim"));
            }
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Town town = resident.getTown();
            if (!resident.isMayor() && !town.hasAssistant(resident)) {
                throw new TownyException(TownySettings.getLangString("msg_not_mayor_ass"));
            }
            TownyWorld world = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
            if (!world.isUsingTowny()) {
                throw new TownyException(TownySettings.getLangString("msg_set_use_towny_off"));
            }
            double blockCost = 0.0;
            boolean attachedToEdge = true;
            boolean outpost = false;
            Coord key = Coord.parseCoord(plugin.getCache(player).getLastLocation());
            if (split.length == 1 && split[0].equalsIgnoreCase("outpost")) {
                if (!TownySettings.isAllowingOutposts() || plugin.isPermissions() && (!plugin.isPermissions() || !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOWN_CLAIM_OUTPOST.getNode()))) throw new TownyException(TownySettings.getLangString("msg_outpost_disable"));
                if (world.hasTownBlock(key)) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_already_claimed_1"), key));
                }
                if (world.getMinDistanceFromOtherTowns(key) < TownySettings.getMinDistanceFromTownHomeblocks()) {
                    throw new TownyException(TownySettings.getLangString("msg_too_close"));
                }
                selection = AreaSelectionUtil.selectWorldCoordArea(town, new WorldCoord(world.getName(), key), new String[0]);
                blockCost = TownySettings.getOutpostCost();
                attachedToEdge = false;
                outpost = true;
            } else {
                selection = AreaSelectionUtil.selectWorldCoordArea(town, new WorldCoord(world.getName(), key), split);
                blockCost = TownySettings.getClaimPrice();
            }
            TownyMessaging.sendDebugMsg("townClaim: Pre-Filter Selection " + Arrays.toString(selection.toArray(new WorldCoord[0])));
            selection = AreaSelectionUtil.filterTownOwnedBlocks(selection);
            TownyMessaging.sendDebugMsg("townClaim: Post-Filter Selection " + Arrays.toString(selection.toArray(new WorldCoord[0])));
            TownCommand.checkIfSelectionIsValid(town, selection, attachedToEdge, blockCost, false);
            try {
                double cost = blockCost * (double)selection.size();
                if (TownySettings.isUsingEconomy() && !town.pay(cost, String.format("Town Claim (%d)", selection.size()))) {
                    throw new TownyException(String.format(TownySettings.getLangString("msg_no_funds_claim"), selection.size(), TownyEconomyHandler.getFormattedBalance(cost)));
                }
            }
            catch (EconomyException e1) {
                throw new TownyException("Economy Error");
            }
            new TownClaim(plugin, player, town, selection, outpost, true, false).start();
            return;
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            return;
        }
    }

    public static void parseTownUnclaimCommand(Player player, String[] split) {
        if (split.length == 1 && split[0].equalsIgnoreCase("?")) {
            player.sendMessage(ChatTools.formatTitle("/town unclaim"));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town unclaim", "", TownySettings.getLangString("mayor_help_6")));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town unclaim", "[circle/rect] [radius]", TownySettings.getLangString("mayor_help_7")));
            player.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("mayor_sing"), "/town unclaim", "all", TownySettings.getLangString("mayor_help_8")));
        } else {
            try {
                if (TownyUniverse.isWarTime()) {
                    throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
                }
                Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                Town town = resident.getTown();
                if (!resident.isMayor() && !town.hasAssistant(resident)) {
                    throw new TownyException(TownySettings.getLangString("msg_not_mayor_ass"));
                }
                TownyWorld world = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
                if (split.length == 1 && split[0].equalsIgnoreCase("all")) {
                    new TownClaim(plugin, player, town, null, false, false, false).start();
                } else {
                    List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(town, new WorldCoord(world.getName(), Coord.parseCoord(plugin.getCache(player).getLastLocation())), split);
                    selection = AreaSelectionUtil.filterOwnedBlocks(town, selection);
                    new TownClaim(plugin, player, town, selection, false, false, false).start();
                    TownyMessaging.sendMsg((Object)player, String.format(TownySettings.getLangString("msg_abandoned_area"), Arrays.toString(selection.toArray(new WorldCoord[0]))));
                }
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
                return;
            }
        }
    }

    public static boolean isEdgeBlock(TownBlockOwner owner, List<WorldCoord> worldCoords) {
        for (WorldCoord worldCoord : worldCoords) {
            if (!TownCommand.isEdgeBlock(owner, worldCoord)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEdgeBlock(TownBlockOwner owner, WorldCoord worldCoord) {
        if (TownySettings.getDebug()) {
            System.out.print("[Towny] Debug: isEdgeBlock(" + worldCoord.toString() + ") = ");
        }
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[0] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = 1;
        nArrayArray[3] = nArray4;
        int[][] offset = nArrayArray;
        int i = 0;
        while (i < 4) {
            try {
                TownBlock edgeTownBlock = worldCoord.getTownyWorld().getTownBlock(new Coord(worldCoord.getX() + offset[i][0], worldCoord.getZ() + offset[i][1]));
                if (edgeTownBlock.isOwner(owner)) {
                    if (TownySettings.getDebug()) {
                        System.out.println("true");
                    }
                    return true;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            ++i;
        }
        if (TownySettings.getDebug()) {
            System.out.println("false");
        }
        return false;
    }

    public static void checkIfSelectionIsValid(TownBlockOwner owner, List<WorldCoord> selection, boolean attachedToEdge, double blockCost, boolean force) throws TownyException {
        if (force) {
            return;
        }
        Town town = (Town)owner;
        if (attachedToEdge && !TownCommand.isEdgeBlock(owner, selection) && !town.getTownBlocks().isEmpty()) {
            if (selection.size() == 0) {
                throw new TownyException(TownySettings.getLangString("msg_already_claimed_2"));
            }
            throw new TownyException(TownySettings.getLangString("msg_err_not_attached_edge"));
        }
        if (owner instanceof Town) {
            int available = TownySettings.getMaxTownBlocks(town) - town.getTownBlocks().size();
            TownyMessaging.sendDebugMsg("Claim Check Available: " + available);
            TownyMessaging.sendDebugMsg("Claim Selection Size: " + selection.size());
            if (available - selection.size() < 0) {
                throw new TownyException(TownySettings.getLangString("msg_err_not_enough_blocks"));
            }
        }
        try {
            double cost = blockCost * (double)selection.size();
            if (TownySettings.isUsingEconomy() && !owner.canPayFromHoldings(cost)) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_cant_afford_blocks"), selection.size(), TownyEconomyHandler.getFormattedBalance(cost)));
            }
        }
        catch (EconomyException e1) {
            throw new TownyException("Economy Error");
        }
    }

    private void townWithdraw(Player player, int amount) {
        try {
            if (!TownySettings.getTownBankAllowWithdrawls()) {
                throw new TownyException(TownySettings.getLangString("msg_err_withdraw_disabled"));
            }
            if (amount < 0) {
                throw new TownyException(TownySettings.getLangString("msg_err_negative_money"));
            }
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Town town = resident.getTown();
            town.withdrawFromBank(resident, amount);
            TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_xx_withdrew_xx"), resident.getName(), amount, "town"));
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
        catch (EconomyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
    }

    private void townDeposit(Player player, int amount) {
        try {
            Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
            Town town = resident.getTown();
            double bankcap = TownySettings.getTownBankCap();
            if (bankcap > 0.0 && (double)amount + town.getHoldingBalance() > bankcap) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_deposit_capped"), bankcap));
            }
            if (amount < 0) {
                throw new TownyException(TownySettings.getLangString("msg_err_negative_money"));
            }
            if (!resident.payTo(amount, town, "Town Deposit")) {
                throw new TownyException(TownySettings.getLangString("msg_insuf_funds"));
            }
            TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_xx_deposited_xx"), resident.getName(), amount, "town"));
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
        catch (EconomyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
    }
}

