/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.command.NationCommand;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.tasks.ResidentPurge;
import com.palmergames.bukkit.towny.tasks.TownClaim;
import com.palmergames.bukkit.towny.utils.AreaSelectionUtil;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.MemMgmt;
import com.palmergames.util.StringMgmt;
import com.palmergames.util.TimeTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class TownyAdminCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> ta_help;
    private static final List<String> ta_panel;
    private static final List<String> ta_unclaim;
    private boolean isConsole;
    private Player player;
    private CommandSender sender;

    static {
        ta_help = new ArrayList<String>();
        ta_panel = new ArrayList<String>();
        ta_unclaim = new ArrayList<String>();
        ta_help.add(ChatTools.formatTitle("/townyadmin"));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "", TownySettings.getLangString("admin_panel_1")));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "set [] .. []", "'/townyadmin set' " + TownySettings.getLangString("res_5")));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "unclaim [radius]", ""));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "town/nation", ""));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "givebonus [town/player] [num]", ""));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "toggle neutral/war/debug/devmode", ""));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "reload", TownySettings.getLangString("admin_panel_2")));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "reset", ""));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "backup", ""));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "newday", TownySettings.getLangString("admin_panel_3")));
        ta_help.add(ChatTools.formatCommand("", "/townyadmin", "purge [number of days]", ""));
        ta_unclaim.add(ChatTools.formatTitle("/townyadmin unclaim"));
        ta_unclaim.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin unclaim", "", TownySettings.getLangString("townyadmin_help_1")));
        ta_unclaim.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin unclaim", "[radius]", TownySettings.getLangString("townyadmin_help_2")));
    }

    public TownyAdminCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        this.sender = sender;
        if (sender instanceof Player) {
            this.player = (Player)sender;
            this.isConsole = false;
            System.out.println("[PLAYER_COMMAND] " + this.player.getName() + ": /" + commandLabel + " " + StringMgmt.join(args));
        } else {
            this.isConsole = true;
            this.player = null;
        }
        try {
            return this.parseTownyAdminCommand(args);
        }
        catch (TownyException e) {
            TownyMessaging.sendErrorMsg((Object)sender, e.getMessage());
            return true;
        }
    }

    private Object getSender() {
        if (this.isConsole) {
            return this.sender;
        }
        return this.player;
    }

    public boolean parseTownyAdminCommand(String[] split) throws TownyException {
        if (split.length == 0) {
            this.buildTAPanel();
            for (String line : ta_panel) {
                this.sender.sendMessage(line);
            }
        } else if (split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            for (String line : ta_help) {
                this.sender.sendMessage(line);
            }
        } else {
            if (!this.isConsole && !TownyUniverse.getPermissionSource().has(this.player, PermissionNodes.TOWNY_ADMIN_COMMAND.getNode(split[0].toLowerCase()))) {
                TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_err_admin_only"));
                return true;
            }
            if (split[0].equalsIgnoreCase("set")) {
                this.adminSet(StringMgmt.remFirstArg(split));
            } else if (split[0].equalsIgnoreCase("town")) {
                this.parseAdminTownCommand(StringMgmt.remFirstArg(split));
            } else if (split[0].equalsIgnoreCase("nation")) {
                this.parseAdminNationCommand(StringMgmt.remFirstArg(split));
            } else if (split[0].equalsIgnoreCase("toggle")) {
                this.parseToggleCommand(StringMgmt.remFirstArg(split));
            } else if (split[0].equalsIgnoreCase("givebonus")) {
                this.giveBonus(StringMgmt.remFirstArg(split));
            } else if (split[0].equalsIgnoreCase("reload")) {
                this.reloadTowny(false);
            } else if (split[0].equalsIgnoreCase("reset")) {
                this.reloadTowny(true);
            } else if (split[0].equalsIgnoreCase("backup")) {
                try {
                    TownyUniverse.getDataSource().backup();
                    TownyMessaging.sendMsg(this.getSender(), TownySettings.getLangString("mag_backup_success"));
                }
                catch (IOException e) {
                    TownyMessaging.sendErrorMsg(this.getSender(), "Error: " + e.getMessage());
                }
            } else if (split[0].equalsIgnoreCase("newday")) {
                TownyTimerHandler.newDay();
            } else if (split[0].equalsIgnoreCase("purge")) {
                this.purge(StringMgmt.remFirstArg(split));
            } else if (split[0].equalsIgnoreCase("unclaim")) {
                this.parseAdminUnclaimCommand(StringMgmt.remFirstArg(split));
            } else {
                TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_err_invalid_sub"));
                return false;
            }
        }
        return true;
    }

    private void giveBonus(String[] split) throws TownyException {
        try {
            Town town;
            if (split.length != 2) {
                throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_input"), "Eg: givebonus [town/player] [n]"));
            }
            try {
                town = TownyUniverse.getDataSource().getTown(split[0]);
            }
            catch (NotRegisteredException e) {
                town = TownyUniverse.getDataSource().getResident(split[0]).getTown();
            }
            try {
                town.setBonusBlocks(town.getBonusBlocks() + Integer.parseInt(split[1].trim()));
                TownyMessaging.sendMsg(this.getSender(), String.format(TownySettings.getLangString("msg_give_total"), town.getName(), split[1], town.getBonusBlocks()));
            }
            catch (NumberFormatException nfe) {
                throw new TownyException(TownySettings.getLangString("msg_error_must_be_int"));
            }
            TownyUniverse.getDataSource().saveTown(town);
        }
        catch (TownyException e) {
            throw new TownyException(e.getMessage());
        }
    }

    private void buildTAPanel() {
        ta_panel.clear();
        Runtime run = Runtime.getRuntime();
        ta_panel.add(ChatTools.formatTitle(TownySettings.getLangString("ta_panel_1")));
        ta_panel.add("\u00a73[\u00a7bTowny\u00a73] \u00a72" + TownySettings.getLangString("ta_panel_2") + "\u00a7a" + TownyUniverse.isWarTime() + "\u00a78" + " | " + "\u00a72" + TownySettings.getLangString("ta_panel_3") + (TownyTimerHandler.isHealthRegenRunning() ? "\u00a7aOn" : "\u00a7cOff") + "\u00a78" + " | " + "\u00a72" + TownySettings.getLangString("ta_panel_5") + (TownyTimerHandler.isDailyTimerRunning() ? "\u00a7aOn" : "\u00a7cOff"));
        ta_panel.add("\u00a73[\u00a7b" + TownySettings.getLangString("ta_panel_8") + "\u00a73" + "] " + "\u00a72" + TownySettings.getLangString("ta_panel_9") + "\u00a7a" + MemMgmt.getMemSize(run.totalMemory()) + "\u00a78" + " | " + "\u00a72" + TownySettings.getLangString("ta_panel_10") + "\u00a7a" + Thread.getAllStackTraces().keySet().size() + "\u00a78" + " | " + "\u00a72" + TownySettings.getLangString("ta_panel_11") + "\u00a7a" + TownyFormatter.getTime());
        ta_panel.add("\u00a7e" + MemMgmt.getMemoryBar(50, run));
    }

    public void parseAdminUnclaimCommand(String[] split) {
        if (split.length == 1 && split[0].equalsIgnoreCase("?")) {
            for (String line : ta_unclaim) {
                ((CommandSender)this.getSender()).sendMessage(line);
            }
        } else {
            if (this.isConsole) {
                this.sender.sendMessage("[Towny] InputError: This command was designed for use in game only.");
                return;
            }
            try {
                if (TownyUniverse.isWarTime()) {
                    throw new TownyException(TownySettings.getLangString("msg_war_cannot_do"));
                }
                List<WorldCoord> selection = AreaSelectionUtil.selectWorldCoordArea(null, new WorldCoord(this.player.getWorld().getName(), Coord.parseCoord((Entity)this.player)), split);
                new TownClaim(plugin, this.player, null, selection, false, false, true).start();
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)this.player, x.getMessage());
                return;
            }
        }
    }

    public void parseAdminTownCommand(String[] split) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            this.sender.sendMessage(ChatTools.formatTitle("/townyadmin town"));
            this.sender.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin town", "[town]", ""));
            this.sender.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin town", "[town] add/kick [] .. []", ""));
            this.sender.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin town", "[town] rename [newname]", ""));
            this.sender.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin town", "[town] delete", ""));
        } else {
            try {
                Town town = TownyUniverse.getDataSource().getTown(split[0]);
                if (split.length == 1) {
                    TownyMessaging.sendMessage(this.getSender(), TownyFormatter.getStatus(town));
                } else if (split[1].equalsIgnoreCase("add")) {
                    TownCommand.townAdd(this.sender, town, StringMgmt.remArgs(split, 2));
                } else if (split[1].equalsIgnoreCase("kick")) {
                    TownCommand.townKickResidents(this.getSender(), town.getMayor(), town, plugin.getTownyUniverse().getValidatedResidents(this.getSender(), StringMgmt.remArgs(split, 2)));
                } else if (split[1].equalsIgnoreCase("delete")) {
                    TownyUniverse.getDataSource().removeTown(town);
                } else if (split[1].equalsIgnoreCase("rename")) {
                    if (!NameValidation.isBlacklistName(split[2])) {
                        TownyUniverse.getDataSource().renameTown(town, split[2]);
                        TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_town_set_name"), this.getSender() instanceof Player ? this.player.getName() : "CONSOLE", town.getName()));
                    } else {
                        TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_invalid_name"));
                    }
                }
            }
            catch (NotRegisteredException e) {
                TownyMessaging.sendErrorMsg(this.getSender(), e.getMessage());
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg(this.getSender(), e.getMessage());
            }
        }
    }

    public void parseAdminNationCommand(String[] split) {
        if (split.length == 0 || split[0].equalsIgnoreCase("?")) {
            this.sender.sendMessage(ChatTools.formatTitle("/townyadmin nation"));
            this.sender.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin nation", "[nation]", ""));
            this.sender.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin nation", "[nation] add [] .. []", ""));
            this.sender.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin nation", "[nation] rename [newname]", ""));
            this.sender.sendMessage(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin nation", "[nation] delete", ""));
        } else {
            try {
                Nation nation = TownyUniverse.getDataSource().getNation(split[0]);
                if (split.length == 1) {
                    TownyMessaging.sendMessage(this.getSender(), TownyFormatter.getStatus(nation));
                } else if (split[1].equalsIgnoreCase("add")) {
                    NationCommand.nationAdd(nation, TownyUniverse.getDataSource().getTowns(StringMgmt.remArgs(split, 2)));
                } else if (split[1].equalsIgnoreCase("delete")) {
                    TownyUniverse.getDataSource().removeNation(nation);
                } else if (split[1].equalsIgnoreCase("rename")) {
                    if (!NameValidation.isBlacklistName(split[2])) {
                        TownyUniverse.getDataSource().renameNation(nation, split[2]);
                        TownyMessaging.sendNationMessage(nation, String.format(TownySettings.getLangString("msg_nation_set_name"), this.getSender() instanceof Player ? this.player.getName() : "CONSOLE", nation.getName()));
                    } else {
                        TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_invalid_name"));
                    }
                }
            }
            catch (NotRegisteredException e) {
                TownyMessaging.sendErrorMsg(this.getSender(), e.getMessage());
            }
            catch (AlreadyRegisteredException e) {
                TownyMessaging.sendErrorMsg(this.getSender(), e.getMessage());
            }
        }
    }

    public void adminSet(String[] split) {
        if (split.length == 0) {
            this.sender.sendMessage(ChatTools.formatTitle("/townyadmin set"));
            this.sender.sendMessage(ChatTools.formatCommand("", "/townyadmin set", "mayor [town] " + TownySettings.getLangString("town_help_2"), ""));
            this.sender.sendMessage(ChatTools.formatCommand("", "/townyadmin set", "mayor [town] npc", ""));
        } else if (split[0].equalsIgnoreCase("mayor")) {
            if (split.length < 3) {
                this.sender.sendMessage(ChatTools.formatTitle("/townyadmin set mayor"));
                this.sender.sendMessage(ChatTools.formatCommand("Eg", "/townyadmin set mayor", "[town] " + TownySettings.getLangString("town_help_2"), ""));
                this.sender.sendMessage(ChatTools.formatCommand("Eg", "/townyadmin set mayor", "[town] npc", ""));
            } else {
                try {
                    Resident newMayor = null;
                    Town town = TownyUniverse.getDataSource().getTown(split[1]);
                    if (split[2].equalsIgnoreCase("npc")) {
                        String name = this.nextNpcName();
                        TownyUniverse.getDataSource().newResident(name);
                        newMayor = TownyUniverse.getDataSource().getResident(name);
                        newMayor.setRegistered(System.currentTimeMillis());
                        newMayor.setLastOnline(0L);
                        newMayor.setNPC(true);
                        TownyUniverse.getDataSource().saveResident(newMayor);
                        TownyUniverse.getDataSource().saveResidentList();
                        town.setHasUpkeep(false);
                    } else {
                        newMayor = TownyUniverse.getDataSource().getResident(split[2]);
                        town.setHasUpkeep(true);
                    }
                    if (!town.hasResident(newMayor)) {
                        TownCommand.townAddResident(town, newMayor);
                    }
                    Resident oldMayor = town.getMayor();
                    town.setMayor(newMayor);
                    if (oldMayor.isNPC()) {
                        try {
                            town.removeResident(oldMayor);
                            TownyUniverse.getDataSource().removeResident(oldMayor);
                            TownyUniverse.getDataSource().removeResidentList(oldMayor);
                        }
                        catch (EmptyTownException e) {
                            e.printStackTrace();
                        }
                    }
                    TownyUniverse.getDataSource().saveTown(town);
                    String[] msg = TownySettings.getNewMayorMsg(newMayor.getName());
                    TownyMessaging.sendTownMessage(town, msg);
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg(this.getSender(), e.getMessage());
                }
            }
        } else {
            TownyMessaging.sendErrorMsg(this.getSender(), String.format(TownySettings.getLangString("msg_err_invalid_property"), "administrative"));
            return;
        }
    }

    public String nextNpcName() throws TownyException {
        int i = 0;
        do {
            String name = String.valueOf(TownySettings.getNPCPrefix()) + ++i;
            if (TownyUniverse.getDataSource().hasResident(name)) continue;
            return name;
        } while (i <= 100000);
        throw new TownyException(TownySettings.getLangString("msg_err_too_many_npc"));
    }

    public void reloadTowny(Boolean reset) {
        if (reset.booleanValue()) {
            TownyUniverse.getDataSource().deleteFile(plugin.getConfigPath());
        }
        TownyLogger.shutDown();
        plugin.load();
        TownyMessaging.sendMsg(this.sender, TownySettings.getLangString("msg_reloaded"));
    }

    public void purge(String[] split) {
        if (split.length == 0) {
            this.player.sendMessage(ChatTools.formatTitle("/townyadmin purge"));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin purge", "[number of days]", ""));
            this.player.sendMessage(ChatTools.formatCommand("", "", "Removes offline residents not seen for this duration.", ""));
            return;
        }
        int days = 1;
        try {
            days = Integer.parseInt(split[0]);
        }
        catch (NumberFormatException e) {
            TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_error_must_be_int"));
            return;
        }
        new ResidentPurge(plugin, this.sender, TimeTools.getMillis(String.valueOf(days) + "d")).start();
    }

    public void parseToggleCommand(String[] split) throws TownyException {
        if (split.length == 0) {
            this.player.sendMessage(ChatTools.formatTitle("/townyadmin toggle"));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin toggle", "war", ""));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin toggle", "neutral", ""));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin toggle", "devmode", ""));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin toggle", "debug", ""));
            this.player.sendMessage(ChatTools.formatCommand("", "/townyadmin toggle", "townwithdraw/nationwithdraw", ""));
            return;
        }
        if (split[0].equalsIgnoreCase("war")) {
            boolean choice = TownyUniverse.isWarTime();
            if (!choice) {
                plugin.getTownyUniverse().startWarEvent();
                TownyMessaging.sendMsg(this.getSender(), TownySettings.getLangString("msg_war_started"));
            } else {
                plugin.getTownyUniverse().endWarEvent();
                TownyMessaging.sendMsg(this.getSender(), TownySettings.getLangString("msg_war_ended"));
            }
        } else if (split[0].equalsIgnoreCase("neutral")) {
            try {
                boolean choice = !TownySettings.isDeclaringNeutral();
                TownySettings.setDeclaringNeutral(choice);
                TownyMessaging.sendMsg(this.getSender(), String.format(TownySettings.getLangString("msg_nation_allow_neutral"), choice ? "Enabled" : "Disabled"));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_err_invalid_choice"));
                return;
            }
        } else if (split[0].equalsIgnoreCase("devmode")) {
            try {
                boolean choice = !TownySettings.isDevMode();
                TownySettings.setDevMode(choice);
                TownyMessaging.sendMsg(this.getSender(), "Dev Mode " + (choice ? "\u00a72Enabled" : "\u00a74Disabled"));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_err_invalid_choice"));
            }
        } else if (split[0].equalsIgnoreCase("debug")) {
            try {
                boolean choice = !TownySettings.getDebug();
                TownySettings.setDebug(choice);
                TownyMessaging.sendMsg(this.getSender(), "Debug Mode " + (choice ? "\u00a72Enabled" : "\u00a74Disabled"));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_err_invalid_choice"));
            }
        } else if (split[0].equalsIgnoreCase("townwithdraw")) {
            try {
                boolean choice = !TownySettings.getTownBankAllowWithdrawls();
                TownySettings.SetTownBankAllowWithdrawls(choice);
                TownyMessaging.sendMsg(this.getSender(), "Town Withdrawls " + (choice ? "\u00a72Enabled" : "\u00a74Disabled"));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_err_invalid_choice"));
            }
        } else if (split[0].equalsIgnoreCase("nationwithdraw")) {
            try {
                boolean choice = !TownySettings.geNationBankAllowWithdrawls();
                TownySettings.SetNationBankAllowWithdrawls(choice);
                TownyMessaging.sendMsg(this.getSender(), "Nation Withdrawls " + (choice ? "\u00a72Enabled" : "\u00a74Disabled"));
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_err_invalid_choice"));
            }
        } else {
            TownyMessaging.sendErrorMsg(this.getSender(), TownySettings.getLangString("msg_err_invalid_choice"));
        }
    }
}

