/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.command;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAsciiMap;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.KeyValue;
import com.palmergames.util.KeyValueTable;
import com.palmergames.util.StringMgmt;
import com.palmergames.util.TimeMgmt;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TownyCommand
implements CommandExecutor {
    private static Towny plugin;
    private static final List<String> towny_general_help;
    private static final List<String> towny_help;
    private static final List<String> towny_top;
    private static final List<String> towny_war;
    private static String towny_version;

    static {
        towny_general_help = new ArrayList<String>();
        towny_help = new ArrayList<String>();
        towny_top = new ArrayList<String>();
        towny_war = new ArrayList<String>();
        towny_general_help.add(ChatTools.formatTitle(TownySettings.getLangString("help_0")));
        towny_general_help.add(TownySettings.getLangString("help_1"));
        towny_general_help.add(String.valueOf(ChatTools.formatCommand("", "/resident", "?", "")) + ", " + ChatTools.formatCommand("", "/town", "?", "") + ", " + ChatTools.formatCommand("", "/nation", "?", "") + ", " + ChatTools.formatCommand("", "/plot", "?", "") + ", " + ChatTools.formatCommand("", "/towny", "?", ""));
        towny_general_help.add(String.valueOf(ChatTools.formatCommand("", "/tc", "[msg]", TownySettings.getLangString("help_2"))) + ", " + ChatTools.formatCommand("", "/nc", "[msg]", TownySettings.getLangString("help_3")).trim());
        towny_general_help.add(ChatTools.formatCommand(TownySettings.getLangString("admin_sing"), "/townyadmin", "?", ""));
        towny_help.add(ChatTools.formatTitle("/towny"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "", "General help for Towny"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "map", "Displays a map of the nearby townblocks"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "prices", "Display the prices used with Economy"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "top", "Display highscores"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "time", "Display time until a new day"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "universe", "Displays stats"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "v", "Displays the version of Towny"));
        towny_help.add(ChatTools.formatCommand("", "/towny", "war", "'/towny war' for more info"));
    }

    public TownyCommand(Towny instance) {
        plugin = instance;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        block5: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    towny_version = "\u00a72Towny version: \u00a7a" + plugin.getVersion();
                                    towny_war.add(ChatTools.formatTitle("/towny war"));
                                    towny_war.add(ChatTools.formatCommand("", "/towny war", "stats", ""));
                                    towny_war.add(ChatTools.formatCommand("", "/towny war", "scores", ""));
                                    if (!(sender instanceof Player)) break block4;
                                    Player player = (Player)sender;
                                    System.out.println("[PLAYER_COMMAND] " + player.getName() + ": /" + commandLabel + " " + StringMgmt.join(args));
                                    this.parseTownyCommand(player, args);
                                    break block5;
                                }
                                if (args.length != 0) break block6;
                                for (String line : towny_general_help) {
                                    sender.sendMessage(Colors.strip(line));
                                }
                                break block5;
                            }
                            if (!args[0].equalsIgnoreCase("tree")) break block7;
                            plugin.getTownyUniverse().sendUniverseTree(sender);
                            break block5;
                        }
                        if (!args[0].equalsIgnoreCase("time")) break block8;
                        TownyMessaging.sendMsg("Time until a New Day: " + TimeMgmt.formatCountdownTime(TownyTimerHandler.townyTime()));
                        break block5;
                    }
                    if (!args[0].equalsIgnoreCase("version") && !args[0].equalsIgnoreCase("v")) break block9;
                    sender.sendMessage(Colors.strip(towny_version));
                    break block5;
                }
                if (!args[0].equalsIgnoreCase("war")) break block10;
                boolean war = this.TownyWar(StringMgmt.remFirstArg(args));
                for (String line : towny_war) {
                    sender.sendMessage(Colors.strip(line));
                }
                if (!war) {
                    sender.sendMessage("The world isn't currently at war.");
                }
                towny_war.clear();
                break block5;
            }
            if (!args[0].equalsIgnoreCase("universe")) break block5;
            for (String line : this.getUniverseStats()) {
                sender.sendMessage(Colors.strip(line));
            }
        }
        return true;
    }

    private void parseTownyCommand(Player player, String[] split) {
        if (split.length == 0) {
            for (String line : towny_general_help) {
                player.sendMessage(line);
            }
        } else if (split[0].equalsIgnoreCase("?") || split[0].equalsIgnoreCase("help")) {
            for (String line : towny_help) {
                player.sendMessage(Colors.strip(line));
            }
        } else if (split[0].equalsIgnoreCase("map")) {
            if (split.length > 1 && split[1].equalsIgnoreCase("big")) {
                TownyAsciiMap.generateAndSend(plugin, player, 18);
            } else {
                TownyCommand.showMap(player);
            }
        } else if (split[0].equalsIgnoreCase("prices")) {
            Town town = null;
            if (split.length > 1) {
                try {
                    town = TownyUniverse.getDataSource().getTown(split[1]);
                }
                catch (NotRegisteredException x) {
                    this.sendErrorMsg((CommandSender)player, x.getMessage());
                    return;
                }
            }
            if (split.length == 1) {
                try {
                    Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                    town = resident.getTown();
                }
                catch (NotRegisteredException resident) {
                    // empty catch block
                }
            }
            for (String line : this.getTownyPrices(town)) {
                player.sendMessage(line);
            }
        } else if (split[0].equalsIgnoreCase("top")) {
            this.TopCommand(player, StringMgmt.remFirstArg(split));
        } else if (split[0].equalsIgnoreCase("tree")) {
            this.consoleUseOnly(player);
        } else if (split[0].equalsIgnoreCase("time")) {
            TownyMessaging.sendMsg((Object)player, "Time until a New Day: " + TimeMgmt.formatCountdownTime(TownyTimerHandler.townyTime()));
        } else if (split[0].equalsIgnoreCase("universe")) {
            for (String line : this.getUniverseStats()) {
                player.sendMessage(line);
            }
        } else if (split[0].equalsIgnoreCase("version") || split[0].equalsIgnoreCase("v")) {
            player.sendMessage(towny_version);
        } else if (split[0].equalsIgnoreCase("war")) {
            boolean war = this.TownyWar(StringMgmt.remFirstArg(split));
            for (String line : towny_war) {
                player.sendMessage(Colors.strip(line));
            }
            if (!war) {
                this.sendErrorMsg((CommandSender)player, "The world isn't currently at war.");
            }
            towny_war.clear();
        } else if (split[0].equalsIgnoreCase("spy")) {
            if (plugin.isPermissions() && TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_CHAT_SPY.getNode())) {
                if (plugin.hasPlayerMode(player, "spy")) {
                    plugin.removePlayerMode(player);
                } else {
                    plugin.setPlayerMode(player, split, true);
                }
            } else {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_command_disable"));
            }
        } else {
            this.sendErrorMsg((CommandSender)player, "Invalid sub command.");
        }
    }

    private boolean TownyWar(String[] args) {
        if (TownyUniverse.isWarTime() && args.length > 0) {
            towny_war.clear();
            if (args[0].equalsIgnoreCase("stats")) {
                towny_war.addAll(plugin.getTownyUniverse().getWarEvent().getStats());
            } else if (args[0].equalsIgnoreCase("scores")) {
                towny_war.addAll(plugin.getTownyUniverse().getWarEvent().getScores(-1));
            }
        }
        return TownyUniverse.isWarTime();
    }

    private void TopCommand(Player player, String[] args) {
        block28: {
            ArrayList<TownyEconomyObject> list;
            if (!TownyUniverse.getPermissionSource().isTownyAdmin(player) && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.TOWNY_TOP.getNode())) {
                this.sendErrorMsg((CommandSender)player, TownySettings.getLangString("msg_err_command_disable"));
                return;
            }
            if (args.length == 0 || args[0].equalsIgnoreCase("?")) {
                towny_top.add(ChatTools.formatTitle("/towny top"));
                towny_top.add(ChatTools.formatCommand("", "/towny top", "money [all/resident/town/nation]", ""));
                towny_top.add(ChatTools.formatCommand("", "/towny top", "residents [all/town/nation]", ""));
                towny_top.add(ChatTools.formatCommand("", "/towny top", "land [all/resident/town]", ""));
            } else if (args[0].equalsIgnoreCase("money")) {
                try {
                    if (args.length == 1 || args[1].equalsIgnoreCase("all")) {
                        list = new ArrayList<Resident>(TownyUniverse.getDataSource().getResidents());
                        list.addAll(TownyUniverse.getDataSource().getTowns());
                        list.addAll(TownyUniverse.getDataSource().getNations());
                        towny_top.add(ChatTools.formatTitle("Top Bank Accounts"));
                        towny_top.addAll(this.getTopBankBalance(list, 10));
                        break block28;
                    }
                    if (args[1].equalsIgnoreCase("resident")) {
                        towny_top.add(ChatTools.formatTitle("Top Resident Bank Accounts"));
                        towny_top.addAll(this.getTopBankBalance(new ArrayList<TownyEconomyObject>(TownyUniverse.getDataSource().getResidents()), 10));
                        break block28;
                    }
                    if (args[1].equalsIgnoreCase("town")) {
                        towny_top.add(ChatTools.formatTitle("Top Town Bank Accounts"));
                        towny_top.addAll(this.getTopBankBalance(new ArrayList<TownyEconomyObject>(TownyUniverse.getDataSource().getTowns()), 10));
                        break block28;
                    }
                    if (args[1].equalsIgnoreCase("nation")) {
                        towny_top.add(ChatTools.formatTitle("Top Nation Bank Accounts"));
                        towny_top.addAll(this.getTopBankBalance(new ArrayList<TownyEconomyObject>(TownyUniverse.getDataSource().getNations()), 10));
                        break block28;
                    }
                    this.sendErrorMsg((CommandSender)player, "Invalid sub command.");
                }
                catch (EconomyException e) {
                    this.sendErrorMsg((CommandSender)player, "Economy error.");
                    this.sendErrorMsg((CommandSender)player, e.getError());
                }
            } else if (args[0].equalsIgnoreCase("residents")) {
                if (args.length == 1 || args[1].equalsIgnoreCase("all")) {
                    list = new ArrayList<Town>(TownyUniverse.getDataSource().getTowns());
                    list.addAll(TownyUniverse.getDataSource().getNations());
                    towny_top.add(ChatTools.formatTitle("Most Residents"));
                    towny_top.addAll(this.getMostResidents(list, 10));
                } else if (args[1].equalsIgnoreCase("town")) {
                    towny_top.add(ChatTools.formatTitle("Most Residents in a Town"));
                    towny_top.addAll(this.getMostResidents(new ArrayList<ResidentList>(TownyUniverse.getDataSource().getTowns()), 10));
                } else if (args[1].equalsIgnoreCase("nation")) {
                    towny_top.add(ChatTools.formatTitle("Most Residents in a Nation"));
                    towny_top.addAll(this.getMostResidents(new ArrayList<ResidentList>(TownyUniverse.getDataSource().getNations()), 10));
                } else {
                    this.sendErrorMsg((CommandSender)player, "Invalid sub command.");
                }
            } else if (args[0].equalsIgnoreCase("land")) {
                if (args.length == 1 || args[1].equalsIgnoreCase("all")) {
                    list = new ArrayList<Resident>(TownyUniverse.getDataSource().getResidents());
                    list.addAll(TownyUniverse.getDataSource().getTowns());
                    towny_top.add(ChatTools.formatTitle("Most Land Owned"));
                    towny_top.addAll(this.getMostLand(list, 10));
                } else if (args[1].equalsIgnoreCase("resident")) {
                    towny_top.add(ChatTools.formatTitle("Most Land Owned by Resident"));
                    towny_top.addAll(this.getMostLand(new ArrayList<TownBlockOwner>(TownyUniverse.getDataSource().getResidents()), 10));
                } else if (args[1].equalsIgnoreCase("town")) {
                    towny_top.add(ChatTools.formatTitle("Most Land Owned by Town"));
                    towny_top.addAll(this.getMostLand(new ArrayList<TownBlockOwner>(TownyUniverse.getDataSource().getTowns()), 10));
                } else {
                    this.sendErrorMsg((CommandSender)player, "Invalid sub command.");
                }
            } else {
                this.sendErrorMsg((CommandSender)player, "Invalid sub command.");
            }
        }
        for (String line : towny_top) {
            player.sendMessage(line);
        }
        towny_top.clear();
    }

    public List<String> getUniverseStats() {
        ArrayList<String> output = new ArrayList<String>();
        output.add("\u00a70-\u00a74###\u00a70---\u00a74###\u00a70-");
        output.add("\u00a74#\u00a7c###\u00a74#\u00a70-\u00a74#\u00a7c###\u00a74#\u00a70   \u00a76[\u00a7eTowny " + plugin.getVersion() + "\u00a76]");
        output.add("\u00a74#\u00a7c####\u00a74#\u00a7c####\u00a74#   \u00a73By: \u00a7bChris H (Shade)/Llmdl/ElgarL");
        output.add("\u00a70-\u00a74#\u00a7c#######\u00a74#\u00a70-");
        output.add("\u00a70--\u00a74##\u00a7c###\u00a74##\u00a70-- \u00a73Residents: \u00a7b" + Integer.toString(TownyUniverse.getDataSource().getResidents().size()) + "\u00a78" + " | " + "\u00a73Towns: \u00a7b" + Integer.toString(TownyUniverse.getDataSource().getTowns().size()) + "\u00a78" + " | " + "\u00a73Nations: \u00a7b" + Integer.toString(TownyUniverse.getDataSource().getNations().size()));
        output.add("\u00a70----\u00a74#\u00a7c#\u00a74#\u00a70---- \u00a73Worlds: \u00a7b" + Integer.toString(TownyUniverse.getDataSource().getWorlds().size()) + "\u00a78" + " | " + "\u00a73TownBlocks: \u00a7b" + Integer.toString(TownyUniverse.getDataSource().getAllTownBlocks().size()));
        output.add("\u00a70-----\u00a74#\u00a70----- ");
        return output;
    }

    public static void showMap(Player player) {
        TownyAsciiMap.generateAndSend(plugin, player, 7);
    }

    public List<String> getTownyPrices(Town town) {
        ArrayList<String> output = new ArrayList<String>();
        Nation nation = null;
        if (town != null && town.hasNation()) {
            try {
                nation = town.getNation();
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
        output.add(ChatTools.formatTitle("Prices"));
        output.add("\u00a7e[New] \u00a72Town: \u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getNewTownPrice()) + "\u00a78" + " | " + "\u00a72" + "Nation: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getNewNationPrice()));
        output.add("\u00a7e[Upkeep] \u00a72Town: \u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getTownUpkeepCost(town)) + "\u00a78" + " | " + "\u00a72" + "Nation: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getNationUpkeepCost(nation)));
        output.add("\u00a78Town upkeep is based on \u00a7a the " + (TownySettings.isUpkeepByPlot() ? " number of plots" : " town level (num residents)."));
        if (town != null) {
            output.add("\u00a7eTown [" + TownyFormatter.getFormattedName(town) + "]");
            output.add("\u00a7c    [Price] \u00a72Plot: \u00a7a" + Double.toString(town.getPlotPrice()) + "\u00a78" + " | " + "\u00a72" + "Outpost: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getOutpostCost()));
            output.add("\u00a7c    [Upkeep] \u00a72Resident: \u00a7a" + Double.toString(town.getTaxes()) + "\u00a78" + " | " + "\u00a72" + "Plot: " + "\u00a7a" + Double.toString(town.getPlotTax()));
            if (nation != null) {
                output.add("\u00a7eNation [" + TownyFormatter.getFormattedName(nation) + "]");
                output.add("\u00a7c    [Upkeep] \u00a72Town: \u00a7a" + Double.toString(nation.getTaxes()) + "\u00a78" + " | " + "\u00a72" + "Neutrality: " + "\u00a7a" + TownyEconomyHandler.getFormattedBalance(TownySettings.getNationNeutralityCost()));
            }
        }
        return output;
    }

    public List<String> getTopBankBalance(List<TownyEconomyObject> list, int maxListing) throws EconomyException {
        ArrayList<String> output = new ArrayList<String>();
        KeyValueTable<TownyEconomyObject, Double> kvTable = new KeyValueTable<TownyEconomyObject, Double>();
        for (TownyEconomyObject obj : list) {
            kvTable.put(obj, obj.getHoldingBalance());
        }
        kvTable.sortByValue();
        kvTable.revese();
        int n = 0;
        for (KeyValue kv : kvTable.getKeyValues()) {
            if (maxListing != -1 && ++n > maxListing) break;
            TownyEconomyObject town = (TownyEconomyObject)kv.key;
            output.add(String.format("\u00a77%-20s \u00a76|\u00a73 %s", TownyFormatter.getFormattedName(town), TownyEconomyHandler.getFormattedBalance((Double)kv.value)));
        }
        return output;
    }

    public List<String> getMostResidents(List<ResidentList> list, int maxListing) {
        ArrayList<String> output = new ArrayList<String>();
        KeyValueTable<ResidentList, Integer> kvTable = new KeyValueTable<ResidentList, Integer>();
        for (ResidentList obj : list) {
            kvTable.put(obj, obj.getResidents().size());
        }
        kvTable.sortByValue();
        kvTable.revese();
        int n = 0;
        for (KeyValue kv : kvTable.getKeyValues()) {
            if (maxListing != -1 && ++n > maxListing) break;
            ResidentList residentList = (ResidentList)kv.key;
            output.add(String.format("\u00a73%30s \u00a76|\u00a77 %10d", TownyFormatter.getFormattedName((TownyObject)((Object)residentList)), (Integer)kv.value));
        }
        return output;
    }

    public List<String> getMostLand(List<TownBlockOwner> list, int maxListing) {
        ArrayList<String> output = new ArrayList<String>();
        KeyValueTable<TownBlockOwner, Integer> kvTable = new KeyValueTable<TownBlockOwner, Integer>();
        for (TownBlockOwner obj : list) {
            kvTable.put(obj, obj.getTownBlocks().size());
        }
        kvTable.sortByValue();
        kvTable.revese();
        int n = 0;
        for (KeyValue kv : kvTable.getKeyValues()) {
            if (maxListing != -1 && ++n > maxListing) break;
            TownBlockOwner town = (TownBlockOwner)kv.key;
            output.add(String.format("\u00a73%30s \u00a76|\u00a77 %10d", TownyFormatter.getFormattedName(town), (Integer)kv.value));
        }
        return output;
    }

    public void consoleUseOnly(Player player) {
        TownyMessaging.sendErrorMsg((Object)player, "This command was designed for use in the console only.");
    }

    public void inGameUseOnly(CommandSender sender) {
        sender.sendMessage("[Towny] InputError: This command was designed for use in game only.");
    }

    public boolean sendErrorMsg(CommandSender sender, String msg) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            TownyMessaging.sendErrorMsg((Object)player, msg);
        } else {
            sender.sendMessage("[Towny] ConsoleError: " + msg);
        }
        return false;
    }
}

