/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.db.TownyDataSource;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObservableType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.war.eventwar.WarSpoils;
import com.palmergames.bukkit.util.NameValidation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.naming.InvalidNameException;
import org.bukkit.entity.Player;

public abstract class TownyDatabaseHandler
extends TownyDataSource {
    @Override
    public boolean hasResident(String name) {
        try {
            return this.universe.getResidentMap().containsKey(NameValidation.checkAndFilterPlayerName(name).toLowerCase());
        }
        catch (InvalidNameException e) {
            return false;
        }
    }

    @Override
    public boolean hasTown(String name) {
        return this.universe.getTownsMap().containsKey(name.toLowerCase());
    }

    @Override
    public boolean hasNation(String name) {
        return this.universe.getNationsMap().containsKey(name.toLowerCase());
    }

    @Override
    public List<Resident> getResidents(Player player, String[] names) {
        ArrayList<Resident> invited = new ArrayList<Resident>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                Resident target = this.getResident(name);
                invited.add(target);
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
            }
            ++n2;
        }
        return invited;
    }

    @Override
    public List<Resident> getResidents(String[] names) {
        ArrayList<Resident> matches = new ArrayList<Resident>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                matches.add(this.getResident(name));
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            ++n2;
        }
        return matches;
    }

    @Override
    public List<Resident> getResidents() {
        return new ArrayList<Resident>(this.universe.getResidentMap().values());
    }

    @Override
    public Resident getResident(String name) throws NotRegisteredException {
        try {
            name = NameValidation.checkAndFilterPlayerName(name).toLowerCase();
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        if (!this.hasResident(name)) {
            throw new NotRegisteredException(String.format("The resident '%s' is not registered.", name));
        }
        return this.universe.getResidentMap().get(name);
    }

    @Override
    public List<Town> getTowns(String[] names) {
        ArrayList<Town> matches = new ArrayList<Town>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                matches.add(this.getTown(name));
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            ++n2;
        }
        return matches;
    }

    @Override
    public List<Town> getTowns() {
        return new ArrayList<Town>(this.universe.getTownsMap().values());
    }

    @Override
    public Town getTown(String name) throws NotRegisteredException {
        try {
            name = NameValidation.checkAndFilterName(name).toLowerCase();
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        if (!this.hasTown(name)) {
            throw new NotRegisteredException(String.format("The town '%s' is not registered.", name));
        }
        return this.universe.getTownsMap().get(name);
    }

    @Override
    public List<Nation> getNations(String[] names) {
        ArrayList<Nation> matches = new ArrayList<Nation>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                matches.add(this.getNation(name));
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            ++n2;
        }
        return matches;
    }

    @Override
    public List<Nation> getNations() {
        return new ArrayList<Nation>(this.universe.getNationsMap().values());
    }

    @Override
    public Nation getNation(String name) throws NotRegisteredException {
        try {
            name = NameValidation.checkAndFilterName(name).toLowerCase();
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        if (!this.hasNation(name)) {
            throw new NotRegisteredException(String.format("The nation '%s' is not registered.", name));
        }
        return this.universe.getNationsMap().get(name.toLowerCase());
    }

    @Override
    public TownyWorld getWorld(String name) throws NotRegisteredException {
        TownyWorld world = this.universe.getWorldMap().get(name.toLowerCase());
        if (world == null) {
            throw new NotRegisteredException("World not registered!");
        }
        return world;
    }

    @Override
    public List<TownyWorld> getWorlds() {
        return new ArrayList<TownyWorld>(this.universe.getWorldMap().values());
    }

    @Override
    public TownyWorld getTownWorld(String townName) {
        for (TownyWorld world : this.universe.getWorldMap().values()) {
            if (!world.hasTown(townName)) continue;
            return world;
        }
        return null;
    }

    @Override
    public void removeResident(Resident resident) {
        Town town = null;
        if (resident.hasTown()) {
            try {
                town = resident.getTown();
            }
            catch (NotRegisteredException e1) {
                e1.printStackTrace();
            }
        }
        try {
            if (town != null) {
                town.removeResident(resident);
                this.saveTown(town);
            }
            resident.clear();
        }
        catch (EmptyTownException e) {
            this.removeTown(town);
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
        }
        this.universe.setChangedNotify(TownyObservableType.REMOVE_RESIDENT);
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) {
        PlotBlockData plotData;
        Resident resident = null;
        Town town = null;
        try {
            resident = townBlock.getResident();
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        try {
            town = townBlock.getTown();
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        TownyWorld world = townBlock.getWorld();
        world.removeTownBlock(townBlock);
        this.saveWorld(world);
        this.deleteTownBlock(townBlock);
        if (resident != null) {
            this.saveResident(resident);
        }
        if (town != null) {
            this.saveTown(town);
        }
        if (townBlock.getWorld().isUsingPlotManagementDelete()) {
            TownyRegenAPI.addDeleteTownBlockIdQueue(townBlock.getWorldCoord());
        }
        if (townBlock.getWorld().isUsingPlotManagementRevert() && (plotData = TownyRegenAPI.getPlotChunkSnapshot(townBlock)) != null && !plotData.getBlockList().isEmpty()) {
            TownyRegenAPI.addPlotChunk(plotData, true);
        }
        this.universe.setChangedNotify(TownyObservableType.REMOVE_TOWN_BLOCK);
    }

    @Override
    public void removeTownBlocks(Town town) {
        for (TownBlock townBlock : new ArrayList<TownBlock>(town.getTownBlocks())) {
            this.removeTownBlock(townBlock);
        }
    }

    @Override
    public List<TownBlock> getAllTownBlocks() {
        ArrayList<TownBlock> townBlocks = new ArrayList<TownBlock>();
        for (TownyWorld world : this.getWorlds()) {
            townBlocks.addAll(world.getTownBlocks());
        }
        return townBlocks;
    }

    @Override
    public void newResident(String name) throws AlreadyRegisteredException, NotRegisteredException {
        String filteredName;
        try {
            filteredName = NameValidation.checkAndFilterPlayerName(name);
        }
        catch (InvalidNameException e) {
            throw new NotRegisteredException(e.getMessage());
        }
        if (this.universe.getResidentMap().containsKey(filteredName.toLowerCase())) {
            throw new AlreadyRegisteredException("A resident with the name " + filteredName + " is already in use.");
        }
        this.universe.getResidentMap().put(filteredName.toLowerCase(), new Resident(filteredName));
        this.universe.setChangedNotify(TownyObservableType.NEW_RESIDENT);
    }

    @Override
    public void newTown(String name) throws AlreadyRegisteredException, NotRegisteredException {
        String filteredName;
        try {
            filteredName = NameValidation.checkAndFilterName(name);
        }
        catch (InvalidNameException e) {
            throw new NotRegisteredException(e.getMessage());
        }
        if (this.universe.getTownsMap().containsKey(filteredName.toLowerCase())) {
            throw new AlreadyRegisteredException("The town " + filteredName + " is already in use.");
        }
        this.universe.getTownsMap().put(filteredName.toLowerCase(), new Town(filteredName));
        this.universe.setChangedNotify(TownyObservableType.NEW_TOWN);
    }

    @Override
    public void newNation(String name) throws AlreadyRegisteredException, NotRegisteredException {
        String filteredName;
        try {
            filteredName = NameValidation.checkAndFilterName(name);
        }
        catch (InvalidNameException e) {
            throw new NotRegisteredException(e.getMessage());
        }
        if (this.universe.getNationsMap().containsKey(filteredName.toLowerCase())) {
            throw new AlreadyRegisteredException("The nation " + filteredName + " is already in use.");
        }
        this.universe.getNationsMap().put(filteredName.toLowerCase(), new Nation(filteredName));
        this.universe.setChangedNotify(TownyObservableType.NEW_NATION);
    }

    @Override
    public void newWorld(String name) throws AlreadyRegisteredException, NotRegisteredException {
        String filteredName = name;
        if (this.universe.getWorldMap().containsKey(filteredName.toLowerCase())) {
            throw new AlreadyRegisteredException("The world " + filteredName + " is already in use.");
        }
        this.universe.getWorldMap().put(filteredName.toLowerCase(), new TownyWorld(filteredName));
        this.universe.setChangedNotify(TownyObservableType.NEW_WORLD);
    }

    @Override
    public void removeResidentList(Resident resident) {
        String name = resident.getName();
        ArrayList<Resident> toSave = new ArrayList<Resident>();
        for (Resident toCheck : new ArrayList<Resident>(this.universe.getResidentMap().values())) {
            TownyMessaging.sendDebugMsg("Checking friends of: " + toCheck.getName());
            if (!toCheck.hasFriend(resident)) continue;
            try {
                TownyMessaging.sendDebugMsg("       - Removing Friend: " + resident.getName());
                toCheck.removeFriend(resident);
                toSave.add(toCheck);
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
        for (Resident toCheck : toSave) {
            this.saveResident(toCheck);
        }
        try {
            resident.clear();
        }
        catch (EmptyTownException ex) {
            this.removeTown(ex.getTown());
        }
        this.deleteResident(resident);
        this.universe.getResidentMap().remove(name.toLowerCase());
        if (TownySettings.isUsingEconomy() && TownySettings.isDeleteEcoAccount()) {
            resident.removeAccount();
        }
        this.plugin.deleteCache(name);
        this.saveResidentList();
    }

    @Override
    public void removeTown(Town town) {
        this.removeTownBlocks(town);
        ArrayList<Resident> toSave = new ArrayList<Resident>(town.getResidents());
        TownyWorld townyWorld = town.getWorld();
        try {
            if (town.hasNation()) {
                Nation nation = town.getNation();
                nation.removeTown(town);
                this.saveNation(nation);
            }
            town.clear();
        }
        catch (EmptyNationException e) {
            this.removeNation(e.getNation());
            TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_del_nation"), e.getNation()));
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
        }
        for (Resident resident : toSave) {
            this.removeResident(resident);
            this.saveResident(resident);
        }
        if (TownyEconomyHandler.isActive()) {
            try {
                town.payTo(town.getHoldingBalance(), new WarSpoils(), "Remove Town");
                town.removeAccount();
            }
            catch (EconomyException economyException) {
                // empty catch block
            }
        }
        this.universe.getTownsMap().remove(town.getName().toLowerCase());
        this.plugin.resetCache();
        this.deleteTown(town);
        this.saveTownList();
        try {
            townyWorld.removeTown(town);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.saveWorld(townyWorld);
        this.universe.setChangedNotify(TownyObservableType.REMOVE_TOWN);
    }

    @Override
    public void removeNation(Nation nation) {
        ArrayList<Nation> toSaveNation = new ArrayList<Nation>();
        for (Nation toCheck : new ArrayList<Nation>(this.universe.getNationsMap().values())) {
            if (!toCheck.hasAlly(nation) && !toCheck.hasEnemy(nation)) continue;
            try {
                if (toCheck.hasAlly(nation)) {
                    toCheck.removeAlly(nation);
                } else {
                    toCheck.removeEnemy(nation);
                }
                toSaveNation.add(toCheck);
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
        for (Nation toCheck : toSaveNation) {
            this.saveNation(toCheck);
        }
        if (TownyEconomyHandler.isActive()) {
            try {
                nation.payTo(nation.getHoldingBalance(), new WarSpoils(), "Remove Nation");
                nation.removeAccount();
            }
            catch (EconomyException toCheck) {
                // empty catch block
            }
        }
        this.deleteNation(nation);
        ArrayList<Town> toSave = new ArrayList<Town>(nation.getTowns());
        nation.clear();
        this.universe.getNationsMap().remove(nation.getName().toLowerCase());
        for (Town town : toSave) {
            this.saveTown(town);
        }
        this.plugin.resetCache();
        this.saveNationList();
        this.universe.setChangedNotify(TownyObservableType.REMOVE_NATION);
    }

    @Override
    public void removeWorld(TownyWorld world) throws UnsupportedOperationException {
        this.deleteWorld(world);
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<String> getResidentKeys() {
        return this.universe.getResidentMap().keySet();
    }

    @Override
    public Set<String> getTownsKeys() {
        return this.universe.getTownsMap().keySet();
    }

    @Override
    public Set<String> getNationsKeys() {
        return this.universe.getNationsMap().keySet();
    }

    @Override
    public List<Town> getTownsWithoutNation() {
        ArrayList<Town> townFilter = new ArrayList<Town>();
        for (Town town : this.getTowns()) {
            if (town.hasNation()) continue;
            townFilter.add(town);
        }
        return townFilter;
    }

    @Override
    public List<Resident> getResidentsWithoutTown() {
        ArrayList<Resident> residentFilter = new ArrayList<Resident>();
        for (Resident resident : this.universe.getResidentMap().values()) {
            if (resident.hasTown()) continue;
            residentFilter.add(resident);
        }
        return residentFilter;
    }

    @Override
    public void renameTown(Town town, String newName) throws AlreadyRegisteredException, NotRegisteredException {
        String filteredName;
        try {
            filteredName = NameValidation.checkAndFilterName(newName);
        }
        catch (InvalidNameException e) {
            throw new NotRegisteredException(e.getMessage());
        }
        if (this.hasTown(filteredName)) {
            throw new AlreadyRegisteredException("The town " + filteredName + " is already in use.");
        }
        ArrayList<Resident> toSave = new ArrayList<Resident>(town.getResidents());
        Boolean isCapital = false;
        Nation nation = null;
        Double townBalance = 0.0;
        if (TownySettings.isUsingEconomy()) {
            try {
                townBalance = town.getHoldingBalance();
                town.removeAccount();
            }
            catch (EconomyException economyException) {
                // empty catch block
            }
        }
        if (town.hasNation()) {
            nation = town.getNation();
            isCapital = town.isCapital();
        }
        this.deleteTown(town);
        this.universe.getTownsMap().remove(town.getName().toLowerCase());
        town.setName(filteredName);
        this.universe.getTownsMap().put(filteredName.toLowerCase(), town);
        if (isCapital.booleanValue()) {
            nation.setCapital(town);
            this.saveNation(nation);
        }
        if (TownySettings.isUsingEconomy()) {
            town.setBalance(townBalance, "Rename Town - Transfer to new account");
        }
        for (Resident resident : toSave) {
            this.saveResident(resident);
        }
        this.saveTown(town);
        this.saveTownList();
        this.saveWorld(town.getWorld());
        this.universe.setChangedNotify(TownyObservableType.RENAME_TOWN);
    }

    @Override
    public void renameNation(Nation nation, String newName) throws AlreadyRegisteredException, NotRegisteredException {
        String filteredName;
        try {
            filteredName = NameValidation.checkAndFilterName(newName);
        }
        catch (InvalidNameException e) {
            throw new NotRegisteredException(e.getMessage());
        }
        if (this.hasNation(filteredName)) {
            throw new AlreadyRegisteredException("The nation " + filteredName + " is already in use.");
        }
        ArrayList<Town> toSave = new ArrayList<Town>(nation.getTowns());
        Double nationBalance = 0.0;
        if (TownySettings.isUsingEconomy()) {
            try {
                nationBalance = nation.getHoldingBalance();
                nation.removeAccount();
            }
            catch (EconomyException economyException) {
                // empty catch block
            }
        }
        this.deleteNation(nation);
        String oldName = nation.getName();
        this.universe.getNationsMap().remove(oldName.toLowerCase());
        nation.setName(filteredName);
        this.universe.getNationsMap().put(filteredName.toLowerCase(), nation);
        if (TownyEconomyHandler.isActive()) {
            nation.setBalance(nationBalance, "Rename Nation - Transfer to new account");
        }
        for (Town town : toSave) {
            this.saveTown(town);
        }
        this.saveNation(nation);
        this.saveNationList();
        Nation oldNation = new Nation(oldName);
        ArrayList<Nation> toSaveNation = new ArrayList<Nation>(this.getNations());
        for (Nation toCheck : toSaveNation) {
            if (toCheck.hasAlly(oldNation) || toCheck.hasEnemy(oldNation)) {
                try {
                    if (toCheck.hasAlly(oldNation)) {
                        toCheck.removeAlly(oldNation);
                        toCheck.addAlly(nation);
                        continue;
                    }
                    toCheck.removeEnemy(oldNation);
                    toCheck.addEnemy(nation);
                }
                catch (NotRegisteredException e) {
                    e.printStackTrace();
                }
                continue;
            }
            toSave.remove(toCheck);
        }
        for (Nation toCheck : toSaveNation) {
            this.saveNation(toCheck);
        }
        this.universe.setChangedNotify(TownyObservableType.RENAME_NATION);
    }
}

