/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.db.TownyDatabaseHandler;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.PlotBlockData;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.util.NameValidation;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.KeyValueFile;
import com.palmergames.util.StringMgmt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;

public class TownyFlatFileSource
extends TownyDatabaseHandler {
    protected final String newLine = System.getProperty("line.separator");
    protected String rootFolder = "";
    protected String dataFolder = String.valueOf(FileMgmt.fileSeparator()) + "data";
    protected String settingsFolder = String.valueOf(FileMgmt.fileSeparator()) + "settings";
    protected String logFolder = String.valueOf(FileMgmt.fileSeparator()) + "logs";

    @Override
    public void initialize(Towny plugin, TownyUniverse universe) {
        this.universe = universe;
        this.plugin = plugin;
        this.rootFolder = universe.getRootFolder();
        try {
            FileMgmt.checkFolders(new String[]{this.rootFolder, String.valueOf(this.rootFolder) + this.dataFolder, String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "residents", String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "towns", String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "towns" + FileMgmt.fileSeparator() + "deleted", String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "nations", String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "nations" + FileMgmt.fileSeparator() + "deleted", String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "worlds", String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "worlds" + FileMgmt.fileSeparator() + "deleted", String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "plot-block-data", String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "townblocks"});
            FileMgmt.checkFiles(new String[]{String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "residents.txt", String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "towns.txt", String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "nations.txt", String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "worlds.txt", String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "regen.txt", String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "snapshot_queue.txt"});
        }
        catch (IOException e) {
            TownyMessaging.sendErrorMsg("Could not create flatfile default files and folders.");
        }
    }

    @Override
    public synchronized void backup() throws IOException {
        String backupType = TownySettings.getFlatFileBackupType();
        if (!backupType.equalsIgnoreCase("none")) {
            TownyLogger.shutDown();
            long t = System.currentTimeMillis();
            String newBackupFolder = String.valueOf(this.rootFolder) + FileMgmt.fileSeparator() + "backup" + FileMgmt.fileSeparator() + new SimpleDateFormat("yyyy-MM-dd HH-mm").format(t) + " - " + Long.toString(t);
            FileMgmt.checkFolders(new String[]{this.rootFolder, String.valueOf(this.rootFolder) + FileMgmt.fileSeparator() + "backup"});
            if (backupType.equalsIgnoreCase("folder")) {
                FileMgmt.checkFolders(new String[]{newBackupFolder});
                FileMgmt.copyDirectory(new File(String.valueOf(this.rootFolder) + this.dataFolder), new File(newBackupFolder));
                FileMgmt.copyDirectory(new File(String.valueOf(this.rootFolder) + this.logFolder), new File(newBackupFolder));
                FileMgmt.copyDirectory(new File(String.valueOf(this.rootFolder) + this.settingsFolder), new File(newBackupFolder));
            } else if (backupType.equalsIgnoreCase("zip")) {
                FileMgmt.zipDirectories(new File[]{new File(String.valueOf(this.rootFolder) + this.dataFolder), new File(String.valueOf(this.rootFolder) + this.logFolder), new File(String.valueOf(this.rootFolder) + this.settingsFolder)}, new File(String.valueOf(newBackupFolder) + ".zip"));
            } else {
                this.plugin.setupLogger();
                throw new IOException("Unsupported flatfile backup type (" + backupType + ")");
            }
            this.plugin.setupLogger();
        }
    }

    @Override
    public synchronized void deleteUnusedResidentFiles() {
        String path = String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "residents";
        Set<String> names = this.getResidentKeys();
        FileMgmt.deleteUnusedFiles(new File(path), names);
        path = String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "towns";
        names = this.getTownsKeys();
        FileMgmt.deleteUnusedFiles(new File(path), names);
        path = String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "nations";
        names = this.getNationsKeys();
        FileMgmt.deleteUnusedFiles(new File(path), names);
    }

    public String getResidentFilename(Resident resident) {
        return String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "residents" + FileMgmt.fileSeparator() + resident.getName() + ".txt";
    }

    public String getTownFilename(Town town) {
        return String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "towns" + FileMgmt.fileSeparator() + town.getName() + ".txt";
    }

    public String getNationFilename(Nation nation) {
        return String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "nations" + FileMgmt.fileSeparator() + nation.getName() + ".txt";
    }

    public String getWorldFilename(TownyWorld world) {
        return String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "worlds" + FileMgmt.fileSeparator() + world.getName() + ".txt";
    }

    public String getPlotFilename(PlotBlockData plotChunk) {
        return String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "plot-block-data" + FileMgmt.fileSeparator() + plotChunk.getWorldName() + FileMgmt.fileSeparator() + plotChunk.getX() + "_" + plotChunk.getZ() + "_" + plotChunk.getSize() + ".data";
    }

    public String getPlotFilename(TownBlock townBlock) {
        return String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "plot-block-data" + FileMgmt.fileSeparator() + townBlock.getWorld().getName() + FileMgmt.fileSeparator() + townBlock.getX() + "_" + townBlock.getZ() + "_" + TownySettings.getTownBlockSize() + ".data";
    }

    public String getTownBlockFilename(TownBlock townBlock) {
        return String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "townblocks" + FileMgmt.fileSeparator() + townBlock.getWorld().getName() + FileMgmt.fileSeparator() + townBlock.getX() + "_" + townBlock.getZ() + "_" + TownySettings.getTownBlockSize() + ".data";
    }

    @Override
    public boolean loadResidentList() {
        TownyMessaging.sendDebugMsg("Loading Resident List");
        BufferedReader fin = null;
        try {
            String line;
            fin = new BufferedReader(new FileReader(String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "residents.txt"));
            while ((line = fin.readLine()) != null) {
                if (line.equals("")) continue;
                this.newResident(line);
            }
            return true;
        }
        catch (AlreadyRegisteredException e) {
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean loadTownList() {
        TownyMessaging.sendDebugMsg("Loading Town List");
        fin = null;
        try {
            fin = new BufferedReader(new FileReader(String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "towns.txt"));
            if (true) ** GOTO lbl12
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        {
            do {
                if (line.equals("")) continue;
                this.newTown(line);
lbl12:
                // 3 sources

            } while ((line = fin.readLine()) != null);
        }
        if (fin != null) {
            try {
                fin.close();
            }
            catch (IOException var5_4) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean loadNationList() {
        TownyMessaging.sendDebugMsg("Loading Nation List");
        fin = null;
        try {
            fin = new BufferedReader(new FileReader(String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "nations.txt"));
            if (true) ** GOTO lbl12
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        {
            do {
                if (line.equals("")) continue;
                this.newNation(line);
lbl12:
                // 3 sources

            } while ((line = fin.readLine()) != null);
        }
        if (fin != null) {
            try {
                fin.close();
            }
            catch (IOException var5_4) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean loadWorldList() {
        if (this.plugin != null) {
            TownyMessaging.sendDebugMsg("Loading Server World List");
            for (World world : this.plugin.getServer().getWorlds()) {
                try {
                    this.newWorld(world.getName());
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
        }
        TownyMessaging.sendDebugMsg("Loading World List");
        BufferedReader fin = null;
        try {
            String line;
            fin = new BufferedReader(new FileReader(String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "worlds.txt"));
            while ((line = fin.readLine()) != null) {
                if (line.equals("")) continue;
                this.newWorld(line);
            }
            return true;
        }
        catch (AlreadyRegisteredException e) {
            return true;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean loadRegenList() {
        TownyMessaging.sendDebugMsg("Loading Regen List");
        BufferedReader fin = null;
        try {
            String line;
            fin = new BufferedReader(new FileReader(String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "regen.txt"));
            while ((line = fin.readLine()) != null) {
                String[] split;
                PlotBlockData plotData;
                if (line.equals("") || (plotData = this.loadPlotData((split = line.split(","))[0], Integer.parseInt(split[1]), Integer.parseInt(split[2]))) == null) continue;
                TownyRegenAPI.addPlotChunk(plotData, false);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean loadSnapshotList() {
        TownyMessaging.sendDebugMsg("Loading Snapshot Queue");
        BufferedReader fin = null;
        try {
            String line;
            fin = new BufferedReader(new FileReader(String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "snapshot_queue.txt"));
            while ((line = fin.readLine()) != null) {
                if (line.equals("")) continue;
                String[] split = line.split(",");
                WorldCoord worldCoord = new WorldCoord(split[0], Integer.parseInt(split[1]), Integer.parseInt(split[2]));
                TownyRegenAPI.addWorldCoord(worldCoord);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean loadResident(Resident resident) {
        String path = this.getResidentFilename(resident);
        File fileResident = new File(path);
        if (fileResident.exists() && fileResident.isFile()) {
            try {
                KeyValueFile kvFile = new KeyValueFile(path);
                resident.setLastOnline(Long.parseLong(kvFile.get("lastOnline")));
                String line = kvFile.get("registered");
                if (line != null) {
                    resident.setRegistered(Long.parseLong(line));
                } else {
                    resident.setRegistered(resident.getLastOnline());
                }
                line = kvFile.get("isNPC");
                if (line != null) {
                    resident.setNPC(Boolean.parseBoolean(line));
                }
                if ((line = kvFile.get("title")) != null) {
                    resident.setTitle(line);
                }
                if ((line = kvFile.get("surname")) != null) {
                    resident.setSurname(line);
                }
                if ((line = kvFile.get("town")) != null) {
                    resident.setTown(this.getTown(line));
                }
                if ((line = kvFile.get("friends")) != null) {
                    String[] tokens;
                    String[] stringArray = tokens = line.split(",");
                    int n = tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Resident friend;
                        String token = stringArray[n2];
                        if (!token.isEmpty() && (friend = this.getResident(token)) != null) {
                            resident.addFriend(friend);
                        }
                        ++n2;
                    }
                }
                if ((line = kvFile.get("protectionStatus")) != null) {
                    resident.setPermissions(line);
                }
                if ((line = kvFile.get("townBlocks")) != null) {
                    this.utilLoadTownBlocks(line, null, resident);
                }
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading resident file " + resident.getName());
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean loadTown(Town town) {
        String path = this.getTownFilename(town);
        File fileTown = new File(path);
        if (fileTown.exists() && fileTown.isFile()) {
            block80: {
                try {
                    String[] outposts;
                    TownyWorld world;
                    String token;
                    int n;
                    int n2;
                    String[] stringArray;
                    String[] tokens;
                    KeyValueFile kvFile = new KeyValueFile(path);
                    String line = kvFile.get("residents");
                    if (line != null) {
                        stringArray = tokens = line.split(",");
                        n2 = tokens.length;
                        n = 0;
                        while (n < n2) {
                            Resident resident;
                            token = stringArray[n];
                            if (!token.isEmpty() && (resident = this.getResident(token)) != null) {
                                town.addResident(resident);
                            }
                            ++n;
                        }
                    }
                    if ((line = kvFile.get("mayor")) != null) {
                        town.setMayor(this.getResident(line));
                    }
                    if ((line = kvFile.get("assistants")) != null) {
                        stringArray = tokens = line.split(",");
                        n2 = tokens.length;
                        n = 0;
                        while (n < n2) {
                            Resident assistant;
                            token = stringArray[n];
                            if (!token.isEmpty() && (assistant = this.getResident(token)) != null && town.hasResident(assistant)) {
                                town.addAssistant(assistant);
                            }
                            ++n;
                        }
                    }
                    town.setTownBoard(kvFile.get("townBoard"));
                    line = kvFile.get("tag");
                    if (line != null) {
                        try {
                            town.setTag(line);
                        }
                        catch (TownyException e) {
                            town.setTag("");
                        }
                    }
                    if ((line = kvFile.get("protectionStatus")) != null) {
                        town.setPermissions(line);
                    }
                    if ((line = kvFile.get("bonusBlocks")) != null) {
                        try {
                            town.setBonusBlocks(Integer.parseInt(line));
                        }
                        catch (Exception e) {
                            town.setBonusBlocks(0);
                        }
                    }
                    if ((line = kvFile.get("purchasedBlocks")) != null) {
                        try {
                            town.setPurchasedBlocks(Integer.parseInt(line));
                        }
                        catch (Exception e) {
                            town.setPurchasedBlocks(0);
                        }
                    }
                    if ((line = kvFile.get("plotPrice")) != null) {
                        try {
                            town.setPlotPrice(Double.parseDouble(line));
                        }
                        catch (Exception e) {
                            town.setPlotPrice(0.0);
                        }
                    }
                    if ((line = kvFile.get("hasUpkeep")) != null) {
                        try {
                            town.setHasUpkeep(Boolean.parseBoolean(line));
                        }
                        catch (NumberFormatException e) {
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if ((line = kvFile.get("taxpercent")) != null) {
                        try {
                            town.setTaxPercentage(Boolean.parseBoolean(line));
                        }
                        catch (NumberFormatException e) {
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if ((line = kvFile.get("taxes")) != null) {
                        try {
                            town.setTaxes(Double.parseDouble(line));
                        }
                        catch (Exception e) {
                            town.setTaxes(0.0);
                        }
                    }
                    if ((line = kvFile.get("plotTax")) != null) {
                        try {
                            town.setPlotTax(Double.parseDouble(line));
                        }
                        catch (Exception e) {
                            town.setPlotTax(0.0);
                        }
                    }
                    if ((line = kvFile.get("commercialPlotPrice")) != null) {
                        try {
                            town.setCommercialPlotPrice(Double.parseDouble(line));
                        }
                        catch (Exception e) {
                            town.setCommercialPlotPrice(0.0);
                        }
                    }
                    if ((line = kvFile.get("commercialPlotTax")) != null) {
                        try {
                            town.setCommercialPlotTax(Double.parseDouble(line));
                        }
                        catch (Exception e) {
                            town.setCommercialPlotTax(0.0);
                        }
                    }
                    if ((line = kvFile.get("embassyPlotPrice")) != null) {
                        try {
                            town.setEmbassyPlotPrice(Double.parseDouble(line));
                        }
                        catch (Exception e) {
                            town.setEmbassyPlotPrice(0.0);
                        }
                    }
                    if ((line = kvFile.get("embassyPlotTax")) != null) {
                        try {
                            town.setEmbassyPlotTax(Double.parseDouble(line));
                        }
                        catch (Exception e) {
                            town.setEmbassyPlotTax(0.0);
                        }
                    }
                    if ((line = kvFile.get("open")) != null) {
                        try {
                            town.setOpen(Boolean.parseBoolean(line));
                        }
                        catch (NumberFormatException e) {
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if ((line = kvFile.get("public")) != null) {
                        try {
                            town.setPublic(Boolean.parseBoolean(line));
                        }
                        catch (NumberFormatException e) {
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if ((line = kvFile.get("townBlocks")) != null) {
                        this.utilLoadTownBlocks(line, town, null);
                    }
                    if ((line = kvFile.get("homeBlock")) != null && (tokens = line.split(",")).length == 3) {
                        try {
                            world = this.getWorld(tokens[0]);
                            try {
                                int x = Integer.parseInt(tokens[1]);
                                int z = Integer.parseInt(tokens[2]);
                                TownBlock homeBlock = world.getTownBlock(x, z);
                                town.setHomeBlock(homeBlock);
                            }
                            catch (NumberFormatException e) {
                                TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid location.");
                            }
                            catch (NotRegisteredException e) {
                                TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid TownBlock.");
                            }
                            catch (TownyException e) {
                                TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " does not have a home block.");
                            }
                        }
                        catch (NotRegisteredException e) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid world.");
                        }
                    }
                    if ((line = kvFile.get("spawn")) != null && (tokens = line.split(",")).length >= 4) {
                        try {
                            world = this.plugin.getServerWorld(tokens[0]);
                            double x = Double.parseDouble(tokens[1]);
                            double y = Double.parseDouble(tokens[2]);
                            double z = Double.parseDouble(tokens[3]);
                            Location loc = new Location((World)world, x, y, z);
                            if (tokens.length == 6) {
                                loc.setPitch(Float.parseFloat(tokens[4]));
                                loc.setYaw(Float.parseFloat(tokens[5]));
                            }
                            town.setSpawn(loc);
                        }
                        catch (NumberFormatException world2) {
                        }
                        catch (NotRegisteredException world2) {
                        }
                        catch (NullPointerException world2) {
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " does not have a spawn point.");
                        }
                    }
                    if ((line = kvFile.get("outpostspawns")) == null) break block80;
                    String[] stringArray2 = outposts = line.split(";");
                    int n3 = outposts.length;
                    n2 = 0;
                    while (n2 < n3) {
                        String spawn = stringArray2[n2];
                        tokens = spawn.split(",");
                        if (tokens.length >= 4) {
                            try {
                                World world3 = this.plugin.getServerWorld(tokens[0]);
                                double x = Double.parseDouble(tokens[1]);
                                double y = Double.parseDouble(tokens[2]);
                                double z = Double.parseDouble(tokens[3]);
                                Location loc = new Location(world3, x, y, z);
                                if (tokens.length == 6) {
                                    loc.setPitch(Float.parseFloat(tokens[4]));
                                    loc.setYaw(Float.parseFloat(tokens[5]));
                                }
                                town.addOutpostSpawn(loc);
                            }
                            catch (NumberFormatException numberFormatException) {
                            }
                            catch (NotRegisteredException notRegisteredException) {
                            }
                            catch (NullPointerException nullPointerException) {
                            }
                            catch (TownyException townyException) {
                                // empty catch block
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    TownyMessaging.sendErrorMsg("Loading Error: Exception while reading town file " + town.getName());
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean loadNation(Nation nation) {
        String line = "";
        String path = this.getNationFilename(nation);
        File fileResident = new File(path);
        if (fileResident.exists() && fileResident.isFile()) {
            try {
                String token;
                int n;
                int n2;
                String[] stringArray;
                String[] tokens;
                KeyValueFile kvFile = new KeyValueFile(path);
                line = kvFile.get("towns");
                if (line != null) {
                    stringArray = tokens = line.split(",");
                    n2 = tokens.length;
                    n = 0;
                    while (n < n2) {
                        Town town;
                        token = stringArray[n];
                        if (!token.isEmpty() && (town = this.getTown(token)) != null) {
                            nation.addTown(town);
                        }
                        ++n;
                    }
                }
                if ((line = kvFile.get("capital")) != null) {
                    nation.setCapital(this.getTown(line));
                }
                if ((line = kvFile.get("assistants")) != null) {
                    stringArray = tokens = line.split(",");
                    n2 = tokens.length;
                    n = 0;
                    while (n < n2) {
                        Resident assistant;
                        token = stringArray[n];
                        if (!token.isEmpty() && (assistant = this.getResident(token)) != null) {
                            nation.addAssistant(assistant);
                        }
                        ++n;
                    }
                }
                if ((line = kvFile.get("tag")) != null) {
                    try {
                        nation.setTag(line);
                    }
                    catch (TownyException e) {
                        nation.setTag("");
                    }
                }
                if ((line = kvFile.get("allies")) != null) {
                    stringArray = tokens = line.split(",");
                    n2 = tokens.length;
                    n = 0;
                    while (n < n2) {
                        Nation friend;
                        token = stringArray[n];
                        if (!token.isEmpty() && (friend = this.getNation(token)) != null) {
                            nation.addAlly(friend);
                        }
                        ++n;
                    }
                }
                if ((line = kvFile.get("enemies")) != null) {
                    stringArray = tokens = line.split(",");
                    n2 = tokens.length;
                    n = 0;
                    while (n < n2) {
                        Nation enemy;
                        token = stringArray[n];
                        if (!token.isEmpty() && (enemy = this.getNation(token)) != null) {
                            nation.addEnemy(enemy);
                        }
                        ++n;
                    }
                }
                if ((line = kvFile.get("taxes")) != null) {
                    try {
                        nation.setTaxes(Double.parseDouble(line));
                    }
                    catch (Exception e) {
                        nation.setTaxes(0.0);
                    }
                }
                if ((line = kvFile.get("neutral")) != null) {
                    try {
                        nation.setNeutral(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading nation file " + nation.getName());
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean loadWorld(TownyWorld world) {
        String line = "";
        String path = this.getWorldFilename(world);
        try {
            FileMgmt.checkFiles(new String[]{path});
        }
        catch (IOException e1) {
            TownyMessaging.sendErrorMsg("Loading Error: Exception while reading file " + path);
        }
        File fileWorld = new File(path);
        if (fileWorld.exists() && fileWorld.isFile()) {
            try {
                String[] stringArray;
                ArrayList<Integer> nums2;
                int n;
                KeyValueFile kvFile = new KeyValueFile(path);
                line = kvFile.get("towns");
                if (line != null) {
                    String[] tokens;
                    String[] stringArray2 = tokens = line.split(",");
                    n = tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Town town;
                        String token = stringArray2[n2];
                        if (!token.isEmpty() && (town = this.getTown(token)) != null) {
                            town.setWorld(world);
                        }
                        ++n2;
                    }
                }
                if ((line = kvFile.get("claimable")) != null) {
                    try {
                        world.setClaimable(Boolean.parseBoolean(line));
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("pvp")) != null) {
                    try {
                        world.setPVP(Boolean.parseBoolean(line));
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("forcepvp")) != null) {
                    try {
                        world.setForcePVP(Boolean.parseBoolean(line));
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("forcetownmobs")) != null) {
                    try {
                        world.setForceTownMobs(Boolean.parseBoolean(line));
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("worldmobs")) != null) {
                    try {
                        world.setWorldMobs(Boolean.parseBoolean(line));
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("firespread")) != null) {
                    try {
                        world.setFire(Boolean.parseBoolean(line));
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("forcefirespread")) != null) {
                    try {
                        world.setForceFire(Boolean.parseBoolean(line));
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("explosions")) != null) {
                    try {
                        world.setExpl(Boolean.parseBoolean(line));
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("forceexplosions")) != null) {
                    try {
                        world.setForceExpl(Boolean.parseBoolean(line));
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("endermanprotect")) != null) {
                    try {
                        world.setEndermanProtect(Boolean.parseBoolean(line));
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("disableplayertrample")) != null) {
                    try {
                        world.setDisablePlayerTrample(Boolean.parseBoolean(line));
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("disablecreaturetrample")) != null) {
                    try {
                        world.setDisableCreatureTrample(Boolean.parseBoolean(line));
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("unclaimedZoneBuild")) != null) {
                    try {
                        world.setUnclaimedZoneBuild(Boolean.parseBoolean(line));
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("unclaimedZoneDestroy")) != null) {
                    try {
                        world.setUnclaimedZoneDestroy(Boolean.parseBoolean(line));
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("unclaimedZoneSwitch")) != null) {
                    try {
                        world.setUnclaimedZoneSwitch(Boolean.parseBoolean(line));
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("unclaimedZoneItemUse")) != null) {
                    try {
                        world.setUnclaimedZoneItemUse(Boolean.parseBoolean(line));
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("unclaimedZoneName")) != null) {
                    try {
                        world.setUnclaimedZoneName(line);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("unclaimedZoneIgnoreIds")) != null) {
                    try {
                        nums2 = new ArrayList<Integer>();
                        stringArray = line.split(",");
                        int n3 = stringArray.length;
                        n = 0;
                        while (n < n3) {
                            String s = stringArray[n];
                            if (!s.isEmpty()) {
                                try {
                                    nums2.add(Integer.parseInt(s));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            ++n;
                        }
                        world.setUnclaimedZoneIgnore(nums2);
                    }
                    catch (Exception nums2) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("usingPlotManagementDelete")) != null) {
                    try {
                        world.setUsingPlotManagementDelete(Boolean.parseBoolean(line));
                    }
                    catch (Exception nums2) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("plotManagementDeleteIds")) != null) {
                    try {
                        nums2 = new ArrayList();
                        stringArray = line.split(",");
                        int n4 = stringArray.length;
                        n = 0;
                        while (n < n4) {
                            String s = stringArray[n];
                            if (!s.isEmpty()) {
                                try {
                                    nums2.add(Integer.parseInt(s));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            ++n;
                        }
                        world.setPlotManagementDeleteIds(nums2);
                    }
                    catch (Exception nums3) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("usingPlotManagementMayorDelete")) != null) {
                    try {
                        world.setUsingPlotManagementMayorDelete(Boolean.parseBoolean(line));
                    }
                    catch (Exception nums3) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("plotManagementMayorDelete")) != null) {
                    try {
                        ArrayList<String> materials = new ArrayList<String>();
                        stringArray = line.split(",");
                        int n5 = stringArray.length;
                        n = 0;
                        while (n < n5) {
                            String s = stringArray[n];
                            if (!s.isEmpty()) {
                                try {
                                    materials.add(s.toUpperCase().trim());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            ++n;
                        }
                        world.setPlotManagementMayorDelete(materials);
                    }
                    catch (Exception materials) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("usingPlotManagementRevert")) != null) {
                    try {
                        world.setUsingPlotManagementRevert(Boolean.parseBoolean(line));
                    }
                    catch (Exception materials) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("usingPlotManagementRevertSpeed")) != null) {
                    try {
                        world.setPlotManagementRevertSpeed(Long.parseLong(line));
                    }
                    catch (Exception materials) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("plotManagementIgnoreIds")) != null) {
                    try {
                        nums2 = new ArrayList();
                        stringArray = line.split(",");
                        int n6 = stringArray.length;
                        n = 0;
                        while (n < n6) {
                            String s = stringArray[n];
                            if (!s.isEmpty()) {
                                try {
                                    nums2.add(Integer.parseInt(s));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            ++n;
                        }
                        world.setPlotManagementIgnoreIds(nums2);
                    }
                    catch (Exception nums4) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("usingPlotManagementWildRegen")) != null) {
                    try {
                        world.setUsingPlotManagementWildRevert(Boolean.parseBoolean(line));
                    }
                    catch (Exception nums4) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("PlotManagementWildRegenEntities")) != null) {
                    try {
                        ArrayList<String> entities = new ArrayList<String>();
                        stringArray = line.split(",");
                        int n7 = stringArray.length;
                        n = 0;
                        while (n < n7) {
                            String s = stringArray[n];
                            if (!s.isEmpty()) {
                                try {
                                    entities.add(s.trim());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            ++n;
                        }
                        world.setPlotManagementWildRevertEntities(entities);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("usingPlotManagementWildRegenDelay")) != null) {
                    try {
                        world.setPlotManagementWildRevertDelay(Long.parseLong(line));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("usingTowny")) != null) {
                    try {
                        world.setUsingTowny(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading world file " + path);
                return false;
            }
            return true;
        }
        TownyMessaging.sendErrorMsg("Loading Error: File error while reading " + world.getName());
        return false;
    }

    @Override
    public boolean loadTownBlocks() {
        String line = "";
        for (TownBlock townBlock : this.getAllTownBlocks()) {
            String path = this.getTownBlockFilename(townBlock);
            boolean set = false;
            File fileTownBlock = new File(path);
            if (!fileTownBlock.exists() || !fileTownBlock.isFile()) continue;
            try {
                KeyValueFile kvFile = new KeyValueFile(path);
                line = kvFile.get("permissions");
                if (line != null) {
                    try {
                        townBlock.setPermissions(line.trim());
                        set = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("changed")) != null) {
                    try {
                        townBlock.setChanged(Boolean.parseBoolean(line.trim()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("locked")) != null) {
                    try {
                        townBlock.setLocked(Boolean.parseBoolean(line.trim()));
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading TownBlock file " + path);
                return false;
            }
            if (set) continue;
            try {
                if (townBlock.hasResident()) {
                    townBlock.setPermissions(townBlock.getResident().getPermissions().toString());
                    continue;
                }
                townBlock.setPermissions(townBlock.getTown().getPermissions().toString());
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public boolean saveResidentList() {
        BufferedWriter fout = null;
        try {
            fout = new BufferedWriter(new FileWriter(String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "residents.txt"));
            for (Resident resident : this.getResidents()) {
                fout.write(String.valueOf(NameValidation.checkAndFilterPlayerName(resident.getName())) + this.newLine);
            }
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving residents list file");
            e.printStackTrace();
            return false;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean saveTownList() {
        BufferedWriter fout = null;
        try {
            fout = new BufferedWriter(new FileWriter(String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "towns.txt"));
            for (Town town : this.getTowns()) {
                fout.write(String.valueOf(town.getName()) + this.newLine);
            }
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving town list file");
            e.printStackTrace();
            return false;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean saveNationList() {
        BufferedWriter fout = null;
        try {
            fout = new BufferedWriter(new FileWriter(String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "nations.txt"));
            for (Nation nation : this.getNations()) {
                fout.write(String.valueOf(nation.getName()) + this.newLine);
            }
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving nation list file");
            e.printStackTrace();
            return false;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean saveWorldList() {
        BufferedWriter fout = null;
        try {
            fout = new BufferedWriter(new FileWriter(String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "worlds.txt"));
            for (TownyWorld world : this.getWorlds()) {
                fout.write(String.valueOf(world.getName()) + this.newLine);
            }
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving world list file");
            e.printStackTrace();
            return false;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean saveRegenList() {
        BufferedWriter fout = null;
        try {
            fout = new BufferedWriter(new FileWriter(String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "regen.txt"));
            for (PlotBlockData plot : new ArrayList<PlotBlockData>(TownyRegenAPI.getPlotChunks().values())) {
                fout.write(String.valueOf(plot.getWorldName()) + "," + plot.getX() + "," + plot.getZ() + this.newLine);
            }
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving regen file");
            e.printStackTrace();
            return false;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean saveSnapshotList() {
        BufferedWriter fout = null;
        try {
            fout = new BufferedWriter(new FileWriter(String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "snapshot_queue.txt"));
            while (TownyRegenAPI.hasWorldCoords()) {
                WorldCoord worldCoord = TownyRegenAPI.getWorldCoord();
                fout.write(String.valueOf(worldCoord.getWorldName()) + "," + worldCoord.getX() + "," + worldCoord.getZ() + this.newLine);
            }
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving snapshot_queue file");
            e.printStackTrace();
            return false;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean saveResident(Resident resident) {
        BufferedWriter fout = null;
        try {
            String path = this.getResidentFilename(resident);
            fout = new BufferedWriter(new FileWriter(path));
            fout.write("lastOnline=" + Long.toString(resident.getLastOnline()) + this.newLine);
            fout.write("registered=" + Long.toString(resident.getRegistered()) + this.newLine);
            fout.write("isNPC=" + Boolean.toString(resident.isNPC()) + this.newLine);
            fout.write("title=" + resident.getTitle() + this.newLine);
            fout.write("surname=" + resident.getSurname() + this.newLine);
            if (resident.hasTown()) {
                fout.write("town=" + resident.getTown().getName() + this.newLine);
            }
            fout.write("friends=");
            for (Resident friend : resident.getFriends()) {
                fout.write(String.valueOf(friend.getName()) + ",");
            }
            fout.write(this.newLine);
            fout.write("townBlocks=" + this.utilSaveTownBlocks(new ArrayList<TownBlock>(resident.getTownBlocks())) + this.newLine);
            fout.write("protectionStatus=" + resident.getPermissions().toString() + this.newLine);
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving resident file (" + resident.getName() + ")");
            e.printStackTrace();
            return false;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean saveTown(Town town) {
        BufferedWriter fout = null;
        try {
            String path = this.getTownFilename(town);
            fout = new BufferedWriter(new FileWriter(path));
            fout.write("name=" + town.getName() + this.newLine);
            fout.write("residents=" + StringMgmt.join(town.getResidents(), ",") + this.newLine);
            if (town.hasMayor()) {
                fout.write("mayor=" + town.getMayor().getName() + this.newLine);
            }
            if (town.hasNation()) {
                fout.write("nation=" + town.getNation().getName() + this.newLine);
            }
            fout.write("assistants=");
            for (Resident assistant : town.getAssistants()) {
                fout.write(String.valueOf(assistant.getName()) + ",");
            }
            fout.write(this.newLine);
            fout.write("townBoard=" + town.getTownBoard() + this.newLine);
            fout.write("tag=" + town.getTag() + this.newLine);
            fout.write("protectionStatus=" + town.getPermissions().toString() + this.newLine);
            fout.write("bonusBlocks=" + Integer.toString(town.getBonusBlocks()) + this.newLine);
            fout.write("purchasedBlocks=" + Integer.toString(town.getPurchasedBlocks()) + this.newLine);
            fout.write("taxpercent=" + Boolean.toString(town.isTaxPercentage()) + this.newLine);
            fout.write("taxes=" + Double.toString(town.getTaxes()) + this.newLine);
            fout.write("plotPrice=" + Double.toString(town.getPlotPrice()) + this.newLine);
            fout.write("plotTax=" + Double.toString(town.getPlotTax()) + this.newLine);
            fout.write("commercialPlotPrice=" + Double.toString(town.getCommercialPlotPrice()) + this.newLine);
            fout.write("commercialPlotTax=" + Double.toString(town.getCommercialPlotTax()) + this.newLine);
            fout.write("embassyPlotPrice=" + Double.toString(town.getEmbassyPlotPrice()) + this.newLine);
            fout.write("embassyPlotTax=" + Double.toString(town.getEmbassyPlotTax()) + this.newLine);
            fout.write("hasUpkeep=" + Boolean.toString(town.hasUpkeep()) + this.newLine);
            fout.write("open=" + Boolean.toString(town.isOpen()) + this.newLine);
            fout.write("public=" + Boolean.toString(town.isPublic()) + this.newLine);
            fout.write("townBlocks=" + this.utilSaveTownBlocks(new ArrayList<TownBlock>(town.getTownBlocks())) + this.newLine);
            if (town.hasHomeBlock()) {
                fout.write("homeBlock=" + town.getHomeBlock().getWorld().getName() + "," + Integer.toString(town.getHomeBlock().getX()) + "," + Integer.toString(town.getHomeBlock().getZ()) + this.newLine);
            }
            if (town.hasSpawn()) {
                fout.write("spawn=" + town.getSpawn().getWorld().getName() + "," + Double.toString(town.getSpawn().getX()) + "," + Double.toString(town.getSpawn().getY()) + "," + Double.toString(town.getSpawn().getZ()) + "," + Float.toString(town.getSpawn().getPitch()) + "," + Float.toString(town.getSpawn().getYaw()) + this.newLine);
            }
            if (town.hasOutpostSpawn()) {
                String outpostArray = "outpostspawns=";
                for (Location spawn : new ArrayList<Location>(town.getAllOutpostSpawns())) {
                    outpostArray = String.valueOf(outpostArray) + spawn.getWorld().getName() + "," + Double.toString(spawn.getX()) + "," + Double.toString(spawn.getY()) + "," + Double.toString(spawn.getZ()) + "," + Float.toString(spawn.getPitch()) + "," + Float.toString(spawn.getYaw()) + ";";
                }
                fout.write(outpostArray);
            }
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving town file (" + town.getName() + ")");
            e.printStackTrace();
            return false;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean saveNation(Nation nation) {
        BufferedWriter fout = null;
        try {
            String path = this.getNationFilename(nation);
            fout = new BufferedWriter(new FileWriter(path));
            fout.write("towns=");
            for (Town town : nation.getTowns()) {
                fout.write(String.valueOf(town.getName()) + ",");
            }
            fout.write(this.newLine);
            if (nation.hasCapital()) {
                fout.write("capital=" + nation.getCapital().getName() + this.newLine);
            }
            if (nation.hasTag()) {
                fout.write("tag=" + nation.getTag() + this.newLine);
            }
            fout.write("assistants=");
            for (Resident assistant : nation.getAssistants()) {
                fout.write(String.valueOf(assistant.getName()) + ",");
            }
            fout.write(this.newLine);
            fout.write("allies=");
            for (Nation allyNation : nation.getAllies()) {
                fout.write(String.valueOf(allyNation.getName()) + ",");
            }
            fout.write(this.newLine);
            fout.write("enemies=");
            for (Nation enemyNation : nation.getEnemies()) {
                fout.write(String.valueOf(enemyNation.getName()) + ",");
            }
            fout.write(this.newLine);
            fout.write("taxes=" + Double.toString(nation.getTaxes()) + this.newLine);
            fout.write("neutral=" + Boolean.toString(nation.isNeutral()) + this.newLine);
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving nation file (" + nation.getName() + ")");
            e.printStackTrace();
            return false;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean saveWorld(TownyWorld world) {
        BufferedWriter fout = null;
        try {
            String path = this.getWorldFilename(world);
            fout = new BufferedWriter(new FileWriter(path));
            fout.write("towns=");
            for (Town town : world.getTowns()) {
                TownyMessaging.sendDebugMsg("   Town - " + town.getName());
                fout.write(String.valueOf(town.getName()) + ",");
            }
            fout.write(this.newLine);
            fout.write(this.newLine);
            fout.write("pvp=" + Boolean.toString(world.isPVP()) + this.newLine);
            fout.write("forcepvp=" + Boolean.toString(world.isForcePVP()) + this.newLine);
            fout.write("# Can players found towns and claim plots in this world?" + this.newLine);
            fout.write("claimable=" + Boolean.toString(world.isClaimable()) + this.newLine);
            fout.write("worldmobs=" + Boolean.toString(world.hasWorldMobs()) + this.newLine);
            fout.write("forcetownmobs=" + Boolean.toString(world.isForceTownMobs()) + this.newLine);
            fout.write("firespread=" + Boolean.toString(world.isFire()) + this.newLine);
            fout.write("forcefirespread=" + Boolean.toString(world.isForceFire()) + this.newLine);
            fout.write("explosions=" + Boolean.toString(world.isExpl()) + this.newLine);
            fout.write("forceexplosions=" + Boolean.toString(world.isForceExpl()) + this.newLine);
            fout.write("endermanprotect=" + Boolean.toString(world.isEndermanProtect()) + this.newLine);
            fout.write("disableplayertrample=" + Boolean.toString(world.isDisablePlayerTrample()) + this.newLine);
            fout.write("disablecreaturetrample=" + Boolean.toString(world.isDisableCreatureTrample()) + this.newLine);
            fout.write(this.newLine);
            fout.write("# Unclaimed Zone settings." + this.newLine);
            if (world.getUnclaimedZoneBuild() != null) {
                fout.write("unclaimedZoneBuild=" + Boolean.toString(world.getUnclaimedZoneBuild()) + this.newLine);
            }
            if (world.getUnclaimedZoneDestroy() != null) {
                fout.write("unclaimedZoneDestroy=" + Boolean.toString(world.getUnclaimedZoneDestroy()) + this.newLine);
            }
            if (world.getUnclaimedZoneSwitch() != null) {
                fout.write("unclaimedZoneSwitch=" + Boolean.toString(world.getUnclaimedZoneSwitch()) + this.newLine);
            }
            if (world.getUnclaimedZoneItemUse() != null) {
                fout.write("unclaimedZoneItemUse=" + Boolean.toString(world.getUnclaimedZoneItemUse()) + this.newLine);
            }
            if (world.getUnclaimedZoneName() != null) {
                fout.write("unclaimedZoneName=" + world.getUnclaimedZoneName() + this.newLine);
            }
            fout.write(this.newLine);
            fout.write("# The following settings are only used if you are not using any permissions provider plugin" + this.newLine);
            if (world.getUnclaimedZoneIgnoreIds() != null) {
                fout.write("unclaimedZoneIgnoreIds=" + StringMgmt.join(world.getUnclaimedZoneIgnoreIds(), ",") + this.newLine);
            }
            fout.write(this.newLine);
            fout.write("# The following settings control what blocks are deleted upon a townblock being unclaimed" + this.newLine);
            fout.write("usingPlotManagementDelete=" + Boolean.toString(world.isUsingPlotManagementDelete()) + this.newLine);
            if (world.getPlotManagementDeleteIds() != null) {
                fout.write("plotManagementDeleteIds=" + StringMgmt.join(world.getPlotManagementDeleteIds(), ",") + this.newLine);
            }
            fout.write(this.newLine);
            fout.write("# The following settings control what blocks are deleted upon a mayor issuing a '/plot clear' command" + this.newLine);
            fout.write("usingPlotManagementMayorDelete=" + Boolean.toString(world.isUsingPlotManagementMayorDelete()) + this.newLine);
            if (world.getPlotManagementMayorDelete() != null) {
                fout.write("plotManagementMayorDelete=" + StringMgmt.join(world.getPlotManagementMayorDelete(), ",") + this.newLine);
            }
            fout.write(String.valueOf(this.newLine) + "# If enabled when a town claims a townblock a snapshot will be taken at the time it is claimed." + this.newLine);
            fout.write("# When the townblock is unclaimded its blocks will begin to revert to the original snapshot." + this.newLine);
            fout.write("usingPlotManagementRevert=" + Boolean.toString(world.isUsingPlotManagementRevert()) + this.newLine);
            fout.write("usingPlotManagementRevertSpeed=" + Long.toString(world.getPlotManagementRevertSpeed()) + this.newLine);
            fout.write("# Any block Id's listed here will not be respawned. Instead it will revert to air." + this.newLine);
            if (world.getPlotManagementIgnoreIds() != null) {
                fout.write("plotManagementIgnoreIds=" + StringMgmt.join(world.getPlotManagementIgnoreIds(), ",") + this.newLine);
            }
            fout.write(this.newLine);
            fout.write("# If enabled any damage caused by explosions will repair itself." + this.newLine);
            fout.write("usingPlotManagementWildRegen=" + Boolean.toString(world.isUsingPlotManagementWildRevert()) + this.newLine);
            if (world.getPlotManagementWildRevertEntities() != null) {
                fout.write("PlotManagementWildRegenEntities=" + StringMgmt.join(world.getPlotManagementWildRevertEntities(), ",") + this.newLine);
            }
            fout.write("usingPlotManagementWildRegenDelay=" + Long.toString(world.getPlotManagementWildRevertDelay()) + this.newLine);
            fout.write(this.newLine);
            fout.write("# This setting is used to enable or disable Towny in this world." + this.newLine);
            fout.write("usingTowny=" + Boolean.toString(world.isUsingTowny()) + this.newLine);
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("Saving Error: Exception while saving world file (" + world.getName() + ")");
            e.printStackTrace();
            return false;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean saveAllTownBlocks() {
        for (TownyWorld world : this.getWorlds()) {
            for (TownBlock townBlock : world.getTownBlocks()) {
                this.saveTownBlock(townBlock);
            }
        }
        return true;
    }

    @Override
    public boolean saveTownBlock(TownBlock townBlock) {
        FileMgmt.checkFolders(new String[]{String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "townblocks" + FileMgmt.fileSeparator() + townBlock.getWorld().getName()});
        BufferedWriter fout = null;
        String path = this.getTownBlockFilename(townBlock);
        try {
            try {
                fout = new BufferedWriter(new FileWriter(path));
                fout.write("permissions=" + townBlock.getPermissions().toString() + this.newLine);
                fout.write("changed=" + Boolean.toString(townBlock.isChanged()) + this.newLine);
                fout.write("locked=" + Boolean.toString(townBlock.isLocked()) + this.newLine);
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Saving Error: Exception while saving TownBlock file (" + path + ")");
                e.printStackTrace();
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public void utilLoadTownBlocks(String line, Town town, Resident resident) {
        String[] worlds;
        String[] stringArray = worlds = line.split("\\|");
        int n = worlds.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            String[] split = w.split(":");
            if (split.length != 2) {
                TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " BlockList does not have a World or data.");
            } else {
                try {
                    TownyWorld world = this.getWorld(split[0]);
                    String[] stringArray2 = split[1].split(";");
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String[] tokens;
                        String s = stringArray2[n4];
                        String blockTypeData = null;
                        int indexOfType = s.indexOf("[");
                        if (indexOfType != -1) {
                            int endIndexOfType = s.indexOf("]");
                            if (endIndexOfType != -1) {
                                blockTypeData = s.substring(indexOfType + 1, endIndexOfType);
                            }
                            s = s.substring(endIndexOfType + 1);
                        }
                        if ((tokens = s.split(",")).length >= 2) {
                            try {
                                int x = Integer.parseInt(tokens[0]);
                                int z = Integer.parseInt(tokens[1]);
                                try {
                                    world.newTownBlock(x, z);
                                }
                                catch (AlreadyRegisteredException alreadyRegisteredException) {
                                    // empty catch block
                                }
                                TownBlock townblock = world.getTownBlock(x, z);
                                if (town != null) {
                                    townblock.setTown(town);
                                }
                                if (resident != null && townblock.hasTown()) {
                                    townblock.setResident(resident);
                                }
                                if (blockTypeData != null) {
                                    this.utilLoadTownBlockTypeData(townblock, blockTypeData);
                                }
                                if (tokens.length >= 3) {
                                    if (tokens[2] == "true") {
                                        townblock.setPlotPrice(town.getPlotPrice());
                                    } else {
                                        townblock.setPlotPrice(Double.parseDouble(tokens[2]));
                                    }
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                            }
                            catch (NotRegisteredException notRegisteredException) {
                                // empty catch block
                            }
                        }
                        ++n4;
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    public void utilLoadTownBlockTypeData(TownBlock townBlock, String data) {
        String[] tokens = data.split(",");
        if (tokens.length >= 1) {
            townBlock.setType(Integer.valueOf(tokens[0]));
        }
        if (tokens.length >= 2) {
            townBlock.setOutpost(tokens[1].equalsIgnoreCase("1"));
        }
    }

    public String utilSaveTownBlocks(List<TownBlock> townBlocks) {
        HashMap worlds = new HashMap();
        String out = "";
        for (TownBlock townBlock : townBlocks) {
            TownyWorld world = townBlock.getWorld();
            if (!worlds.containsKey(world)) {
                worlds.put(world, new ArrayList());
            }
            ((ArrayList)worlds.get(world)).add(townBlock);
        }
        for (TownyWorld world : worlds.keySet()) {
            out = String.valueOf(out) + world.getName() + ":";
            for (TownBlock townBlock : (ArrayList)worlds.get(world)) {
                out = String.valueOf(out) + "[" + townBlock.getType().getId();
                out = String.valueOf(out) + "," + (townBlock.isOutpost() ? "1" : "0");
                out = String.valueOf(out) + "]" + townBlock.getX() + "," + townBlock.getZ() + "," + townBlock.getPlotPrice() + ";";
            }
            out = String.valueOf(out) + "|";
        }
        return out;
    }

    @Override
    public boolean savePlotData(PlotBlockData plotChunk) {
        FileMgmt.checkFolders(new String[]{String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "plot-block-data" + FileMgmt.fileSeparator() + plotChunk.getWorldName()});
        FilterOutputStream fout = null;
        String path = this.getPlotFilename(plotChunk);
        try {
            try {
                fout = new BufferedOutputStream(new FileOutputStream(path));
                switch (plotChunk.getVersion()) {
                    case 1: {
                        fout.write("VER".getBytes(Charset.forName("UTF-8")));
                        ((BufferedOutputStream)fout).write(plotChunk.getVersion());
                    }
                }
                ((BufferedOutputStream)fout).write(plotChunk.getHeight());
                for (int block : new ArrayList<Integer>(plotChunk.getBlockList())) {
                    ((BufferedOutputStream)fout).write(block);
                }
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("Saving Error: Exception while saving PlotBlockData file (" + path + ")");
                e.printStackTrace();
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    @Override
    public PlotBlockData loadPlotData(String worldName, int x, int z) {
        try {
            TownyWorld world = this.getWorld(worldName);
            TownBlock townBlock = new TownBlock(x, z, world);
            return this.loadPlotData(townBlock);
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public PlotBlockData loadPlotData(TownBlock townBlock) {
        String fileName = this.getPlotFilename(townBlock);
        if (this.isFile(fileName)) {
            ArrayList<Integer> IntArr;
            PlotBlockData plotBlockData;
            block19: {
                plotBlockData = new PlotBlockData(townBlock);
                IntArr = new ArrayList<Integer>();
                BufferedInputStream fin = null;
                try {
                    try {
                        int value;
                        fin = new BufferedInputStream(new FileInputStream(fileName));
                        byte[] key = new byte[3];
                        fin.read(key, 0, 3);
                        String test = new String(key);
                        switch (elements.fromString(test)) {
                            case VER: {
                                int version = fin.read();
                                plotBlockData.setVersion(version);
                                plotBlockData.setHeight(fin.read());
                                break;
                            }
                            default: {
                                plotBlockData.setVersion(0);
                                plotBlockData.setHeight(key[0]);
                                IntArr.add(Integer.valueOf(key[1]));
                                IntArr.add(Integer.valueOf(key[2]));
                                break;
                            }
                        }
                        while ((value = fin.read()) >= 0) {
                            IntArr.add(value);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (fin != null) {
                            try {
                                fin.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (fin != null) {
                    try {
                        fin.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            plotBlockData.setBlockList(IntArr);
            plotBlockData.resetBlockListRestored();
            return plotBlockData;
        }
        return null;
    }

    @Override
    public void deletePlotData(PlotBlockData plotChunk) {
        File file = new File(this.getPlotFilename(plotChunk));
        if (file.exists()) {
            file.delete();
        }
    }

    private boolean isFile(String fileName) {
        File file = new File(fileName);
        return file.exists() && file.isFile();
    }

    @Override
    public void deleteFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void deleteResident(Resident resident) {
        File file = new File(this.getResidentFilename(resident));
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void deleteTown(Town town) {
        File file = new File(this.getTownFilename(town));
        if (file.exists()) {
            try {
                FileMgmt.moveFile(file, "deleted");
            }
            catch (IOException e) {
                TownyMessaging.sendErrorMsg("Error moving Town txt file.");
                file.delete();
            }
        }
    }

    @Override
    public void deleteNation(Nation nation) {
        File file = new File(this.getNationFilename(nation));
        if (file.exists()) {
            try {
                FileMgmt.moveFile(file, "deleted");
            }
            catch (IOException e) {
                TownyMessaging.sendErrorMsg("Error moving Nation txt file.");
                file.delete();
            }
        }
    }

    @Override
    public void deleteWorld(TownyWorld world) {
        File file = new File(this.getWorldFilename(world));
        if (file.exists()) {
            try {
                FileMgmt.moveFile(file, "deleted");
            }
            catch (IOException e) {
                TownyMessaging.sendErrorMsg("Error moving World txt file.");
            }
        }
    }

    @Override
    public void deleteTownBlock(TownBlock townBlock) {
        File file = new File(this.getTownBlockFilename(townBlock));
        if (file.exists()) {
            file.delete();
        }
    }

    private static enum elements {
        VER,
        novalue;


        public static elements fromString(String Str) {
            try {
                return elements.valueOf(Str);
            }
            catch (Exception ex) {
                return novalue;
            }
        }
    }
}

