/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.db.TownyFlatFileSource;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.KeyValueFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.bukkit.World;

public class TownyHModFlatFileSource
extends TownyFlatFileSource {
    @Override
    public void initialize(Towny plugin, TownyUniverse universe) {
        this.universe = universe;
        this.plugin = plugin;
        this.rootFolder = universe.getRootFolder();
        this.dataFolder = "/data-hmod";
        try {
            FileMgmt.checkFolders(new String[]{this.rootFolder, String.valueOf(this.rootFolder) + this.dataFolder, String.valueOf(this.rootFolder) + this.dataFolder + "/residents", String.valueOf(this.rootFolder) + this.dataFolder + "/towns", String.valueOf(this.rootFolder) + this.dataFolder + "/nations"});
            FileMgmt.checkFiles(new String[]{String.valueOf(this.rootFolder) + this.dataFolder + "/residents.txt", String.valueOf(this.rootFolder) + this.dataFolder + "/towns.txt", String.valueOf(this.rootFolder) + this.dataFolder + "/nations.txt", String.valueOf(this.rootFolder) + this.dataFolder + "/townblocks.txt"});
        }
        catch (IOException e) {
            System.out.println("[Towny] Error: Could not create hmod-flatfile default files and folders.");
        }
    }

    @Override
    public void backup() throws IOException {
    }

    @Override
    public boolean loadWorldList() {
        TownyMessaging.sendDebugMsg("Loading World List");
        if (this.plugin != null) {
            TownyMessaging.sendDebugMsg("Loading Server World List");
            for (World world : this.plugin.getServer().getWorlds()) {
                try {
                    this.newWorld(world.getName());
                }
                catch (AlreadyRegisteredException e) {
                    e.printStackTrace();
                }
                catch (NotRegisteredException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean loadWorlds() {
        System.out.println("[Towny] [hMod Conversion] Town Blocks");
        TownyWorld world = this.getWorlds().toArray(new TownyWorld[0])[0];
        try {
            String line;
            BufferedReader fin = new BufferedReader(new FileReader(String.valueOf(this.rootFolder) + this.dataFolder + "/townblocks.csv"));
            while ((line = fin.readLine()) != null) {
                String[] tokens = line.split(",");
                if (tokens.length < 4) continue;
                try {
                    Town town = this.getTown(tokens[2]);
                    int x = Integer.parseInt(tokens[0]);
                    int z = Integer.parseInt(tokens[1]);
                    try {
                        world.newTownBlock(x, z);
                    }
                    catch (AlreadyRegisteredException alreadyRegisteredException) {
                        // empty catch block
                    }
                    TownBlock townblock = world.getTownBlock(x, z);
                    if (town != null) {
                        townblock.setTown(town);
                    }
                    try {
                        townblock.setResident(this.getResident(tokens[3]));
                    }
                    catch (NotRegisteredException notRegisteredException) {}
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (NotRegisteredException e) {
                    e.printStackTrace();
                }
            }
            fin.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean loadResident(Resident resident) {
        System.out.println("[Towny] [hMod Conversion] Resident: " + resident.getName());
        String path = String.valueOf(this.rootFolder) + this.dataFolder + "/residents/" + resident.getName() + ".txt";
        File fileResident = new File(path);
        if (fileResident.exists() && fileResident.isFile()) {
            try {
                KeyValueFile kvFile = new KeyValueFile(path);
                resident.setLastOnline(Long.parseLong(kvFile.get("lastLogin")));
                String line = kvFile.get("registered");
                if (line != null) {
                    resident.setRegistered(Long.parseLong(line));
                } else {
                    resident.setRegistered(resident.getLastOnline());
                }
                line = kvFile.get("town");
                if (line != null) {
                    resident.setTown(this.getTown(line));
                }
                if ((line = kvFile.get("friends")) != null) {
                    String[] tokens;
                    String[] stringArray = tokens = line.split(",");
                    int n = tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String token = stringArray[n2];
                        Resident friend = this.getResident(token);
                        if (friend != null) {
                            resident.addFriend(friend);
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("[Towny] Loading Error: Exception while reading resident file " + resident.getName());
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean loadTown(Town town) {
        System.out.println("[Towny] [hMod Conversion] Town: " + town.getName());
        String path = String.valueOf(this.rootFolder) + this.dataFolder + "/towns/" + town.getName() + ".txt";
        File fileResident = new File(path);
        if (fileResident.exists() && fileResident.isFile()) {
            try {
                String token;
                int n;
                int n2;
                String[] stringArray;
                String[] tokens;
                KeyValueFile kvFile = new KeyValueFile(path);
                String line = kvFile.get("residents");
                if (line != null) {
                    stringArray = tokens = line.split(",");
                    n2 = tokens.length;
                    n = 0;
                    while (n < n2) {
                        token = stringArray[n];
                        Resident resident = this.getResident(token);
                        if (resident != null) {
                            town.addResident(resident);
                        }
                        ++n;
                    }
                }
                if ((line = kvFile.get("mayor")) != null) {
                    town.setMayor(this.getResident(line));
                }
                if ((line = kvFile.get("assistants")) != null) {
                    stringArray = tokens = line.split(",");
                    n2 = tokens.length;
                    n = 0;
                    while (n < n2) {
                        token = stringArray[n];
                        Resident assistant = this.getResident(token);
                        if (assistant != null) {
                            town.addAssistant(assistant);
                        }
                        ++n;
                    }
                }
                town.setTownBoard(kvFile.get("townBoard"));
                line = kvFile.get("bonusBlocks");
                if (line != null) {
                    try {
                        town.setBonusBlocks(Integer.parseInt(line));
                    }
                    catch (Exception e) {
                        town.setBonusBlocks(0);
                    }
                }
                if ((line = kvFile.get("purchasedBlocks")) != null) {
                    try {
                        town.setPurchasedBlocks(Integer.parseInt(line));
                    }
                    catch (Exception e) {
                        town.setPurchasedBlocks(0);
                    }
                }
                if ((line = kvFile.get("plotPrice")) != null) {
                    try {
                        town.setPlotPrice(Integer.parseInt(line));
                    }
                    catch (Exception e) {
                        town.setPlotPrice(0.0);
                    }
                }
                if ((line = kvFile.get("taxes")) != null) {
                    try {
                        town.setTaxes(Integer.parseInt(line));
                    }
                    catch (Exception e) {
                        town.setTaxes(0.0);
                    }
                }
                if ((line = kvFile.get("plotTax")) != null) {
                    try {
                        town.setPlotTax(Integer.parseInt(line));
                    }
                    catch (Exception e) {
                        town.setPlotTax(0.0);
                    }
                }
                if ((line = kvFile.get("pvp")) != null) {
                    try {
                        town.setPVP(Boolean.parseBoolean(line));
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("explosion")) != null) {
                    try {
                        town.setBANG(Boolean.parseBoolean(line));
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("taxpercent")) != null) {
                    try {
                        town.setTaxPercentage(Boolean.parseBoolean(line));
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((line = kvFile.get("fire")) != null) {
                    try {
                        town.setFire(Boolean.parseBoolean(line));
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                System.out.println("[Towny] Loading Error: Exception while reading town file " + town.getName());
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean loadNation(Nation nation) {
        System.out.println("[Towny] [hMod Conversion] Nation: " + nation.getName());
        String line = "";
        String path = String.valueOf(this.rootFolder) + this.dataFolder + "/nations/" + nation.getName() + ".txt";
        File fileResident = new File(path);
        if (fileResident.exists() && fileResident.isFile()) {
            try {
                String token;
                int n;
                int n2;
                String[] stringArray;
                String[] tokens;
                KeyValueFile kvFile = new KeyValueFile(path);
                line = kvFile.get("towns");
                if (line != null) {
                    stringArray = tokens = line.split(",");
                    n2 = tokens.length;
                    n = 0;
                    while (n < n2) {
                        token = stringArray[n];
                        Town town = this.getTown(token);
                        if (town != null) {
                            nation.addTown(town);
                        }
                        ++n;
                    }
                }
                line = kvFile.get("capital");
                nation.setCapital(this.getTown(line));
                line = kvFile.get("assistants");
                if (line != null) {
                    stringArray = tokens = line.split(",");
                    n2 = tokens.length;
                    n = 0;
                    while (n < n2) {
                        token = stringArray[n];
                        Resident assistant = this.getResident(token);
                        if (assistant != null) {
                            nation.addAssistant(assistant);
                        }
                        ++n;
                    }
                }
                if ((line = kvFile.get("allies")) != null) {
                    stringArray = tokens = line.split(",");
                    n2 = tokens.length;
                    n = 0;
                    while (n < n2) {
                        token = stringArray[n];
                        Nation friend = this.getNation(token);
                        if (friend != null) {
                            nation.setAliegeance("ally", friend);
                        }
                        ++n;
                    }
                }
                if ((line = kvFile.get("enemies")) != null) {
                    stringArray = tokens = line.split(",");
                    n2 = tokens.length;
                    n = 0;
                    while (n < n2) {
                        token = stringArray[n];
                        Nation enemy = this.getNation(token);
                        if (enemy != null) {
                            nation.setAliegeance("enemy", enemy);
                        }
                        ++n;
                    }
                }
                if ((line = kvFile.get("taxes")) != null) {
                    try {
                        nation.setTaxes(Integer.parseInt(line));
                    }
                    catch (Exception e) {
                        nation.setTaxes(0.0);
                    }
                }
                if ((line = kvFile.get("neutral")) != null) {
                    try {
                        nation.setNeutral(Boolean.parseBoolean(line));
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                System.out.println("[Towny] Loading Error: Exception while reading nation file " + nation.getName());
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean loadWorld(TownyWorld world) {
        return false;
    }

    @Override
    public boolean saveResidentList() {
        return false;
    }

    @Override
    public boolean saveTownList() {
        return false;
    }

    @Override
    public boolean saveNationList() {
        return false;
    }

    @Override
    public boolean saveWorldList() {
        return false;
    }

    @Override
    public boolean saveResident(Resident resident) {
        return false;
    }

    @Override
    public boolean saveTown(Town town) {
        return false;
    }

    @Override
    public boolean saveNation(Nation nation) {
        return false;
    }

    @Override
    public boolean saveWorld(TownyWorld world) {
        return false;
    }
}

