/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.db;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.db.TownyFlatFileSource;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.StringMgmt;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;

public class TownySQLSource
extends TownyFlatFileSource {
    protected String dsn = "";
    protected String hostname = "";
    protected String port = "";
    protected String db_name = "";
    protected String username = "";
    protected String password = "";
    protected String tb_prefix = "";
    private Connection cntx = null;
    private boolean ish2 = false;

    public TownySQLSource(String type) {
        if (type.equalsIgnoreCase("sqlite") || type.equalsIgnoreCase("h2")) {
            this.ish2 = true;
        }
    }

    @Override
    public void initialize(Towny plugin, TownyUniverse universe) {
        ResultSet tb_table;
        Statement s;
        DatabaseMetaData dbm;
        this.universe = universe;
        this.plugin = plugin;
        this.rootFolder = universe.getRootFolder();
        try {
            FileMgmt.checkFolders(new String[]{this.rootFolder, String.valueOf(this.rootFolder) + this.dataFolder, String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "plot-block-data"});
            FileMgmt.checkFiles(new String[]{String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "regen.txt", String.valueOf(this.rootFolder) + this.dataFolder + FileMgmt.fileSeparator() + "snapshot_queue.txt"});
        }
        catch (IOException e) {
            TownyMessaging.sendErrorMsg("Could not create flatfile default files and folders.");
        }
        this.hostname = TownySettings.getSQLHostName();
        this.port = TownySettings.getSQLPort();
        this.db_name = TownySettings.getSQLDBName();
        this.tb_prefix = TownySettings.getSQLTablePrefix().toUpperCase();
        if (this.ish2) {
            this.dsn = "jdbc:h2:" + this.rootFolder + this.dataFolder + File.separator + this.db_name + ";AUTO_RECONNECT=TRUE";
            this.username = "sa";
            this.password = "sa";
        } else {
            this.dsn = "jdbc:mysql://" + this.hostname + ":" + this.port + "/" + this.db_name;
            this.username = TownySettings.getSQLUsername();
            this.password = TownySettings.getSQLPassword();
        }
        TownyMessaging.sendDebugMsg("Checking for tables existence");
        if (!this.getContext()) {
            TownyMessaging.sendErrorMsg("Failed when connecting to Database");
            return;
        }
        TownyMessaging.sendDebugMsg("[Towny] Connected to Database");
        try {
            dbm = this.cntx.getMetaData();
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("Cannot get Table metadata");
            return;
        }
        String[] types = new String[]{"TABLE"};
        try {
            ResultSet town_table = dbm.getTables(null, null, (String.valueOf(this.tb_prefix) + "TOWNS").toUpperCase(), types);
            if (town_table.next()) {
                TownyMessaging.sendDebugMsg("Table TOWNS is ok!");
            } else {
                String town_create = "CREATE TABLE " + this.tb_prefix + "TOWNS (" + "`name` VARCHAR(32) NOT NULL," + "`residents` mediumtext," + "`mayor` mediumtext," + "`nation` mediumtext NOT NULL," + "`assistants` text DEFAULT NULL," + "`townBoard` mediumtext DEFAULT NULL," + "`tag` mediumtext DEFAULT NULL," + "`protectionStatus` mediumtext DEFAULT NULL," + "`bonus` int(11) DEFAULT 0," + "`purchased` int(11)  DEFAULT 0," + "`taxpercent` bool NOT NULL DEFAULT '0'," + "`taxes` float DEFAULT 0," + "`hasUpkeep` bool NOT NULL DEFAULT '0'," + "`plotPrice` float DEFAULT NULL," + "`plotTax` float DEFAULT NULL," + "`commercialPlotPrice` float DEFAULT NULL," + "`commercialPlotTax` float NOT NULL," + "`embassyPlotPrice` float NOT NULL," + "`embassyPlotTax` float NOT NULL," + "`open` bool NOT NULL DEFAULT '0'," + "`public` bool NOT NULL DEFAULT '0'," + "`homeblock` mediumtext NOT NULL," + "`townBlocks` mediumtext NOT NULL," + "`spawn` mediumtext NOT NULL," + "`outpostSpawns` mediumtext DEFAULT NULL," + "PRIMARY KEY (`name`)" + ")";
                try {
                    s = this.cntx.createStatement();
                    s.executeUpdate(town_create);
                }
                catch (SQLException ee) {
                    TownyMessaging.sendErrorMsg("Creating table TOWNS :" + ee.getMessage());
                }
            }
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("Error Checking table TOWNS :" + e.getMessage());
        }
        try {
            ResultSet res_table = dbm.getTables(null, null, (String.valueOf(this.tb_prefix) + "RESIDENTS").toUpperCase(), types);
            if (res_table.next()) {
                TownyMessaging.sendDebugMsg("Table RESIDENTS is ok!");
            } else {
                String resident_create = "CREATE TABLE " + this.tb_prefix + "RESIDENTS (" + " `name` VARCHAR(16) NOT NULL," + "`town` mediumtext," + "`lastOnline` BIGINT NOT NULL," + "`registered` BIGINT NOT NULL," + "`isNPC` bool NOT NULL DEFAULT '0'," + "`title` mediumtext," + "`surname` mediumtext," + "`protectionStatus` mediumtext," + "`friends` mediumtext," + "`townBlocks` mediumtext," + "PRIMARY KEY (`name`)" + ")";
                try {
                    s = this.cntx.createStatement();
                    s.executeUpdate(resident_create);
                }
                catch (SQLException ee) {
                    TownyMessaging.sendErrorMsg("Error Creating table RESIDENTS :" + ee.getMessage());
                }
            }
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("Error Checking table RESIDENTS :" + e.getMessage());
        }
        try {
            ResultSet nat_table = dbm.getTables(null, null, (String.valueOf(this.tb_prefix) + "NATIONS").toUpperCase(), types);
            if (nat_table.next()) {
                TownyMessaging.sendDebugMsg("Table NATIONS is ok!");
            } else {
                String nation_create = "CREATE TABLE " + this.tb_prefix + "NATIONS (" + "`name` VARCHAR(32) NOT NULL," + "`towns` mediumtext NOT NULL," + "`capital` mediumtext NOT NULL," + "`assistants` mediumtext NOT NULL," + "`tag` mediumtext NOT NULL," + "`allies` mediumtext NOT NULL," + "`enemies` mediumtext NOT NULL," + "`taxes` float NOT NULL," + "`neutral` bool NOT NULL DEFAULT '0', " + "PRIMARY KEY (`name`)" + ")";
                try {
                    s = this.cntx.createStatement();
                    s.executeUpdate(nation_create);
                }
                catch (SQLException ee) {
                    TownyMessaging.sendErrorMsg("Error Creating table NATIONS : " + ee.getMessage());
                }
            }
        }
        catch (SQLException e) {
            System.out.println("[Towny] Error Checking table NATIONS :" + e.getMessage());
        }
        try {
            tb_table = dbm.getTables(null, null, (String.valueOf(this.tb_prefix) + "TOWNBLOCKS").toUpperCase(), types);
            if (tb_table.next()) {
                TownyMessaging.sendDebugMsg("Table TOWNBLOCKS is ok!");
            } else {
                String townblock_create = "CREATE TABLE " + this.tb_prefix + "TOWNBLOCKS (" + "`world` VARCHAR(32) NOT NULL," + "`x` bigint(20) NOT NULL," + "`z` bigint(20) NOT NULL," + "`permissions` mediumtext NOT NULL," + "`locked` bool NOT NULL DEFAULT '0'," + "`changed` bool NOT NULL DEFAULT '0'," + "PRIMARY KEY (`world`,`x`,`z`)" + ")";
                try {
                    s = this.cntx.createStatement();
                    s.executeUpdate(townblock_create);
                }
                catch (SQLException ee) {
                    TownyMessaging.sendErrorMsg("Error Creating table TOWNBLOCKS : " + ee.getMessage());
                }
            }
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("Error Checking table TOWNBLOCKS :" + e.getMessage());
        }
        try {
            tb_table = dbm.getTables(null, null, (String.valueOf(this.tb_prefix) + "WORLDS").toUpperCase(), types);
            if (tb_table.next()) {
                TownyMessaging.sendDebugMsg("Table WORLDS is ok!");
            } else {
                String world_create = "CREATE TABLE " + this.tb_prefix + "WORLDS (" + "`name` VARCHAR(32) NOT NULL," + "`towns` mediumtext NOT NULL," + "`claimable` bool NOT NULL DEFAULT '0'," + "`pvp` bool NOT NULL DEFAULT '0'," + "`forcepvp` bool NOT NULL DEFAULT '0'," + "`forcetownmobs` bool NOT NULL DEFAULT '0'," + "`worldmobs` bool NOT NULL DEFAULT '0'," + "`firespread` bool NOT NULL DEFAULT '0'," + "`forcefirespread` bool NOT NULL DEFAULT '0'," + "`explosions` bool NOT NULL DEFAULT '0'," + "`forceexplosions` bool NOT NULL DEFAULT '0'," + "`endermanprotect` bool NOT NULL DEFAULT '0'," + "`disableplayertrample` bool NOT NULL DEFAULT '0'," + "`disablecreaturetrample` bool NOT NULL DEFAULT '0'," + "`unclaimedZoneBuild` bool NOT NULL DEFAULT '0'," + "`unclaimedZoneDestroy` bool NOT NULL DEFAULT '0'," + "`unclaimedZoneSwitch` bool NOT NULL DEFAULT '0'," + "`unclaimedZoneItemUse` bool NOT NULL DEFAULT '0'," + "`unclaimedZoneName` mediumtext NOT NULL," + "`unclaimedZoneIgnoreIds` mediumtext NOT NULL," + "`usingPlotManagementDelete` bool NOT NULL DEFAULT '0'," + "`plotManagementDeleteIds` mediumtext NOT NULL," + "`usingPlotManagementMayorDelete` bool NOT NULL DEFAULT '0'," + "`plotManagementMayorDelete` mediumtext NOT NULL," + "`usingPlotManagementRevert` bool NOT NULL DEFAULT '0'," + "`plotManagementRevertSpeed` long NOT NULL," + "`plotManagementIgnoreIds` mediumtext NOT NULL," + "`usingPlotManagementWildRegen` bool NOT NULL DEFAULT '0'," + "`plotManagementWildRegenEntities` mediumtext NOT NULL," + "`plotManagementWildRegenSpeed` long NOT NULL," + "`usingTowny` bool NOT NULL DEFAULT '0'," + "PRIMARY KEY (`name`)" + ")";
                try {
                    s = this.cntx.createStatement();
                    s.executeUpdate(world_create);
                }
                catch (SQLException ee) {
                    TownyMessaging.sendErrorMsg("Error Creating table WORLDS : " + ee.getMessage());
                }
            }
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("Error Checking table WORLDS :" + e.getMessage());
        }
        TownyMessaging.sendDebugMsg("Checking done!");
    }

    public boolean getContext() {
        try {
            if (this.cntx == null || this.cntx.isClosed()) {
                this.cntx = this.username.equalsIgnoreCase("") && this.password.equalsIgnoreCase("") ? DriverManager.getConnection(this.dsn) : DriverManager.getConnection(this.dsn, this.username, this.password);
            }
            return this.cntx != null && !this.cntx.isClosed();
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("Error could not Connect to db " + this.dsn + ": " + e.getMessage());
            return false;
        }
    }

    public boolean UpdateDB(String tb_name, HashMap<String, Object> args, List<String> keys) {
        if (!this.getContext()) {
            return false;
        }
        if (keys == null) {
            String code = "INSERT INTO " + this.tb_prefix + tb_name.toUpperCase() + " ";
            String keycode = "(";
            String valuecode = " VALUES (";
            Set<Map.Entry<String, Object>> set = args.entrySet();
            Iterator<Map.Entry<String, Object>> i = set.iterator();
            while (i.hasNext()) {
                Map.Entry<String, Object> me = i.next();
                keycode = String.valueOf(keycode) + me.getKey();
                keycode = String.valueOf(keycode) + (i.hasNext() ? ", " : ")");
                valuecode = me.getValue() instanceof String ? String.valueOf(valuecode) + "'" + ((String)me.getValue()).replace("'", "''") + "'" : (me.getValue() instanceof Double ? String.valueOf(valuecode) + "'" + me.getValue() + "'" : (me.getValue() instanceof Float ? String.valueOf(valuecode) + "'" + me.getValue() + "'" : String.valueOf(valuecode) + me.getValue()));
                valuecode = String.valueOf(valuecode) + (i.hasNext() ? "," : ")");
            }
            code = String.valueOf(code) + keycode;
            code = String.valueOf(code) + valuecode;
            try {
                Statement s = this.cntx.createStatement();
                int rs = s.executeUpdate(code);
                return rs != 0;
            }
            catch (SQLException e) {
                TownyMessaging.sendErrorMsg("SQL: Insert sql error " + e.getMessage() + " --> " + code);
                return false;
            }
        }
        String code = "UPDATE " + this.tb_prefix + tb_name.toUpperCase() + " SET ";
        Set<Map.Entry<String, Object>> set = args.entrySet();
        Iterator<Map.Entry<String, Object>> i = set.iterator();
        while (i.hasNext()) {
            Map.Entry<String, Object> me = i.next();
            code = String.valueOf(code) + me.getKey() + " = ";
            code = me.getValue() instanceof String ? String.valueOf(code) + "'" + ((String)me.getValue()).replace("'", "''") + "'" : (me.getValue() instanceof Float ? String.valueOf(code) + "'" + me.getValue() + "'" : (me.getValue() instanceof Double ? String.valueOf(code) + "'" + me.getValue() + "'" : String.valueOf(code) + me.getValue()));
            code = String.valueOf(code) + (i.hasNext() ? "," : "");
        }
        code = String.valueOf(code) + " WHERE ";
        Iterator<String> keys_i = keys.iterator();
        while (keys_i.hasNext()) {
            String key = keys_i.next();
            code = String.valueOf(code) + key + " = ";
            Object v = args.get(key);
            code = v instanceof String ? String.valueOf(code) + "'" + v + "'" : String.valueOf(code) + v;
            code = String.valueOf(code) + (keys_i.hasNext() ? " AND " : "");
        }
        try {
            Statement s = this.cntx.createStatement();
            int rs = s.executeUpdate(code);
            if (rs == 0) {
                return this.UpdateDB(tb_name, args, null);
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Update sql error " + e.getMessage() + " --> " + code);
            return false;
        }
    }

    public boolean DeleteDB(String tb_name, HashMap<String, Object> args) {
        if (!this.getContext()) {
            return false;
        }
        try {
            String wherecode = "DELETE FROM " + this.tb_prefix + tb_name.toUpperCase() + " WHERE ";
            Set<Map.Entry<String, Object>> set = args.entrySet();
            Iterator<Map.Entry<String, Object>> i = set.iterator();
            while (i.hasNext()) {
                Map.Entry<String, Object> me = i.next();
                wherecode = String.valueOf(wherecode) + me.getKey() + " = ";
                wherecode = me.getValue() instanceof String ? String.valueOf(wherecode) + "'" + me.getValue() + "'" : (me.getValue() instanceof Float ? String.valueOf(wherecode) + "'" + me.getValue() + "'" : String.valueOf(wherecode) + me.getValue());
                wherecode = String.valueOf(wherecode) + (i.hasNext() ? " AND " : "");
            }
            Statement s = this.cntx.createStatement();
            int rs = s.executeUpdate(wherecode);
            if (rs == 0) {
                TownyMessaging.sendDebugMsg("SQL: delete returned 0: " + wherecode);
            }
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Error delete : " + e.getMessage());
        }
        return false;
    }

    @Override
    public boolean loadResidentList() {
        TownyMessaging.sendDebugMsg("Loading Resident List");
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT name FROM " + this.tb_prefix + "RESIDENTS");
            while (rs.next()) {
                try {
                    this.newResident(rs.getString("name"));
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadTownList() {
        TownyMessaging.sendDebugMsg("Loading Town List");
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT name FROM " + this.tb_prefix + "TOWNS");
            while (rs.next()) {
                try {
                    this.newTown(rs.getString("name"));
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: town list sql error : " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: town list unknown error: ");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadNationList() {
        TownyMessaging.sendDebugMsg("Loading Nation List");
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT name FROM " + this.tb_prefix + "NATIONS");
            while (rs.next()) {
                try {
                    this.newNation(rs.getString("name"));
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: nation list sql error : " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: nation list unknown error : ");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadWorldList() {
        TownyMessaging.sendDebugMsg("Loading World List");
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT name FROM " + this.tb_prefix + "WORLDS");
            while (rs.next()) {
                try {
                    this.newWorld(rs.getString("name"));
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {
                    // empty catch block
                }
            }
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: world list sql error : " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: world list unknown error : ");
            e.printStackTrace();
        }
        if (this.plugin != null) {
            for (World world : this.plugin.getServer().getWorlds()) {
                try {
                    this.newWorld(world.getName());
                }
                catch (AlreadyRegisteredException alreadyRegisteredException) {
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    @Override
    public boolean loadResident(Resident resident) {
        TownyMessaging.sendDebugMsg("Loading resident " + resident.getName());
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT  lastOnline,registered,isNPC,title,surname,town,friends,protectionStatus,townBlocks FROM " + this.tb_prefix + "RESIDENTS " + " WHERE name='" + resident.getName() + "'");
            if (rs.next()) {
                try {
                    resident.setLastOnline(rs.getLong("lastOnline"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    resident.setRegistered(rs.getLong("registered"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    resident.setNPC(rs.getBoolean("isNPC"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    resident.setTitle(rs.getString("title"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    resident.setSurname(rs.getString("surname"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String line = rs.getString("town");
                if (line != null && !line.isEmpty()) {
                    resident.setTown(this.getTown(line));
                    TownyMessaging.sendDebugMsg("Resident " + resident.getName() + " set to Town " + rs.getString("town"));
                }
                try {
                    line = rs.getString("friends");
                    if (line != null) {
                        String[] tokens;
                        String[] stringArray = tokens = line.split(",");
                        int n = tokens.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Resident friend;
                            String token = stringArray[n2];
                            if (!token.isEmpty() && (friend = this.getResident(token)) != null) {
                                resident.addFriend(friend);
                            }
                            ++n2;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    resident.setPermissions(rs.getString("protectionStatus"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                line = rs.getString("townBlocks");
                if (line != null && !line.isEmpty()) {
                    this.utilLoadTownBlocks(line, null, resident);
                }
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load resident sql error : " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Load resident unknown error");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadTown(Town town) {
        TownyMessaging.sendDebugMsg("Loading town " + town.getName());
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT residents,mayor,assistants,townBoard,nation,tag,protectionStatus,bonus,purchased,plotPrice,hasUpkeep,taxpercent,taxes,plotTax,commercialPlotPrice,commercialPlotTax,embassyPlotPrice,embassyPlotTax,open,public,townBlocks,homeBlock,spawn,outpostSpawns FROM " + this.tb_prefix + "TOWNS " + " WHERE name='" + town.getName() + "'");
            if (rs.next()) {
                TownyWorld world;
                String token;
                int n;
                int n2;
                String[] stringArray;
                String[] tokens;
                String line = rs.getString("residents");
                if (line != null) {
                    stringArray = tokens = line.split(",");
                    n2 = tokens.length;
                    n = 0;
                    while (n < n2) {
                        Resident resident;
                        token = stringArray[n];
                        if (!token.isEmpty() && (resident = this.getResident(token)) != null) {
                            town.addResident(resident);
                        }
                        ++n;
                    }
                }
                town.setMayor(this.getResident(rs.getString("mayor")));
                line = rs.getString("assistants");
                if (line != null) {
                    stringArray = tokens = line.split(",");
                    n2 = tokens.length;
                    n = 0;
                    while (n < n2) {
                        Resident assistant;
                        token = stringArray[n];
                        if (!token.isEmpty() && (assistant = this.getResident(token)) != null && town.hasResident(assistant)) {
                            town.addAssistant(assistant);
                        }
                        ++n;
                    }
                }
                town.setTownBoard(rs.getString("townBoard"));
                line = rs.getString("tag");
                if (line != null) {
                    try {
                        town.setTag(line);
                    }
                    catch (TownyException e) {
                        town.setTag("");
                    }
                }
                town.setPermissions(rs.getString("protectionStatus"));
                town.setBonusBlocks(rs.getInt("bonus"));
                town.setTaxPercentage(rs.getBoolean("taxpercent"));
                town.setTaxes(rs.getFloat("taxes"));
                town.setHasUpkeep(rs.getBoolean("hasUpkeep"));
                town.setPlotPrice(rs.getFloat("plotPrice"));
                town.setPlotTax(rs.getFloat("plotTax"));
                town.setEmbassyPlotPrice(rs.getFloat("embassyPlotPrice"));
                town.setEmbassyPlotTax(rs.getFloat("embassyPlotTax"));
                town.setCommercialPlotPrice(rs.getFloat("commercialPlotPrice"));
                town.setCommercialPlotTax(rs.getFloat("commercialPlotTax"));
                town.setOpen(rs.getBoolean("open"));
                town.setPublic(rs.getBoolean("public"));
                town.setPurchasedBlocks(rs.getInt("purchased"));
                line = rs.getString("townBlocks");
                if (line != null) {
                    this.utilLoadTownBlocks(line, town, null);
                }
                if ((line = rs.getString("homeBlock")) != null && (tokens = line.split(",")).length == 3) {
                    try {
                        world = this.getWorld(tokens[0]);
                        try {
                            int x = Integer.parseInt(tokens[1]);
                            int z = Integer.parseInt(tokens[2]);
                            TownBlock homeBlock = world.getTownBlock(x, z);
                            town.setHomeBlock(homeBlock);
                        }
                        catch (NumberFormatException e) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid location.");
                        }
                        catch (NotRegisteredException e) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid TownBlock.");
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " does not have a home block.");
                        }
                    }
                    catch (NotRegisteredException e) {
                        TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " homeBlock tried to load invalid world.");
                    }
                }
                if ((line = rs.getString("spawn")) != null) {
                    tokens = line.split(",");
                    if (tokens.length >= 4) {
                        try {
                            world = this.plugin.getServerWorld(tokens[0]);
                            double x = Double.parseDouble(tokens[1]);
                            double y = Double.parseDouble(tokens[2]);
                            double z = Double.parseDouble(tokens[3]);
                            Location loc = new Location((World)world, x, y, z);
                            if (tokens.length == 6) {
                                loc.setPitch(Float.parseFloat(tokens[4]));
                                loc.setYaw(Float.parseFloat(tokens[5]));
                            }
                            town.setSpawn(loc);
                        }
                        catch (NumberFormatException world2) {
                        }
                        catch (NotRegisteredException world2) {
                        }
                        catch (NullPointerException world2) {
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg("[Warning] " + town.getName() + " does not have a spawn point.");
                        }
                    }
                    if ((line = rs.getString("outpostSpawns")) != null) {
                        String[] outposts;
                        String[] stringArray2 = outposts = line.split(";");
                        int n3 = outposts.length;
                        n2 = 0;
                        while (n2 < n3) {
                            String spawn = stringArray2[n2];
                            tokens = spawn.split(",");
                            if (tokens.length >= 4) {
                                try {
                                    World world3 = this.plugin.getServerWorld(tokens[0]);
                                    double x = Double.parseDouble(tokens[1]);
                                    double y = Double.parseDouble(tokens[2]);
                                    double z = Double.parseDouble(tokens[3]);
                                    Location loc = new Location(world3, x, y, z);
                                    if (tokens.length == 6) {
                                        loc.setPitch(Float.parseFloat(tokens[4]));
                                        loc.setYaw(Float.parseFloat(tokens[5]));
                                    }
                                    town.addOutpostSpawn(loc);
                                }
                                catch (NumberFormatException numberFormatException) {
                                }
                                catch (NotRegisteredException notRegisteredException) {
                                }
                                catch (NullPointerException nullPointerException) {
                                }
                                catch (TownyException townyException) {
                                    // empty catch block
                                }
                            }
                            ++n2;
                        }
                    }
                }
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load Town sql Error - " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Load Town unknown Error - ");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadNation(Nation nation) {
        String line = "";
        TownyMessaging.sendDebugMsg("Loading nation " + nation.getName());
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT towns,capital,assistants,tag,allies,enemies,taxes,neutral FROM " + this.tb_prefix + "NATIONS WHERE name='" + nation.getName() + "'");
            while (rs.next()) {
                String token;
                int n;
                int n2;
                String[] stringArray;
                String[] tokens;
                line = rs.getString("towns");
                if (line != null) {
                    stringArray = tokens = line.split(",");
                    n2 = tokens.length;
                    n = 0;
                    while (n < n2) {
                        Town town;
                        token = stringArray[n];
                        if (!token.isEmpty() && (town = this.getTown(token)) != null) {
                            nation.addTown(town);
                        }
                        ++n;
                    }
                }
                nation.setCapital(this.getTown(rs.getString("capital")));
                line = rs.getString("assistants");
                if (line != null) {
                    stringArray = tokens = line.split(",");
                    n2 = tokens.length;
                    n = 0;
                    while (n < n2) {
                        Resident assistant;
                        token = stringArray[n];
                        if (!token.isEmpty() && (assistant = this.getResident(token)) != null) {
                            nation.addAssistant(assistant);
                        }
                        ++n;
                    }
                }
                nation.setTag(rs.getString("tag"));
                line = rs.getString("allies");
                if (line != null) {
                    stringArray = tokens = line.split(",");
                    n2 = tokens.length;
                    n = 0;
                    while (n < n2) {
                        Nation friend;
                        token = stringArray[n];
                        if (!token.isEmpty() && (friend = this.getNation(token)) != null) {
                            nation.addAlly(friend);
                        }
                        ++n;
                    }
                }
                if ((line = rs.getString("enemies")) != null) {
                    stringArray = tokens = line.split(",");
                    n2 = tokens.length;
                    n = 0;
                    while (n < n2) {
                        Nation enemy;
                        token = stringArray[n];
                        if (!token.isEmpty() && (enemy = this.getNation(token)) != null) {
                            nation.addEnemy(enemy);
                        }
                        ++n;
                    }
                }
                nation.setTaxes(rs.getDouble("taxes"));
                nation.setNeutral(rs.getBoolean("neutral"));
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load Nation sql error " + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Load Nation unknown error - ");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadWorld(TownyWorld world) {
        String line = "";
        Boolean result = false;
        TownyMessaging.sendDebugMsg("Loading world " + world.getName());
        if (!this.getContext()) {
            return false;
        }
        try {
            Statement s = this.cntx.createStatement();
            ResultSet rs = s.executeQuery("SELECT * FROM " + this.tb_prefix + "WORLDS WHERE name='" + world.getName() + "'");
            while (rs.next()) {
                Long resultLong;
                String[] stringArray;
                ArrayList<Integer> nums2;
                int n;
                line = rs.getString("towns");
                if (line != null) {
                    String[] tokens;
                    String[] stringArray2 = tokens = line.split(",");
                    n = tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Town town;
                        String token = stringArray2[n2];
                        if (!token.isEmpty() && (town = this.getTown(token)) != null) {
                            town.setWorld(world);
                        }
                        ++n2;
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("claimable"))) != null) {
                    try {
                        world.setClaimable(result);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("pvp"))) != null) {
                    try {
                        world.setPVP(result);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("forcepvp"))) != null) {
                    try {
                        world.setForcePVP(result);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("forcetownmobs"))) != null) {
                    try {
                        world.setForceTownMobs(result);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("worldmobs"))) != null) {
                    try {
                        world.setWorldMobs(result);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("firespread"))) != null) {
                    try {
                        world.setFire(result);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("forcefirespread"))) != null) {
                    try {
                        world.setForceFire(result);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("explosions"))) != null) {
                    try {
                        world.setExpl(result);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("forceexplosions"))) != null) {
                    try {
                        world.setForceExpl(result);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("endermanprotect"))) != null) {
                    try {
                        world.setEndermanProtect(result);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("disableplayertrample"))) != null) {
                    try {
                        world.setDisablePlayerTrample(result);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("disablecreaturetrample"))) != null) {
                    try {
                        world.setDisableCreatureTrample(result);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("unclaimedZoneBuild"))) != null) {
                    try {
                        world.setUnclaimedZoneBuild(result);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("unclaimedZoneDestroy"))) != null) {
                    try {
                        world.setUnclaimedZoneDestroy(result);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("unclaimedZoneSwitch"))) != null) {
                    try {
                        world.setUnclaimedZoneSwitch(result);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("unclaimedZoneItemUse"))) != null) {
                    try {
                        world.setUnclaimedZoneItemUse(result);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                line = rs.getString("unclaimedZoneName");
                if (result != null) {
                    try {
                        world.setUnclaimedZoneName(line);
                    }
                    catch (Exception token) {
                        // empty catch block
                    }
                }
                if ((line = rs.getString("unclaimedZoneIgnoreIds")) != null) {
                    try {
                        nums2 = new ArrayList<Integer>();
                        stringArray = line.split(",");
                        int n3 = stringArray.length;
                        n = 0;
                        while (n < n3) {
                            String split = stringArray[n];
                            if (!split.isEmpty()) {
                                try {
                                    nums2.add(Integer.parseInt(split));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            ++n;
                        }
                        world.setUnclaimedZoneIgnore(nums2);
                    }
                    catch (Exception nums2) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("usingPlotManagementDelete"))) != null) {
                    try {
                        world.setUsingPlotManagementDelete(result);
                    }
                    catch (Exception nums2) {
                        // empty catch block
                    }
                }
                if ((line = rs.getString("plotManagementDeleteIds")) != null) {
                    try {
                        nums2 = new ArrayList();
                        stringArray = line.split(",");
                        int n4 = stringArray.length;
                        n = 0;
                        while (n < n4) {
                            String split = stringArray[n];
                            if (!split.isEmpty()) {
                                try {
                                    nums2.add(Integer.parseInt(split));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            ++n;
                        }
                        world.setPlotManagementDeleteIds(nums2);
                    }
                    catch (Exception nums3) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("usingPlotManagementMayorDelete"))) != null) {
                    try {
                        world.setUsingPlotManagementMayorDelete(result);
                    }
                    catch (Exception nums3) {
                        // empty catch block
                    }
                }
                if ((line = rs.getString("plotManagementMayorDelete")) != null) {
                    try {
                        ArrayList<String> materials = new ArrayList<String>();
                        stringArray = line.split(",");
                        int n5 = stringArray.length;
                        n = 0;
                        while (n < n5) {
                            String split = stringArray[n];
                            if (!split.isEmpty()) {
                                try {
                                    materials.add(split.toUpperCase().trim());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            ++n;
                        }
                        world.setPlotManagementMayorDelete(materials);
                    }
                    catch (Exception materials) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("usingPlotManagementRevert"))) != null) {
                    try {
                        world.setUsingPlotManagementRevert(result);
                    }
                    catch (Exception materials) {
                        // empty catch block
                    }
                }
                if ((resultLong = Long.valueOf(rs.getLong("PlotManagementRevertSpeed"))) != null) {
                    try {
                        world.setPlotManagementRevertSpeed(resultLong);
                    }
                    catch (Exception materials) {
                        // empty catch block
                    }
                }
                if ((line = rs.getString("plotManagementIgnoreIds")) != null) {
                    try {
                        nums2 = new ArrayList();
                        stringArray = line.split(",");
                        int n6 = stringArray.length;
                        n = 0;
                        while (n < n6) {
                            String split = stringArray[n];
                            if (!split.isEmpty()) {
                                try {
                                    nums2.add(Integer.parseInt(split));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            ++n;
                        }
                        world.setPlotManagementIgnoreIds(nums2);
                    }
                    catch (Exception nums4) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("usingPlotManagementWildRegen"))) != null) {
                    try {
                        world.setUsingPlotManagementWildRevert(result);
                    }
                    catch (Exception nums4) {
                        // empty catch block
                    }
                }
                if ((line = rs.getString("plotManagementWildRegenEntities")) != null) {
                    try {
                        ArrayList<String> entities = new ArrayList<String>();
                        stringArray = line.split(",");
                        int n7 = stringArray.length;
                        n = 0;
                        while (n < n7) {
                            String split = stringArray[n];
                            if (!split.isEmpty()) {
                                try {
                                    entities.add(split.trim());
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            ++n;
                        }
                        world.setPlotManagementWildRevertEntities(entities);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((resultLong = Long.valueOf(rs.getLong("plotManagementWildRegenSpeed"))) != null) {
                    try {
                        world.setPlotManagementWildRevertDelay(resultLong);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((result = Boolean.valueOf(rs.getBoolean("usingTowny"))) == null) continue;
                try {
                    world.setUsingTowny(result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (SQLException e) {
            TownyMessaging.sendErrorMsg("SQL: Load world sql error (" + world.getName() + ")" + e.getMessage());
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Load world unknown error - ");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean loadTownBlocks() {
        String line = "";
        Boolean result = false;
        if (!this.getContext()) {
            return false;
        }
        for (TownBlock townBlock : this.getAllTownBlocks()) {
            boolean set = false;
            try {
                Statement s = this.cntx.createStatement();
                ResultSet rs = s.executeQuery("SELECT permissions,locked,changed FROM " + this.tb_prefix + "TOWNBLOCKS" + " WHERE world='" + townBlock.getWorld().getName() + "' AND x='" + townBlock.getX() + "' AND z='" + townBlock.getZ() + "'");
                while (rs.next()) {
                    line = rs.getString("permissions");
                    if (line != null) {
                        try {
                            townBlock.setPermissions(line.trim());
                            set = true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((result = Boolean.valueOf(rs.getBoolean("changed"))) != null) {
                        try {
                            townBlock.setChanged(result);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((result = Boolean.valueOf(rs.getBoolean("locked"))) != null) {
                        try {
                            townBlock.setLocked(result);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (set) continue;
                    try {
                        if (townBlock.hasResident()) {
                            townBlock.setPermissions(townBlock.getResident().getPermissions().toString());
                            continue;
                        }
                        townBlock.setPermissions(townBlock.getTown().getPermissions().toString());
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
            }
            catch (SQLException e) {
                TownyMessaging.sendErrorMsg("Loading Error: Exception while reading TownBlocks ");
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized boolean saveResident(Resident resident) {
        TownyMessaging.sendDebugMsg("Saving Resident");
        try {
            HashMap<String, Object> res_hm = new HashMap<String, Object>();
            res_hm.put("name", resident.getName());
            res_hm.put("lastOnline", resident.getLastOnline());
            res_hm.put("registered", resident.getRegistered());
            res_hm.put("isNPC", resident.isNPC());
            res_hm.put("title", resident.getTitle());
            res_hm.put("surname", resident.getSurname());
            res_hm.put("town", resident.hasTown() ? resident.getTown().getName() : "");
            String fstr = "";
            for (Resident friend : resident.getFriends()) {
                fstr = String.valueOf(fstr) + friend.getName() + ",";
            }
            res_hm.put("friends", fstr);
            res_hm.put("townBlocks", this.utilSaveTownBlocks(new ArrayList<TownBlock>(resident.getTownBlocks())));
            res_hm.put("protectionStatus", resident.getPermissions().toString());
            this.UpdateDB("RESIDENTS", res_hm, Arrays.asList("name"));
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save Resident unknown error " + e.getMessage());
            return false;
        }
    }

    @Override
    public synchronized boolean saveTown(Town town) {
        TownyMessaging.sendDebugMsg("Saving town " + town.getName());
        try {
            HashMap<String, Object> twn_hm = new HashMap<String, Object>();
            twn_hm.put("name", town.getName());
            twn_hm.put("residents", StringMgmt.join(town.getResidents(), ","));
            twn_hm.put("mayor", town.hasMayor() ? town.getMayor().getName() : "");
            twn_hm.put("nation", town.hasNation() ? town.getNation().getName() : "");
            String fstr = "";
            for (Resident assist : town.getAssistants()) {
                fstr = String.valueOf(fstr) + assist.getName() + ",";
            }
            twn_hm.put("assistants", fstr);
            twn_hm.put("townBoard", town.getTownBoard());
            twn_hm.put("tag", town.getTag());
            twn_hm.put("protectionStatus", town.getPermissions().toString());
            twn_hm.put("bonus", town.getBonusBlocks());
            twn_hm.put("purchased", town.getPurchasedBlocks());
            twn_hm.put("commercialPlotPrice", town.getCommercialPlotPrice());
            twn_hm.put("commercialPlotTax", town.getCommercialPlotTax());
            twn_hm.put("embassyPlotPrice", town.getEmbassyPlotPrice());
            twn_hm.put("embassyPlotTax", town.getEmbassyPlotTax());
            twn_hm.put("plotPrice", town.getPlotPrice());
            twn_hm.put("plotTax", town.getPlotTax());
            twn_hm.put("taxes", town.getTaxes());
            twn_hm.put("hasUpkeep", town.hasUpkeep());
            twn_hm.put("taxpercent", town.isTaxPercentage());
            twn_hm.put("open", town.isOpen());
            twn_hm.put("public", town.isPublic());
            twn_hm.put("townBlocks", this.utilSaveTownBlocks(new ArrayList<TownBlock>(town.getTownBlocks())));
            twn_hm.put("homeblock", town.hasHomeBlock() ? String.valueOf(town.getHomeBlock().getWorld().getName()) + "," + Integer.toString(town.getHomeBlock().getX()) + "," + Integer.toString(town.getHomeBlock().getZ()) : "");
            twn_hm.put("spawn", town.hasSpawn() ? String.valueOf(town.getSpawn().getWorld().getName()) + "," + Double.toString(town.getSpawn().getX()) + "," + Double.toString(town.getSpawn().getY()) + "," + Double.toString(town.getSpawn().getZ()) + "," + Float.toString(town.getSpawn().getPitch()) + "," + Float.toString(town.getSpawn().getYaw()) : "");
            if (town.hasOutpostSpawn()) {
                String outpostArray = "";
                for (Location spawn : new ArrayList<Location>(town.getAllOutpostSpawns())) {
                    outpostArray = String.valueOf(outpostArray) + spawn.getWorld().getName() + "," + Double.toString(spawn.getX()) + "," + Double.toString(spawn.getY()) + "," + Double.toString(spawn.getZ()) + "," + Float.toString(spawn.getPitch()) + "," + Float.toString(spawn.getYaw()) + ";";
                }
                twn_hm.put("outpostSpawns", outpostArray);
            }
            this.UpdateDB("TOWNS", twn_hm, Arrays.asList("name"));
            return true;
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save Town unknown error");
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public synchronized boolean saveNation(Nation nation) {
        TownyMessaging.sendDebugMsg("Saving nation " + nation.getName());
        try {
            HashMap<String, Object> nat_hm = new HashMap<String, Object>();
            nat_hm.put("name", nation.getName());
            String fstr = "";
            for (Town town : nation.getTowns()) {
                fstr = String.valueOf(fstr) + town.getName() + ",";
            }
            nat_hm.put("towns", fstr);
            nat_hm.put("capital", nation.hasCapital() ? nation.getCapital().getName() : "");
            nat_hm.put("tag", nation.hasTag() ? nation.getTag() : "");
            fstr = "";
            for (Resident assistant : nation.getAssistants()) {
                fstr = String.valueOf(fstr) + assistant.getName() + ",";
            }
            nat_hm.put("assistants", fstr);
            fstr = "";
            for (Nation allyNation : nation.getAllies()) {
                fstr = String.valueOf(fstr) + allyNation.getName() + ",";
            }
            nat_hm.put("allies", fstr);
            fstr = "";
            for (Nation enemyNation : nation.getEnemies()) {
                fstr = String.valueOf(fstr) + enemyNation.getName() + ",";
            }
            nat_hm.put("enemies", fstr);
            nat_hm.put("taxes", nation.getTaxes());
            nat_hm.put("neutral", nation.isNeutral());
            this.UpdateDB("NATIONS", nat_hm, Arrays.asList("name"));
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save Nation unknown error");
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public synchronized boolean saveWorld(TownyWorld world) {
        TownyMessaging.sendDebugMsg("Saving world " + world.getName());
        try {
            HashMap<String, Object> nat_hm = new HashMap<String, Object>();
            nat_hm.put("name", world.getName());
            String fstr = "";
            for (Town town : world.getTowns()) {
                fstr = String.valueOf(fstr) + town.getName() + ",";
            }
            nat_hm.put("towns", fstr);
            nat_hm.put("pvp", world.isPVP());
            nat_hm.put("forcepvp", world.isForcePVP());
            nat_hm.put("claimable", world.isClaimable());
            nat_hm.put("worldmobs", world.hasWorldMobs());
            nat_hm.put("forcetownmobs", world.isForceTownMobs());
            nat_hm.put("firespread", world.isFire());
            nat_hm.put("forcefirespread", world.isForceFire());
            nat_hm.put("explosions", world.isExpl());
            nat_hm.put("forceexplosions", world.isForceExpl());
            nat_hm.put("endermanprotect", world.isEndermanProtect());
            nat_hm.put("disableplayertrample", world.isDisablePlayerTrample());
            nat_hm.put("disablecreaturetrample", world.isDisableCreatureTrample());
            nat_hm.put("unclaimedZoneBuild", world.getUnclaimedZoneBuild());
            nat_hm.put("unclaimedZoneDestroy", world.getUnclaimedZoneDestroy());
            nat_hm.put("unclaimedZoneSwitch", world.getUnclaimedZoneSwitch());
            nat_hm.put("unclaimedZoneItemUse", world.getUnclaimedZoneItemUse());
            if (world.getUnclaimedZoneName() != null) {
                nat_hm.put("unclaimedZoneName", world.getUnclaimedZoneName());
            }
            if (world.getUnclaimedZoneIgnoreIds() != null) {
                nat_hm.put("unclaimedZoneIgnoreIds", StringMgmt.join(world.getUnclaimedZoneIgnoreIds(), ","));
            }
            nat_hm.put("usingPlotManagementDelete", world.isUsingPlotManagementDelete());
            if (world.getPlotManagementDeleteIds() != null) {
                nat_hm.put("plotManagementDeleteIds", StringMgmt.join(world.getPlotManagementDeleteIds(), ","));
            }
            nat_hm.put("usingPlotManagementMayorDelete", world.isUsingPlotManagementMayorDelete());
            if (world.getPlotManagementMayorDelete() != null) {
                nat_hm.put("plotManagementMayorDelete", StringMgmt.join(world.getPlotManagementMayorDelete(), ","));
            }
            nat_hm.put("usingPlotManagementRevert", world.isUsingPlotManagementRevert());
            nat_hm.put("plotManagementRevertSpeed", world.getPlotManagementRevertSpeed());
            if (world.getPlotManagementIgnoreIds() != null) {
                nat_hm.put("plotManagementIgnoreIds", StringMgmt.join(world.getPlotManagementIgnoreIds(), ","));
            }
            nat_hm.put("usingPlotManagementWildRegen", world.isUsingPlotManagementWildRevert());
            if (world.getPlotManagementWildRevertEntities() != null) {
                nat_hm.put("PlotManagementWildRegenEntities", StringMgmt.join(world.getPlotManagementWildRevertEntities(), ","));
            }
            nat_hm.put("plotManagementWildRegenSpeed", world.getPlotManagementWildRevertDelay());
            nat_hm.put("usingTowny", world.isUsingTowny());
            this.UpdateDB("WORLDS", nat_hm, Arrays.asList("name"));
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save world unknown error (" + world.getName() + ")");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean saveTownBlock(TownBlock townBlock) {
        TownyMessaging.sendDebugMsg("Saving town block " + townBlock.getWorld().getName() + ":" + townBlock.getX() + "x" + townBlock.getZ());
        try {
            HashMap<String, Object> tb_hm = new HashMap<String, Object>();
            tb_hm.put("world", townBlock.getWorld().getName());
            tb_hm.put("x", townBlock.getX());
            tb_hm.put("z", townBlock.getZ());
            tb_hm.put("permissions", townBlock.getPermissions().toString());
            tb_hm.put("locked", townBlock.isLocked());
            tb_hm.put("changed", townBlock.isChanged());
            this.UpdateDB("TOWNBLOCKS", tb_hm, Arrays.asList("world", "x", "z"));
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg("SQL: Save TownBlock unknown error");
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void deleteResident(Resident resident) {
        HashMap<String, Object> res_hm = new HashMap<String, Object>();
        res_hm.put("name", resident.getName());
        this.DeleteDB("RESIDENTS", res_hm);
    }

    @Override
    public void deleteTown(Town town) {
        HashMap<String, Object> twn_hm = new HashMap<String, Object>();
        twn_hm.put("name", town.getName());
        this.DeleteDB("TOWNS", twn_hm);
    }

    @Override
    public void deleteNation(Nation nation) {
        HashMap<String, Object> nat_hm = new HashMap<String, Object>();
        nat_hm.put("name", nation.getName());
        this.DeleteDB("NATIONS", nat_hm);
    }

    @Override
    public void deleteTownBlock(TownBlock townBlock) {
        HashMap<String, Object> twn_hm = new HashMap<String, Object>();
        twn_hm.put("world", townBlock.getWorld().getName());
        twn_hm.put("x", townBlock.getX());
        twn_hm.put("z", townBlock.getZ());
        this.DeleteDB("TOWNBLOCKS", twn_hm);
    }

    @Override
    public synchronized void backup() throws IOException {
        TownyMessaging.sendMsg("Performing backup");
        TownyMessaging.sendMsg("***** Warning *****");
        TownyMessaging.sendMsg("***** Only Snapshots and Regen files will be backed up");
        TownyMessaging.sendMsg("***** Make sure you schedule a backup in MySQL too!!!");
        String backupType = TownySettings.getFlatFileBackupType();
        if (!backupType.equalsIgnoreCase("none")) {
            TownyLogger.shutDown();
            long t = System.currentTimeMillis();
            String newBackupFolder = String.valueOf(this.rootFolder) + FileMgmt.fileSeparator() + "backup" + FileMgmt.fileSeparator() + new SimpleDateFormat("yyyy-MM-dd HH-mm").format(t) + " - " + Long.toString(t);
            FileMgmt.checkFolders(new String[]{this.rootFolder, String.valueOf(this.rootFolder) + FileMgmt.fileSeparator() + "backup"});
            if (backupType.equalsIgnoreCase("folder")) {
                FileMgmt.checkFolders(new String[]{newBackupFolder});
                FileMgmt.copyDirectory(new File(String.valueOf(this.rootFolder) + this.dataFolder), new File(newBackupFolder));
                FileMgmt.copyDirectory(new File(String.valueOf(this.rootFolder) + this.logFolder), new File(newBackupFolder));
                FileMgmt.copyDirectory(new File(String.valueOf(this.rootFolder) + this.settingsFolder), new File(newBackupFolder));
            } else if (backupType.equalsIgnoreCase("zip")) {
                FileMgmt.zipDirectories(new File[]{new File(String.valueOf(this.rootFolder) + this.dataFolder), new File(String.valueOf(this.rootFolder) + this.logFolder), new File(String.valueOf(this.rootFolder) + this.settingsFolder)}, new File(String.valueOf(newBackupFolder) + ".zip"));
            } else {
                this.plugin.setupLogger();
                throw new IOException("[Towny] Unsupported flatfile backup type (" + backupType + ")");
            }
            this.plugin.setupLogger();
        }
    }

    @Override
    public boolean saveResidentList() {
        return true;
    }

    @Override
    public boolean saveTownList() {
        return true;
    }

    @Override
    public boolean saveNationList() {
        return true;
    }

    @Override
    public boolean saveWorldList() {
        return true;
    }
}

