/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.BlockLocation;
import com.palmergames.bukkit.towny.regen.NeedsPlaceholder;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.ProtectionRegenTask;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.towny.war.flagwar.TownyWar;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;

public class TownyBlockListener
implements Listener {
    private final Towny plugin;

    public TownyBlockListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (TownySettings.getRegenDelay() <= 0L) {
            return;
        }
        Block block = event.getBlock();
        if (block == null) {
            return;
        }
        BlockLocation blockLocation = new BlockLocation(block.getLocation());
        if (TownyRegenAPI.isPlaceholder(block)) {
            TownyRegenAPI.removePlaceholder(block);
            block.setTypeId(0, false);
        }
        if (TownyRegenAPI.hasProtectionRegenTask(blockLocation)) {
            event.setCancelled(true);
        } else {
            Block blockBelow = block.getRelative(BlockFace.DOWN);
            blockLocation = new BlockLocation(blockBelow.getLocation());
            if (TownyRegenAPI.hasProtectionRegenTask(blockLocation) && NeedsPlaceholder.contains(block.getType())) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Player player = event.getPlayer();
        boolean bDestroy = PlayerCacheUtil.getCachePermission(player, (block = event.getBlock()).getLocation(), event.getBlock().getTypeId(), TownyPermission.ActionType.DESTROY);
        if (bDestroy) {
            return;
        }
        PlayerCache cache = this.plugin.getCache(player);
        if (cache.getStatus() == PlayerCache.TownBlockStatus.WARZONE) {
            if (!TownyWarConfig.isEditableMaterialInWarZone(block.getType())) {
                event.setCancelled(true);
                TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_warzone_cannot_edit_material"), "destroy", block.getType().toString().toLowerCase()));
            }
            return;
        }
        long delay = TownySettings.getRegenDelay();
        if (delay > 0L) {
            if (!TownyRegenAPI.isPlaceholder(block)) {
                if (!TownyRegenAPI.hasProtectionRegenTask(new BlockLocation(block.getLocation()))) {
                    ProtectionRegenTask task = new ProtectionRegenTask(this.plugin, block, true);
                    task.setTaskId(this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)task, 20L * delay));
                    TownyRegenAPI.addProtectionRegenTask(task);
                }
            } else {
                TownyRegenAPI.removePlaceholder(block);
                block.setTypeId(0, false);
            }
        } else {
            event.setCancelled(true);
        }
        if (cache.hasBlockErrMsg() && event.isCancelled()) {
            TownyMessaging.sendErrorMsg((Object)player, cache.getBlockErrMsg());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        try {
            TownyWorld world = TownyUniverse.getDataSource().getWorld(block.getWorld().getName());
            WorldCoord worldCoord = new WorldCoord(world.getName(), Coord.parseCoord(block));
            boolean bBuild = PlayerCacheUtil.getCachePermission(player, block.getLocation(), block.getTypeId(), TownyPermission.ActionType.BUILD);
            if (bBuild) {
                return;
            }
            PlayerCache cache = this.plugin.getCache(player);
            PlayerCache.TownBlockStatus status = cache.getStatus();
            if (status == PlayerCache.TownBlockStatus.ENEMY && TownyWarConfig.isAllowingAttacks() && event.getBlock().getType() == TownyWarConfig.getFlagBaseMaterial()) {
                try {
                    if (TownyWar.callAttackCellEvent(this.plugin, player, block, worldCoord)) {
                        return;
                    }
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
                }
                event.setBuild(false);
                event.setCancelled(true);
            } else {
                if (status == PlayerCache.TownBlockStatus.WARZONE) {
                    if (!TownyWarConfig.isEditableMaterialInWarZone(block.getType())) {
                        event.setBuild(false);
                        event.setCancelled(true);
                        TownyMessaging.sendErrorMsg((Object)player, String.format(TownySettings.getLangString("msg_err_warzone_cannot_edit_material"), "build", block.getType().toString().toLowerCase()));
                    }
                    return;
                }
                event.setBuild(false);
                event.setCancelled(true);
            }
            if (cache.hasBlockErrMsg() && event.isCancelled()) {
                TownyMessaging.sendErrorMsg((Object)player, cache.getBlockErrMsg());
            }
        }
        catch (NotRegisteredException e1) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_not_configured"));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (this.onBurn(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockIgnite(BlockIgniteEvent event) {
        if (event.isCancelled() || this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (this.onBurn(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Block block = event.getBlock();
        if (block.getType() != Material.PISTON_STICKY_BASE) {
            return;
        }
        if ((block = block.getRelative(event.getDirection()).getRelative(event.getDirection())).getType() != Material.AIR && !block.isLiquid() && this.testBlockMove(block, event.getDirection().getOppositeFace())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        List blocks = event.getBlocks();
        if (!blocks.isEmpty()) {
            for (Block block : blocks) {
                if (!this.testBlockMove(block, event.getDirection())) continue;
                event.setCancelled(true);
            }
        }
    }

    private boolean testBlockMove(Block block, BlockFace direction) {
        Block blockTo = block.getRelative(direction);
        Location loc = block.getLocation();
        Location locTo = blockTo.getLocation();
        Coord coord = Coord.parseCoord(loc);
        Coord coordTo = Coord.parseCoord(locTo);
        TownyWorld townyWorld = null;
        TownBlock CurrentTownBlock = null;
        TownBlock destinationTownBlock = null;
        try {
            townyWorld = TownyUniverse.getDataSource().getWorld(loc.getWorld().getName());
            CurrentTownBlock = townyWorld.getTownBlock(coord);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        try {
            destinationTownBlock = townyWorld.getTownBlock(coordTo);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (CurrentTownBlock != destinationTownBlock) {
            if (CurrentTownBlock == null && destinationTownBlock != null || CurrentTownBlock != null && destinationTownBlock == null) {
                return true;
            }
            if (!CurrentTownBlock.hasResident() && !destinationTownBlock.hasResident()) {
                return false;
            }
            try {
                if (!CurrentTownBlock.hasResident() && destinationTownBlock.hasResident() || CurrentTownBlock.hasResident() && !destinationTownBlock.hasResident() || CurrentTownBlock.getResident() != destinationTownBlock.getResident() || CurrentTownBlock.getPlotPrice() != -1.0 || destinationTownBlock.getPlotPrice() != -1.0) {
                    return true;
                }
            }
            catch (NotRegisteredException e) {
                return true;
            }
        }
        return false;
    }

    private boolean onBurn(Block block) {
        TownyWorld townyWorld;
        Coord coord;
        block10: {
            block11: {
                block9: {
                    Location loc = block.getLocation();
                    coord = Coord.parseCoord(loc);
                    townyWorld = TownyUniverse.getDataSource().getWorld(loc.getWorld().getName());
                    if (townyWorld.isUsingTowny()) break block9;
                    return false;
                }
                if (!townyWorld.isWarZone(coord)) break block10;
                if (!TownyWarConfig.isAllowingFireInWarZone()) break block11;
                return false;
            }
            TownyMessaging.sendDebugMsg("onBlockIgnite: Canceled " + block.getTypeId() + " from igniting within " + coord.toString() + ".");
            return true;
        }
        try {
            TownBlock townBlock = townyWorld.getTownBlock(coord);
            if (block.getRelative(BlockFace.DOWN).getType() != Material.OBSIDIAN && (!townBlock.getTown().isFire() && !townyWorld.isForceFire() && !townBlock.getPermissions().fire || TownyUniverse.isWarTime() && TownySettings.isAllowWarBlockGriefing() && !townBlock.getTown().hasNation())) {
                TownyMessaging.sendDebugMsg("onBlockIgnite: Canceled " + block.getTypeId() + " from igniting within " + coord.toString() + ".");
                return true;
            }
        }
        catch (TownyException x) {
            try {
                if (!townyWorld.isFire()) {
                    TownyMessaging.sendDebugMsg("onBlockIgnite: Canceled " + block.getTypeId() + " from igniting within " + coord.toString() + ".");
                    return true;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return false;
    }
}

