/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.BlockLocation;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.MobRemovalTimerTask;
import com.palmergames.bukkit.towny.tasks.ProtectionRegenTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import com.palmergames.bukkit.util.ArraySort;
import java.util.Collections;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.painting.PaintingBreakByEntityEvent;
import org.bukkit.event.painting.PaintingBreakEvent;
import org.bukkit.event.painting.PaintingPlaceEvent;
import org.bukkit.plugin.Plugin;

public class TownyEntityListener
implements Listener {
    private final Towny plugin;

    public TownyEntityListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Entity attacker = event.getDamager();
        if (!TownyUniverse.isWarTime() && CombatUtil.preventDamageCall(attacker, event.getEntity())) {
            if (attacker instanceof Projectile) {
                attacker.remove();
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity instanceof Monster) {
            Location loc = entity.getLocation();
            TownyWorld townyWorld = null;
            try {
                townyWorld = TownyUniverse.getDataSource().getWorld(loc.getWorld().getName());
                if (townyWorld.isUsingTowny() && townyWorld.getTownBlock(Coord.parseCoord(loc)).getType() == TownBlockType.ARENA) {
                    event.getDrops().clear();
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPotionSplashEvent(PotionSplashEvent event) {
        List affectedEntities = (List)event.getAffectedEntities();
        ThrownPotion potion = event.getPotion();
        LivingEntity attacker = potion.getShooter();
        if (!TownyUniverse.isWarTime()) {
            for (LivingEntity defender : affectedEntities) {
                if (!CombatUtil.preventDamageCall((Entity)attacker, (Entity)defender)) continue;
                event.setIntensity(defender, -1.0);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (event.getEntity() instanceof LivingEntity) {
            LivingEntity livingEntity = event.getEntity();
            Location loc = event.getLocation();
            Coord coord = Coord.parseCoord(loc);
            TownyWorld townyWorld = null;
            try {
                townyWorld = TownyUniverse.getDataSource().getWorld(loc.getWorld().getName());
            }
            catch (NotRegisteredException e) {
                return;
            }
            if (townyWorld.isUsingTowny() && !townyWorld.hasWorldMobs() && MobRemovalTimerTask.isRemovingWorldEntity(livingEntity)) {
                if (this.plugin.isCitizens2()) {
                    if (!CitizensAPI.getNPCManager().isNPC((Entity)livingEntity)) {
                        event.setCancelled(true);
                    }
                } else {
                    event.setCancelled(true);
                }
            }
            try {
                TownBlock townBlock = townyWorld.getTownBlock(coord);
                if (townyWorld.isUsingTowny() && !townyWorld.isForceTownMobs() && !townBlock.getTown().hasMobs() && !townBlock.getPermissions().mobs && MobRemovalTimerTask.isRemovingTownEntity(livingEntity)) {
                    if (this.plugin.isCitizens2()) {
                        if (!CitizensAPI.getNPCManager().isNPC((Entity)livingEntity)) {
                            event.setCancelled(true);
                        }
                    } else {
                        event.setCancelled(true);
                    }
                }
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityInteract(EntityInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Block block = event.getBlock();
        Entity entity = event.getEntity();
        try {
            TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(block.getLocation().getWorld().getName());
            if (townyWorld.isUsingTowny() && townyWorld.isDisableCreatureTrample() && (block.getType() == Material.SOIL || block.getType() == Material.CROPS)) {
                if (entity instanceof Creature) {
                    event.setCancelled(true);
                }
                return;
            }
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityChangeBlockEvent(EntityChangeBlockEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        switch (event.getEntity().getType()) {
            case ENDERMAN: {
                try {
                    TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(event.getBlock().getWorld().getName());
                    if (!townyWorld.isUsingTowny()) {
                        return;
                    }
                    if (!townyWorld.isEndermanProtect()) break;
                    event.setCancelled(true);
                    break;
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        TownyWorld townyWorld;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        try {
            townyWorld = TownyUniverse.getDataSource().getWorld(event.getLocation().getWorld().getName());
            if (!townyWorld.isUsingTowny()) {
                return;
            }
        }
        catch (NotRegisteredException e) {
            return;
        }
        List blocks = event.blockList();
        Entity entity = event.getEntity();
        int count = 0;
        Collections.sort(blocks, ArraySort.getInstance());
        for (Block block : blocks) {
            Coord coord = Coord.parseCoord(block.getLocation());
            ++count;
            if (townyWorld.isWarZone(coord)) {
                if (!TownyWarConfig.isAllowingExplosionsInWarZone()) {
                    if (event.getEntity() != null) {
                        TownyMessaging.sendDebugMsg("onEntityExplode: Canceled " + event.getEntity().getEntityId() + " from exploding within " + coord.toString() + ".");
                    }
                    event.setCancelled(true);
                    return;
                }
                if (TownyWarConfig.explosionsBreakBlocksInWarZone()) {
                    TownyWarConfig.regenBlocksAfterExplosionInWarZone();
                } else {
                    event.blockList().remove(block);
                }
                return;
            }
            try {
                TownBlock townBlock = townyWorld.getTownBlock(coord);
                if (!townyWorld.isUsingTowny() || townyWorld.isForceExpl() || townBlock.getPermissions().explosion && (!TownyUniverse.isWarTime() || !TownySettings.isAllowWarBlockGriefing() || townBlock.getTown().hasNation() || townBlock.getTown().isBANG())) continue;
                if (event.getEntity() != null) {
                    TownyMessaging.sendDebugMsg("onEntityExplode: Canceled " + event.getEntity().getEntityId() + " from exploding within " + coord.toString() + ".");
                }
                event.setCancelled(true);
                return;
            }
            catch (TownyException x) {
                if (!townyWorld.isUsingTowny()) continue;
                if (townyWorld.isExpl()) {
                    if (!townyWorld.isUsingPlotManagementWildRevert() || entity == null || !townyWorld.isProtectingExplosionEntity(entity) || TownyRegenAPI.hasProtectionRegenTask(new BlockLocation(block.getLocation())) || block.getType() == Material.TNT) continue;
                    ProtectionRegenTask task = new ProtectionRegenTask(this.plugin, block, false);
                    task.setTaskId(this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)task, (TownySettings.getPlotManagementWildRegenDelay() + (long)count) * 20L));
                    TownyRegenAPI.addProtectionRegenTask(task);
                    event.setYield(0.0f);
                    continue;
                }
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityCombustByEntityEvent(EntityCombustByEntityEvent event) {
        LivingEntity attacker;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Entity combuster = event.getCombuster();
        Entity defender = event.getEntity();
        if (combuster instanceof Projectile && (attacker = ((Projectile)combuster).getShooter()) != null && !TownyUniverse.isWarTime() && CombatUtil.preventDamageCall((Entity)attacker, defender)) {
            combuster.remove();
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPaintingBreak(PaintingBreakEvent event) {
        block12: {
            if (this.plugin.isError()) {
                event.setCancelled(true);
                return;
            }
            if (event instanceof PaintingBreakByEntityEvent) {
                PaintingBreakByEntityEvent evt = (PaintingBreakByEntityEvent)event;
                Painting painting = evt.getPainting();
                Entity remover = evt.getRemover();
                try {
                    String worldName = painting.getWorld().getName();
                    TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(worldName);
                    if (!townyWorld.isUsingTowny()) {
                        return;
                    }
                    if (remover instanceof Player) {
                        Player player = (Player)evt.getRemover();
                        boolean bDestroy = PlayerCacheUtil.getCachePermission(player, painting.getLocation(), 321, TownyPermission.ActionType.DESTROY);
                        if (bDestroy) {
                            return;
                        }
                        PlayerCache cache = this.plugin.getCache(player);
                        event.setCancelled(true);
                        if (cache.hasBlockErrMsg()) {
                            TownyMessaging.sendErrorMsg((Object)player, cache.getBlockErrMsg());
                        }
                        break block12;
                    }
                    if (!(remover instanceof Fireball) && !(remover instanceof LightningStrike)) break block12;
                    try {
                        TownBlock townBlock = new WorldCoord(worldName, Coord.parseCoord(painting.getLocation())).getTownBlock();
                        if (!townBlock.getPermissions().explosion && !townBlock.getWorld().isForceExpl()) {
                            event.setCancelled(true);
                        }
                    }
                    catch (NotRegisteredException e) {
                        if (!townyWorld.isExpl() && !townyWorld.isForceExpl()) {
                            event.setCancelled(true);
                        }
                    }
                }
                catch (NotRegisteredException e1) {
                    event.setCancelled(true);
                    return;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPaintingPlace(PaintingPlaceEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        long start = System.currentTimeMillis();
        Player player = event.getPlayer();
        Painting painting = event.getPainting();
        try {
            TownyWorld townyWorld = TownyUniverse.getDataSource().getWorld(painting.getWorld().getName());
            if (!townyWorld.isUsingTowny()) {
                return;
            }
            boolean bBuild = PlayerCacheUtil.getCachePermission(player, painting.getLocation(), 321, TownyPermission.ActionType.BUILD);
            if (bBuild) {
                return;
            }
            PlayerCache cache = this.plugin.getCache(player);
            event.setCancelled(true);
            if (cache.hasBlockErrMsg()) {
                TownyMessaging.sendErrorMsg((Object)player, cache.getBlockErrMsg());
            }
        }
        catch (NotRegisteredException e1) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_not_configured"));
            event.setCancelled(true);
            return;
        }
        TownyMessaging.sendDebugMsg("onPaintingBreak took " + (System.currentTimeMillis() - start) + "ms (" + event.getEventName() + ", " + event.isCancelled() + ")");
    }
}

