/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.towny.war.eventwar.WarSpoils;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class TownyEntityMonitorListener
implements Listener {
    private final Towny plugin;

    public TownyEntityMonitorListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity defenderEntity = event.getEntity();
        TownyWorld World2 = null;
        try {
            World2 = TownyUniverse.getDataSource().getWorld(defenderEntity.getLocation().getWorld().getName());
            if (!World2.isUsingTowny()) {
                return;
            }
        }
        catch (NotRegisteredException e) {
            return;
        }
        if (defenderEntity instanceof Player && defenderEntity.getLastDamageCause() instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent damageEvent = (EntityDamageByEntityEvent)defenderEntity.getLastDamageCause();
            Entity attackerEntity = damageEvent.getDamager();
            Player defenderPlayer = (Player)defenderEntity;
            Player attackerPlayer = null;
            Resident attackerResident = null;
            Resident defenderResident = null;
            try {
                defenderResident = TownyUniverse.getDataSource().getResident(defenderPlayer.getName());
            }
            catch (NotRegisteredException e) {
                return;
            }
            if (attackerEntity instanceof Projectile) {
                Projectile projectile = (Projectile)attackerEntity;
                if (projectile.getShooter() instanceof Player) {
                    attackerPlayer = (Player)projectile.getShooter();
                    try {
                        attackerResident = TownyUniverse.getDataSource().getResident(attackerPlayer.getName());
                    }
                    catch (NotRegisteredException notRegisteredException) {}
                }
            } else if (attackerEntity instanceof Player) {
                attackerPlayer = (Player)attackerEntity;
                try {
                    attackerResident = TownyUniverse.getDataSource().getResident(attackerPlayer.getName());
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
            this.deathPayment(attackerPlayer, defenderPlayer, attackerResident, defenderResident);
            this.wartimeDeathPoints(attackerPlayer, defenderPlayer, attackerResident, defenderResident);
            if (TownySettings.isRemovingOnMonarchDeath()) {
                this.monarchDeath(attackerPlayer, defenderPlayer, attackerResident, defenderResident);
            }
        }
    }

    private void wartimeDeathPoints(Player attackerPlayer, Player defenderPlayer, Resident attackerResident, Resident defenderResident) {
        if (attackerPlayer != null && defenderPlayer != null && TownyUniverse.isWarTime()) {
            try {
                if (CombatUtil.isAlly(attackerPlayer.getName(), defenderPlayer.getName())) {
                    return;
                }
                if (TownySettings.getWarPointsForKill() > 0) {
                    this.plugin.getTownyUniverse().getWarEvent().townScored(attackerResident.getTown(), TownySettings.getWarPointsForKill());
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    private void monarchDeath(Player attackerPlayer, Player defenderPlayer, Resident attackerResident, Resident defenderResident) {
        if (TownyUniverse.isWarTime()) {
            War warEvent = this.plugin.getTownyUniverse().getWarEvent();
            try {
                Nation defenderNation = defenderResident.getTown().getNation();
                if (warEvent.isWarringNation(defenderNation) && defenderResident.isMayor()) {
                    if (defenderResident.isKing()) {
                        if (attackerResident != null && attackerResident.hasTown()) {
                            warEvent.remove(attackerResident.getTown(), defenderNation);
                        } else {
                            warEvent.remove(defenderNation);
                        }
                        TownyMessaging.sendGlobalMessage(String.valueOf(defenderNation.getName()) + "'s king was killed. Nation removed from war.");
                    } else {
                        if (attackerResident != null && attackerResident.hasTown()) {
                            warEvent.remove(attackerResident.getTown(), defenderResident.getTown());
                        } else {
                            warEvent.remove(defenderResident.getTown());
                        }
                        TownyMessaging.sendGlobalMessage(defenderResident.getTown() + "'s mayor was killed. Town removed from war.");
                    }
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    public void deathPayment(Player attackerPlayer, Player defenderPlayer, Resident attackerResident, Resident defenderResident) {
        if (attackerPlayer != null && TownyUniverse.isWarTime() && TownySettings.getWartimeDeathPrice() > 0.0) {
            try {
                if (attackerResident == null) {
                    throw new NotRegisteredException(String.format("The attackingResident %s has not been registered.", attackerPlayer.getName()));
                }
                double price = TownySettings.getWartimeDeathPrice();
                double townPrice = 0.0;
                if (!defenderResident.canPayFromHoldings(price)) {
                    townPrice = price - defenderResident.getHoldingBalance();
                    price = defenderResident.getHoldingBalance();
                }
                if (price > 0.0) {
                    defenderResident.payTo(price, attackerResident, "Death Payment (War)");
                    TownyMessaging.sendMsg((Object)attackerPlayer, "You robbed " + defenderResident.getName() + " of " + TownyEconomyHandler.getFormattedBalance(price) + ".");
                    TownyMessaging.sendMsg((Object)defenderPlayer, String.valueOf(attackerResident.getName()) + " robbed you of " + TownyEconomyHandler.getFormattedBalance(price) + ".");
                }
                if (townPrice > 0.0) {
                    Town town = defenderResident.getTown();
                    if (!town.canPayFromHoldings(townPrice)) {
                        townPrice = town.getHoldingBalance();
                        try {
                            this.plugin.getTownyUniverse().getWarEvent().remove(attackerResident.getTown(), town);
                        }
                        catch (NotRegisteredException e) {
                            this.plugin.getTownyUniverse().getWarEvent().remove(town);
                        }
                    } else {
                        TownyMessaging.sendTownMessage(town, String.valueOf(defenderResident.getName()) + "'s wallet couldn't satisfy " + attackerResident.getName() + ". " + townPrice + " taken from town bank.");
                    }
                    town.payTo(townPrice, attackerResident, String.format("Death Payment (War) (%s couldn't pay)", defenderResident.getName()));
                }
            }
            catch (NotRegisteredException price) {
            }
            catch (EconomyException e) {
                TownyMessaging.sendErrorMsg((Object)attackerPlayer, "Could not take wartime death funds.");
                TownyMessaging.sendErrorMsg((Object)defenderPlayer, "Could not take wartime death funds.");
            }
        } else if (TownySettings.getDeathPrice() > 0.0) {
            try {
                double price = TownySettings.getDeathPrice();
                if (!defenderResident.canPayFromHoldings(price)) {
                    price = defenderResident.getHoldingBalance();
                }
                defenderResident.payTo(price, new WarSpoils(), "Death Payment");
                TownyMessaging.sendMsg((Object)defenderPlayer, "You lost " + TownyEconomyHandler.getFormattedBalance(price) + ".");
            }
            catch (EconomyException e) {
                TownyMessaging.sendErrorMsg((Object)defenderPlayer, "Could not take death funds.");
            }
        }
    }
}

