/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.event.PlayerChangePlotEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.regen.BlockLocation;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.material.Attachable;

public class TownyPlayerListener
implements Listener {
    private final Towny plugin;

    public TownyPlayerListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.isError()) {
            player.sendMessage("\u00a7c[Towny Error] Locked in Safe mode!");
            return;
        }
        try {
            this.plugin.getTownyUniverse().onLogin(player);
        }
        catch (TownyException x) {
            TownyMessaging.sendErrorMsg((Object)player, x.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        this.plugin.getTownyUniverse().onLogout(event.getPlayer());
        try {
            if (TownyTimerHandler.isTeleportWarmupRunning()) {
                this.plugin.getTownyUniverse().abortTeleportRequest(TownyUniverse.getDataSource().getResident(event.getPlayer().getName().toLowerCase()));
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.plugin.deleteCache(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        Player player = event.getPlayer();
        TownyMessaging.sendDebugMsg("onPlayerDeath: " + player.getName());
        if (!TownySettings.isTownRespawning()) {
            return;
        }
        try {
            Location respawn = this.plugin.getTownyUniverse().getTownSpawnLocation(player);
            if (TownySettings.isTownRespawningInOtherWorlds() && !player.getWorld().equals(respawn.getWorld())) {
                return;
            }
            event.setRespawnLocation(respawn);
        }
        catch (TownyException townyException) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (event.isCancelled()) {
            Integer item;
            if (event.getAction() == Action.RIGHT_CLICK_AIR && ((item = Integer.valueOf(event.getPlayer().getItemInHand().getTypeId())) == 326 || item == 327 || item == 259 || item >= 8 && item <= 11 || item == 51)) {
                event.setCancelled(true);
            }
            return;
        }
        Block block = event.getPlayer().getLocation().getBlock().getRelative(BlockFace.DOWN);
        TownyWorld World2 = null;
        try {
            World2 = TownyUniverse.getDataSource().getWorld(block.getLocation().getWorld().getName());
            if (!World2.isUsingTowny()) {
                return;
            }
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
            return;
        }
        if (event.getAction() == Action.PHYSICAL && (block.getType() == Material.SOIL || block.getType() == Material.CROPS) && World2.isDisablePlayerTrample()) {
            event.setCancelled(true);
            return;
        }
        if (event.hasItem() && TownySettings.isItemUseId(event.getItem().getTypeId())) {
            this.onPlayerInteractEvent(event);
            return;
        }
        if (event.getClickedBlock() != null) {
            if (TownySettings.getRegenDelay() > 0L && event.getClickedBlock().getState().getData() instanceof Attachable) {
                Attachable attachable = (Attachable)event.getClickedBlock().getState().getData();
                BlockLocation attachedToBlock = new BlockLocation(event.getClickedBlock().getRelative(attachable.getAttachedFace()).getLocation());
                if (TownyRegenAPI.hasProtectionRegenTask(attachedToBlock)) {
                    event.setCancelled(true);
                    return;
                }
            }
            if (TownySettings.isSwitchId(event.getClickedBlock().getTypeId()) || event.getAction() == Action.PHYSICAL) {
                this.onPlayerSwitchEvent(event, null, World2);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Location from;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockZ() == event.getTo().getBlockZ() && event.getFrom().getBlockY() == event.getTo().getBlockY()) {
            return;
        }
        Player player = event.getPlayer();
        Location to = event.getTo();
        PlayerCache cache = this.plugin.getCache(player);
        try {
            from = cache.getLastLocation();
        }
        catch (NullPointerException e) {
            from = event.getFrom();
        }
        if (!(event instanceof PlayerTeleportEvent) && TownySettings.isUsingCheatProtection() && player.getGameMode() != GameMode.CREATIVE && !TownyUniverse.getPermissionSource().has(player, PermissionNodes.CHEAT_BYPASS.getNode())) {
            try {
                if (TownyUniverse.getDataSource().getWorld(player.getWorld().getName()).isUsingTowny() && from.getBlock().getRelative(BlockFace.DOWN).getType() == Material.AIR && player.getFallDistance() == 0.0f && player.getVelocity().getY() <= -0.6 && player.getLocation().getY() > 0.0) {
                    Location blockLocation = from;
                    while (blockLocation.getBlock().getType() == Material.AIR && blockLocation.getY() > 0.0) {
                        blockLocation.setY(blockLocation.getY() - 1.0);
                    }
                    blockLocation.setY(blockLocation.getY() + 1.0);
                    cache.setLastLocation(blockLocation);
                    player.teleport(blockLocation);
                    return;
                }
            }
            catch (NotRegisteredException e1) {
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_not_configured"));
                return;
            }
        }
        try {
            TownyWorld fromWorld = TownyUniverse.getDataSource().getWorld(from.getWorld().getName());
            WorldCoord fromCoord = new WorldCoord(fromWorld.getName(), Coord.parseCoord(from));
            TownyWorld toWorld = TownyUniverse.getDataSource().getWorld(to.getWorld().getName());
            WorldCoord toCoord = new WorldCoord(toWorld.getName(), Coord.parseCoord(to));
            if (!fromCoord.equals(toCoord)) {
                this.onPlayerMoveChunk(player, fromCoord, toCoord, from, to);
            }
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
        cache.setLastLocation(to);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        this.onPlayerMove((PlayerMoveEvent)event);
    }

    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        try {
            String worldName = player.getWorld().getName();
            WorldCoord worldCoord = block != null ? new WorldCoord(worldName, Coord.parseCoord(block)) : new WorldCoord(worldName, Coord.parseCoord((Entity)player));
            boolean bItemUse = block != null ? PlayerCacheUtil.getCachePermission(player, block.getLocation(), block.getTypeId(), TownyPermission.ActionType.ITEM_USE) : PlayerCacheUtil.getCachePermission(player, player.getLocation(), event.getItem().getTypeId(), TownyPermission.ActionType.ITEM_USE);
            boolean wildOverride = TownyUniverse.getPermissionSource().hasWildOverride(worldCoord.getTownyWorld(), player, event.getItem().getTypeId(), TownyPermission.ActionType.ITEM_USE);
            PlayerCache cache = this.plugin.getCache(player);
            try {
                PlayerCache.TownBlockStatus status = cache.getStatus();
                if (status == PlayerCache.TownBlockStatus.UNCLAIMED_ZONE && wildOverride) {
                    return;
                }
                if (status == PlayerCache.TownBlockStatus.TOWN_RESIDENT && TownyUniverse.getPermissionSource().hasOwnTownOverride(player, event.getItem().getTypeId(), TownyPermission.ActionType.ITEM_USE) || (status == PlayerCache.TownBlockStatus.OUTSIDER || status == PlayerCache.TownBlockStatus.TOWN_ALLY || status == PlayerCache.TownBlockStatus.ENEMY) && TownyUniverse.getPermissionSource().hasAllTownOverride(player, event.getItem().getTypeId(), TownyPermission.ActionType.ITEM_USE)) {
                    return;
                }
                if (status == PlayerCache.TownBlockStatus.WARZONE) {
                    if (!TownyWarConfig.isAllowingItemUseInWarZone()) {
                        event.setCancelled(true);
                        TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_warzone_cannot_use_item"));
                    }
                    return;
                }
                if (status == PlayerCache.TownBlockStatus.UNCLAIMED_ZONE && !wildOverride || !bItemUse && status != PlayerCache.TownBlockStatus.UNCLAIMED_ZONE) {
                    event.setCancelled(true);
                }
                if (cache.hasBlockErrMsg()) {
                    TownyMessaging.sendErrorMsg((Object)player, cache.getBlockErrMsg());
                }
            }
            catch (NullPointerException e) {
                System.out.print("NPE generated!");
                System.out.print("Player: " + event.getPlayer().getName());
                System.out.print("Item: " + event.getItem().getType().toString());
            }
        }
        catch (NotRegisteredException e1) {
            TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_not_configured"));
            event.setCancelled(true);
            return;
        }
    }

    public void onPlayerSwitchEvent(PlayerInteractEvent event, String errMsg, TownyWorld world) {
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (!TownySettings.isSwitchId(block.getTypeId())) {
            return;
        }
        boolean bSwitch = PlayerCacheUtil.getCachePermission(player, block.getLocation(), block.getTypeId(), TownyPermission.ActionType.SWITCH);
        if (bSwitch) {
            return;
        }
        PlayerCache cache = this.plugin.getCache(player);
        PlayerCache.TownBlockStatus status = cache.getStatus();
        if (status == PlayerCache.TownBlockStatus.WARZONE) {
            if (!TownyWarConfig.isAllowingSwitchesInWarZone()) {
                event.setCancelled(true);
                TownyMessaging.sendErrorMsg((Object)player, TownySettings.getLangString("msg_err_warzone_cannot_use_switches"));
            }
            return;
        }
        event.setCancelled(true);
        if (cache.hasBlockErrMsg()) {
            TownyMessaging.sendErrorMsg((Object)player, cache.getBlockErrMsg());
        }
    }

    public void onPlayerMoveChunk(Player player, WorldCoord from, WorldCoord to, Location fromLoc, Location toLoc) {
        this.plugin.getCache(player).setLastLocation(toLoc);
        this.plugin.getCache(player).updateCoord(to);
        PlayerChangePlotEvent event = new PlayerChangePlotEvent(player, from, to);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }
}

