/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;

public class TownyWorldListener
implements Listener {
    public TownyWorldListener(Towny instance) {
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onWorldLoad(WorldLoadEvent event) {
        this.newWorld(event.getWorld().getName());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onWorldInit(WorldInitEvent event) {
        this.newWorld(event.getWorld().getName());
    }

    private void newWorld(String worldName) {
        try {
            TownyUniverse.getDataSource().newWorld(worldName);
            TownyWorld world = TownyUniverse.getDataSource().getWorld(worldName);
            if (world == null) {
                TownyMessaging.sendErrorMsg("Could not create data for " + worldName);
            } else if (!TownyUniverse.getDataSource().loadWorld(world)) {
                TownyUniverse.getDataSource().saveWorld(world);
            }
        }
        catch (AlreadyRegisteredException world) {
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendErrorMsg("Could not create data for " + worldName);
            e.printStackTrace();
        }
    }
}

