/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.util.DrawUtil;
import com.palmergames.bukkit.util.LocationRunnable;
import java.util.Arrays;
import org.bukkit.World;

public class CellBorder
extends WorldCoord {
    public boolean[] border;

    public CellBorder(WorldCoord worldCoord, boolean[] border) {
        super(worldCoord);
        this.border = border;
    }

    public void setBorderAt(Section s, boolean b) {
        this.border[s.ordinal()] = b;
    }

    public boolean hasBorderAt(Section s) {
        return this.border[s.ordinal()];
    }

    public boolean[] getBorder() {
        return this.border;
    }

    public boolean hasAnyBorder() {
        boolean[] blArray = this.border;
        int n = this.border.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b = blArray[n2];
            if (b) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getBlockX() {
        return this.getX() * CellBorder.getCellSize();
    }

    public int getBlockZ() {
        return this.getZ() * CellBorder.getCellSize();
    }

    public void runBorderedOnSurface(int wallHeight, int cornerHeight, LocationRunnable runnable) {
        int x = this.getBlockX();
        int z = this.getBlockZ();
        int w = Coord.getCellSize() - 1;
        World world = this.getBukkitWorld();
        Section[] sectionArray = Section.values();
        int n = sectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Section section = sectionArray[n2];
            if (this.border[section.ordinal()] && (section.getType() == Section.Type.WALL && wallHeight > 0 || section.getType() == Section.Type.CORNER && cornerHeight > 0)) {
                switch (section) {
                    case N: {
                        DrawUtil.runOnSurface(world, x, z, x, z + w, wallHeight, runnable);
                        break;
                    }
                    case NE: {
                        DrawUtil.runOnSurface(world, x, z, x, z, cornerHeight, runnable);
                        break;
                    }
                    case E: {
                        DrawUtil.runOnSurface(world, x, z, x + w, z, wallHeight, runnable);
                        break;
                    }
                    case SE: {
                        DrawUtil.runOnSurface(world, x + w, z, x + w, z, cornerHeight, runnable);
                        break;
                    }
                    case S: {
                        DrawUtil.runOnSurface(world, x + w, z, x + w, z + w, wallHeight, runnable);
                        break;
                    }
                    case SW: {
                        DrawUtil.runOnSurface(world, x + w, z + w, x + w, z + w, cornerHeight, runnable);
                        break;
                    }
                    case W: {
                        DrawUtil.runOnSurface(world, x, z + w, x + w, z + w, wallHeight, runnable);
                        break;
                    }
                    case NW: {
                        DrawUtil.runOnSurface(world, x, z + w, x, z + w, cornerHeight, runnable);
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + Arrays.toString(this.getBorder());
    }

    public static enum Section {
        N(Type.WALL),
        NE(Type.CORNER),
        E(Type.WALL),
        SE(Type.CORNER),
        S(Type.WALL),
        SW(Type.CORNER),
        W(Type.WALL),
        NW(Type.CORNER);

        private Type type;

        private Section(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public static int numParts() {
            return Section.values().length;
        }

        public static enum Type {
            WALL,
            CORNER;

        }
    }
}

