/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;

public class Coord {
    protected static int cellSize = 16;
    protected int x;
    protected int z;

    public Coord(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public Coord(Coord coord) {
        this.x = coord.getX();
        this.z = coord.getZ();
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public Coord add(int xOffset, int zOffset) {
        return new Coord(this.getX() + xOffset, this.getZ() + zOffset);
    }

    public int hashCode() {
        int result = 17;
        result = 27 * result + this.x;
        result = 27 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Coord)) {
            return false;
        }
        Coord o = (Coord)obj;
        return this.x == o.x && this.z == o.z;
    }

    public static Coord parseCoord(int x, int z) {
        int xresult = x / Coord.getCellSize();
        int zresult = z / Coord.getCellSize();
        boolean xneedfix = x % Coord.getCellSize() != 0;
        boolean zneedfix = z % Coord.getCellSize() != 0;
        return new Coord(xresult - (x < 0 && xneedfix ? 1 : 0), zresult - (z < 0 && zneedfix ? 1 : 0));
    }

    public static Coord parseCoord(Entity entity) {
        return Coord.parseCoord(entity.getLocation());
    }

    public static Coord parseCoord(Location loc) {
        return Coord.parseCoord(loc.getBlockX(), loc.getBlockZ());
    }

    public static Coord parseCoord(Block block) {
        return Coord.parseCoord(block.getX(), block.getZ());
    }

    public String toString() {
        return String.valueOf(this.getX()) + "," + this.getZ();
    }

    public static void setCellSize(int cellSize) {
        Coord.cellSize = cellSize;
    }

    public static int getCellSize() {
        return cellSize;
    }
}

