/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import com.palmergames.bukkit.towny.war.flagwar.TownyWar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Nation
extends TownyEconomyObject
implements ResidentList {
    private List<Resident> assistants = new ArrayList<Resident>();
    private List<Town> towns = new ArrayList<Town>();
    private List<Nation> allies = new ArrayList<Nation>();
    private List<Nation> enemies = new ArrayList<Nation>();
    private Town capital;
    private double taxes;
    private boolean neutral = false;
    private String tag;

    public Nation(String name) {
        this.setName(name);
        this.tag = "";
    }

    public void setTag(String text) throws TownyException {
        if (text.length() > 4) {
            throw new TownyException("Tag too long");
        }
        this.tag = text.toUpperCase();
        if (this.tag.matches(" ")) {
            this.tag = "";
        }
        this.setChangedName(true);
    }

    public String getTag() {
        return this.tag;
    }

    public boolean hasTag() {
        return !this.tag.isEmpty();
    }

    public void addAlly(Nation nation) throws AlreadyRegisteredException {
        if (this.hasAlly(nation)) {
            throw new AlreadyRegisteredException();
        }
        try {
            this.removeEnemy(nation);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.getAllies().add(nation);
    }

    public boolean removeAlly(Nation nation) throws NotRegisteredException {
        if (!this.hasAlly(nation)) {
            throw new NotRegisteredException();
        }
        return this.getAllies().remove(nation);
    }

    public boolean removeAllAllies() {
        for (Nation ally : new ArrayList<Nation>(this.getAllies())) {
            try {
                this.removeAlly(ally);
                ally.removeAlly(this);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return this.getAllies().size() == 0;
    }

    public boolean hasAlly(Nation nation) {
        return this.getAllies().contains(nation);
    }

    public void addEnemy(Nation nation) throws AlreadyRegisteredException {
        if (this.hasEnemy(nation)) {
            throw new AlreadyRegisteredException();
        }
        try {
            this.removeAlly(nation);
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.getEnemies().add(nation);
    }

    public boolean removeEnemy(Nation nation) throws NotRegisteredException {
        if (!this.hasEnemy(nation)) {
            throw new NotRegisteredException();
        }
        return this.getEnemies().remove(nation);
    }

    public boolean removeAllEnemies() {
        for (Nation enemy : new ArrayList<Nation>(this.getEnemies())) {
            try {
                this.removeEnemy(enemy);
                enemy.removeEnemy(this);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return this.getAllies().size() == 0;
    }

    public boolean hasEnemy(Nation nation) {
        return this.getEnemies().contains(nation);
    }

    public List<Town> getTowns() {
        return this.towns;
    }

    public boolean isKing(Resident resident) {
        return this.hasCapital() ? this.getCapital().isMayor(resident) : false;
    }

    public boolean hasCapital() {
        return this.getCapital() != null;
    }

    public boolean hasAssistant(Resident resident) {
        return this.getAssistants().contains(resident);
    }

    public boolean isCapital(Town town) {
        return town == this.getCapital();
    }

    public boolean hasTown(String name) {
        for (Town town : this.towns) {
            if (!town.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTown(Town town) {
        return this.towns.contains(town);
    }

    public void addTown(Town town) throws AlreadyRegisteredException {
        if (this.hasTown(town)) {
            throw new AlreadyRegisteredException();
        }
        if (town.hasNation()) {
            throw new AlreadyRegisteredException();
        }
        this.towns.add(town);
        town.setNation(this);
    }

    public void addAssistant(Resident resident) throws AlreadyRegisteredException {
        if (this.hasAssistant(resident)) {
            throw new AlreadyRegisteredException();
        }
        this.getAssistants().add(resident);
    }

    public void removeAssistant(Resident resident) throws NotRegisteredException {
        if (!this.hasAssistant(resident)) {
            throw new NotRegisteredException();
        }
        this.assistants.remove(resident);
    }

    public void setCapital(Town capital) {
        this.capital = capital;
    }

    public Town getCapital() {
        return this.capital;
    }

    public boolean setAliegeance(String type, Nation nation) {
        block10: {
            block9: {
                if (!type.equalsIgnoreCase("ally")) break block9;
                this.removeEnemy(nation);
                this.addAlly(nation);
                if (!this.hasEnemy(nation) && this.hasAlly(nation)) {
                    return true;
                }
            }
            if (!type.equalsIgnoreCase("neutral")) break block10;
            this.removeEnemy(nation);
            this.removeAlly(nation);
            if (!this.hasEnemy(nation) && !this.hasAlly(nation)) {
                return true;
            }
        }
        try {
            if (type.equalsIgnoreCase("enemy")) {
                this.removeAlly(nation);
                this.addEnemy(nation);
                if (this.hasEnemy(nation) && !this.hasAlly(nation)) {
                    return true;
                }
            }
        }
        catch (AlreadyRegisteredException x) {
            return false;
        }
        catch (NotRegisteredException e) {
            return false;
        }
        return false;
    }

    public void setAssistants(List<Resident> assistants) {
        this.assistants = assistants;
    }

    public List<Resident> getAssistants() {
        return this.assistants;
    }

    public void setEnemies(List<Nation> enemies) {
        this.enemies = enemies;
    }

    public List<Nation> getEnemies() {
        return this.enemies;
    }

    public void setAllies(List<Nation> allies) {
        this.allies = allies;
    }

    public List<Nation> getAllies() {
        return this.allies;
    }

    public int getNumTowns() {
        return this.towns.size();
    }

    public int getNumResidents() {
        int numResidents = 0;
        for (Town town : this.getTowns()) {
            numResidents += town.getNumResidents();
        }
        return numResidents;
    }

    public void removeTown(Town town) throws EmptyNationException, NotRegisteredException {
        if (!this.hasTown(town)) {
            throw new NotRegisteredException();
        }
        boolean isCapital = town.isCapital();
        this.remove(town);
        if (this.getNumTowns() == 0) {
            throw new EmptyNationException(this);
        }
        if (isCapital) {
            int numResidents = 0;
            Town tempCapital = null;
            for (Town newCapital : this.getTowns()) {
                if (newCapital.getNumResidents() <= numResidents) continue;
                tempCapital = newCapital;
                numResidents = newCapital.getNumResidents();
            }
            if (tempCapital != null) {
                this.setCapital(tempCapital);
            }
        }
    }

    private void remove(Town town) {
        this.removeAssistantsIn(town);
        try {
            town.setNation(null);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        this.towns.remove(town);
    }

    private void removeAllTowns() {
        for (Town town : new ArrayList<Town>(this.towns)) {
            this.remove(town);
        }
    }

    public boolean hasAssistantIn(Town town) {
        for (Resident resident : town.getResidents()) {
            if (!this.hasAssistant(resident)) continue;
            return true;
        }
        return false;
    }

    private void removeAssistantsIn(Town town) {
        for (Resident resident : new ArrayList<Resident>(town.getResidents())) {
            if (!this.hasAssistant(resident)) continue;
            try {
                this.removeAssistant(resident);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    public void setTaxes(double taxes) {
        this.taxes = taxes > TownySettings.getMaxTax() ? TownySettings.getMaxTax() : taxes;
    }

    public double getTaxes() {
        this.setTaxes(this.taxes);
        return this.taxes;
    }

    public void clear() {
        this.removeAllAllies();
        this.removeAllEnemies();
        this.removeAllTowns();
        this.capital = null;
        this.assistants.clear();
    }

    public void setNeutral(boolean neutral) throws TownyException {
        if (!TownySettings.isDeclaringNeutral() && neutral) {
            throw new TownyException(TownySettings.getLangString("msg_err_fight_like_king"));
        }
        if (neutral) {
            for (Resident resident : this.getResidents()) {
                TownyWar.removeAttackerFlags(resident.getName());
            }
        }
        this.neutral = neutral;
    }

    public boolean isNeutral() {
        return this.neutral;
    }

    public void setKing(Resident king) throws TownyException {
        if (!this.hasResident(king)) {
            throw new TownyException(TownySettings.getLangString("msg_err_king_not_in_nation"));
        }
        if (!king.isMayor()) {
            throw new TownyException(TownySettings.getLangString("msg_err_new_king_notmayor"));
        }
        this.setCapital(king.getTown());
    }

    public boolean hasResident(Resident resident) {
        for (Town town : this.getTowns()) {
            if (!town.hasResident(resident)) continue;
            return true;
        }
        return false;
    }

    public void withdrawFromBank(Resident resident, int amount) throws EconomyException, TownyException {
        if (!this.isKing(resident) && !this.hasAssistant(resident)) {
            throw new TownyException(TownySettings.getLangString("msg_no_access_nation_bank"));
        }
        if (TownySettings.isUsingEconomy()) {
            if (!this.payTo(amount, resident, "Nation Withdraw")) {
                throw new TownyException(TownySettings.getLangString("msg_err_no_money"));
            }
        } else {
            throw new TownyException(TownySettings.getLangString("msg_err_no_economy"));
        }
    }

    @Override
    public List<Resident> getResidents() {
        ArrayList<Resident> out = new ArrayList<Resident>();
        for (Town town : this.getTowns()) {
            out.addAll(town.getResidents());
        }
        return out;
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(String.valueOf(this.getTreeDepth(depth)) + "Nation (" + this.getName() + ")");
        out.add(String.valueOf(this.getTreeDepth(depth + 1)) + "Capital: " + this.getCapital().getName());
        if (this.getAssistants().size() > 0) {
            out.add(String.valueOf(this.getTreeDepth(depth + 1)) + "Assistants (" + this.getAssistants().size() + "): " + Arrays.toString(this.getAssistants().toArray(new Resident[0])));
        }
        if (this.getAllies().size() > 0) {
            out.add(String.valueOf(this.getTreeDepth(depth + 1)) + "Allies (" + this.getAllies().size() + "): " + Arrays.toString(this.getAllies().toArray(new Nation[0])));
        }
        if (this.getEnemies().size() > 0) {
            out.add(String.valueOf(this.getTreeDepth(depth + 1)) + "Enemies (" + this.getEnemies().size() + "): " + Arrays.toString(this.getEnemies().toArray(new Nation[0])));
        }
        out.add(String.valueOf(this.getTreeDepth(depth + 1)) + "Towns (" + this.getTowns().size() + "):");
        for (Town town : this.getTowns()) {
            out.addAll(town.getTreeString(depth + 2));
        }
        return out;
    }

    @Override
    public boolean hasResident(String name) {
        for (Town town : this.getTowns()) {
            if (!town.hasResident(name)) continue;
            return true;
        }
        return false;
    }
}

