/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlayerCache {
    private Map<Integer, Boolean> buildPermission = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> destroyPermission = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> switchPermission = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> itemUsePermission = new HashMap<Integer, Boolean>();
    private WorldCoord lastWorldCoord;
    private String blockErrMsg;
    private Location lastLocation;
    private TownBlockStatus townBlockStatus = TownBlockStatus.UNKOWN;

    public PlayerCache(TownyWorld world, Player player) {
        this(new WorldCoord(world.getName(), Coord.parseCoord((Entity)player)));
        this.setLastLocation(player.getLocation());
    }

    public PlayerCache(WorldCoord worldCoord) {
        this.setLastTownBlock(worldCoord);
    }

    public void setLastTownBlock(WorldCoord worldCoord) {
        this.lastWorldCoord = worldCoord;
    }

    public void resetAndUpdate(WorldCoord worldCoord) {
        this.reset();
        this.setLastTownBlock(worldCoord);
    }

    public WorldCoord getLastTownBlock() {
        return this.lastWorldCoord;
    }

    public boolean updateCoord(WorldCoord pos) {
        if (!this.getLastTownBlock().equals(pos)) {
            this.reset();
            this.setLastTownBlock(pos);
            return true;
        }
        return false;
    }

    public boolean getCachePermission(Integer id, TownyPermission.ActionType action) throws NullPointerException {
        switch (action) {
            case BUILD: {
                if (!this.buildPermission.containsKey(id)) {
                    throw new NullPointerException();
                }
                return this.buildPermission.get(id);
            }
            case DESTROY: {
                if (!this.destroyPermission.containsKey(id)) {
                    throw new NullPointerException();
                }
                return this.destroyPermission.get(id);
            }
            case SWITCH: {
                if (!this.switchPermission.containsKey(id)) {
                    throw new NullPointerException();
                }
                return this.switchPermission.get(id);
            }
            case ITEM_USE: {
                if (!this.itemUsePermission.containsKey(id)) {
                    throw new NullPointerException();
                }
                return this.itemUsePermission.get(id);
            }
        }
        throw new NullPointerException();
    }

    public void setBuildPermission(Integer id, Boolean value) {
        this.buildPermission.put(id, value);
    }

    public boolean getBuildPermission(Integer id) throws NullPointerException {
        if (!this.buildPermission.containsKey(id)) {
            throw new NullPointerException();
        }
        return this.buildPermission.get(id);
    }

    public void setDestroyPermission(Integer id, Boolean value) {
        this.destroyPermission.put(id, value);
    }

    public boolean getDestroyPermission(Integer id) throws NullPointerException {
        if (!this.destroyPermission.containsKey(id)) {
            throw new NullPointerException();
        }
        return this.destroyPermission.get(id);
    }

    public void setSwitchPermission(Integer id, Boolean value) {
        this.switchPermission.put(id, value);
    }

    public boolean getSwitchPermission(Integer id) throws NullPointerException {
        if (!this.switchPermission.containsKey(id)) {
            throw new NullPointerException();
        }
        return this.switchPermission.get(id);
    }

    public void setItemUsePermission(Integer id, Boolean value) {
        this.itemUsePermission.put(id, value);
    }

    public Boolean getItemUsePermission(Integer id) throws NullPointerException {
        if (!this.itemUsePermission.containsKey(id)) {
            throw new NullPointerException();
        }
        return this.itemUsePermission.get(id);
    }

    private void reset() {
        this.lastWorldCoord = null;
        this.townBlockStatus = null;
        this.blockErrMsg = null;
        this.buildPermission = new HashMap<Integer, Boolean>();
        this.destroyPermission = new HashMap<Integer, Boolean>();
        this.switchPermission = new HashMap<Integer, Boolean>();
        this.itemUsePermission = new HashMap<Integer, Boolean>();
    }

    public void setStatus(TownBlockStatus townBlockStatus) {
        this.townBlockStatus = townBlockStatus;
    }

    public TownBlockStatus getStatus() throws NullPointerException {
        if (this.townBlockStatus == null) {
            throw new NullPointerException();
        }
        return this.townBlockStatus;
    }

    public void setBlockErrMsg(String blockErrMsg) {
        this.blockErrMsg = blockErrMsg;
    }

    public String getBlockErrMsg() {
        String temp = this.blockErrMsg;
        this.setBlockErrMsg(null);
        return temp;
    }

    public boolean hasBlockErrMsg() {
        return this.blockErrMsg != null;
    }

    public void setLastLocation(Location lastLocation) {
        this.lastLocation = lastLocation.clone();
    }

    public Location getLastLocation() throws NullPointerException {
        if (this.lastLocation == null) {
            throw new NullPointerException();
        }
        return this.lastLocation;
    }

    public static enum TownBlockStatus {
        UNKOWN,
        NOT_REGISTERED,
        OFF_WORLD,
        ADMIN,
        UNCLAIMED_ZONE,
        LOCKED,
        WARZONE,
        OUTSIDER,
        PLOT_OWNER,
        PLOT_FRIEND,
        PLOT_ALLY,
        TOWN_OWNER,
        TOWN_RESIDENT,
        TOWN_ALLY,
        ENEMY;

    }
}

