/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.ResidentModes;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.SetDefaultModes;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;

public class Resident
extends TownBlockOwner
implements ResidentModes {
    private List<Resident> friends = new ArrayList<Resident>();
    private List<ChunkSnapshot> regenUndo = new ArrayList<ChunkSnapshot>();
    private Town town;
    private long lastOnline;
    private long registered;
    private boolean isNPC = false;
    private String title;
    private String surname;
    private long teleportRequestTime;
    private Location teleportDestination;
    private double teleportCost;
    private String chatFormattedName;
    private List<String> modes = new ArrayList<String>();

    public Resident(String name) {
        this.setChatFormattedName(name);
        this.setName(name);
        this.setTitle("");
        this.setSurname("");
        this.permissions.loadDefault(this);
        this.teleportRequestTime = -1L;
        this.teleportCost = 0.0;
    }

    public void setLastOnline(long lastOnline) {
        this.lastOnline = lastOnline;
    }

    public long getLastOnline() {
        return this.lastOnline;
    }

    public void setNPC(boolean isNPC) {
        this.isNPC = isNPC;
    }

    public boolean isNPC() {
        return this.isNPC;
    }

    public void setTitle(String title) {
        if (title.matches(" ")) {
            title = "";
        }
        this.title = title;
        this.setChangedName(true);
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasTitle() {
        return !this.title.isEmpty();
    }

    public void setSurname(String surname) {
        if (surname.matches(" ")) {
            surname = "";
        }
        this.surname = surname;
        this.setChangedName(true);
    }

    public String getSurname() {
        return this.surname;
    }

    public boolean hasSurname() {
        return !this.surname.isEmpty();
    }

    public boolean isKing() {
        try {
            return this.getTown().getNation().isKing(this);
        }
        catch (TownyException e) {
            return false;
        }
    }

    public boolean isMayor() {
        return this.hasTown() ? this.town.isMayor(this) : false;
    }

    public boolean hasTown() {
        return this.town != null;
    }

    public boolean hasNation() {
        return this.hasTown() ? this.town.hasNation() : false;
    }

    public Town getTown() throws NotRegisteredException {
        if (this.hasTown()) {
            return this.town;
        }
        throw new NotRegisteredException("Resident doesn't belong to any town");
    }

    public void setTown(Town town) throws AlreadyRegisteredException {
        if (town == null) {
            this.town = null;
            this.setTitle("");
            this.setSurname("");
            return;
        }
        if (this.town == town) {
            return;
        }
        if (this.hasTown()) {
            throw new AlreadyRegisteredException();
        }
        this.town = town;
        this.setTitle("");
        this.setSurname("");
    }

    public void setFriends(List<Resident> newFriends) {
        this.friends = newFriends;
    }

    public List<Resident> getFriends() {
        return this.friends;
    }

    public boolean removeFriend(Resident resident) throws NotRegisteredException {
        if (this.hasFriend(resident)) {
            return this.friends.remove(resident);
        }
        throw new NotRegisteredException();
    }

    public boolean hasFriend(Resident resident) {
        return this.friends.contains(resident);
    }

    public void addFriend(Resident resident) throws AlreadyRegisteredException {
        if (this.hasFriend(resident)) {
            throw new AlreadyRegisteredException();
        }
        this.friends.add(resident);
    }

    public void removeAllFriends() {
        for (Resident resident : new ArrayList<Resident>(this.friends)) {
            try {
                this.removeFriend(resident);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    public void clear() throws EmptyTownException {
        this.removeAllFriends();
        if (this.hasTown()) {
            try {
                this.town.removeResident(this);
                this.setTitle("");
                this.setSurname("");
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    public void setRegistered(long registered) {
        this.registered = registered;
    }

    public long getRegistered() {
        return this.registered;
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(String.valueOf(this.getTreeDepth(depth)) + "Resident (" + this.getName() + ")");
        out.add(String.valueOf(this.getTreeDepth(depth + 1)) + "Registered: " + this.getRegistered());
        out.add(String.valueOf(this.getTreeDepth(depth + 1)) + "Last Online: " + this.getLastOnline());
        if (this.getFriends().size() > 0) {
            out.add(String.valueOf(this.getTreeDepth(depth + 1)) + "Friends (" + this.getFriends().size() + "): " + Arrays.toString(this.getFriends().toArray(new Resident[0])));
        }
        return out;
    }

    public void clearTeleportRequest() {
        this.teleportRequestTime = -1L;
    }

    public void setTeleportRequestTime() {
        this.teleportRequestTime = System.currentTimeMillis();
    }

    public long getTeleportRequestTime() {
        return this.teleportRequestTime;
    }

    public void setTeleportDestination(Location spawnLoc) {
        this.teleportDestination = spawnLoc;
    }

    public Location getTeleportDestination() {
        return this.teleportDestination;
    }

    public boolean hasRequestedTeleport() {
        return this.teleportRequestTime != -1L;
    }

    public void setTeleportCost(double cost) {
        this.teleportCost = cost;
    }

    public double getTeleportCost() {
        return this.teleportCost;
    }

    public String getChatFormattedName() {
        return this.chatFormattedName;
    }

    public void setChatFormattedName(String chatFormattedName) {
        this.chatFormattedName = chatFormattedName;
        this.setChangedName(false);
    }

    public void addUndo(ChunkSnapshot snapshot) {
        if (this.regenUndo.size() == 5) {
            this.regenUndo.remove(0);
        }
        this.regenUndo.add(snapshot);
    }

    public void regenUndo() {
        if (this.regenUndo.size() > 0) {
            ChunkSnapshot snapshot = this.regenUndo.get(this.regenUndo.size() - 1);
            this.regenUndo.remove(snapshot);
            TownyRegenAPI.regenUndo(snapshot, this);
        }
    }

    @Override
    public List<String> getModes() {
        return this.modes;
    }

    @Override
    public boolean hasMode(String mode) {
        return this.modes.contains(mode.toLowerCase());
    }

    @Override
    public void toggleMode(String[] newModes, boolean notify) {
        if (newModes.length == 0) {
            this.clearModes();
            return;
        }
        String[] stringArray = newModes;
        int n = newModes.length;
        int n2 = 0;
        while (n2 < n) {
            String mode = stringArray[n2];
            if (this.modes.contains(mode = mode.toLowerCase())) {
                this.modes.remove(mode);
            } else {
                this.modes.add(mode);
            }
            ++n2;
        }
        if (notify) {
            TownyMessaging.sendMsg(this, "Modes set: " + StringMgmt.join(this.getModes(), ","));
        }
    }

    @Override
    public void setModes(String[] modes, boolean notify) {
        if (modes.length == 0) {
            this.clearModes();
            return;
        }
        this.modes.clear();
        this.toggleMode(modes, false);
        if (notify) {
            TownyMessaging.sendMsg(this, "Modes set: " + StringMgmt.join(this.getModes(), ","));
        }
    }

    @Override
    public void clearModes() {
        this.modes.clear();
        if (BukkitTools.scheduleSyncDelayedTask(new SetDefaultModes(this.getName(), true), 1L) == -1) {
            TownyMessaging.sendErrorMsg("Could not set default modes for " + this.getName() + ".");
        }
    }
}

