/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.wallgen.Wall;
import com.palmergames.bukkit.wallgen.WallSection;
import com.palmergames.bukkit.wallgen.Walled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Location;

public class Town
extends TownBlockOwner
implements Walled,
ResidentList {
    private List<Resident> residents = new ArrayList<Resident>();
    private List<Resident> assistants = new ArrayList<Resident>();
    private List<Location> outpostSpawns = new ArrayList<Location>();
    private Wall wall = new Wall();
    private Resident mayor;
    private int bonusBlocks;
    private int purchasedBlocks;
    private double taxes;
    private double plotTax;
    private double commercialPlotTax;
    private double embassyPlotTax;
    private double plotPrice;
    private double commercialPlotPrice;
    private double embassyPlotPrice;
    private Nation nation;
    private boolean hasUpkeep;
    private boolean isPublic;
    private boolean isTaxPercentage;
    private boolean isOpen;
    private String townBoard = "/town set board [msg]";
    private String tag;
    private TownBlock homeBlock;
    private TownyWorld world;
    private Location spawn;

    public Town(String name) {
        this.setName(name);
        this.tag = "";
        this.bonusBlocks = 0;
        this.purchasedBlocks = 0;
        this.taxes = 0.0;
        this.plotTax = 0.0;
        this.commercialPlotTax = 0.0;
        this.plotPrice = 0.0;
        this.hasUpkeep = true;
        this.isPublic = TownySettings.getTownDefaultPublic();
        this.isTaxPercentage = false;
        this.isOpen = TownySettings.getTownDefaultOpen();
        this.permissions.loadDefault(this);
    }

    @Override
    public void addTownBlock(TownBlock townBlock) throws AlreadyRegisteredException {
        if (this.hasTownBlock(townBlock)) {
            throw new AlreadyRegisteredException();
        }
        this.townBlocks.add(townBlock);
        if (this.townBlocks.size() == 1 && !this.hasHomeBlock()) {
            try {
                this.setHomeBlock(townBlock);
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
    }

    public void setTag(String text) throws TownyException {
        if (text.length() > 4) {
            throw new TownyException("Tag too long");
        }
        this.tag = text.toUpperCase();
        if (this.tag.matches(" ")) {
            this.tag = "";
        }
        this.setChangedName(true);
    }

    public String getTag() {
        return this.tag;
    }

    public boolean hasTag() {
        return !this.tag.isEmpty();
    }

    public Resident getMayor() {
        return this.mayor;
    }

    public void setTaxes(double taxes) {
        this.taxes = this.isTaxPercentage ? (taxes > TownySettings.getMaxTaxPercent() ? TownySettings.getMaxTaxPercent() : taxes) : (taxes > TownySettings.getMaxTax() ? TownySettings.getMaxTax() : taxes);
    }

    public double getTaxes() {
        this.setTaxes(this.taxes);
        return this.taxes;
    }

    public void setMayor(Resident mayor) throws TownyException {
        if (!this.hasResident(mayor)) {
            throw new TownyException("Mayor doesn't belong to town.");
        }
        this.mayor = mayor;
    }

    public Nation getNation() throws NotRegisteredException {
        if (this.hasNation()) {
            return this.nation;
        }
        throw new NotRegisteredException("Town doesn't belong to any nation.");
    }

    public void setNation(Nation nation) throws AlreadyRegisteredException {
        if (nation == null) {
            this.nation = null;
            return;
        }
        if (this.nation == nation) {
            return;
        }
        if (this.hasNation()) {
            throw new AlreadyRegisteredException();
        }
        this.nation = nation;
    }

    @Override
    public List<Resident> getResidents() {
        return this.residents;
    }

    public List<Resident> getAssistants() {
        return this.assistants;
    }

    @Override
    public boolean hasResident(String name) {
        for (Resident resident : this.residents) {
            if (!resident.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasResident(Resident resident) {
        return this.residents.contains(resident);
    }

    public boolean hasAssistant(Resident resident) {
        return this.assistants.contains(resident);
    }

    public void addResident(Resident resident) throws AlreadyRegisteredException {
        this.addResidentCheck(resident);
        this.residents.add(resident);
        resident.setTown(this);
    }

    public void addResidentCheck(Resident resident) throws AlreadyRegisteredException {
        if (this.hasResident(resident)) {
            throw new AlreadyRegisteredException(String.format(TownySettings.getLangString("msg_err_already_in_town"), resident.getName(), this.getFormattedName()));
        }
        if (resident.hasTown()) {
            try {
                if (!resident.getTown().equals(this)) {
                    throw new AlreadyRegisteredException(String.format(TownySettings.getLangString("msg_err_already_in_town"), resident.getName(), this.getFormattedName()));
                }
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
    }

    public void addAssistant(Resident resident) throws AlreadyRegisteredException, NotRegisteredException {
        if (this.hasAssistant(resident)) {
            throw new AlreadyRegisteredException();
        }
        if (!this.hasResident(resident)) {
            throw new NotRegisteredException(String.valueOf(resident.getName()) + " doesn't belong to your town.");
        }
        this.assistants.add(resident);
    }

    public boolean isMayor(Resident resident) {
        return resident == this.mayor;
    }

    public boolean hasNation() {
        return this.nation != null;
    }

    public int getNumResidents() {
        return this.residents.size();
    }

    public boolean isCapital() {
        return this.hasNation() ? this.nation.isCapital(this) : false;
    }

    public void setHasUpkeep(boolean hasUpkeep) {
        this.hasUpkeep = hasUpkeep;
    }

    public boolean hasUpkeep() {
        return this.hasUpkeep;
    }

    public void setHasMobs(boolean hasMobs) {
        this.permissions.mobs = hasMobs;
    }

    public boolean hasMobs() {
        return this.permissions.mobs;
    }

    public void setPVP(boolean isPVP) {
        this.permissions.pvp = isPVP;
    }

    public boolean isPVP() {
        return this.permissions.pvp;
    }

    public void setBANG(boolean isBANG) {
        this.permissions.explosion = isBANG;
    }

    public boolean isBANG() {
        return this.permissions.explosion;
    }

    public void setTaxPercentage(boolean isPercentage) {
        this.isTaxPercentage = isPercentage;
        if (this.getTaxes() > 100.0) {
            this.setTaxes(0.0);
        }
    }

    public boolean isTaxPercentage() {
        return this.isTaxPercentage;
    }

    public void setFire(boolean isFire) {
        this.permissions.fire = isFire;
    }

    public boolean isFire() {
        return this.permissions.fire;
    }

    public void setTownBoard(String townBoard) {
        this.townBoard = townBoard;
    }

    public String getTownBoard() {
        return this.townBoard;
    }

    public void setBonusBlocks(int bonusBlocks) {
        this.bonusBlocks = bonusBlocks;
    }

    public int getTotalBlocks() {
        return TownySettings.getMaxTownBlocks(this);
    }

    public int getBonusBlocks() {
        return this.bonusBlocks;
    }

    public void addBonusBlocks(int bonusBlocks) {
        this.bonusBlocks += bonusBlocks;
    }

    public void setPurchasedBlocks(int purchasedBlocks) {
        this.purchasedBlocks = purchasedBlocks;
    }

    public int getPurchasedBlocks() {
        return this.purchasedBlocks;
    }

    public void addPurchasedBlocks(int purchasedBlocks) {
        this.purchasedBlocks += purchasedBlocks;
    }

    public boolean setHomeBlock(TownBlock homeBlock) throws TownyException {
        if (homeBlock == null) {
            this.homeBlock = null;
            return false;
        }
        if (!this.hasTownBlock(homeBlock)) {
            throw new TownyException("Town has no claim over this town block.");
        }
        this.homeBlock = homeBlock;
        if (this.world != homeBlock.getWorld()) {
            if (this.world != null && this.world.hasTown(this)) {
                this.world.removeTown(this);
            }
            this.setWorld(homeBlock.getWorld());
        }
        try {
            this.setSpawn(this.spawn);
        }
        catch (TownyException e) {
            this.spawn = null;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return true;
    }

    public TownBlock getHomeBlock() throws TownyException {
        if (this.hasHomeBlock()) {
            return this.homeBlock;
        }
        throw new TownyException("Town has not set a home block.");
    }

    public void setWorld(TownyWorld world) {
        if (world == null) {
            this.world = null;
            return;
        }
        if (this.world == world) {
            return;
        }
        if (this.hasWorld()) {
            try {
                world.removeTown(this);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        this.world = world;
        try {
            this.world.addTown(this);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
    }

    public TownyWorld getWorld() {
        if (this.world != null) {
            return this.world;
        }
        return TownyUniverse.getDataSource().getTownWorld(this.getName());
    }

    public boolean hasMayor() {
        return this.mayor != null;
    }

    public void removeResident(Resident resident) throws EmptyTownException, NotRegisteredException {
        if (!this.hasResident(resident)) {
            throw new NotRegisteredException();
        }
        this.remove(resident);
        if (this.getNumResidents() == 0) {
            throw new EmptyTownException(this);
        }
    }

    private void removeAllResidents() {
        for (Resident resident : new ArrayList<Resident>(this.residents)) {
            this.remove(resident);
        }
    }

    private void remove(Resident resident) {
        for (TownBlock townBlock : new ArrayList<TownBlock>(resident.getTownBlocks())) {
            townBlock.setResident(null);
            try {
                townBlock.setPlotPrice(townBlock.getTown().getPlotPrice());
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
        if (this.isMayor(resident) && this.residents.size() > 1) {
            for (Resident assistant : new ArrayList<Resident>(this.getAssistants())) {
                if (assistant == resident) continue;
                try {
                    this.setMayor(assistant);
                }
                catch (TownyException e) {
                    e.printStackTrace();
                }
            }
            if (this.isMayor(resident)) {
                for (Resident newMayor : new ArrayList<Resident>(this.getResidents())) {
                    if (newMayor == resident) continue;
                    try {
                        this.setMayor(newMayor);
                    }
                    catch (TownyException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (this.hasNation() && this.nation.hasAssistant(resident)) {
            try {
                this.nation.removeAssistant(resident);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        if (this.hasAssistant(resident)) {
            try {
                this.removeAssistant(resident);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        try {
            resident.setTown(null);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        this.residents.remove(resident);
    }

    public void removeAssistant(Resident resident) throws NotRegisteredException {
        if (!this.hasAssistant(resident)) {
            throw new NotRegisteredException();
        }
        this.assistants.remove(resident);
    }

    public void setSpawn(Location spawn) throws TownyException {
        if (!this.hasHomeBlock()) {
            throw new TownyException("Home Block has not been set");
        }
        Coord spawnBlock = Coord.parseCoord(spawn);
        if (this.homeBlock.getX() != spawnBlock.getX() || this.homeBlock.getZ() != spawnBlock.getZ()) {
            throw new TownyException("Spawn is not within the homeBlock.");
        }
        this.spawn = spawn;
    }

    public Location getSpawn() throws TownyException {
        if (this.hasHomeBlock() && this.spawn != null) {
            return this.spawn;
        }
        this.spawn = null;
        throw new TownyException("Town has not set a spawn location.");
    }

    public boolean hasSpawn() {
        return this.hasHomeBlock() && this.spawn != null;
    }

    public boolean hasHomeBlock() {
        return this.homeBlock != null;
    }

    public void clear() throws EmptyNationException {
        this.removeAllResidents();
        this.mayor = null;
        this.residents.clear();
        this.assistants.clear();
        this.homeBlock = null;
        this.outpostSpawns.clear();
        try {
            if (this.hasWorld()) {
                this.world.removeTownBlocks(this.getTownBlocks());
                this.world.removeTown(this);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (this.hasNation()) {
            try {
                this.nation.removeTown(this);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    private boolean hasWorld() {
        return this.world != null;
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) throws NotRegisteredException {
        if (!this.hasTownBlock(townBlock)) {
            throw new NotRegisteredException();
        }
        if (townBlock.isOutpost()) {
            this.removeOutpostSpawn(townBlock.getCoord());
        }
        try {
            if (this.getHomeBlock() == townBlock) {
                this.setHomeBlock(null);
            }
        }
        catch (TownyException townyException) {
            // empty catch block
        }
        this.townBlocks.remove(townBlock);
    }

    public void addOutpostSpawn(Location spawn) throws TownyException {
        this.removeOutpostSpawn(Coord.parseCoord(spawn));
        Coord spawnBlock = Coord.parseCoord(spawn);
        try {
            TownBlock outpost = TownyUniverse.getDataSource().getWorld(spawn.getWorld().getName()).getTownBlock(spawnBlock);
            if (outpost.getX() == spawnBlock.getX() && outpost.getZ() == spawnBlock.getZ()) {
                if (!outpost.isOutpost()) {
                    throw new TownyException("Location is not within an outpost plot.");
                }
                this.outpostSpawns.add(spawn);
            }
        }
        catch (NotRegisteredException e) {
            throw new TownyException("Location is not within a Town.");
        }
    }

    public Location getOutpostSpawn(Integer index) throws TownyException {
        if (this.getMaxOutpostSpawn() == 0) {
            throw new TownyException("Town has no outpost spawns set.");
        }
        return this.outpostSpawns.get(Math.min(this.getMaxOutpostSpawn() - 1, Math.max(0, index - 1)));
    }

    public int getMaxOutpostSpawn() {
        return this.outpostSpawns.size();
    }

    public boolean hasOutpostSpawn() {
        return this.outpostSpawns.size() > 0;
    }

    public List<Location> getAllOutpostSpawns() {
        return Collections.unmodifiableList(this.outpostSpawns);
    }

    private void removeOutpostSpawn(Coord coord) {
        for (Location spawn : new ArrayList<Location>(this.outpostSpawns)) {
            Coord spawnBlock = Coord.parseCoord(spawn);
            if (coord.getX() != spawnBlock.getX() || coord.getZ() != coord.getZ()) continue;
            this.outpostSpawns.remove(spawn);
        }
    }

    public void setPlotPrice(double plotPrice) {
        this.plotPrice = plotPrice;
    }

    public double getPlotPrice() {
        return this.plotPrice;
    }

    public double getPlotTypePrice(TownBlockType type) {
        double plotPrice = 0.0;
        switch (type.ordinal()) {
            case 0: {
                plotPrice = this.getPlotPrice();
                break;
            }
            case 1: {
                plotPrice = this.getCommercialPlotPrice();
                break;
            }
            case 3: {
                plotPrice = this.getEmbassyPlotPrice();
                break;
            }
            default: {
                plotPrice = this.getPlotPrice();
            }
        }
        if (plotPrice < 0.0) {
            plotPrice = 0.0;
        }
        return plotPrice;
    }

    public void setCommercialPlotPrice(double commercialPlotPrice) {
        this.commercialPlotPrice = commercialPlotPrice;
    }

    public double getCommercialPlotPrice() {
        return this.commercialPlotPrice;
    }

    public void setEmbassyPlotPrice(double embassyPlotPrice) {
        this.embassyPlotPrice = embassyPlotPrice;
    }

    public double getEmbassyPlotPrice() {
        return this.embassyPlotPrice;
    }

    @Override
    public Wall getWall() {
        return this.wall;
    }

    @Override
    public List<WallSection> getWallSections() {
        return this.getWall().getWallSections();
    }

    @Override
    public void setWallSections(List<WallSection> wallSections) {
        this.getWall().setWallSections(wallSections);
    }

    @Override
    public boolean hasWallSection(WallSection wallSection) {
        return this.getWall().hasWallSection(wallSection);
    }

    @Override
    public void addWallSection(WallSection wallSection) {
        this.getWall().addWallSection(wallSection);
    }

    @Override
    public void removeWallSection(WallSection wallSection) {
        this.getWall().removeWallSection(wallSection);
    }

    public boolean isHomeBlock(TownBlock townBlock) {
        return this.hasHomeBlock() ? townBlock == this.homeBlock : false;
    }

    public void setPlotTax(double plotTax) {
        this.plotTax = plotTax;
    }

    public double getPlotTax() {
        return this.plotTax;
    }

    public void setCommercialPlotTax(double commercialTax) {
        this.commercialPlotTax = commercialTax;
    }

    public double getCommercialPlotTax() {
        return this.commercialPlotTax;
    }

    public void setEmbassyPlotTax(double embassyPlotTax) {
        this.embassyPlotTax = embassyPlotTax;
    }

    public double getEmbassyPlotTax() {
        return this.embassyPlotTax;
    }

    public void setOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void withdrawFromBank(Resident resident, int amount) throws EconomyException, TownyException {
        if (!this.isMayor(resident) && !this.hasAssistant(resident)) {
            throw new TownyException("You don't have access to the town's bank.");
        }
        if (TownySettings.isUsingEconomy()) {
            if (!this.payTo(amount, resident, "Town Widthdraw")) {
                throw new TownyException("There is not enough money in the bank.");
            }
        } else {
            throw new TownyException("Economy has not been turned on.");
        }
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(String.valueOf(this.getTreeDepth(depth)) + "Town (" + this.getName() + ")");
        out.add(String.valueOf(this.getTreeDepth(depth + 1)) + "Mayor: " + (this.hasMayor() ? this.getMayor().getName() : "None"));
        out.add(String.valueOf(this.getTreeDepth(depth + 1)) + "Home: " + this.homeBlock);
        out.add(String.valueOf(this.getTreeDepth(depth + 1)) + "Bonus: " + this.bonusBlocks);
        out.add(String.valueOf(this.getTreeDepth(depth + 1)) + "TownBlocks (" + this.getTownBlocks().size() + "): ");
        if (this.getAssistants().size() > 0) {
            out.add(String.valueOf(this.getTreeDepth(depth + 1)) + "Assistants (" + this.getAssistants().size() + "): " + Arrays.toString(this.getAssistants().toArray(new Resident[0])));
        }
        out.add(String.valueOf(this.getTreeDepth(depth + 1)) + "Residents (" + this.getResidents().size() + "):");
        for (Resident resident : this.getResidents()) {
            out.addAll(resident.getTreeString(depth + 2));
        }
        return out;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public boolean isPublic() {
        return this.isPublic;
    }
}

