/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyLogger;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.util.StringMgmt;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class TownyEconomyObject
extends TownyObject {
    private static final String townAccountPrefix = "town-";
    private static final String nationAccountPrefix = "nation-";

    public boolean pay(double amount, String reason) throws EconomyException {
        boolean payed = this._pay(amount);
        if (payed) {
            TownyLogger.logMoneyTransaction(this, amount, null, reason);
        }
        return payed;
    }

    public boolean pay(double amount) throws EconomyException {
        return this.pay(amount, null);
    }

    private boolean _pay(double amount) throws EconomyException {
        if (this.canPayFromHoldings(amount) && TownyEconomyHandler.isActive()) {
            return TownyEconomyHandler.subtract(this.getEconomyName(), amount, this.getBukkitWorld());
        }
        return false;
    }

    public void collect(double amount, String reason) throws EconomyException {
        TownyEconomyHandler.add(this.getEconomyName(), amount, this.getBukkitWorld());
        TownyLogger.logMoneyTransaction(null, amount, this, reason);
    }

    public void collect(double amount) throws EconomyException {
        this.collect(amount, null);
    }

    public boolean payTo(double amount, TownyEconomyObject collector, String reason) throws EconomyException {
        boolean payed = this._payTo(amount, collector);
        if (payed) {
            TownyLogger.logMoneyTransaction(this, amount, collector, reason);
        }
        return payed;
    }

    public boolean payTo(double amount, TownyEconomyObject collector) throws EconomyException {
        return this.payTo(amount, collector, null);
    }

    private boolean _payTo(double amount, TownyEconomyObject collector) throws EconomyException {
        if (this._pay(amount)) {
            collector.collect(amount);
            return true;
        }
        return false;
    }

    public String getEconomyName() {
        if (this instanceof Nation) {
            return StringMgmt.trimMaxLength(nationAccountPrefix + this.getName(), 32);
        }
        if (this instanceof Town) {
            return StringMgmt.trimMaxLength(townAccountPrefix + this.getName(), 32);
        }
        return this.getName();
    }

    private World getBukkitWorld() {
        try {
            if (this instanceof Nation) {
                return Bukkit.getWorld((String)TownyUniverse.getDataSource().getNation(this.getName()).getCapital().getWorld().getName());
            }
            if (this instanceof Town) {
                return Bukkit.getWorld((String)TownyUniverse.getDataSource().getTown(this.getName()).getWorld().getName());
            }
            if (this instanceof Resident) {
                Player player = Bukkit.getPlayer((String)this.getName());
                return player != null ? player.getWorld() : (World)Bukkit.getWorlds().get(0);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return (World)Bukkit.getWorlds().get(0);
    }

    public void setBalance(double amount, String reason) {
        this.setBalance(amount);
        TownyLogger.logMoneyTransaction(null, amount, this, reason);
    }

    public void setBalance(double amount) {
        TownyEconomyHandler.setBalance(this.getEconomyName(), amount, this.getBukkitWorld());
    }

    public double getHoldingBalance() throws EconomyException {
        try {
            return TownyEconomyHandler.getBalance(this.getEconomyName(), this.getBukkitWorld());
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            throw new EconomyException("Economy error getting holdings for " + this.getEconomyName());
        }
    }

    public boolean canPayFromHoldings(double amount) throws EconomyException {
        return TownyEconomyHandler.hasEnough(this.getEconomyName(), amount, this.getBukkitWorld());
    }

    public String getHoldingFormattedBalance() {
        try {
            return TownyEconomyHandler.getFormattedBalance(this.getHoldingBalance());
        }
        catch (EconomyException e) {
            return "Error Accessing Bank Account";
        }
    }

    public void removeAccount() {
        TownyEconomyHandler.removeAccount(this.getEconomyName());
    }
}

