/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.object.TownyObservableType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Random;

public abstract class TownyObject
extends Observable {
    private Integer UID = 0;
    private String name;
    private boolean isChangedName = true;

    public void setName(String name) {
        if (this.getUID() == 0) {
            this.setUID(name.hashCode() + new Random(System.currentTimeMillis()).nextInt());
        }
        this.setChanged();
        this.notifyObservers((Object)TownyObservableType.OBJECT_NAME);
        this.name = name;
        this.setChangedName(true);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getTreeString(int depth) {
        return new ArrayList<String>();
    }

    public String getTreeDepth(int depth) {
        char[] fill = new char[depth * 4];
        Arrays.fill(fill, ' ');
        if (depth > 0) {
            fill[0] = 124;
            int offset = (depth - 1) * 4;
            fill[offset] = 43;
            fill[offset + 1] = 45;
            fill[offset + 2] = 45;
        }
        return new String(fill);
    }

    public String toString() {
        return this.getName();
    }

    public String getFormattedName() {
        return TownyFormatter.getFormattedName(this);
    }

    public boolean isChangedName() {
        return this.isChangedName;
    }

    public void setChangedName(boolean isChangedName) {
        this.isChangedName = isChangedName;
    }

    public Integer getUID() {
        return this.UID;
    }

    public void setUID(Integer uID) {
        this.UID = uID;
    }
}

