/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;

public class TownyPermission {
    public boolean residentBuild;
    public boolean residentDestroy;
    public boolean residentSwitch;
    public boolean residentItemUse;
    public boolean outsiderBuild;
    public boolean outsiderDestroy;
    public boolean outsiderSwitch;
    public boolean outsiderItemUse;
    public boolean allyBuild;
    public boolean allyDestroy;
    public boolean allySwitch;
    public boolean allyItemUse;
    public boolean pvp;
    public boolean fire;
    public boolean explosion;
    public boolean mobs;

    public TownyPermission() {
        this.reset();
    }

    public void reset() {
        this.setAll(false);
    }

    public void setAll(boolean b) {
        this.residentBuild = b;
        this.residentDestroy = b;
        this.residentSwitch = b;
        this.residentItemUse = b;
        this.outsiderBuild = b;
        this.outsiderDestroy = b;
        this.outsiderSwitch = b;
        this.outsiderItemUse = b;
        this.allyBuild = b;
        this.allyDestroy = b;
        this.allySwitch = b;
        this.allyItemUse = b;
        this.pvp = b;
        this.fire = b;
        this.explosion = b;
        this.mobs = b;
    }

    public void set(String s, boolean b) {
        if (s.equalsIgnoreCase("denyAll")) {
            this.reset();
        } else if (s.equalsIgnoreCase("residentBuild")) {
            this.residentBuild = b;
        } else if (s.equalsIgnoreCase("residentDestroy")) {
            this.residentDestroy = b;
        } else if (s.equalsIgnoreCase("residentSwitch")) {
            this.residentSwitch = b;
        } else if (s.equalsIgnoreCase("residentItemUse")) {
            this.residentItemUse = b;
        } else if (s.equalsIgnoreCase("outsiderBuild")) {
            this.outsiderBuild = b;
        } else if (s.equalsIgnoreCase("outsiderDestroy")) {
            this.outsiderDestroy = b;
        } else if (s.equalsIgnoreCase("outsiderSwitch")) {
            this.outsiderSwitch = b;
        } else if (s.equalsIgnoreCase("outsiderItemUse")) {
            this.outsiderItemUse = b;
        } else if (s.equalsIgnoreCase("allyBuild")) {
            this.allyBuild = b;
        } else if (s.equalsIgnoreCase("allyDestroy")) {
            this.allyDestroy = b;
        } else if (s.equalsIgnoreCase("allySwitch")) {
            this.allySwitch = b;
        } else if (s.equalsIgnoreCase("allyItemUse")) {
            this.allyItemUse = b;
        } else if (s.equalsIgnoreCase("pvp")) {
            this.pvp = b;
        } else if (s.equalsIgnoreCase("fire")) {
            this.fire = b;
        } else if (s.equalsIgnoreCase("explosion")) {
            this.explosion = b;
        } else if (s.equalsIgnoreCase("mobs")) {
            this.mobs = b;
        }
    }

    public void load(String s) {
        String[] tokens;
        this.setAll(false);
        String[] stringArray = tokens = s.split(",");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            this.set(token, true);
            ++n2;
        }
    }

    public String toString() {
        String out = "";
        if (this.residentBuild) {
            out = String.valueOf(out) + "residentBuild";
        }
        if (this.residentDestroy) {
            out = String.valueOf(out) + (out.length() > 0 ? "," : "") + "residentDestroy";
        }
        if (this.residentSwitch) {
            out = String.valueOf(out) + (out.length() > 0 ? "," : "") + "residentSwitch";
        }
        if (this.residentItemUse) {
            out = String.valueOf(out) + (out.length() > 0 ? "," : "") + "residentItemUse";
        }
        if (this.outsiderBuild) {
            out = String.valueOf(out) + (out.length() > 0 ? "," : "") + "outsiderBuild";
        }
        if (this.outsiderDestroy) {
            out = String.valueOf(out) + (out.length() > 0 ? "," : "") + "outsiderDestroy";
        }
        if (this.outsiderSwitch) {
            out = String.valueOf(out) + (out.length() > 0 ? "," : "") + "outsiderSwitch";
        }
        if (this.outsiderItemUse) {
            out = String.valueOf(out) + (out.length() > 0 ? "," : "") + "outsiderItemUse";
        }
        if (this.allyBuild) {
            out = String.valueOf(out) + (out.length() > 0 ? "," : "") + "allyBuild";
        }
        if (this.allyDestroy) {
            out = String.valueOf(out) + (out.length() > 0 ? "," : "") + "allyDestroy";
        }
        if (this.allySwitch) {
            out = String.valueOf(out) + (out.length() > 0 ? "," : "") + "allySwitch";
        }
        if (this.allyItemUse) {
            out = String.valueOf(out) + (out.length() > 0 ? "," : "") + "allyItemUse";
        }
        if (this.pvp) {
            out = String.valueOf(out) + (out.length() > 0 ? "," : "") + "pvp";
        }
        if (this.fire) {
            out = String.valueOf(out) + (out.length() > 0 ? "," : "") + "fire";
        }
        if (this.explosion) {
            out = String.valueOf(out) + (out.length() > 0 ? "," : "") + "explosion";
        }
        if (this.mobs) {
            out = String.valueOf(out) + (out.length() > 0 ? "," : "") + "mobs";
        }
        if (out.length() == 0) {
            out = String.valueOf(out) + "denyAll";
        }
        return out;
    }

    public boolean getResidentPerm(ActionType type) {
        switch (type) {
            case BUILD: {
                return this.residentBuild;
            }
            case DESTROY: {
                return this.residentDestroy;
            }
            case SWITCH: {
                return this.residentSwitch;
            }
            case ITEM_USE: {
                return this.residentItemUse;
            }
        }
        throw new UnsupportedOperationException();
    }

    public boolean getOutsiderPerm(ActionType type) {
        switch (type) {
            case BUILD: {
                return this.outsiderBuild;
            }
            case DESTROY: {
                return this.outsiderDestroy;
            }
            case SWITCH: {
                return this.outsiderSwitch;
            }
            case ITEM_USE: {
                return this.outsiderItemUse;
            }
        }
        throw new UnsupportedOperationException();
    }

    public boolean getAllyPerm(ActionType type) {
        switch (type) {
            case BUILD: {
                return this.allyBuild;
            }
            case DESTROY: {
                return this.allyDestroy;
            }
            case SWITCH: {
                return this.allySwitch;
            }
            case ITEM_USE: {
                return this.allyItemUse;
            }
        }
        throw new UnsupportedOperationException();
    }

    public String getColourString() {
        return "\u00a7aBuild = \u00a77" + (this.residentBuild ? "f" : "-") + (this.allyBuild ? "a" : "-") + (this.outsiderBuild ? "o" : "-") + "\u00a7a" + " Destroy = " + "\u00a77" + (this.residentDestroy ? "f" : "-") + (this.allyDestroy ? "a" : "-") + (this.outsiderDestroy ? "o" : "-") + "\u00a7a" + " Switch = " + "\u00a77" + (this.residentSwitch ? "f" : "-") + (this.allySwitch ? "a" : "-") + (this.outsiderSwitch ? "o" : "-") + "\u00a7a" + " Item = " + "\u00a77" + (this.residentItemUse ? "f" : "-") + (this.allyItemUse ? "a" : "-") + (this.outsiderItemUse ? "o" : "-");
    }

    public void loadDefault(TownBlockOwner owner) {
        this.residentBuild = TownySettings.getDefaultPermission(owner, PermLevel.RESIDENT, ActionType.BUILD);
        this.residentDestroy = TownySettings.getDefaultPermission(owner, PermLevel.RESIDENT, ActionType.DESTROY);
        this.residentSwitch = TownySettings.getDefaultPermission(owner, PermLevel.RESIDENT, ActionType.SWITCH);
        this.residentItemUse = TownySettings.getDefaultPermission(owner, PermLevel.RESIDENT, ActionType.ITEM_USE);
        this.allyBuild = TownySettings.getDefaultPermission(owner, PermLevel.ALLY, ActionType.BUILD);
        this.allyDestroy = TownySettings.getDefaultPermission(owner, PermLevel.ALLY, ActionType.DESTROY);
        this.allySwitch = TownySettings.getDefaultPermission(owner, PermLevel.ALLY, ActionType.SWITCH);
        this.allyItemUse = TownySettings.getDefaultPermission(owner, PermLevel.ALLY, ActionType.ITEM_USE);
        this.outsiderBuild = TownySettings.getDefaultPermission(owner, PermLevel.OUTSIDER, ActionType.BUILD);
        this.outsiderDestroy = TownySettings.getDefaultPermission(owner, PermLevel.OUTSIDER, ActionType.DESTROY);
        this.outsiderItemUse = TownySettings.getDefaultPermission(owner, PermLevel.OUTSIDER, ActionType.ITEM_USE);
        this.outsiderSwitch = TownySettings.getDefaultPermission(owner, PermLevel.OUTSIDER, ActionType.SWITCH);
        if (owner instanceof Town) {
            this.pvp = TownySettings.getPermFlag_Town_Default_PVP();
            this.fire = TownySettings.getPermFlag_Town_Default_FIRE();
            this.explosion = TownySettings.getPermFlag_Town_Default_Explosion();
            this.mobs = TownySettings.getPermFlag_Town_Default_Mobs();
        } else {
            this.pvp = owner.getPermissions().pvp;
            this.fire = owner.getPermissions().fire;
            this.explosion = owner.getPermissions().explosion;
            this.mobs = owner.getPermissions().mobs;
        }
    }

    public static enum ActionType {
        BUILD,
        DESTROY,
        SWITCH,
        ITEM_USE;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static enum PermLevel {
        RESIDENT,
        ALLY,
        OUTSIDER;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

