/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.permissions.PermissionEventEnums;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.util.BukkitTools;
import org.anjocaido.groupmanager.GroupManager;
import org.anjocaido.groupmanager.data.Group;
import org.anjocaido.groupmanager.events.GMGroupEvent;
import org.anjocaido.groupmanager.events.GMSystemEvent;
import org.anjocaido.groupmanager.events.GMUserEvent;
import org.anjocaido.groupmanager.permissions.AnjoPermissionsHandler;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;

public class GroupManagerSource
extends TownyPermissionSource {
    public GroupManagerSource(Towny towny, Plugin test) {
        this.groupManager = (GroupManager)test;
        this.plugin = towny;
        try {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)new GMCustomEventListener(), (Plugin)this.plugin);
        }
        catch (IllegalPluginAccessException e) {
            System.out.print("Your Version of GroupManager is out of date. Please update.");
        }
    }

    @Override
    public String getPrefixSuffix(Resident resident, String node) {
        String group = "";
        String user = "";
        Player player = this.plugin.getServer().getPlayer(resident.getName());
        AnjoPermissionsHandler handler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        if (node == "prefix") {
            group = handler.getGroupPrefix(handler.getPrimaryGroup(player.getName()));
            user = handler.getUserPrefix(player.getName());
        } else if (node == "suffix") {
            group = handler.getGroupSuffix(handler.getPrimaryGroup(player.getName()));
            user = handler.getUserSuffix(player.getName());
        }
        if (!group.equals(user)) {
            user = String.valueOf(group) + user;
        }
        user = TownySettings.parseSingleLineString(user);
        return user;
    }

    @Override
    public int getGroupPermissionIntNode(String playerName, String node) {
        Player player = this.plugin.getServer().getPlayer(playerName);
        AnjoPermissionsHandler handler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        return handler.getPermissionInteger(playerName, node);
    }

    @Override
    public String getPlayerPermissionStringNode(String playerName, String node) {
        Player player = this.plugin.getServer().getPlayer(playerName);
        AnjoPermissionsHandler handler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        return handler.getPermissionString(playerName, node);
    }

    @Override
    public String getPlayerGroup(Player player) {
        AnjoPermissionsHandler handler = this.groupManager.getWorldsHolder().getWorldData(player).getPermissionsHandler();
        return handler.getGroup(player.getName());
    }

    protected class GMCustomEventListener
    implements Listener {
        @EventHandler(priority=EventPriority.HIGH)
        public void onGMUserEvent(GMUserEvent event) {
            block5: {
                Resident resident = null;
                Player player = null;
                try {
                    if (PermissionEventEnums.GMUser_Action.valueOf(event.getAction().name()) == null) break block5;
                    try {
                        resident = TownyUniverse.getDataSource().getResident(event.getUserName());
                        player = GroupManagerSource.this.plugin.getServer().getPlayerExact(resident.getName());
                        if (player != null) {
                            String[] modes = GroupManagerSource.this.getPlayerPermissionStringNode(player.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                            GroupManagerSource.this.plugin.setPlayerMode(player, modes, false);
                            GroupManagerSource.this.plugin.resetCache(player);
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {}
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        @EventHandler(priority=EventPriority.HIGH)
        public void onGMGroupEvent(GMGroupEvent event) {
            Player player = null;
            try {
                if (PermissionEventEnums.GMGroup_Action.valueOf(event.getAction().name()) != null) {
                    Group group = event.getGroup();
                    Player[] playerArray = BukkitTools.getOnlinePlayers();
                    int n = playerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Player toUpdate = playerArray[n2];
                        if (toUpdate != null && group.equals((Object)GroupManagerSource.this.getPlayerGroup(toUpdate))) {
                            String[] modes = GroupManagerSource.this.getPlayerPermissionStringNode(toUpdate.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                            GroupManagerSource.this.plugin.setPlayerMode(player, modes, false);
                            GroupManagerSource.this.plugin.resetCache(player);
                        }
                        ++n2;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        @EventHandler(priority=EventPriority.HIGH)
        public void onGMSystemEvent(GMSystemEvent event) {
            Player player = null;
            try {
                if (PermissionEventEnums.GMSystem_Action.valueOf(event.getAction().name()) != null) {
                    Player[] playerArray = BukkitTools.getOnlinePlayers();
                    int n = playerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Player toUpdate = playerArray[n2];
                        if (toUpdate != null) {
                            String[] modes = GroupManagerSource.this.getPlayerPermissionStringNode(toUpdate.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                            GroupManagerSource.this.plugin.setPlayerMode(player, modes, false);
                            GroupManagerSource.this.plugin.resetCache(player);
                        }
                        ++n2;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

