/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.permissions.PermissionEventEnums;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPermissionSource;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.Arrays;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import ru.tehkode.permissions.PermissionEntity;
import ru.tehkode.permissions.PermissionGroup;
import ru.tehkode.permissions.PermissionManager;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;
import ru.tehkode.permissions.events.PermissionEntityEvent;
import ru.tehkode.permissions.events.PermissionSystemEvent;

public class PEXSource
extends TownyPermissionSource {
    public PEXSource(Towny towny, Plugin test) {
        this.pex = (PermissionsEx)test;
        this.plugin = towny;
        try {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)new PEXCustomEventListener(), (Plugin)this.plugin);
        }
        catch (IllegalPluginAccessException e) {
            System.out.print("Your Version of PEX is out of date. Please update.");
        }
    }

    @Override
    public String getPrefixSuffix(Resident resident, String node) {
        String group = "";
        String user = "";
        Player player = this.plugin.getServer().getPlayer(resident.getName());
        PermissionManager pexPM = PermissionsEx.getPermissionManager();
        if (node == "prefix") {
            group = pexPM.getUser(player).getPrefix(player.getWorld().getName());
            user = pexPM.getUser(player).getOwnPrefix();
        } else if (node == "suffix") {
            group = pexPM.getUser(player).getSuffix(player.getWorld().getName());
            user = pexPM.getUser(player).getOwnSuffix();
        }
        if (group == null) {
            group = "";
        }
        if (user == null) {
            user = "";
        }
        if (!group.equals(user)) {
            user = String.valueOf(group) + user;
        }
        user = TownySettings.parseSingleLineString(user);
        return user;
    }

    @Override
    public int getGroupPermissionIntNode(String playerName, String node) {
        Player player = this.plugin.getServer().getPlayer(playerName);
        String worldName = player.getWorld().getName();
        PermissionManager pexPM = PermissionsEx.getPermissionManager();
        String result = pexPM.getUser(player).getOption(node, worldName);
        try {
            return Integer.parseInt(result);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public String getPlayerPermissionStringNode(String playerName, String node) {
        Player player = this.plugin.getServer().getPlayer(playerName);
        String worldName = player.getWorld().getName();
        PermissionManager pexPM = PermissionsEx.getPermissionManager();
        String result = pexPM.getUser(player).getOption(node, worldName);
        if (result != null) {
            return result;
        }
        return "";
    }

    @Override
    public String getPlayerGroup(Player player) {
        PermissionManager pexPM = PermissionsEx.getPermissionManager();
        return pexPM.getUser(player).getGroupsNames()[0];
    }

    public PermissionGroup[] getPlayerGroups(Player player) {
        PermissionManager pexPM = PermissionsEx.getPermissionManager();
        return pexPM.getUser(player).getGroups();
    }

    protected class PEXCustomEventListener
    implements Listener {
        @EventHandler(priority=EventPriority.HIGH)
        public void onPermissionEntityEvent(PermissionEntityEvent event) {
            block8: {
                Resident resident = null;
                Player player = null;
                try {
                    if (PermissionEventEnums.PEXEntity_Action.valueOf(event.getEventName()) == null) break block8;
                    PermissionEntityEvent EntityEvent = event;
                    PermissionEntity entity = EntityEvent.getEntity();
                    if (entity instanceof PermissionGroup) {
                        PermissionGroup group = (PermissionGroup)entity;
                        Player[] playerArray = BukkitTools.getOnlinePlayers();
                        int n = playerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Player toUpdate = playerArray[n2];
                            if (toUpdate != null && Arrays.asList(PEXSource.this.getPlayerGroups(toUpdate)).contains(group)) {
                                String[] modes = PEXSource.this.getPlayerPermissionStringNode(toUpdate.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                                PEXSource.this.plugin.setPlayerMode(player, modes, false);
                                PEXSource.this.plugin.resetCache(player);
                            }
                            ++n2;
                        }
                        break block8;
                    }
                    if (!(entity instanceof PermissionUser)) break block8;
                    try {
                        resident = TownyUniverse.getDataSource().getResident(((PermissionUser)entity).getName());
                        player = PEXSource.this.plugin.getServer().getPlayerExact(resident.getName());
                        if (player != null) {
                            String[] modes = PEXSource.this.getPlayerPermissionStringNode(player.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                            PEXSource.this.plugin.setPlayerMode(player, modes, false);
                            PEXSource.this.plugin.resetCache(player);
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {}
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        @EventHandler(priority=EventPriority.HIGH)
        public void onPermissionSystemEvent(PermissionSystemEvent event) {
            Player player = null;
            try {
                if (PermissionEventEnums.PEXSystem_Action.valueOf(event.getEventName()) != null) {
                    Player[] playerArray = BukkitTools.getOnlinePlayers();
                    int n = playerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Player toUpdate = playerArray[n2];
                        if (toUpdate != null) {
                            String[] modes = PEXSource.this.getPlayerPermissionStringNode(toUpdate.getName(), PermissionNodes.TOWNY_DEFAULT_MODES.getNode()).split(",");
                            PEXSource.this.plugin.setPlayerMode(player, modes, false);
                            PEXSource.this.plugin.resetCache(player);
                        }
                        ++n2;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

