/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.nijikokun.bukkit.Permissions.Permissions;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import org.anjocaido.groupmanager.GroupManager;
import org.bukkit.entity.Player;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public abstract class TownyPermissionSource {
    protected TownySettings settings;
    protected Towny plugin;
    protected GroupManager groupManager = null;
    protected Permissions permissions = null;
    protected PermissionsEx pex = null;

    public abstract String getPrefixSuffix(Resident var1, String var2);

    public abstract int getGroupPermissionIntNode(String var1, String var2);

    public abstract String getPlayerGroup(Player var1);

    public abstract String getPlayerPermissionStringNode(String var1, String var2);

    public boolean hasWildOverride(TownyWorld world, Player player, int blockId, TownyPermission.ActionType action) {
        if (this.plugin.isPermissions()) {
            if (this.has(player, PermissionNodes.TOWNY_WILD_ALL.getNode(String.valueOf(action.toString().toLowerCase()) + "." + blockId))) {
                return true;
            }
            switch (action) {
                case BUILD: {
                    return world.getUnclaimedZoneBuild();
                }
                case DESTROY: {
                    return world.getUnclaimedZoneDestroy();
                }
                case SWITCH: {
                    return world.getUnclaimedZoneSwitch();
                }
                case ITEM_USE: {
                    return world.getUnclaimedZoneItemUse();
                }
            }
        } else {
            if (this.isTownyAdmin(player)) {
                return true;
            }
            switch (action) {
                case BUILD: {
                    return world.getUnclaimedZoneBuild() != false || world.isUnclaimedZoneIgnoreId(blockId);
                }
                case DESTROY: {
                    return world.getUnclaimedZoneDestroy() != false || world.isUnclaimedZoneIgnoreId(blockId);
                }
                case SWITCH: {
                    return world.getUnclaimedZoneSwitch() != false || world.isUnclaimedZoneIgnoreId(blockId);
                }
                case ITEM_USE: {
                    return world.getUnclaimedZoneItemUse() != false || world.isUnclaimedZoneIgnoreId(blockId);
                }
            }
        }
        return false;
    }

    public boolean hasOwnTownOverride(Player player, int blockId, TownyPermission.ActionType action) {
        return this.plugin.isPermissions() ? this.has(player, PermissionNodes.TOWNY_CLAIMED_ALL.getNode("owntown." + action.toString().toLowerCase() + "." + blockId)) || this.hasAllTownOverride(player, blockId, action) : this.isTownyAdmin(player);
    }

    public boolean hasAllTownOverride(Player player, int blockId, TownyPermission.ActionType action) {
        return this.plugin.isPermissions() ? this.has(player, PermissionNodes.TOWNY_CLAIMED_ALL.getNode("alltown." + action.toString().toLowerCase() + "." + blockId)) : this.isTownyAdmin(player);
    }

    public boolean isTownyAdmin(Player player) {
        return player.isOp() || this.plugin.isPermissions() && this.has(player, PermissionNodes.TOWNY_ADMIN.getNode());
    }

    public boolean has(Player player, String node) {
        if (player.isOp()) {
            return true;
        }
        if (player.isPermissionSet(node)) {
            return player.hasPermission(node);
        }
        String[] parts = node.split("\\.");
        StringBuilder builder = new StringBuilder(node.length());
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            builder.append('*');
            if (player.hasPermission("-" + builder.toString())) {
                return false;
            }
            if (player.hasPermission(builder.toString())) {
                return true;
            }
            builder.deleteCharAt(builder.length() - 1);
            builder.append(part).append('.');
            ++n2;
        }
        return false;
    }
}

