/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.questioner;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyObservableType;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.questioner.ResidentTownQuestionTask;
import com.palmergames.bukkit.util.ChatTools;

public class JoinTownTask
extends ResidentTownQuestionTask {
    public JoinTownTask(Resident resident, Town town) {
        super(resident, town);
    }

    @Override
    public void run() {
        try {
            this.town.addResident(this.resident);
            this.towny.deleteCache(this.resident.getName());
            TownyUniverse.getDataSource().saveResident(this.resident);
            TownyUniverse.getDataSource().saveTown(this.town);
            TownyMessaging.sendTownMessage(this.town, ChatTools.color(String.format(TownySettings.getLangString("msg_join_town"), this.resident.getName())));
            this.universe.setChangedNotify(TownyObservableType.TOWN_ADD_RESIDENT);
        }
        catch (AlreadyRegisteredException e) {
            try {
                TownyMessaging.sendResidentMessage(this.resident, e.getMessage());
            }
            catch (TownyException townyException) {
                // empty catch block
            }
        }
    }
}

