/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.regen;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.regen.blockObject;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.World;
import org.bukkit.block.Block;

public class PlotBlockData {
    private int defaultVersion = 1;
    private String worldName;
    private TownBlock townBlock;
    private int x;
    private int z;
    private int size;
    private int height;
    private int version;
    private List<Integer> blockList = new ArrayList<Integer>();
    private int blockListRestored;

    public PlotBlockData(TownBlock townBlock) {
        this.townBlock = townBlock;
        this.setX(townBlock.getX());
        this.setZ(townBlock.getZ());
        this.setSize(TownySettings.getTownBlockSize());
        this.worldName = townBlock.getWorld().getName();
        this.setVersion(this.defaultVersion);
        this.setHeight(townBlock.getWorldCoord().getBukkitWorld().getMaxHeight() - 1);
        this.blockListRestored = 0;
    }

    public void initialize() {
        List<Integer> blocks = this.getBlockArr();
        if (blocks != null) {
            this.setBlockList(blocks);
            this.resetBlockListRestored();
        }
    }

    private List<Integer> getBlockArr() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Block block = null;
        World world = this.townBlock.getWorldCoord().getBukkitWorld();
        int z = 0;
        while (z < this.size) {
            int x = 0;
            while (x < this.size) {
                int y = this.height;
                while (y > 0) {
                    block = world.getBlockAt(this.getX() * this.size + x, y, this.getZ() * this.size + z);
                    switch (this.defaultVersion) {
                        case 1: {
                            list.add(block.getTypeId());
                            list.add(Integer.valueOf(block.getData()));
                            break;
                        }
                        default: {
                            list.add(block.getTypeId());
                        }
                    }
                    --y;
                }
                ++x;
            }
            ++z;
        }
        return list;
    }

    public boolean restoreNextBlock() {
        int scale;
        Block block = null;
        int worldx = this.getX() * this.size;
        int worldz = this.getZ() * this.size;
        World world = this.townBlock.getWorldCoord().getBukkitWorld();
        if (!world.isChunkLoaded(BukkitTools.calcChunk(this.getX()), BukkitTools.calcChunk(this.getZ()))) {
            return true;
        }
        switch (this.version) {
            case 1: {
                scale = 2;
                break;
            }
            default: {
                scale = 1;
            }
        }
        int reverse = (this.blockList.size() - this.blockListRestored) / scale;
        while (reverse > 0) {
            int y = this.height - --reverse % this.height;
            int x = reverse / this.height % this.size;
            int z = reverse / this.height / this.size % this.size;
            block = world.getBlockAt(worldx + x, y, worldz + z);
            int blockId = block.getTypeId();
            blockObject storedData = this.getStoredBlockData(this.blockList.size() - 1 - this.blockListRestored);
            this.blockListRestored += scale;
            if (blockId == storedData.getTypeID()) continue;
            if (!this.townBlock.getWorld().isPlotManagementIgnoreIds(storedData.getTypeID())) {
                switch (this.version) {
                    case 1: {
                        block.setTypeIdAndData(storedData.getTypeID(), storedData.getData(), false);
                        break;
                    }
                    default: {
                        block.setTypeId(storedData.getTypeID());
                        break;
                    }
                }
            } else {
                block.setTypeId(0);
            }
            return true;
        }
        this.resetBlockListRestored();
        return false;
    }

    private blockObject getStoredBlockData(int index) {
        switch (this.version) {
            case 1: {
                return new blockObject(this.blockList.get(index - 1), (byte)(this.blockList.get(index) & 0xFF));
            }
        }
        return new blockObject(this.blockList.get(index), 0);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public List<Integer> getBlockList() {
        return this.blockList;
    }

    public void setBlockList(List<Integer> blockList) {
        this.blockList = blockList;
    }

    public void resetBlockListRestored() {
        this.blockListRestored = 0;
    }
}

