/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyObservableType;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.tasks.ResidentPurge;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;

public class DailyTimerTask
extends TownyTimerTask {
    public DailyTimerTask(Towny plugin) {
        super(plugin);
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        TownyMessaging.sendDebugMsg("New Day");
        if (TownyEconomyHandler.isActive() && TownySettings.isTaxingDaily()) {
            TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_new_day_tax"), new Object[0]));
            try {
                TownyMessaging.sendDebugMsg("Collecting Town Taxes");
                this.collectTownTaxes();
                TownyMessaging.sendDebugMsg("Collecting Nation Taxes");
                this.collectNationTaxes();
                TownyMessaging.sendDebugMsg("Collecting Town Costs");
                this.collectTownCosts();
                TownyMessaging.sendDebugMsg("Collecting Nation Costs");
                this.collectNationCosts();
            }
            catch (EconomyException economyException) {
            }
            catch (TownyException e) {
                e.printStackTrace();
            }
        } else {
            TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_new_day"), new Object[0]));
        }
        if (TownySettings.isDeletingOldResidents()) {
            new ResidentPurge(this.plugin, null, TownySettings.getDeleteTime() * 1000L).start();
        }
        TownyMessaging.sendDebugMsg("Cleaning up old backups.");
        TownyUniverse.getDataSource().cleanupBackups();
        if (TownySettings.isBackingUpDaily()) {
            try {
                TownyMessaging.sendDebugMsg("Making backup.");
                TownyUniverse.getDataSource().backup();
            }
            catch (IOException e) {
                TownyMessaging.sendErrorMsg("Could not create backup.");
                e.printStackTrace();
            }
        }
        TownyMessaging.sendDebugMsg("Finished New Day Code");
        TownyMessaging.sendDebugMsg("Universe Stats:");
        TownyMessaging.sendDebugMsg("    Residents: " + TownyUniverse.getDataSource().getResidents().size());
        TownyMessaging.sendDebugMsg("    Towns: " + TownyUniverse.getDataSource().getTowns().size());
        TownyMessaging.sendDebugMsg("    Nations: " + TownyUniverse.getDataSource().getNations().size());
        for (TownyWorld world : TownyUniverse.getDataSource().getWorlds()) {
            TownyMessaging.sendDebugMsg("    " + world.getName() + " (townblocks): " + world.getTownBlocks().size());
        }
        TownyMessaging.sendDebugMsg("Memory (Java Heap):");
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (max)", Runtime.getRuntime().maxMemory() / 1024L / 1024L));
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (total)", Runtime.getRuntime().totalMemory() / 1024L / 1024L));
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (free)", Runtime.getRuntime().freeMemory() / 1024L / 1024L));
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (used=total-free)", (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L));
        TownyMessaging.sendDebugMsg("newDay took " + (System.currentTimeMillis() - start) + "ms");
    }

    public void collectNationTaxes() throws EconomyException {
        ArrayList<Nation> nations = new ArrayList<Nation>(TownyUniverse.getDataSource().getNations());
        ListIterator nationItr = nations.listIterator();
        Nation nation = null;
        while (nationItr.hasNext()) {
            nation = (Nation)nationItr.next();
            if (!TownyUniverse.getDataSource().hasNation(nation.getName())) continue;
            this.collectNationTaxes(nation);
        }
        this.universe.setChangedNotify(TownyObservableType.COLLECTED_NATION_TAX);
    }

    protected void collectNationTaxes(Nation nation) throws EconomyException {
        if (nation.getTaxes() > 0.0) {
            ArrayList<Town> towns = new ArrayList<Town>(nation.getTowns());
            ListIterator townItr = towns.listIterator();
            Town town = null;
            while (townItr.hasNext()) {
                town = (Town)townItr.next();
                if (TownyUniverse.getDataSource().hasTown(town.getName())) {
                    if (town.isCapital() || !town.hasUpkeep() || town.payTo(nation.getTaxes(), nation, "Nation Tax")) continue;
                    try {
                        TownyMessaging.sendNationMessage(nation, TownySettings.getCouldntPayTaxesMsg(town, "nation"));
                        nation.removeTown(town);
                    }
                    catch (EmptyNationException emptyNationException) {
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                    TownyUniverse.getDataSource().saveTown(town);
                    TownyUniverse.getDataSource().saveNation(nation);
                    continue;
                }
                TownyMessaging.sendTownMessage(town, String.valueOf(TownySettings.getPayedTownTaxMsg()) + nation.getTaxes());
            }
        }
    }

    public void collectTownTaxes() throws EconomyException {
        ArrayList<Town> towns = new ArrayList<Town>(TownyUniverse.getDataSource().getTowns());
        ListIterator townItr = towns.listIterator();
        Town town = null;
        while (townItr.hasNext()) {
            town = (Town)townItr.next();
            if (!TownyUniverse.getDataSource().hasTown(town.getName())) continue;
            this.collectTownTaxes(town);
        }
        this.universe.setChangedNotify(TownyObservableType.COLLECTED_TONW_TAX);
    }

    protected void collectTownTaxes(Town town) throws EconomyException {
        if (town.getTaxes() > 0.0) {
            ArrayList<Resident> residents = new ArrayList<Resident>(town.getResidents());
            ListIterator residentItr = residents.listIterator();
            Resident resident = null;
            while (residentItr.hasNext()) {
                resident = (Resident)residentItr.next();
                if (!TownyUniverse.getDataSource().hasResident(resident.getName())) continue;
                if (town.isMayor(resident) || town.hasAssistant(resident)) {
                    try {
                        TownyMessaging.sendResidentMessage(resident, TownySettings.getTaxExemptMsg());
                    }
                    catch (TownyException townyException) {}
                    continue;
                }
                if (town.isTaxPercentage()) {
                    double cost = resident.getHoldingBalance() * town.getTaxes() / 100.0;
                    resident.payTo(cost, town, "Town Tax (Percentage)");
                    continue;
                }
                if (resident.payTo(town.getTaxes(), town, "Town Tax")) continue;
                TownyMessaging.sendTownMessage(town, TownySettings.getCouldntPayTaxesMsg(resident, "town"));
                try {
                    resident.clear();
                }
                catch (EmptyTownException cost) {
                    // empty catch block
                }
                TownyUniverse.getDataSource().saveResident(resident);
                TownyUniverse.getDataSource().saveTown(town);
            }
        }
        if (town.getPlotTax() > 0.0 || town.getCommercialPlotTax() > 0.0) {
            ArrayList<TownBlock> townBlocks = new ArrayList<TownBlock>(town.getTownBlocks());
            ListIterator townBlockItr = townBlocks.listIterator();
            TownBlock townBlock = null;
            while (townBlockItr.hasNext()) {
                townBlock = (TownBlock)townBlockItr.next();
                if (!townBlock.hasResident()) continue;
                try {
                    Resident resident = townBlock.getResident();
                    if (!TownyUniverse.getDataSource().hasResident(resident.getName()) || town.isMayor(resident) || town.hasAssistant(resident) || resident.payTo(townBlock.getType().getTax(town), town, String.format("Plot Tax (%s)", new Object[]{townBlock.getType()}))) continue;
                    TownyMessaging.sendTownMessage(town, String.format(TownySettings.getLangString("msg_couldnt_pay_plot_taxes"), resident));
                    townBlock.setResident(null);
                    townBlock.setPlotPrice(-1.0);
                    townBlock.setType(townBlock.getType());
                    TownyUniverse.getDataSource().saveResident(resident);
                    TownyUniverse.getDataSource().saveTownBlock(townBlock);
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
        }
    }

    public void collectTownCosts() throws EconomyException, TownyException {
        ArrayList<Town> towns = new ArrayList<Town>(TownyUniverse.getDataSource().getTowns());
        ListIterator townItr = towns.listIterator();
        Town town = null;
        while (townItr.hasNext()) {
            town = (Town)townItr.next();
            if (!TownyUniverse.getDataSource().hasTown(town.getName()) || !town.hasUpkeep()) continue;
            double upkeep = TownySettings.getTownUpkeepCost(town);
            if (upkeep > 0.0) {
                if (town.pay(upkeep, "Town Upkeep")) continue;
                TownyUniverse.getDataSource().removeTown(town);
                TownyMessaging.sendGlobalMessage(String.valueOf(town.getName()) + TownySettings.getLangString("msg_bankrupt_town"));
                continue;
            }
            if (!(upkeep < 0.0)) continue;
            if (TownySettings.isUpkeepPayingPlots()) {
                ArrayList<TownBlock> plots = new ArrayList<TownBlock>(town.getTownBlocks());
                for (TownBlock townBlock : plots) {
                    if (townBlock.hasResident()) {
                        townBlock.getResident().pay(upkeep / (double)plots.size(), "Negative Town Upkeep - Plot income");
                        continue;
                    }
                    town.pay(upkeep / (double)plots.size(), "Negative Town Upkeep - Plot income");
                }
                continue;
            }
            town.pay(upkeep, "Negative Town Upkeep");
        }
        this.universe.setChangedNotify(TownyObservableType.UPKEEP_TOWN);
    }

    public void collectNationCosts() throws EconomyException {
        ArrayList<Nation> nations = new ArrayList<Nation>(TownyUniverse.getDataSource().getNations());
        ListIterator nationItr = nations.listIterator();
        Nation nation = null;
        while (nationItr.hasNext()) {
            nation = (Nation)nationItr.next();
            if (!TownyUniverse.getDataSource().hasNation(nation.getName())) continue;
            if (!nation.pay(TownySettings.getNationUpkeepCost(nation), "Nation Upkeep")) {
                TownyUniverse.getDataSource().removeNation(nation);
                TownyMessaging.sendGlobalMessage(String.valueOf(nation.getName()) + TownySettings.getLangString("msg_bankrupt_nation"));
            }
            if (!nation.isNeutral() || nation.pay(TownySettings.getNationNeutralityCost(), "Nation Neutrality Upkeep")) continue;
            try {
                nation.setNeutral(false);
            }
            catch (TownyException e) {
                e.printStackTrace();
            }
            TownyUniverse.getDataSource().saveNation(nation);
            TownyMessaging.sendNationMessage(nation, TownySettings.getLangString("msg_nation_not_neutral"));
        }
        this.universe.setChangedNotify(TownyObservableType.UPKEEP_NATION);
    }
}

