/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class HealthRegenTimerTask
extends TownyTimerTask {
    private Server server;

    public HealthRegenTimerTask(Towny plugin, Server server) {
        super(plugin);
        this.server = server;
    }

    @Override
    public void run() {
        if (TownyUniverse.isWarTime()) {
            return;
        }
        Player[] playerArray = this.server.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            if (player.getHealth() > 0) {
                Coord coord = Coord.parseCoord((Entity)player);
                try {
                    TownyWorld world = TownyUniverse.getDataSource().getWorld(player.getWorld().getName());
                    TownBlock townBlock = world.getTownBlock(coord);
                    if (CombatUtil.isAlly(townBlock.getTown(), TownyUniverse.getDataSource().getResident(player.getName()).getTown()) && !townBlock.getType().equals((Object)TownBlockType.ARENA)) {
                        this.incHealth(player);
                    }
                }
                catch (TownyException townyException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    public void incHealth(Player player) {
        int currentHP = player.getHealth();
        if (currentHP < 20) {
            player.setHealth(++currentHP);
            EntityRegainHealthEvent event = new EntityRegainHealthEvent((Entity)player, currentHP, EntityRegainHealthEvent.RegainReason.REGEN);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
        }
    }
}

