/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.util.JavaUtil;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class MobRemovalTimerTask
extends TownyTimerTask {
    private Server server;
    public static List<Class> worldMobsToRemove = new ArrayList<Class>();
    public static List<Class> townMobsToRemove = new ArrayList<Class>();

    public MobRemovalTimerTask(Towny plugin, Server server) {
        super(plugin);
        Class<?> c;
        this.server = server;
        worldMobsToRemove.clear();
        for (String mob : TownySettings.getWorldMobRemovalEntities()) {
            if (mob.equals("")) continue;
            try {
                c = Class.forName("org.bukkit.entity." + mob);
                if (JavaUtil.isSubInterface(LivingEntity.class, c)) {
                    worldMobsToRemove.add(c);
                    continue;
                }
                throw new Exception();
            }
            catch (ClassNotFoundException e) {
                TownyMessaging.sendErrorMsg("WorldMob: " + mob + " is not an acceptable class.");
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("WorldMob: " + mob + " is not an acceptable living entity.");
            }
        }
        townMobsToRemove.clear();
        for (String mob : TownySettings.getTownMobRemovalEntities()) {
            if (mob.equals("")) continue;
            try {
                c = Class.forName("org.bukkit.entity." + mob);
                if (JavaUtil.isSubInterface(LivingEntity.class, c)) {
                    townMobsToRemove.add(c);
                    continue;
                }
                throw new Exception();
            }
            catch (ClassNotFoundException e) {
                TownyMessaging.sendErrorMsg("TownMob: " + mob + " is not an acceptable class.");
            }
            catch (Exception e) {
                TownyMessaging.sendErrorMsg("TownMob: " + mob + " is not an acceptable living entity.");
            }
        }
    }

    public static boolean isRemovingWorldEntity(LivingEntity livingEntity) {
        for (Class c : worldMobsToRemove) {
            if (c.isInstance(livingEntity)) {
                return true;
            }
            if (!c.getName().contains(livingEntity.toString())) continue;
            System.out.print(livingEntity.toString());
        }
        return false;
    }

    public static boolean isRemovingTownEntity(LivingEntity livingEntity) {
        for (Class c : townMobsToRemove) {
            if (c.isInstance(livingEntity)) {
                return true;
            }
            if (!c.getName().contains(livingEntity.toString())) continue;
            System.out.print(livingEntity.toString());
        }
        return false;
    }

    @Override
    public void run() {
        for (World world : this.server.getWorlds()) {
            ArrayList<LivingEntity> livingEntitiesToRemove = new ArrayList<LivingEntity>();
            for (LivingEntity livingEntity : world.getLivingEntities()) {
                Coord coord = Coord.parseCoord(livingEntity.getLocation());
                TownyWorld townyWorld = null;
                try {
                    townyWorld = TownyUniverse.getDataSource().getWorld(world.getName());
                }
                catch (NotRegisteredException e) {
                    e.printStackTrace();
                    return;
                }
                try {
                    TownBlock townBlock = townyWorld.getTownBlock(coord);
                    if (townyWorld.isForceTownMobs() || townBlock.getTown().hasMobs() || townBlock.getPermissions().mobs || !MobRemovalTimerTask.isRemovingTownEntity(livingEntity)) continue;
                    if (this.plugin.isCitizens2()) {
                        if (CitizensAPI.getNPCManager().isNPC((Entity)livingEntity)) continue;
                        livingEntitiesToRemove.add(livingEntity);
                        continue;
                    }
                    livingEntitiesToRemove.add(livingEntity);
                }
                catch (TownyException x) {
                    if (townyWorld.hasWorldMobs() || !MobRemovalTimerTask.isRemovingWorldEntity(livingEntity)) continue;
                    if (this.plugin.isCitizens2()) {
                        if (CitizensAPI.getNPCManager().isNPC((Entity)livingEntity)) continue;
                        livingEntitiesToRemove.add(livingEntity);
                        continue;
                    }
                    livingEntitiesToRemove.add(livingEntity);
                }
            }
            for (LivingEntity livingEntity : livingEntitiesToRemove) {
                TownyMessaging.sendDebugMsg("MobRemoval Removed: " + livingEntity.toString());
                livingEntity.remove();
            }
        }
    }
}

