/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.regen.BlockLocation;
import com.palmergames.bukkit.towny.regen.NeedsPlaceholder;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.material.Attachable;
import org.bukkit.material.Door;
import org.bukkit.material.PistonExtensionMaterial;

public class ProtectionRegenTask
extends TownyTimerTask {
    private BlockState state;
    private BlockState altState;
    private BlockLocation blockLocation;
    private int TaskId;
    private static final Material placeholder = Material.DIRT;

    public ProtectionRegenTask(Towny plugin, Block block, boolean update) {
        super(plugin);
        this.state = block.getState();
        this.altState = null;
        this.setBlockLocation(new BlockLocation(block.getLocation()));
        if (update) {
            if (this.state.getData() instanceof Door) {
                Block bottomHalf;
                Block topHalf;
                Door door = (Door)this.state.getData();
                if (door.isTopHalf()) {
                    topHalf = block;
                    bottomHalf = block.getRelative(BlockFace.DOWN);
                } else {
                    bottomHalf = block;
                    topHalf = block.getRelative(BlockFace.UP);
                }
                bottomHalf.setTypeId(0);
                topHalf.setTypeId(0);
            } else if (this.state.getData() instanceof PistonExtensionMaterial) {
                PistonExtensionMaterial extension = (PistonExtensionMaterial)this.state.getData();
                Block piston = block.getRelative(extension.getAttachedFace());
                if (piston.getTypeId() != 0) {
                    this.altState = piston.getState();
                    piston.setTypeId(0, false);
                }
                block.setTypeId(0, false);
            } else {
                block.setTypeId(0, false);
            }
        }
    }

    @Override
    public void run() {
        this.replaceProtections();
        TownyRegenAPI.removeProtectionRegenTask(this);
    }

    public void replaceProtections() {
        Block block = this.state.getBlock();
        if (this.state.getData() instanceof Door) {
            Block bottomHalf;
            Block topHalf;
            Door door = (Door)this.state.getData();
            if (door.isTopHalf()) {
                topHalf = block;
                bottomHalf = block.getRelative(BlockFace.DOWN);
            } else {
                bottomHalf = block;
                topHalf = block.getRelative(BlockFace.UP);
            }
            door.setTopHalf(true);
            topHalf.setTypeIdAndData(this.state.getTypeId(), this.state.getData().getData(), false);
            door.setTopHalf(false);
            bottomHalf.setTypeIdAndData(this.state.getTypeId(), this.state.getData().getData(), false);
        } else if (this.state instanceof Sign) {
            block.setTypeIdAndData(this.state.getTypeId(), this.state.getData().getData(), false);
            Sign sign = (Sign)block.getState();
            int i = 0;
            String[] stringArray = ((Sign)this.state).getLines();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                sign.setLine(i++, line);
                ++n2;
            }
        } else if (this.state.getData() instanceof PistonExtensionMaterial) {
            PistonExtensionMaterial extension = (PistonExtensionMaterial)this.state.getData();
            Block piston = block.getRelative(extension.getAttachedFace());
            block.setTypeIdAndData(this.state.getTypeId(), this.state.getData().getData(), false);
            if (this.altState != null) {
                piston.setTypeIdAndData(this.altState.getTypeId(), this.altState.getData().getData(), false);
            }
        } else if (this.state.getData() instanceof Attachable) {
            Block attachedBlock = block.getRelative(((Attachable)this.state.getData()).getAttachedFace());
            if (attachedBlock.getTypeId() == 0) {
                attachedBlock.setTypeId(placeholder.getId(), false);
                TownyRegenAPI.addPlaceholder(attachedBlock);
            }
            block.setTypeIdAndData(this.state.getTypeId(), this.state.getData().getData(), false);
        } else {
            Block blockBelow;
            if (NeedsPlaceholder.contains(this.state.getType()) && (blockBelow = block.getRelative(BlockFace.DOWN)).getTypeId() == 0) {
                if (this.state.getType().equals((Object)Material.CROPS)) {
                    blockBelow.setTypeId(Material.SOIL.getId(), true);
                } else {
                    blockBelow.setTypeId(placeholder.getId(), true);
                }
                TownyRegenAPI.addPlaceholder(blockBelow);
            }
            block.setTypeIdAndData(this.state.getTypeId(), this.state.getData().getData(), !NeedsPlaceholder.contains(this.state.getType()));
        }
        TownyRegenAPI.removePlaceholder(block);
    }

    public BlockLocation getBlockLocation() {
        return this.blockLocation;
    }

    private void setBlockLocation(BlockLocation blockLocation) {
        this.blockLocation = blockLocation;
    }

    public BlockState getState() {
        return this.state;
    }

    public int getTaskId() {
        return this.TaskId;
    }

    public void setTaskId(int taskId) {
        this.TaskId = taskId;
    }
}

