/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.List;

public class AreaSelectionUtil {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<WorldCoord> selectWorldCoordArea(TownBlockOwner owner, WorldCoord pos, String[] args) throws TownyException {
        void var3_8;
        ArrayList<WorldCoord> arrayList = new ArrayList<WorldCoord>();
        if (args.length == 0) {
            if (!pos.getTownyWorld().isClaimable()) throw new TownyException(TownySettings.getLangString("msg_not_claimable"));
            arrayList.add(pos);
            return var3_8;
        }
        if (args.length > 1) {
            if (args[0].equalsIgnoreCase("rect")) {
                List<WorldCoord> list = AreaSelectionUtil.selectWorldCoordAreaRect(owner, pos, StringMgmt.remFirstArg(args));
                return var3_8;
            } else {
                if (!args[0].equalsIgnoreCase("circle")) throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_property"), StringMgmt.join(args, " ")));
                List<WorldCoord> list = AreaSelectionUtil.selectWorldCoordAreaCircle(owner, pos, StringMgmt.remFirstArg(args));
            }
            return var3_8;
        }
        if (args[0].equalsIgnoreCase("auto")) {
            List<WorldCoord> list = AreaSelectionUtil.selectWorldCoordAreaRect(owner, pos, args);
            return var3_8;
        }
        try {
            Integer.parseInt(args[0]);
            List<WorldCoord> list = AreaSelectionUtil.selectWorldCoordAreaRect(owner, pos, args);
            return var3_8;
        }
        catch (NumberFormatException e) {
            throw new TownyException(String.format(TownySettings.getLangString("msg_err_invalid_property"), args[0]));
        }
    }

    public static List<WorldCoord> selectWorldCoordAreaRect(TownBlockOwner owner, WorldCoord pos, String[] args) throws TownyException {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        if (pos.getTownyWorld().isClaimable()) {
            if (args.length > 0) {
                int r = 0;
                int available = 0;
                if (owner instanceof Town) {
                    Town town = (Town)owner;
                    available = TownySettings.getMaxTownBlocks(town) - town.getTownBlocks().size();
                } else if (owner instanceof Resident) {
                    available = TownySettings.getMaxResidentPlots((Resident)owner);
                }
                if (args[0].equalsIgnoreCase("auto")) {
                    while ((double)available - Math.pow((r + 1) * 2 - 1, 2.0) >= 0.0) {
                        ++r;
                    }
                } else {
                    try {
                        r = Integer.parseInt(args[0]);
                    }
                    catch (NumberFormatException e) {
                        throw new TownyException(TownySettings.getLangString("msg_err_invalid_radius"));
                    }
                }
                if (r > 1000) {
                    r = 1000;
                }
                int z = -r;
                while (z <= r) {
                    int x = -r;
                    while (x <= r) {
                        if (out.size() < available) {
                            out.add(new WorldCoord(pos.getWorldName(), pos.getX() + x, pos.getZ() + z));
                        }
                        ++x;
                    }
                    ++z;
                }
            } else {
                throw new TownyException(TownySettings.getLangString("msg_err_invalid_radius"));
            }
        }
        return out;
    }

    public static List<WorldCoord> selectWorldCoordAreaCircle(TownBlockOwner owner, WorldCoord pos, String[] args) throws TownyException {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        if (pos.getTownyWorld().isClaimable()) {
            if (args.length > 0) {
                int r = 0;
                int available = 0;
                if (owner instanceof Town) {
                    Town town = (Town)owner;
                    available = TownySettings.getMaxTownBlocks(town) - town.getTownBlocks().size();
                } else if (owner instanceof Resident) {
                    available = TownySettings.getMaxResidentPlots((Resident)owner);
                }
                if (args[0].equalsIgnoreCase("auto")) {
                    if (available > 0) {
                        while ((double)available - Math.ceil(Math.PI * (double)r * (double)r) >= 0.0) {
                            ++r;
                        }
                    }
                } else {
                    try {
                        r = Integer.parseInt(args[0]);
                    }
                    catch (NumberFormatException e) {
                        throw new TownyException(TownySettings.getLangString("msg_err_invalid_radius"));
                    }
                }
                if (r > 1000) {
                    r = 1000;
                }
                int z = -r;
                while (z <= r) {
                    int x = -r;
                    while (x <= r) {
                        if (x * x + z * z <= r * r && out.size() < available) {
                            out.add(new WorldCoord(pos.getWorldName(), pos.getX() + x, pos.getZ() + z));
                        }
                        ++x;
                    }
                    ++z;
                }
            } else {
                throw new TownyException(TownySettings.getLangString("msg_err_invalid_radius"));
            }
        }
        return out;
    }

    public static List<WorldCoord> filterTownOwnedBlocks(List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (worldCoord.getTownBlock().hasTown()) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException e) {
                out.add(worldCoord);
            }
        }
        return out;
    }

    public static List<WorldCoord> filterOwnedBlocks(TownBlockOwner owner, List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (!worldCoord.getTownBlock().isOwner(owner)) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return out;
    }

    public static List<WorldCoord> filterPlotsForSale(List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (!worldCoord.getTownBlock().isForSale()) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return out;
    }

    public static List<WorldCoord> filterPlotsNotForSale(List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (!worldCoord.getTownBlock().isForSale()) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return out;
    }

    public static List<WorldCoord> filterUnownedPlots(List<WorldCoord> selection) {
        ArrayList<WorldCoord> out = new ArrayList<WorldCoord>();
        for (WorldCoord worldCoord : selection) {
            try {
                if (!(worldCoord.getTownBlock().getPlotPrice() > -1.0)) continue;
                out.add(worldCoord);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return out;
    }

    public static int getAreaSelectPivot(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("within")) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isOnEdgeOfOwnership(TownBlockOwner owner, WorldCoord worldCoord) {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[2];
        nArray[0] = -1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = -1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = 1;
        nArrayArray[3] = nArray4;
        int[][] offset = nArrayArray;
        int i = 0;
        while (i < 4) {
            try {
                TownBlock edgeTownBlock = worldCoord.getTownyWorld().getTownBlock(new Coord(worldCoord.getX() + offset[i][0], worldCoord.getZ() + offset[i][1]));
                if (!edgeTownBlock.isOwner(owner)) {
                    return true;
                }
            }
            catch (NotRegisteredException e) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

