/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import java.util.List;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;

public class CombatUtil {
    public static boolean preventDamageCall(Entity attacker, Entity defender) {
        TownyWorld world;
        block6: {
            try {
                world = TownyUniverse.getDataSource().getWorld(defender.getWorld().getName());
                if (world.isUsingTowny()) break block6;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        Player a = null;
        Player b = null;
        if (attacker instanceof Projectile) {
            Projectile projectile = (Projectile)attacker;
            attacker = projectile.getShooter();
        }
        if (attacker instanceof Player) {
            a = (Player)attacker;
        }
        if (defender instanceof Player) {
            b = (Player)defender;
        }
        return CombatUtil.preventDamageCall(world, attacker, defender, a, b);
    }

    public static boolean preventDamageCall(TownyWorld world, Entity attackingEntity, Entity defendingEntity, Player attackingPlayer, Player defendingPlayer) {
        block17: {
            if (!world.isUsingTowny()) {
                return false;
            }
            if (attackingPlayer != null) {
                Coord coord = Coord.parseCoord(defendingEntity);
                TownBlock defenderTB = null;
                TownBlock attackerTB = null;
                try {
                    attackerTB = world.getTownBlock(Coord.parseCoord(attackingEntity));
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                try {
                    defenderTB = world.getTownBlock(coord);
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                if (defendingPlayer != null || defenderTB != null && defendingEntity instanceof Wolf && ((Wolf)defendingEntity).isTamed() && !((Wolf)defendingEntity).getOwner().equals((AnimalTamer)attackingEntity)) {
                    if (world.isWarZone(coord)) {
                        return false;
                    }
                    if (CombatUtil.isPvPPlot(attackingPlayer, defendingPlayer)) {
                        return false;
                    }
                    if (CombatUtil.preventFriendlyFire(attackingPlayer, defendingPlayer)) {
                        return true;
                    }
                    if (CombatUtil.preventPvP(world, attackerTB)) {
                        return true;
                    }
                    if (CombatUtil.preventPvP(world, defenderTB)) {
                        return true;
                    }
                } else if (defenderTB != null && (defendingEntity instanceof Animals || defendingEntity instanceof Villager)) {
                    try {
                        if (defenderTB.getTown().equals(TownyUniverse.getDataSource().getResident(attackingPlayer.getName()).getTown()) && PlayerCacheUtil.getCachePermission(attackingPlayer, attackingPlayer.getLocation(), 3, TownyPermission.ActionType.DESTROY)) {
                            return false;
                        }
                    }
                    catch (NotRegisteredException e) {
                        if (!PlayerCacheUtil.getCachePermission(attackingPlayer, attackingPlayer.getLocation(), 3, TownyPermission.ActionType.DESTROY)) break block17;
                        return false;
                    }
                }
            }
        }
        return false;
    }

    public static boolean preventPvP(TownyWorld world, TownBlock townBlock) {
        block6: {
            if (townBlock != null) {
                try {
                    if (!townBlock.getTown().isPVP() && !townBlock.getPermissions().pvp) {
                        return true;
                    }
                    break block6;
                }
                catch (NotRegisteredException ex) {
                    if (CombatUtil.preventPvP(world)) {
                        return true;
                    }
                    break block6;
                }
            }
            if (CombatUtil.preventPvP(world)) {
                return true;
            }
        }
        return false;
    }

    public static boolean preventPvP(TownyWorld world) {
        return !world.isForcePVP() && !world.isPVP();
    }

    public static boolean preventFriendlyFire(Player attacker, Player defender) {
        if (attacker != null && defender != null && !TownySettings.getFriendlyFire() && CombatUtil.isAlly(attacker.getName(), defender.getName())) {
            try {
                TownBlock townBlock = new WorldCoord(defender.getWorld().getName(), Coord.parseCoord((Entity)defender)).getTownBlock();
                if (!townBlock.getType().equals((Object)TownBlockType.ARENA)) {
                    return true;
                }
            }
            catch (TownyException x) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPvPPlot(Player attacker, Player defender) {
        if (attacker != null && defender != null) {
            try {
                TownBlock attackerTB = new WorldCoord(attacker.getWorld().getName(), Coord.parseCoord((Entity)attacker)).getTownBlock();
                TownBlock defenderTB = new WorldCoord(defender.getWorld().getName(), Coord.parseCoord((Entity)defender)).getTownBlock();
                if (defenderTB.getType().equals((Object)TownBlockType.ARENA) && attackerTB.getType().equals((Object)TownBlockType.ARENA)) {
                    return true;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isAlly(String attackingResident, String defendingResident) {
        Resident residentB;
        Resident residentA;
        block5: {
            block4: {
                try {
                    residentA = TownyUniverse.getDataSource().getResident(attackingResident);
                    residentB = TownyUniverse.getDataSource().getResident(defendingResident);
                    if (residentA.getTown() != residentB.getTown()) break block4;
                    return true;
                }
                catch (NotRegisteredException e) {
                    return false;
                }
            }
            if (residentA.getTown().getNation() != residentB.getTown().getNation()) break block5;
            return true;
        }
        return residentA.getTown().getNation().hasAlly(residentB.getTown().getNation());
    }

    public static boolean isAlly(Town a, Town b) {
        block5: {
            block4: {
                try {
                    if (a != b) break block4;
                    return true;
                }
                catch (NotRegisteredException e) {
                    return false;
                }
            }
            if (a.getNation() != b.getNation()) break block5;
            return true;
        }
        return a.getNation().hasAlly(b.getNation());
    }

    public static boolean canAttackEnemy(String a, String b) {
        Nation nationB;
        Nation nationA;
        block7: {
            Resident residentB;
            Resident residentA;
            block6: {
                block5: {
                    try {
                        residentA = TownyUniverse.getDataSource().getResident(a);
                        residentB = TownyUniverse.getDataSource().getResident(b);
                        if (residentA.getTown() != residentB.getTown()) break block5;
                        return false;
                    }
                    catch (NotRegisteredException e) {
                        return false;
                    }
                }
                if (residentA.getTown().getNation() != residentB.getTown().getNation()) break block6;
                return false;
            }
            nationA = residentA.getTown().getNation();
            nationB = residentB.getTown().getNation();
            if (!nationA.isNeutral() && !nationB.isNeutral()) break block7;
            return false;
        }
        return nationA.hasEnemy(nationB);
    }

    public static boolean areAllAllies(List<Nation> possibleAllies) {
        if (possibleAllies.size() <= 1) {
            return true;
        }
        int i = 0;
        while (i < possibleAllies.size() - 1) {
            if (!possibleAllies.get(i).hasAlly(possibleAllies.get(i + 1))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEnemy(String a, String b) {
        Resident residentB;
        Resident residentA;
        block5: {
            block4: {
                try {
                    residentA = TownyUniverse.getDataSource().getResident(a);
                    residentB = TownyUniverse.getDataSource().getResident(b);
                    if (residentA.getTown() != residentB.getTown()) break block4;
                    return false;
                }
                catch (NotRegisteredException e) {
                    return false;
                }
            }
            if (residentA.getTown().getNation() != residentB.getTown().getNation()) break block5;
            return false;
        }
        return residentA.getTown().getNation().hasEnemy(residentB.getTown().getNation());
    }

    public static boolean isEnemy(Town a, Town b) {
        block5: {
            block4: {
                try {
                    if (a != b) break block4;
                    return false;
                }
                catch (NotRegisteredException e) {
                    return false;
                }
            }
            if (a.getNation() != b.getNation()) break block5;
            return false;
        }
        return a.getNation().hasEnemy(b.getNation());
    }

    public boolean isEnemyTownBlock(Player player, WorldCoord worldCoord) {
        try {
            return CombatUtil.isEnemy(TownyUniverse.getDataSource().getResident(player.getName()).getTown(), worldCoord.getTownBlock().getTown());
        }
        catch (NotRegisteredException e) {
            return false;
        }
    }
}

