/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class PlayerCacheUtil {
    static Towny plugin = null;

    public static void initialize(Towny plugin) {
        PlayerCacheUtil.plugin = plugin;
    }

    public static boolean getCachePermission(Player player, Location location, Integer blockId, TownyPermission.ActionType action) {
        try {
            WorldCoord worldCoord = new WorldCoord(player.getWorld().getName(), Coord.parseCoord(location));
            PlayerCache cache = plugin.getCache(player);
            cache.updateCoord(worldCoord);
            TownyMessaging.sendDebugMsg("Cache permissions for " + action.toString() + " : " + cache.getCachePermission(blockId, action));
            return cache.getCachePermission(blockId, action);
        }
        catch (NullPointerException e) {
            WorldCoord worldCoord = new WorldCoord(player.getWorld().getName(), Coord.parseCoord(location));
            PlayerCache.TownBlockStatus status = PlayerCacheUtil.cacheStatus(player, worldCoord, PlayerCacheUtil.getTownBlockStatus(player, worldCoord));
            PlayerCacheUtil.triggerCacheCreate(player, location, worldCoord, status, blockId, action);
            PlayerCache cache = plugin.getCache(player);
            cache.updateCoord(worldCoord);
            TownyMessaging.sendDebugMsg("New Cache permissions for " + blockId + ":" + action.toString() + " = " + cache.getCachePermission(blockId, action));
            return cache.getCachePermission(blockId, action);
        }
    }

    private static void triggerCacheCreate(Player player, Location location, WorldCoord worldCoord, PlayerCache.TownBlockStatus status, Integer id, TownyPermission.ActionType action) {
        switch (action) {
            case BUILD: {
                PlayerCacheUtil.cacheBuild(player, worldCoord, id, PlayerCacheUtil.getPermission(player, status, worldCoord, id, action));
                return;
            }
            case DESTROY: {
                PlayerCacheUtil.cacheDestroy(player, worldCoord, id, PlayerCacheUtil.getPermission(player, status, worldCoord, id, action));
                return;
            }
            case SWITCH: {
                PlayerCacheUtil.cacheSwitch(player, worldCoord, id, PlayerCacheUtil.getPermission(player, status, worldCoord, id, action));
                return;
            }
            case ITEM_USE: {
                PlayerCacheUtil.cacheItemUse(player, worldCoord, id, PlayerCacheUtil.getPermission(player, status, worldCoord, id, action));
                return;
            }
        }
    }

    public static PlayerCache.TownBlockStatus cacheStatus(Player player, WorldCoord worldCoord, PlayerCache.TownBlockStatus townBlockStatus) {
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        cache.setStatus(townBlockStatus);
        TownyMessaging.sendDebugMsg(String.valueOf(player.getName()) + " (" + worldCoord.toString() + ") Cached Status: " + (Object)((Object)townBlockStatus));
        return townBlockStatus;
    }

    private static void cacheBuild(Player player, WorldCoord worldCoord, Integer id, Boolean buildRight) {
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        cache.setBuildPermission(id, buildRight);
        TownyMessaging.sendDebugMsg(String.valueOf(player.getName()) + " (" + worldCoord.toString() + ") Cached Build: " + buildRight);
    }

    private static void cacheDestroy(Player player, WorldCoord worldCoord, Integer id, Boolean destroyRight) {
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        cache.setDestroyPermission(id, destroyRight);
        TownyMessaging.sendDebugMsg(String.valueOf(player.getName()) + " (" + worldCoord.toString() + ") Cached Destroy: " + destroyRight);
    }

    private static void cacheSwitch(Player player, WorldCoord worldCoord, Integer id, Boolean switchRight) {
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        cache.setSwitchPermission(id, switchRight);
        TownyMessaging.sendDebugMsg(String.valueOf(player.getName()) + " (" + worldCoord.toString() + ") Cached Switch: " + switchRight);
    }

    private static void cacheItemUse(Player player, WorldCoord worldCoord, Integer id, Boolean itemUseRight) {
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        cache.setItemUsePermission(id, itemUseRight);
        TownyMessaging.sendDebugMsg(String.valueOf(player.getName()) + " (" + worldCoord.toString() + ") Cached Item Use: " + itemUseRight);
    }

    public static void cacheBlockErrMsg(Player player, String msg) {
        PlayerCache cache = plugin.getCache(player);
        cache.setBlockErrMsg(msg);
    }

    public static PlayerCache.TownBlockStatus getTownBlockStatus(Player player, WorldCoord worldCoord) {
        Resident resident;
        Town town;
        TownBlock townBlock;
        try {
            if (!worldCoord.getTownyWorld().isUsingTowny()) {
                return PlayerCache.TownBlockStatus.OFF_WORLD;
            }
        }
        catch (NotRegisteredException ex) {
            return PlayerCache.TownBlockStatus.NOT_REGISTERED;
        }
        try {
            townBlock = worldCoord.getTownBlock();
            town = townBlock.getTown();
            if (townBlock.isLocked()) {
                if (town.getWorld().isUsingPlotManagementRevert() && TownySettings.getPlotManagementSpeed() > 0L) {
                    TownyRegenAPI.addWorldCoord(townBlock.getWorldCoord());
                    return PlayerCache.TownBlockStatus.LOCKED;
                }
                townBlock.setLocked(false);
            }
        }
        catch (NotRegisteredException e) {
            return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        try {
            resident = TownyUniverse.getDataSource().getResident(player.getName());
        }
        catch (TownyException e) {
            System.out.print("Failed to fetch resident: " + player.getName());
            return PlayerCache.TownBlockStatus.NOT_REGISTERED;
        }
        try {
            if (TownyUniverse.isWarTime()) {
                if (TownySettings.isAllowWarBlockGriefing()) {
                    try {
                        if (!resident.getTown().getNation().isNeutral() && !town.getNation().isNeutral()) {
                            return PlayerCache.TownBlockStatus.WARZONE;
                        }
                    }
                    catch (NotRegisteredException e) {
                        // empty catch block
                    }
                }
                if (!TownySettings.isWarTimeTownsNeutral() && !town.hasNation()) {
                    return PlayerCache.TownBlockStatus.WARZONE;
                }
            }
            try {
                if (townBlock.getTown().isMayor(resident) || townBlock.getTown().hasAssistant(resident)) {
                    return PlayerCache.TownBlockStatus.TOWN_OWNER;
                }
            }
            catch (NotRegisteredException e) {
                // empty catch block
            }
            try {
                Resident owner = townBlock.getResident();
                if (resident == owner) {
                    return PlayerCache.TownBlockStatus.PLOT_OWNER;
                }
                if (owner.hasFriend(resident)) {
                    return PlayerCache.TownBlockStatus.PLOT_FRIEND;
                }
                if (resident.hasTown() && CombatUtil.isAlly(owner.getTown(), resident.getTown())) {
                    return PlayerCache.TownBlockStatus.PLOT_ALLY;
                }
                throw new TownyException();
            }
            catch (NotRegisteredException owner) {
            }
            catch (TownyException owner) {
                // empty catch block
            }
            if (!resident.hasTown()) {
                if (townBlock.isWarZone()) {
                    if (!TownySettings.isWarTimeTownsNeutral()) {
                        return PlayerCache.TownBlockStatus.WARZONE;
                    }
                    return PlayerCache.TownBlockStatus.OUTSIDER;
                }
                throw new TownyException();
            }
            if (resident.getTown() != town) {
                if (CombatUtil.isAlly(town, resident.getTown())) {
                    return PlayerCache.TownBlockStatus.TOWN_ALLY;
                }
                if (CombatUtil.isEnemy(resident.getTown(), town)) {
                    if (townBlock.isWarZone()) {
                        return PlayerCache.TownBlockStatus.WARZONE;
                    }
                    return PlayerCache.TownBlockStatus.ENEMY;
                }
                return PlayerCache.TownBlockStatus.OUTSIDER;
            }
            if (resident.isMayor() || resident.getTown().hasAssistant(resident)) {
                return PlayerCache.TownBlockStatus.TOWN_OWNER;
            }
            return PlayerCache.TownBlockStatus.TOWN_RESIDENT;
        }
        catch (TownyException e) {
            return PlayerCache.TownBlockStatus.OUTSIDER;
        }
    }

    private static boolean getPermission(Player player, PlayerCache.TownBlockStatus status, WorldCoord pos, Integer blockId, TownyPermission.ActionType action) {
        Town targetTown;
        Town playersTown;
        TownBlock townBlock;
        block33: {
            if (status == PlayerCache.TownBlockStatus.OFF_WORLD || status == PlayerCache.TownBlockStatus.WARZONE || status == PlayerCache.TownBlockStatus.PLOT_OWNER || status == PlayerCache.TownBlockStatus.TOWN_OWNER) {
                return true;
            }
            if (status == PlayerCache.TownBlockStatus.NOT_REGISTERED) {
                PlayerCacheUtil.cacheBlockErrMsg(player, TownySettings.getLangString("msg_cache_block_error"));
                return false;
            }
            if (status == PlayerCache.TownBlockStatus.LOCKED) {
                PlayerCacheUtil.cacheBlockErrMsg(player, TownySettings.getLangString("msg_cache_block_error_locked"));
                return false;
            }
            townBlock = null;
            playersTown = null;
            targetTown = null;
            try {
                playersTown = TownyUniverse.getDataSource().getResident(player.getName()).getTown();
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            try {
                townBlock = pos.getTownBlock();
                targetTown = townBlock.getTown();
            }
            catch (NotRegisteredException e) {
                block34: {
                    try {
                        if (status != PlayerCache.TownBlockStatus.UNCLAIMED_ZONE) break block33;
                        if (!TownyUniverse.getPermissionSource().hasWildOverride(pos.getTownyWorld(), player, blockId, action)) break block34;
                        return true;
                    }
                    catch (NotRegisteredException e2) {
                        TownyMessaging.sendErrorMsg((Object)player, "Error updating " + action.toString() + " permission.");
                        return false;
                    }
                }
                PlayerCacheUtil.cacheBlockErrMsg(player, String.format(TownySettings.getLangString("msg_cache_block_error_wild"), action.toString()));
                return false;
            }
        }
        if (TownyUniverse.getPermissionSource().isTownyAdmin(player)) {
            return true;
        }
        try {
            if (townBlock.getType() == TownBlockType.WILDS && TownyUniverse.getPermissionSource().hasWildOverride(pos.getTownyWorld(), player, blockId, action)) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (townBlock.hasResident()) {
            if (targetTown.equals(playersTown) && TownyUniverse.getPermissionSource().hasOwnTownOverride(player, blockId, action)) {
                return true;
            }
            if (!targetTown.equals(playersTown) && TownyUniverse.getPermissionSource().hasAllTownOverride(player, blockId, action)) {
                return true;
            }
            if (status == PlayerCache.TownBlockStatus.PLOT_FRIEND) {
                if (townBlock.getPermissions().getResidentPerm(action)) {
                    return true;
                }
                PlayerCacheUtil.cacheBlockErrMsg(player, String.format(TownySettings.getLangString("msg_cache_block_error_plot"), "friends", action.toString()));
                return false;
            }
            if (status == PlayerCache.TownBlockStatus.PLOT_ALLY) {
                if (townBlock.getPermissions().getAllyPerm(action)) {
                    return true;
                }
                PlayerCacheUtil.cacheBlockErrMsg(player, String.format(TownySettings.getLangString("msg_cache_block_error_plot"), "allies", action.toString()));
                return false;
            }
            if (townBlock.getPermissions().getOutsiderPerm(action)) {
                return true;
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, String.format(TownySettings.getLangString("msg_cache_block_error_plot"), "outsiders", action.toString()));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.TOWN_RESIDENT) {
            if (targetTown.equals(playersTown) && TownyUniverse.getPermissionSource().hasOwnTownOverride(player, blockId, action)) {
                return true;
            }
            if (!targetTown.equals(playersTown) && TownyUniverse.getPermissionSource().hasAllTownOverride(player, blockId, action)) {
                return true;
            }
            if (townBlock.getPermissions().getResidentPerm(action)) {
                return true;
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, String.format(TownySettings.getLangString("msg_cache_block_error_town_resident"), action.toString()));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.TOWN_ALLY) {
            if (targetTown.equals(playersTown) && TownyUniverse.getPermissionSource().hasOwnTownOverride(player, blockId, action)) {
                return true;
            }
            if (!targetTown.equals(playersTown) && TownyUniverse.getPermissionSource().hasAllTownOverride(player, blockId, action)) {
                return true;
            }
            if (townBlock.getPermissions().getAllyPerm(action)) {
                return true;
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, String.format(TownySettings.getLangString("msg_cache_block_error_town_allies"), action.toString()));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.OUTSIDER || status == PlayerCache.TownBlockStatus.ENEMY) {
            if (TownyUniverse.getPermissionSource().hasAllTownOverride(player, blockId, action)) {
                return true;
            }
            if (townBlock.getPermissions().getOutsiderPerm(action)) {
                return true;
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, String.format(TownySettings.getLangString("msg_cache_block_error_town_outsider"), action.toString()));
            return false;
        }
        TownyMessaging.sendErrorMsg((Object)player, "Error updating " + action.toString() + " permission.");
        return false;
    }
}

