/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.eventwar;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyEconomyObject;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.war.eventwar.StartWarTimerTask;
import com.palmergames.bukkit.towny.war.eventwar.WarSpoils;
import com.palmergames.bukkit.towny.war.eventwar.WarTimerTask;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.ServerBroadCastTimerTask;
import com.palmergames.util.KeyValue;
import com.palmergames.util.KeyValueTable;
import com.palmergames.util.TimeMgmt;
import com.palmergames.util.TimeTools;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class War {
    private Hashtable<WorldCoord, Integer> warZone = new Hashtable();
    private Hashtable<Town, Integer> townScores = new Hashtable();
    private List<Town> warringTowns = new ArrayList<Town>();
    private List<Nation> warringNations = new ArrayList<Nation>();
    private Towny plugin;
    private TownyUniverse universe;
    private boolean warTime = false;
    private List<Integer> warTaskIds = new ArrayList<Integer>();
    private WarSpoils warSpoils = new WarSpoils();

    public War(Towny plugin, int startDelay) {
        this.plugin = plugin;
        this.universe = plugin.getTownyUniverse();
        this.setupDelay(startDelay);
    }

    public void addTaskId(int id) {
        this.warTaskIds.add(id);
    }

    public void clearTaskIds() {
        this.warTaskIds.clear();
    }

    public void cancelTasks(BukkitScheduler scheduler) {
        for (Integer id : this.getTaskIds()) {
            scheduler.cancelTask(id.intValue());
        }
        this.clearTaskIds();
    }

    public List<Integer> getTaskIds() {
        return new ArrayList<Integer>(this.warTaskIds);
    }

    public Towny getPlugin() {
        return this.plugin;
    }

    public void setPlugin(Towny plugin) {
        this.plugin = plugin;
    }

    public void setupDelay(int delay) {
        if (delay <= 0) {
            this.start();
        } else {
            for (Long t : TimeMgmt.getCountdownDelays(delay, TimeMgmt.defaultCountdownDelays)) {
                int id = this.plugin.getServer().getScheduler().scheduleAsyncDelayedTask((Plugin)this.getPlugin(), (Runnable)new ServerBroadCastTimerTask(this.plugin, String.format("War starts in %s", TimeMgmt.formatCountdownTime(t))), TimeTools.convertToTicks((long)delay - t));
                if (id == -1) {
                    TownyMessaging.sendErrorMsg("Could not schedule a countdown message for war event.");
                    this.end();
                    continue;
                }
                this.addTaskId(id);
            }
            int id = BukkitTools.scheduleAsyncDelayedTask(new StartWarTimerTask(this.plugin), TimeTools.convertToTicks(delay));
            if (id == -1) {
                TownyMessaging.sendErrorMsg("Could not schedule setup delay for war event.");
                this.end();
            } else {
                this.addTaskId(id);
            }
        }
    }

    public boolean isWarTime() {
        return this.warTime;
    }

    public TownyUniverse getTownyUniverse() {
        return this.universe;
    }

    public void start() {
        this.warTime = true;
        try {
            this.warSpoils.pay(TownySettings.getBaseSpoilsOfWar(), "Start of War - Base Spoils");
            TownyMessaging.sendMsg("[War] Seeding spoils of war with " + TownySettings.getBaseSpoilsOfWar());
        }
        catch (EconomyException e) {
            TownyMessaging.sendErrorMsg("[War] Could not seed spoils of war.");
        }
        for (Nation nation : TownyUniverse.getDataSource().getNations()) {
            if (!nation.isNeutral()) {
                this.add(nation);
                TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_war_join_nation"), nation.getName()));
                continue;
            }
            if (TownySettings.isDeclaringNeutral()) continue;
            try {
                nation.setNeutral(false);
                this.add(nation);
                TownyMessaging.sendGlobalMessage(String.format(TownySettings.getLangString("msg_war_join_forced"), nation.getName()));
            }
            catch (TownyException e) {
                e.printStackTrace();
            }
        }
        int id = this.plugin.getServer().getScheduler().scheduleAsyncRepeatingTask((Plugin)this.getPlugin(), (Runnable)new WarTimerTask(this.plugin, this), 0L, TimeTools.convertToTicks(5L));
        if (id == -1) {
            TownyMessaging.sendErrorMsg("Could not schedule war event loop.");
            this.end();
        } else {
            this.addTaskId(id);
        }
        this.checkEnd();
    }

    public void end() {
        Player[] playerArray = BukkitTools.getOnlinePlayers();
        int n = playerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            if (player != null) {
                this.sendStats(player);
            }
            ++n2;
        }
        try {
            double halfWinnings = this.getWarSpoils().getHoldingBalance() / 2.0;
            try {
                double nationWinnings = halfWinnings / (double)this.warringNations.size();
                for (Nation winningNation : this.warringNations) {
                    this.getWarSpoils().payTo(nationWinnings, winningNation, "War - Nation Winnings");
                    TownyMessaging.sendGlobalMessage("Winning Nation: " + winningNation.getName() + " won " + TownyEconomyHandler.getFormattedBalance(nationWinnings) + ".");
                }
            }
            catch (ArithmeticException nationWinnings) {
                // empty catch block
            }
            try {
                KeyValue<Town, Integer> winningTownScore = this.getWinningTownScore();
                this.getWarSpoils().payTo(halfWinnings, (TownyEconomyObject)winningTownScore.key, "War - Town Winnings");
                TownyMessaging.sendGlobalMessage("Highest Score: " + ((Town)winningTownScore.key).getName() + " won " + TownyEconomyHandler.getFormattedBalance(halfWinnings) + " with the score " + winningTownScore.value + ".");
            }
            catch (TownyException townyException) {}
        }
        catch (EconomyException economyException) {
            // empty catch block
        }
    }

    public void add(Nation nation) {
        for (Town town : nation.getTowns()) {
            this.add(town);
        }
        this.warringNations.add(nation);
    }

    public void add(Town town) {
        TownyMessaging.sendTownMessage(town, TownySettings.getJoinWarMsg(town));
        this.townScores.put(town, 0);
        this.warringTowns.add(town);
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (town.isHomeBlock(townBlock)) {
                this.warZone.put(townBlock.getWorldCoord(), TownySettings.getWarzoneHomeBlockHealth());
                continue;
            }
            this.warZone.put(townBlock.getWorldCoord(), TownySettings.getWarzoneTownBlockHealth());
        }
    }

    public boolean isWarZone(WorldCoord worldCoord) {
        return this.warZone.containsKey(worldCoord);
    }

    public void townScored(Town town, int n) {
        this.townScores.put(town, this.townScores.get(town) + n);
        TownyMessaging.sendTownMessage(town, TownySettings.getWarTimeScoreMsg(town, n));
    }

    public void damage(Town attacker, TownBlock townBlock) throws NotRegisteredException {
        WorldCoord worldCoord = townBlock.getWorldCoord();
        int hp = this.warZone.get(worldCoord) - 1;
        if (hp > 0) {
            this.warZone.put(worldCoord, hp);
            TownyMessaging.sendMessageToMode(townBlock.getTown(), "\u00a78[" + townBlock.getTown().getName() + "](" + townBlock.getCoord().toString() + ") HP: " + hp, "");
            TownyMessaging.sendMessageToMode(attacker, "\u00a78[" + townBlock.getTown().getName() + "](" + townBlock.getCoord().toString() + ") HP: " + hp, "");
        } else {
            this.remove(attacker, townBlock);
        }
    }

    public void remove(Town attacker, TownBlock townBlock) throws NotRegisteredException {
        this.townScored(attacker, TownySettings.getWarPointsForTownBlock());
        townBlock.getTown().addBonusBlocks(-1);
        attacker.addBonusBlocks(1);
        try {
            if (!townBlock.getTown().payTo(TownySettings.getWartimeTownBlockLossPrice(), attacker, "War - TownBlock Loss")) {
                this.remove(townBlock.getTown());
                TownyMessaging.sendTownMessage(townBlock.getTown(), "Your town ran out of funds to support yourself in war.");
            } else {
                TownyMessaging.sendTownMessage(townBlock.getTown(), "Your town lost " + TownyEconomyHandler.getFormattedBalance(TownySettings.getWartimeTownBlockLossPrice()) + ".");
            }
        }
        catch (EconomyException economyException) {
            // empty catch block
        }
        if (townBlock.getTown().isHomeBlock(townBlock)) {
            this.remove(townBlock.getTown());
        } else {
            this.remove(townBlock.getWorldCoord());
        }
        TownyUniverse.getDataSource().saveTown(townBlock.getTown());
        TownyUniverse.getDataSource().saveTown(attacker);
    }

    public void remove(TownBlock townBlock) throws NotRegisteredException {
        if (townBlock.getTown().isHomeBlock(townBlock)) {
            this.remove(townBlock.getTown());
        } else {
            this.remove(townBlock.getWorldCoord());
        }
    }

    public void eliminate(Town town) {
        this.remove(town);
        try {
            this.checkNation(town.getNation());
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendErrorMsg("[War] Error checking " + town.getName() + "'s nation.");
        }
        TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeEliminatedMsg(town.getName()));
        this.checkEnd();
    }

    public void eliminate(Nation nation) {
        this.remove(nation);
        TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeEliminatedMsg(nation.getName()));
        this.checkEnd();
    }

    public void nationLeave(Nation nation) {
        this.remove(nation);
        for (Town town : nation.getTowns()) {
            this.remove(town);
        }
        TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeForfeitMsg(nation.getName()));
        this.checkEnd();
    }

    public void townLeave(Town town) {
        this.remove(town);
        TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeForfeitMsg(town.getName()));
        this.checkEnd();
    }

    public void remove(Town attacker, Nation nation) {
        this.townScored(attacker, TownySettings.getWarPointsForNation());
        this.warringNations.remove(nation);
    }

    public void remove(Nation nation) {
        this.warringNations.remove(nation);
    }

    public void remove(Town attacker, Town town) throws NotRegisteredException {
        this.townScored(attacker, TownySettings.getWarPointsForTown());
        for (TownBlock townBlock : town.getTownBlocks()) {
            this.remove(townBlock.getWorldCoord());
        }
        this.warringTowns.remove(town);
        try {
            if (!this.townsLeft(town.getNation())) {
                this.eliminate(town.getNation());
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
    }

    public void remove(Town town) {
        for (TownBlock townBlock : town.getTownBlocks()) {
            this.remove(townBlock.getWorldCoord());
        }
        this.warringTowns.remove(town);
        try {
            if (!this.townsLeft(town.getNation())) {
                this.eliminate(town.getNation());
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
    }

    public boolean townsLeft(Nation nation) {
        return this.warringTowns.containsAll(nation.getTowns());
    }

    public void remove(WorldCoord worldCoord) {
        try {
            Town town = worldCoord.getTownBlock().getTown();
            TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeLoseTownBlockMsg(worldCoord, town.getName()));
            this.warZone.remove(worldCoord);
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendGlobalMessage(TownySettings.getWarTimeLoseTownBlockMsg(worldCoord));
            this.warZone.remove(worldCoord);
        }
    }

    public void checkEnd() {
        if (this.warringNations.size() <= 1) {
            this.toggleEnd();
        } else if (CombatUtil.areAllAllies(this.warringNations)) {
            this.toggleEnd();
        }
    }

    public void checkTown(Town town) {
        if (this.countActiveWarBlocks(town) == 0) {
            this.eliminate(town);
        }
    }

    public void checkNation(Nation nation) {
        if (this.countActiveTowns(nation) == 0) {
            this.eliminate(nation);
        }
    }

    public int countActiveWarBlocks(Town town) {
        int n = 0;
        for (TownBlock townBlock : town.getTownBlocks()) {
            if (!this.warZone.containsKey(townBlock.getWorldCoord())) continue;
            ++n;
        }
        return n;
    }

    public int countActiveTowns(Nation nation) {
        int n = 0;
        for (Town town : nation.getTowns()) {
            if (!this.warringTowns.contains(town)) continue;
            ++n;
        }
        return n;
    }

    public void toggleEnd() {
        this.warTime = false;
    }

    public void sendStats(Player player) {
        for (String line : this.getStats()) {
            player.sendMessage(line);
        }
    }

    public List<String> getStats() {
        ArrayList<String> output = new ArrayList<String>();
        output.add(ChatTools.formatTitle("War Stats"));
        output.add("\u00a72  Nations: \u00a7a" + this.warringNations.size());
        output.add("\u00a72  Towns: \u00a7a" + this.warringTowns.size() + " / " + this.townScores.size());
        output.add("\u00a72  WarZone: \u00a7a" + this.warZone.size() + " Town blocks");
        try {
            output.add("\u00a72  Spoils of War: \u00a7a" + TownyEconomyHandler.getFormattedBalance(this.warSpoils.getHoldingBalance()));
            return output;
        }
        catch (EconomyException economyException) {
            return null;
        }
    }

    public void sendScores(Player player) {
        this.sendScores(player, 10);
    }

    public void sendScores(Player player, int maxListing) {
        for (String line : this.getScores(maxListing)) {
            player.sendMessage(line);
        }
    }

    public List<String> getScores(int maxListing) {
        ArrayList<String> output = new ArrayList<String>();
        output.add(ChatTools.formatTitle("War - Top Scores"));
        KeyValueTable<Town, Integer> kvTable = new KeyValueTable<Town, Integer>(this.townScores);
        kvTable.sortByValue();
        kvTable.revese();
        int n = 0;
        for (KeyValue<Town, Integer> kv : kvTable.getKeyValues()) {
            if (maxListing != -1 && ++n > maxListing) break;
            Town town = (Town)kv.key;
            output.add(String.format("\u00a73%40s \u00a76|\u00a77 %4d", TownyFormatter.getFormattedName(town), (Integer)kv.value));
        }
        return output;
    }

    public boolean isWarringNation(Nation nation) {
        return this.warringNations.contains(nation);
    }

    public KeyValue<Town, Integer> getWinningTownScore() throws TownyException {
        KeyValueTable<Town, Integer> kvTable = new KeyValueTable<Town, Integer>(this.townScores);
        kvTable.sortByValue();
        kvTable.revese();
        if (kvTable.getKeyValues().size() > 0) {
            return kvTable.getKeyValues().get(0);
        }
        throw new TownyException();
    }

    public WarSpoils getWarSpoils() {
        return this.warSpoils;
    }
}

