/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.flagwar;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.war.flagwar.Cell;
import com.palmergames.bukkit.towny.war.flagwar.CellAttackThread;
import com.palmergames.bukkit.towny.war.flagwar.TownyWarConfig;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public class CellUnderAttack
extends Cell {
    private Towny plugin;
    private String nameOfFlagOwner;
    private List<Block> beaconFlagBlocks;
    private List<Block> beaconWireframeBlocks;
    private Block flagBaseBlock;
    private Block flagBlock;
    private Block flagLightBlock;
    private int flagColorId;
    private int thread;

    public CellUnderAttack(Towny plugin, String nameOfFlagOwner, Block flagBaseBlock) {
        super(flagBaseBlock.getLocation());
        this.plugin = plugin;
        this.nameOfFlagOwner = nameOfFlagOwner;
        this.flagBaseBlock = flagBaseBlock;
        this.flagColorId = 0;
        this.thread = -1;
        World world = flagBaseBlock.getWorld();
        this.flagBlock = world.getBlockAt(flagBaseBlock.getX(), flagBaseBlock.getY() + 1, flagBaseBlock.getZ());
        this.flagLightBlock = world.getBlockAt(flagBaseBlock.getX(), flagBaseBlock.getY() + 2, flagBaseBlock.getZ());
    }

    public void loadBeacon() {
        this.beaconFlagBlocks = new ArrayList<Block>();
        this.beaconWireframeBlocks = new ArrayList<Block>();
        if (!TownyWarConfig.isDrawingBeacon()) {
            return;
        }
        int beaconSize = TownyWarConfig.getBeaconSize();
        if (Coord.getCellSize() < beaconSize) {
            return;
        }
        Block minBlock = this.getBeaconMinBlock(this.getFlagBaseBlock().getWorld());
        if (this.getMinimumHeightForBeacon() >= minBlock.getY()) {
            return;
        }
        int outerEdge = beaconSize - 1;
        int y = 0;
        while (y < beaconSize) {
            int z = 0;
            while (z < beaconSize) {
                int x = 0;
                while (x < beaconSize) {
                    Block block = this.flagBaseBlock.getWorld().getBlockAt(minBlock.getX() + x, minBlock.getY() + y, minBlock.getZ() + z);
                    if (block.isEmpty()) {
                        int edgeCount = this.getEdgeCount(x, y, z, outerEdge);
                        if (edgeCount == 1) {
                            this.beaconFlagBlocks.add(block);
                        } else if (edgeCount > 1) {
                            this.beaconWireframeBlocks.add(block);
                        }
                    }
                    ++x;
                }
                ++z;
            }
            ++y;
        }
    }

    private Block getTopOfFlagBlock() {
        return this.flagLightBlock;
    }

    private int getMinimumHeightForBeacon() {
        return this.getTopOfFlagBlock().getY() + TownyWarConfig.getBeaconMinHeightAboveFlag();
    }

    private int getEdgeCount(int x, int y, int z, int outerEdge) {
        return (this.zeroOr(x, outerEdge) ? 1 : 0) + (this.zeroOr(y, outerEdge) ? 1 : 0) + (this.zeroOr(z, outerEdge) ? 1 : 0);
    }

    private boolean zeroOr(int n, int max) {
        return n == 0 || n == max;
    }

    private Block getBeaconMinBlock(World world) {
        int middle = (int)Math.floor((double)Coord.getCellSize() / 2.0);
        int radiusCenterExpansion = TownyWarConfig.getBeaconRadius() - 1;
        int fromCorner = middle - radiusCenterExpansion;
        int x = this.getX() * Coord.getCellSize() + fromCorner;
        int z = this.getZ() * Coord.getCellSize() + fromCorner;
        int maxY = world.getMaxHeight();
        int y = this.getTopOfFlagBlock().getY() + TownyWarConfig.getBeaconMaxHeightAboveFlag();
        if (y > maxY) {
            y = maxY - TownyWarConfig.getBeaconSize();
        }
        return world.getBlockAt(x, y, z);
    }

    public Block getFlagBaseBlock() {
        return this.flagBaseBlock;
    }

    public String getNameOfFlagOwner() {
        return this.nameOfFlagOwner;
    }

    public boolean hasEnded() {
        return this.flagColorId >= TownyWarConfig.getWoolColors().length;
    }

    public void changeFlag() {
        ++this.flagColorId;
        this.updateFlag();
    }

    public void drawFlag() {
        this.loadBeacon();
        this.flagBaseBlock.setType(TownyWarConfig.getFlagBaseMaterial());
        this.updateFlag();
        this.flagLightBlock.setType(TownyWarConfig.getFlagLightMaterial());
        for (Block block : this.beaconWireframeBlocks) {
            block.setType(TownyWarConfig.getBeaconWireFrameMaterial());
        }
    }

    public void updateFlag() {
        DyeColor[] woolColors = TownyWarConfig.getWoolColors();
        if (this.flagColorId < woolColors.length) {
            System.out.println(String.format("Flag at %s turned %s.", this.getCellString(), woolColors[this.flagColorId].toString()));
            int woolId = Material.WOOL.getId();
            byte woolData = woolColors[this.flagColorId].getData();
            this.flagBlock.setTypeIdAndData(woolId, woolData, true);
            for (Block block : this.beaconFlagBlocks) {
                block.setTypeIdAndData(woolId, woolData, true);
            }
        }
    }

    public void destroyFlag() {
        this.flagLightBlock.setType(Material.AIR);
        this.flagBlock.setType(Material.AIR);
        this.flagBaseBlock.setType(Material.AIR);
        for (Block block : this.beaconFlagBlocks) {
            block.setType(Material.AIR);
        }
        for (Block block : this.beaconWireframeBlocks) {
            block.setType(Material.AIR);
        }
    }

    public void begin() {
        this.drawFlag();
        this.thread = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new CellAttackThread(this), TownyWarConfig.getTimeBetweenFlagColorChange(), TownyWarConfig.getTimeBetweenFlagColorChange());
    }

    public void cancel() {
        if (this.thread != -1) {
            this.plugin.getServer().getScheduler().cancelTask(this.thread);
        }
        this.destroyFlag();
    }

    public String getCellString() {
        return String.format("%s (%d, %d)", this.getWorldName(), this.getX(), this.getZ());
    }

    public boolean isFlagLight(Block block) {
        return this.flagLightBlock.equals(block);
    }

    public boolean isFlag(Block block) {
        return this.flagBlock.equals(block);
    }

    public boolean isFlagBase(Block block) {
        return this.flagBaseBlock.equals(block);
    }

    public boolean isPartOfBeacon(Block block) {
        return this.beaconFlagBlocks.contains(block) || this.beaconWireframeBlocks.contains(block);
    }

    public boolean isUneditableBlock(Block block) {
        return this.isPartOfBeacon(block) || this.isFlagBase(block) || this.isFlagLight(block);
    }
}

